/* Keen Dreams Source Code
 * Copyright (C) 2014 Javier M. Chavez
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

extern "C"
{


// New file used for preparing and converting statetype objects offset

#include "kd_def.h"

// List of all states
extern statetype s_score;
extern statetype s_flowerpower1;
extern statetype s_flowerpower2;
extern statetype s_boobusbomb1;
extern statetype s_boobusbomb2;
extern statetype s_bombexplode;
extern statetype s_bombexplode2;
extern statetype s_bombexplode3;
extern statetype s_bombexplode4;
extern statetype s_bombexplode5;
extern statetype s_bombexplode6;
extern statetype s_powerblink1;
extern statetype s_powerblink2;
extern statetype s_worldkeen;
extern statetype s_worldkeenwave1;
extern statetype s_worldkeenwave2;
extern statetype s_worldkeenwave3;
extern statetype s_worldkeenwave4;
extern statetype s_worldkeenwave5;
extern statetype s_worldkeenwait;
extern statetype s_worldkeensleep1;
extern statetype s_worldkeensleep2;
extern statetype s_worldwalk;
extern statetype s_keenzee1;
extern statetype s_keenzee2;
extern statetype s_keenzee3;
extern statetype s_keenstand;
extern statetype s_keenpauselook;
extern statetype s_keenyawn1;
extern statetype s_keenyawn2;
extern statetype s_keenyawn3;
extern statetype s_keenyawn4;
extern statetype s_keenwait1;
extern statetype s_keenwait2;
extern statetype s_keenwait3;
extern statetype s_keenwait4;
extern statetype s_keenwait5;
extern statetype s_keenwait6;
extern statetype s_keengosleep1;
extern statetype s_keengosleep2;
extern statetype s_keensleep1;
extern statetype s_keensleep2;
extern statetype s_keengetup;
extern statetype s_keendie1;
extern statetype s_keendie2;
extern statetype s_keendie3;
extern statetype s_keenlookup;
extern statetype s_keenduck;
extern statetype s_keendrop;
extern statetype s_keenpole;
extern statetype s_keenclimb1;
extern statetype s_keenclimb2;
extern statetype s_keenclimb3;
extern statetype s_keenslide1;
extern statetype s_keenslide2;
extern statetype s_keenslide3;
extern statetype s_keenslide4;
extern statetype s_keenpolethrow1;
extern statetype s_keenpolethrow2;
extern statetype s_keenpolethrow3;
extern statetype s_keenpolethrowup1;
extern statetype s_keenpolethrowup2;
extern statetype s_keenpolethrowup3;
extern statetype s_keenpolethrowdown1;
extern statetype s_keenpolethrowdown2;
extern statetype s_keenpolethrowdown3;
extern statetype s_keenwalk1;
extern statetype s_keenwalk2;
extern statetype s_keenwalk3;
extern statetype s_keenwalk4;
extern statetype s_keenthrow1;
extern statetype s_keenthrow2;
extern statetype s_keenthrow3;
extern statetype s_keenthrow4;
extern statetype s_keenthrowup1;
extern statetype s_keenthrowup2;
extern statetype s_keenthrowup3;
extern statetype s_keenjumpup1;
extern statetype s_keenjumpup2;
extern statetype s_keenjumpup3;
extern statetype s_keenjump1;
extern statetype s_keenjump2;
extern statetype s_keenjump3;
extern statetype s_keenairthrow1;
extern statetype s_keenairthrow2;
extern statetype s_keenairthrow3;
extern statetype s_keenairthrowup1;
extern statetype s_keenairthrowup2;
extern statetype s_keenairthrowup3;
extern statetype s_keenairthrowdown1;
extern statetype s_keenairthrowdown2;
extern statetype s_keenairthrowdown3;
extern statetype s_door;
extern statetype s_doorraise;
extern statetype s_flower1;
extern statetype s_flower2;
extern statetype s_flower3;
extern statetype s_flower4;
extern statetype s_flower5;
extern statetype s_flower6;
extern statetype s_poofto1;
extern statetype s_poofto2;
extern statetype s_poofto3;
extern statetype s_poofto4;
extern statetype s_pooffrom1;
extern statetype s_pooffrom2;
extern statetype s_pooffrom3;
extern statetype s_pooffrom4;
extern statetype s_pooffrom5;
extern statetype s_pooffrom6;
extern statetype s_pooffrom7;
extern statetype s_bonus;
extern statetype s_bonusrise;
extern statetype s_broccowalk1;
extern statetype s_broccowalk2;
extern statetype s_broccowalk3;
extern statetype s_broccowalk4;
extern statetype s_broccosmash1;
extern statetype s_broccosmash2;
extern statetype s_broccosmash3;
extern statetype s_broccosmash4;
extern statetype s_broccosmash5;
extern statetype s_broccosmash6;
extern statetype s_broccosmash7;
extern statetype s_broccosmash8;
extern statetype s_broccosmash9;
extern statetype s_tomatbounce;
extern statetype s_tomatbounce2;
extern statetype s_carrotwalk1;
extern statetype s_carrotwalk2;
extern statetype s_carrotwalk3;
extern statetype s_carrotwalk4;
extern statetype s_carrotleap;
extern statetype s_asparwalk1;
extern statetype s_asparwalk2;
extern statetype s_asparwalk3;
extern statetype s_asparwalk4;
extern statetype s_grapewait;
extern statetype s_grapefall;
extern statetype s_grapesit;
extern statetype s_graperise;
extern statetype s_taterwalk1;
extern statetype s_taterwalk2;
extern statetype s_taterwalk3;
extern statetype s_taterwalk4;
extern statetype s_taterattack1;
extern statetype s_taterattack2;
extern statetype s_taterattack3;
extern statetype s_cartroll1;
extern statetype s_cartroll2;
extern statetype s_frenchywalk1;
extern statetype s_frenchywalk2;
extern statetype s_frenchywalk3;
extern statetype s_frenchywalk4;
extern statetype s_frenchyrun1;
extern statetype s_frenchyrun2;
extern statetype s_frenchyrun3;
extern statetype s_frenchyrun4;
extern statetype s_frenchythrow1;
extern statetype s_frenchythrow2;
extern statetype s_frenchythrow3;
extern statetype s_fry1;
extern statetype s_fry2;
extern statetype s_melonside;
extern statetype s_melonsidespit;
extern statetype s_melonsidespit2;
extern statetype s_melondown;
extern statetype s_melondownspit;
extern statetype s_melondownspit2;
extern statetype s_melonseed1;
extern statetype s_melonseed2;
extern statetype s_melonseedd1;
extern statetype s_melonseedd2;
extern statetype s_squasherwalk1;
extern statetype s_squasherwalk2;
extern statetype s_squasherjump1;
extern statetype s_squasherjump2;
extern statetype s_squasherwait;
extern statetype s_apelwalk1;
extern statetype s_apelwalk2;
extern statetype s_apelwalk3;
extern statetype s_apelclimb1;
extern statetype s_apelclimb2;
extern statetype s_apelslide1;
extern statetype s_apelslide2;
extern statetype s_apelslide3;
extern statetype s_apelslide4;
extern statetype s_apelfall;
extern statetype s_peabrainfly;
extern statetype s_peabrainwalk1;
extern statetype s_peabrainwalk2;
extern statetype s_peabrainwalk3;
extern statetype s_peabrainwalk4;
extern statetype s_peapodwalk1;
extern statetype s_peapodwalk2;
extern statetype s_peapodwalk3;
extern statetype s_peapodwalk4;
extern statetype s_peapodspit1;
extern statetype s_peapodspit2;
extern statetype s_boobuswalk1;
extern statetype s_boobuswalk2;
extern statetype s_boobuswalk3;
extern statetype s_boobuswalk4;
extern statetype s_boobusjump;
extern statetype s_boobusdie;
extern statetype s_boobusdie2;
extern statetype s_boobusdie3;
extern statetype s_deathboom1;
extern statetype s_deathboom2;
extern statetype s_deathboom3;
extern statetype s_deathboom4;
extern statetype s_deathboom5;
extern statetype s_deathboom6;

statetype* (*RefKeen_GetObjStatePtrFromDOSPointer)(uint_fast32_t dosptr);

#ifdef REFKEEN_VER_KDREAMS_CGA_ALL
static statetype* RefKeen_GetObjStatePtrFromDOSPointer_KDreamsC105(uint_fast32_t dosptr);
#else
static statetype* RefKeen_GetObjStatePtrFromDOSPointer_KDreamsE113(uint_fast32_t dosptr);
static statetype* RefKeen_GetObjStatePtrFromDOSPointer_KDreamsE193(uint_fast32_t dosptr);
static statetype* RefKeen_GetObjStatePtrFromDOSPointer_KDreamsE120(uint_fast32_t dosptr);
#endif


void RefKeen_FillObjStatesWithDOSPointers(void)
{
	switch (refkeen_current_gamever)
	{
#ifdef REFKEEN_VER_KDREAMS_CGA_ALL
	case BE_GAMEVER_KDREAMSC105:
		RefKeen_GetObjStatePtrFromDOSPointer = RefKeen_GetObjStatePtrFromDOSPointer_KDreamsC105;

		s_score.compatdospointer = 0x0D0A;
		s_flowerpower1.compatdospointer = 0x0D28;
		s_flowerpower2.compatdospointer = 0x0D46;
		s_boobusbomb1.compatdospointer = 0x0D64;
		s_boobusbomb2.compatdospointer = 0x0D82;
		s_bombexplode.compatdospointer = 0x0DA0;
		s_bombexplode2.compatdospointer = 0x0DBE;
		s_bombexplode3.compatdospointer = 0x0DDC;
		s_bombexplode4.compatdospointer = 0x0DFA;
		s_bombexplode5.compatdospointer = 0x0E18;
		s_bombexplode6.compatdospointer = 0x0E36;
		s_powerblink1.compatdospointer = 0x0E54;
		s_powerblink2.compatdospointer = 0x0E72;
		s_worldkeen.compatdospointer = 0x0E90;
		s_worldkeenwave1.compatdospointer = 0x0EAE;
		s_worldkeenwave2.compatdospointer = 0x0ECC;
		s_worldkeenwave3.compatdospointer = 0x0EEA;
		s_worldkeenwave4.compatdospointer = 0x0F08;
		s_worldkeenwave5.compatdospointer = 0x0F26;
		s_worldkeenwait.compatdospointer = 0x0F44;
		s_worldkeensleep1.compatdospointer = 0x0F62;
		s_worldkeensleep2.compatdospointer = 0x0F80;
		s_worldwalk.compatdospointer = 0x0F9E;
		s_keenzee1.compatdospointer = 0x0FD4;
		s_keenzee2.compatdospointer = 0x0FF2;
		s_keenzee3.compatdospointer = 0x1010;
		s_keenstand.compatdospointer = 0x102E;
		s_keenpauselook.compatdospointer = 0x104C;
		s_keenyawn1.compatdospointer = 0x106A;
		s_keenyawn2.compatdospointer = 0x1088;
		s_keenyawn3.compatdospointer = 0x10A6;
		s_keenyawn4.compatdospointer = 0x10C4;
		s_keenwait1.compatdospointer = 0x10E2;
		s_keenwait2.compatdospointer = 0x1100;
		s_keenwait3.compatdospointer = 0x111E;
		s_keenwait4.compatdospointer = 0x113C;
		s_keenwait5.compatdospointer = 0x115A;
		s_keenwait6.compatdospointer = 0x1178;
		s_keengosleep1.compatdospointer = 0x1196;
		s_keengosleep2.compatdospointer = 0x11B4;
		s_keensleep1.compatdospointer = 0x11D2;
		s_keensleep2.compatdospointer = 0x11F0;
		s_keengetup.compatdospointer = 0x120E;
		s_keendie1.compatdospointer = 0x122C;
		s_keendie2.compatdospointer = 0x124A;
		s_keendie3.compatdospointer = 0x1268;
		s_keenlookup.compatdospointer = 0x1286;
		s_keenduck.compatdospointer = 0x12A4;
		s_keendrop.compatdospointer = 0x12C2;
		s_keenpole.compatdospointer = 0x12E0;
		s_keenclimb1.compatdospointer = 0x12FE;
		s_keenclimb2.compatdospointer = 0x131C;
		s_keenclimb3.compatdospointer = 0x133A;
		s_keenslide1.compatdospointer = 0x1358;
		s_keenslide2.compatdospointer = 0x1376;
		s_keenslide3.compatdospointer = 0x1394;
		s_keenslide4.compatdospointer = 0x13B2;
		s_keenpolethrow1.compatdospointer = 0x13D0;
		s_keenpolethrow2.compatdospointer = 0x13EE;
		s_keenpolethrow3.compatdospointer = 0x140C;
		s_keenpolethrowup1.compatdospointer = 0x142A;
		s_keenpolethrowup2.compatdospointer = 0x1448;
		s_keenpolethrowup3.compatdospointer = 0x1466;
		s_keenpolethrowdown1.compatdospointer = 0x1484;
		s_keenpolethrowdown2.compatdospointer = 0x14A2;
		s_keenpolethrowdown3.compatdospointer = 0x14C0;
		s_keenwalk1.compatdospointer = 0x14DE;
		s_keenwalk2.compatdospointer = 0x14FC;
		s_keenwalk3.compatdospointer = 0x151A;
		s_keenwalk4.compatdospointer = 0x1538;
		s_keenthrow1.compatdospointer = 0x1556;
		s_keenthrow2.compatdospointer = 0x1574;
		s_keenthrow3.compatdospointer = 0x1592;
		s_keenthrow4.compatdospointer = 0x15B0;
		s_keenthrowup1.compatdospointer = 0x15CE;
		s_keenthrowup2.compatdospointer = 0x15EC;
		s_keenthrowup3.compatdospointer = 0x160A;
		s_keenjumpup1.compatdospointer = 0x1628;
		s_keenjumpup2.compatdospointer = 0x1646;
		s_keenjumpup3.compatdospointer = 0x1664;
		s_keenjump1.compatdospointer = 0x1682;
		s_keenjump2.compatdospointer = 0x16A0;
		s_keenjump3.compatdospointer = 0x16BE;
		s_keenairthrow1.compatdospointer = 0x16DC;
		s_keenairthrow2.compatdospointer = 0x16FA;
		s_keenairthrow3.compatdospointer = 0x1718;
		s_keenairthrowup1.compatdospointer = 0x1736;
		s_keenairthrowup2.compatdospointer = 0x1754;
		s_keenairthrowup3.compatdospointer = 0x1772;
		s_keenairthrowdown1.compatdospointer = 0x1790;
		s_keenairthrowdown2.compatdospointer = 0x17AE;
		s_keenairthrowdown3.compatdospointer = 0x17CC;
		s_door.compatdospointer = 0x1888;
		s_doorraise.compatdospointer = 0x18A6;
		s_flower1.compatdospointer = 0x18C4;
		s_flower2.compatdospointer = 0x18E2;
		s_flower3.compatdospointer = 0x1900;
		s_flower4.compatdospointer = 0x191E;
		s_flower5.compatdospointer = 0x193C;
		s_flower6.compatdospointer = 0x195A;
		s_poofto1.compatdospointer = 0x1978;
		s_poofto2.compatdospointer = 0x1996;
		s_poofto3.compatdospointer = 0x19B4;
		s_poofto4.compatdospointer = 0x19D2;
		s_pooffrom1.compatdospointer = 0x19F0;
		s_pooffrom2.compatdospointer = 0x1A0E;
		s_pooffrom3.compatdospointer = 0x1A2C;
		s_pooffrom4.compatdospointer = 0x1A4A;
		s_pooffrom5.compatdospointer = 0x1A68;
		s_pooffrom6.compatdospointer = 0x1A86;
		s_pooffrom7.compatdospointer = 0x1AA4;
		s_bonus.compatdospointer = 0x1AC2;
		s_bonusrise.compatdospointer = 0x1AE0;
		s_broccowalk1.compatdospointer = 0x1B16;
		s_broccowalk2.compatdospointer = 0x1B34;
		s_broccowalk3.compatdospointer = 0x1B52;
		s_broccowalk4.compatdospointer = 0x1B70;
		s_broccosmash1.compatdospointer = 0x1B8E;
		s_broccosmash2.compatdospointer = 0x1BAC;
		s_broccosmash3.compatdospointer = 0x1BCA;
		s_broccosmash4.compatdospointer = 0x1BE8;
		s_broccosmash5.compatdospointer = 0x1C06;
		s_broccosmash6.compatdospointer = 0x1C24;
		s_broccosmash7.compatdospointer = 0x1C42;
		s_broccosmash8.compatdospointer = 0x1C60;
		s_broccosmash9.compatdospointer = 0x1C7E;
		s_tomatbounce.compatdospointer = 0x1C9C;
		s_tomatbounce2.compatdospointer = 0x1CBA;
		s_carrotwalk1.compatdospointer = 0x1CD8;
		s_carrotwalk2.compatdospointer = 0x1CF6;
		s_carrotwalk3.compatdospointer = 0x1D14;
		s_carrotwalk4.compatdospointer = 0x1D32;
		s_carrotleap.compatdospointer = 0x1D50;
		s_asparwalk1.compatdospointer = 0x1D6E;
		s_asparwalk2.compatdospointer = 0x1D8C;
		s_asparwalk3.compatdospointer = 0x1DAA;
		s_asparwalk4.compatdospointer = 0x1DC8;
		s_grapewait.compatdospointer = 0x1DE6;
		s_grapefall.compatdospointer = 0x1E04;
		s_grapesit.compatdospointer = 0x1E22;
		s_graperise.compatdospointer = 0x1E40;
		s_taterwalk1.compatdospointer = 0x1E5E;
		s_taterwalk2.compatdospointer = 0x1E7C;
		s_taterwalk3.compatdospointer = 0x1E9A;
		s_taterwalk4.compatdospointer = 0x1EB8;
		s_taterattack1.compatdospointer = 0x1ED6;
		s_taterattack2.compatdospointer = 0x1EF4;
		s_taterattack3.compatdospointer = 0x1F12;
		s_cartroll1.compatdospointer = 0x1F30;
		s_cartroll2.compatdospointer = 0x1F4E;
		s_frenchywalk1.compatdospointer = 0x1F6C;
		s_frenchywalk2.compatdospointer = 0x1F8A;
		s_frenchywalk3.compatdospointer = 0x1FA8;
		s_frenchywalk4.compatdospointer = 0x1FC6;
		s_frenchyrun1.compatdospointer = 0x1FE4;
		s_frenchyrun2.compatdospointer = 0x2002;
		s_frenchyrun3.compatdospointer = 0x2020;
		s_frenchyrun4.compatdospointer = 0x203E;
		s_frenchythrow1.compatdospointer = 0x205C;
		s_frenchythrow2.compatdospointer = 0x207A;
		s_frenchythrow3.compatdospointer = 0x2098;
		s_fry1.compatdospointer = 0x20B6;
		s_fry2.compatdospointer = 0x20D4;
		s_melonside.compatdospointer = 0x20F2;
		s_melonsidespit.compatdospointer = 0x2110;
		s_melonsidespit2.compatdospointer = 0x212E;
		s_melondown.compatdospointer = 0x214C;
		s_melondownspit.compatdospointer = 0x216A;
		s_melondownspit2.compatdospointer = 0x2188;
		s_melonseed1.compatdospointer = 0x21A6;
		s_melonseed2.compatdospointer = 0x21C4;
		s_melonseedd1.compatdospointer = 0x21E2;
		s_melonseedd2.compatdospointer = 0x2200;
		s_squasherwalk1.compatdospointer = 0x221E;
		s_squasherwalk2.compatdospointer = 0x223C;
		s_squasherjump1.compatdospointer = 0x225A;
		s_squasherjump2.compatdospointer = 0x2278;
		s_squasherwait.compatdospointer = 0x2296;
		s_apelwalk1.compatdospointer = 0x22B4;
		s_apelwalk2.compatdospointer = 0x22D2;
		s_apelwalk3.compatdospointer = 0x22F0;
		s_apelclimb1.compatdospointer = 0x230E;
		s_apelclimb2.compatdospointer = 0x232C;
		s_apelslide1.compatdospointer = 0x234A;
		s_apelslide2.compatdospointer = 0x2368;
		s_apelslide3.compatdospointer = 0x2386;
		s_apelslide4.compatdospointer = 0x23A4;
		s_apelfall.compatdospointer = 0x23C2;
		s_peabrainfly.compatdospointer = 0x23E0;
		s_peabrainwalk1.compatdospointer = 0x23FE;
		s_peabrainwalk2.compatdospointer = 0x241C;
		s_peabrainwalk3.compatdospointer = 0x243A;
		s_peabrainwalk4.compatdospointer = 0x2458;
		s_peapodwalk1.compatdospointer = 0x2476;
		s_peapodwalk2.compatdospointer = 0x2494;
		s_peapodwalk3.compatdospointer = 0x24B2;
		s_peapodwalk4.compatdospointer = 0x24D0;
		s_peapodspit1.compatdospointer = 0x24EE;
		s_peapodspit2.compatdospointer = 0x250C;
		s_boobuswalk1.compatdospointer = 0x252A;
		s_boobuswalk2.compatdospointer = 0x2548;
		s_boobuswalk3.compatdospointer = 0x2566;
		s_boobuswalk4.compatdospointer = 0x2584;
		s_boobusjump.compatdospointer = 0x25A2;
		s_boobusdie.compatdospointer = 0x25C0;
		s_boobusdie2.compatdospointer = 0x25DE;
		s_boobusdie3.compatdospointer = 0x25FC;
		s_deathboom1.compatdospointer = 0x261A;
		s_deathboom2.compatdospointer = 0x2638;
		s_deathboom3.compatdospointer = 0x2656;
		s_deathboom4.compatdospointer = 0x2674;
		s_deathboom5.compatdospointer = 0x2692;
		s_deathboom6.compatdospointer = 0x26B0;

		break;
#else // EGA
	case BE_GAMEVER_KDREAMSE113:
		RefKeen_GetObjStatePtrFromDOSPointer = RefKeen_GetObjStatePtrFromDOSPointer_KDreamsE113;

		s_score.compatdospointer = 0x0BB4;
		s_flowerpower1.compatdospointer = 0x0BD2;
		s_flowerpower2.compatdospointer = 0x0BF0;
		s_boobusbomb1.compatdospointer = 0x0C0E;
		s_boobusbomb2.compatdospointer = 0x0C2C;
		s_bombexplode.compatdospointer = 0x0C4A;
		s_bombexplode2.compatdospointer = 0x0C68;
		s_bombexplode3.compatdospointer = 0x0C86;
		s_bombexplode4.compatdospointer = 0x0CA4;
		s_bombexplode5.compatdospointer = 0x0CC2;
		s_bombexplode6.compatdospointer = 0x0CE0;
		s_powerblink1.compatdospointer = 0x0CFE;
		s_powerblink2.compatdospointer = 0x0D1C;
		s_worldkeen.compatdospointer = 0x0D3A;
		s_worldkeenwave1.compatdospointer = 0x0D58;
		s_worldkeenwave2.compatdospointer = 0x0D76;
		s_worldkeenwave3.compatdospointer = 0x0D94;
		s_worldkeenwave4.compatdospointer = 0x0DB2;
		s_worldkeenwave5.compatdospointer = 0x0DD0;
		s_worldkeenwait.compatdospointer = 0x0DEE;
		s_worldkeensleep1.compatdospointer = 0x0E0C;
		s_worldkeensleep2.compatdospointer = 0x0E2A;
		s_worldwalk.compatdospointer = 0x0E48;
		s_keenzee1.compatdospointer = 0x0E7E;
		s_keenzee2.compatdospointer = 0x0E9C;
		s_keenzee3.compatdospointer = 0x0EBA;
		s_keenstand.compatdospointer = 0x0ED8;
		s_keenpauselook.compatdospointer = 0x0EF6;
		s_keenyawn1.compatdospointer = 0x0F14;
		s_keenyawn2.compatdospointer = 0x0F32;
		s_keenyawn3.compatdospointer = 0x0F50;
		s_keenyawn4.compatdospointer = 0x0F6E;
		s_keenwait1.compatdospointer = 0x0F8C;
		s_keenwait2.compatdospointer = 0x0FAA;
		s_keenwait3.compatdospointer = 0x0FC8;
		s_keenwait4.compatdospointer = 0x0FE6;
		s_keenwait5.compatdospointer = 0x1004;
		s_keenwait6.compatdospointer = 0x1022;
		s_keengosleep1.compatdospointer = 0x1040;
		s_keengosleep2.compatdospointer = 0x105E;
		s_keensleep1.compatdospointer = 0x107C;
		s_keensleep2.compatdospointer = 0x109A;
		s_keengetup.compatdospointer = 0x10B8;
		s_keendie1.compatdospointer = 0x10D6;
		s_keendie2.compatdospointer = 0x10F4;
		s_keendie3.compatdospointer = 0x1112;
		s_keenlookup.compatdospointer = 0x1130;
		s_keenduck.compatdospointer = 0x114E;
		s_keendrop.compatdospointer = 0x116C;
		s_keenpole.compatdospointer = 0x118A;
		s_keenclimb1.compatdospointer = 0x11A8;
		s_keenclimb2.compatdospointer = 0x11C6;
		s_keenclimb3.compatdospointer = 0x11E4;
		s_keenslide1.compatdospointer = 0x1202;
		s_keenslide2.compatdospointer = 0x1220;
		s_keenslide3.compatdospointer = 0x123E;
		s_keenslide4.compatdospointer = 0x125C;
		s_keenpolethrow1.compatdospointer = 0x127A;
		s_keenpolethrow2.compatdospointer = 0x1298;
		s_keenpolethrow3.compatdospointer = 0x12B6;
		s_keenpolethrowup1.compatdospointer = 0x12D4;
		s_keenpolethrowup2.compatdospointer = 0x12F2;
		s_keenpolethrowup3.compatdospointer = 0x1310;
		s_keenpolethrowdown1.compatdospointer = 0x132E;
		s_keenpolethrowdown2.compatdospointer = 0x134C;
		s_keenpolethrowdown3.compatdospointer = 0x136A;
		s_keenwalk1.compatdospointer = 0x1388;
		s_keenwalk2.compatdospointer = 0x13A6;
		s_keenwalk3.compatdospointer = 0x13C4;
		s_keenwalk4.compatdospointer = 0x13E2;
		s_keenthrow1.compatdospointer = 0x1400;
		s_keenthrow2.compatdospointer = 0x141E;
		s_keenthrow3.compatdospointer = 0x143C;
		s_keenthrow4.compatdospointer = 0x145A;
		s_keenthrowup1.compatdospointer = 0x1478;
		s_keenthrowup2.compatdospointer = 0x1496;
		s_keenthrowup3.compatdospointer = 0x14B4;
		s_keenjumpup1.compatdospointer = 0x14D2;
		s_keenjumpup2.compatdospointer = 0x14F0;
		s_keenjumpup3.compatdospointer = 0x150E;
		s_keenjump1.compatdospointer = 0x152C;
		s_keenjump2.compatdospointer = 0x154A;
		s_keenjump3.compatdospointer = 0x1568;
		s_keenairthrow1.compatdospointer = 0x1586;
		s_keenairthrow2.compatdospointer = 0x15A4;
		s_keenairthrow3.compatdospointer = 0x15C2;
		s_keenairthrowup1.compatdospointer = 0x15E0;
		s_keenairthrowup2.compatdospointer = 0x15FE;
		s_keenairthrowup3.compatdospointer = 0x161C;
		s_keenairthrowdown1.compatdospointer = 0x163A;
		s_keenairthrowdown2.compatdospointer = 0x1658;
		s_keenairthrowdown3.compatdospointer = 0x1676;
		s_door.compatdospointer = 0x1732;
		s_doorraise.compatdospointer = 0x1750;
		s_flower1.compatdospointer = 0x176E;
		s_flower2.compatdospointer = 0x178C;
		s_flower3.compatdospointer = 0x17AA;
		s_flower4.compatdospointer = 0x17C8;
		s_flower5.compatdospointer = 0x17E6;
		s_flower6.compatdospointer = 0x1804;
		s_poofto1.compatdospointer = 0x1822;
		s_poofto2.compatdospointer = 0x1840;
		s_poofto3.compatdospointer = 0x185E;
		s_poofto4.compatdospointer = 0x187C;
		s_pooffrom1.compatdospointer = 0x189A;
		s_pooffrom2.compatdospointer = 0x18B8;
		s_pooffrom3.compatdospointer = 0x18D6;
		s_pooffrom4.compatdospointer = 0x18F4;
		s_pooffrom5.compatdospointer = 0x1912;
		s_pooffrom6.compatdospointer = 0x1930;
		s_pooffrom7.compatdospointer = 0x194E;
		s_bonus.compatdospointer = 0x196C;
		s_bonusrise.compatdospointer = 0x198A;
		s_broccowalk1.compatdospointer = 0x19C0;
		s_broccowalk2.compatdospointer = 0x19DE;
		s_broccowalk3.compatdospointer = 0x19FC;
		s_broccowalk4.compatdospointer = 0x1A1A;
		s_broccosmash1.compatdospointer = 0x1A38;
		s_broccosmash2.compatdospointer = 0x1A56;
		s_broccosmash3.compatdospointer = 0x1A74;
		s_broccosmash4.compatdospointer = 0x1A92;
		s_broccosmash5.compatdospointer = 0x1AB0;
		s_broccosmash6.compatdospointer = 0x1ACE;
		s_broccosmash7.compatdospointer = 0x1AEC;
		s_broccosmash8.compatdospointer = 0x1B0A;
		s_broccosmash9.compatdospointer = 0x1B28;
		s_tomatbounce.compatdospointer = 0x1B46;
		s_tomatbounce2.compatdospointer = 0x1B64;
		s_carrotwalk1.compatdospointer = 0x1B82;
		s_carrotwalk2.compatdospointer = 0x1BA0;
		s_carrotwalk3.compatdospointer = 0x1BBE;
		s_carrotwalk4.compatdospointer = 0x1BDC;
		s_carrotleap.compatdospointer = 0x1BFA;
		s_asparwalk1.compatdospointer = 0x1C18;
		s_asparwalk2.compatdospointer = 0x1C36;
		s_asparwalk3.compatdospointer = 0x1C54;
		s_asparwalk4.compatdospointer = 0x1C72;
		s_grapewait.compatdospointer = 0x1C90;
		s_grapefall.compatdospointer = 0x1CAE;
		s_grapesit.compatdospointer = 0x1CCC;
		s_graperise.compatdospointer = 0x1CEA;
		s_taterwalk1.compatdospointer = 0x1D08;
		s_taterwalk2.compatdospointer = 0x1D26;
		s_taterwalk3.compatdospointer = 0x1D44;
		s_taterwalk4.compatdospointer = 0x1D62;
		s_taterattack1.compatdospointer = 0x1D80;
		s_taterattack2.compatdospointer = 0x1D9E;
		s_taterattack3.compatdospointer = 0x1DBC;
		s_cartroll1.compatdospointer = 0x1DDA;
		s_cartroll2.compatdospointer = 0x1DF8;
		s_frenchywalk1.compatdospointer = 0x1E16;
		s_frenchywalk2.compatdospointer = 0x1E34;
		s_frenchywalk3.compatdospointer = 0x1E52;
		s_frenchywalk4.compatdospointer = 0x1E70;
		s_frenchyrun1.compatdospointer = 0x1E8E;
		s_frenchyrun2.compatdospointer = 0x1EAC;
		s_frenchyrun3.compatdospointer = 0x1ECA;
		s_frenchyrun4.compatdospointer = 0x1EE8;
		s_frenchythrow1.compatdospointer = 0x1F06;
		s_frenchythrow2.compatdospointer = 0x1F24;
		s_frenchythrow3.compatdospointer = 0x1F42;
		s_fry1.compatdospointer = 0x1F60;
		s_fry2.compatdospointer = 0x1F7E;
		s_melonside.compatdospointer = 0x1F9C;
		s_melonsidespit.compatdospointer = 0x1FBA;
		s_melonsidespit2.compatdospointer = 0x1FD8;
		s_melondown.compatdospointer = 0x1FF6;
		s_melondownspit.compatdospointer = 0x2014;
		s_melondownspit2.compatdospointer = 0x2032;
		s_melonseed1.compatdospointer = 0x2050;
		s_melonseed2.compatdospointer = 0x206E;
		s_melonseedd1.compatdospointer = 0x208C;
		s_melonseedd2.compatdospointer = 0x20AA;
		s_squasherwalk1.compatdospointer = 0x20C8;
		s_squasherwalk2.compatdospointer = 0x20E6;
		s_squasherjump1.compatdospointer = 0x2104;
		s_squasherjump2.compatdospointer = 0x2122;
		s_squasherwait.compatdospointer = 0x2140;
		s_apelwalk1.compatdospointer = 0x215E;
		s_apelwalk2.compatdospointer = 0x217C;
		s_apelwalk3.compatdospointer = 0x219A;
		s_apelclimb1.compatdospointer = 0x21B8;
		s_apelclimb2.compatdospointer = 0x21D6;
		s_apelslide1.compatdospointer = 0x21F4;
		s_apelslide2.compatdospointer = 0x2212;
		s_apelslide3.compatdospointer = 0x2230;
		s_apelslide4.compatdospointer = 0x224E;
		s_apelfall.compatdospointer = 0x226C;
		s_peabrainfly.compatdospointer = 0x228A;
		s_peabrainwalk1.compatdospointer = 0x22A8;
		s_peabrainwalk2.compatdospointer = 0x22C6;
		s_peabrainwalk3.compatdospointer = 0x22E4;
		s_peabrainwalk4.compatdospointer = 0x2302;
		s_peapodwalk1.compatdospointer = 0x2320;
		s_peapodwalk2.compatdospointer = 0x233E;
		s_peapodwalk3.compatdospointer = 0x235C;
		s_peapodwalk4.compatdospointer = 0x237A;
		s_peapodspit1.compatdospointer = 0x2398;
		s_peapodspit2.compatdospointer = 0x23B6;
		s_boobuswalk1.compatdospointer = 0x23D4;
		s_boobuswalk2.compatdospointer = 0x23F2;
		s_boobuswalk3.compatdospointer = 0x2410;
		s_boobuswalk4.compatdospointer = 0x242E;
		s_boobusjump.compatdospointer = 0x244C;
		s_boobusdie.compatdospointer = 0x246A;
		s_boobusdie2.compatdospointer = 0x2488;
		s_boobusdie3.compatdospointer = 0x24A6;
		s_deathboom1.compatdospointer = 0x24C4;
		s_deathboom2.compatdospointer = 0x24E2;
		s_deathboom3.compatdospointer = 0x2500;
		s_deathboom4.compatdospointer = 0x251E;
		s_deathboom5.compatdospointer = 0x253C;
		s_deathboom6.compatdospointer = 0x255A;

		break;

	case BE_GAMEVER_KDREAMSE193:
		RefKeen_GetObjStatePtrFromDOSPointer = RefKeen_GetObjStatePtrFromDOSPointer_KDreamsE193;

		s_score.compatdospointer = 0x0DC8;
		s_flowerpower1.compatdospointer = 0x0DE6;
		s_flowerpower2.compatdospointer = 0x0E04;
		s_boobusbomb1.compatdospointer = 0x0E22;
		s_boobusbomb2.compatdospointer = 0x0E40;
		s_bombexplode.compatdospointer = 0x0E5E;
		s_bombexplode2.compatdospointer = 0x0E7C;
		s_bombexplode3.compatdospointer = 0x0E9A;
		s_bombexplode4.compatdospointer = 0x0EB8;
		s_bombexplode5.compatdospointer = 0x0ED6;
		s_bombexplode6.compatdospointer = 0x0EF4;
		s_powerblink1.compatdospointer = 0x0F12;
		s_powerblink2.compatdospointer = 0x0F30;
		s_worldkeen.compatdospointer = 0x0F4E;
		s_worldkeenwave1.compatdospointer = 0x0F6C;
		s_worldkeenwave2.compatdospointer = 0x0F8A;
		s_worldkeenwave3.compatdospointer = 0x0FA8;
		s_worldkeenwave4.compatdospointer = 0x0FC6;
		s_worldkeenwave5.compatdospointer = 0x0FE4;
		s_worldkeenwait.compatdospointer = 0x1002;
		s_worldkeensleep1.compatdospointer = 0x1020;
		s_worldkeensleep2.compatdospointer = 0x103E;
		s_worldwalk.compatdospointer = 0x105C;
		s_keenzee1.compatdospointer = 0x1092;
		s_keenzee2.compatdospointer = 0x10B0;
		s_keenzee3.compatdospointer = 0x10CE;
		s_keenstand.compatdospointer = 0x10EC;
		s_keenpauselook.compatdospointer = 0x110A;
		s_keenyawn1.compatdospointer = 0x1128;
		s_keenyawn2.compatdospointer = 0x1146;
		s_keenyawn3.compatdospointer = 0x1164;
		s_keenyawn4.compatdospointer = 0x1182;
		s_keenwait1.compatdospointer = 0x11A0;
		s_keenwait2.compatdospointer = 0x11BE;
		s_keenwait3.compatdospointer = 0x11DC;
		s_keenwait4.compatdospointer = 0x11FA;
		s_keenwait5.compatdospointer = 0x1218;
		s_keenwait6.compatdospointer = 0x1236;
		s_keengosleep1.compatdospointer = 0x1254;
		s_keengosleep2.compatdospointer = 0x1272;
		s_keensleep1.compatdospointer = 0x1290;
		s_keensleep2.compatdospointer = 0x12AE;
		s_keengetup.compatdospointer = 0x12CC;
		s_keendie1.compatdospointer = 0x12EA;
		s_keendie2.compatdospointer = 0x1308;
		s_keendie3.compatdospointer = 0x1326;
		s_keenlookup.compatdospointer = 0x1344;
		s_keenduck.compatdospointer = 0x1362;
		s_keendrop.compatdospointer = 0x1380;
		s_keenpole.compatdospointer = 0x139E;
		s_keenclimb1.compatdospointer = 0x13BC;
		s_keenclimb2.compatdospointer = 0x13DA;
		s_keenclimb3.compatdospointer = 0x13F8;
		s_keenslide1.compatdospointer = 0x1416;
		s_keenslide2.compatdospointer = 0x1434;
		s_keenslide3.compatdospointer = 0x1452;
		s_keenslide4.compatdospointer = 0x1470;
		s_keenpolethrow1.compatdospointer = 0x148E;
		s_keenpolethrow2.compatdospointer = 0x14AC;
		s_keenpolethrow3.compatdospointer = 0x14CA;
		s_keenpolethrowup1.compatdospointer = 0x14E8;
		s_keenpolethrowup2.compatdospointer = 0x1506;
		s_keenpolethrowup3.compatdospointer = 0x1524;
		s_keenpolethrowdown1.compatdospointer = 0x1542;
		s_keenpolethrowdown2.compatdospointer = 0x1560;
		s_keenpolethrowdown3.compatdospointer = 0x157E;
		s_keenwalk1.compatdospointer = 0x159C;
		s_keenwalk2.compatdospointer = 0x15BA;
		s_keenwalk3.compatdospointer = 0x15D8;
		s_keenwalk4.compatdospointer = 0x15F6;
		s_keenthrow1.compatdospointer = 0x1614;
		s_keenthrow2.compatdospointer = 0x1632;
		s_keenthrow3.compatdospointer = 0x1650;
		s_keenthrow4.compatdospointer = 0x166E;
		s_keenthrowup1.compatdospointer = 0x168C;
		s_keenthrowup2.compatdospointer = 0x16AA;
		s_keenthrowup3.compatdospointer = 0x16C8;
		s_keenjumpup1.compatdospointer = 0x16E6;
		s_keenjumpup2.compatdospointer = 0x1704;
		s_keenjumpup3.compatdospointer = 0x1722;
		s_keenjump1.compatdospointer = 0x1740;
		s_keenjump2.compatdospointer = 0x175E;
		s_keenjump3.compatdospointer = 0x177C;
		s_keenairthrow1.compatdospointer = 0x179A;
		s_keenairthrow2.compatdospointer = 0x17B8;
		s_keenairthrow3.compatdospointer = 0x17D6;
		s_keenairthrowup1.compatdospointer = 0x17F4;
		s_keenairthrowup2.compatdospointer = 0x1812;
		s_keenairthrowup3.compatdospointer = 0x1830;
		s_keenairthrowdown1.compatdospointer = 0x184E;
		s_keenairthrowdown2.compatdospointer = 0x186C;
		s_keenairthrowdown3.compatdospointer = 0x188A;
		s_door.compatdospointer = 0x1946;
		s_doorraise.compatdospointer = 0x1964;
		s_flower1.compatdospointer = 0x1982;
		s_flower2.compatdospointer = 0x19A0;
		s_flower3.compatdospointer = 0x19BE;
		s_flower4.compatdospointer = 0x19DC;
		s_flower5.compatdospointer = 0x19FA;
		s_flower6.compatdospointer = 0x1A18;
		s_poofto1.compatdospointer = 0x1A36;
		s_poofto2.compatdospointer = 0x1A54;
		s_poofto3.compatdospointer = 0x1A72;
		s_poofto4.compatdospointer = 0x1A90;
		s_pooffrom1.compatdospointer = 0x1AAE;
		s_pooffrom2.compatdospointer = 0x1ACC;
		s_pooffrom3.compatdospointer = 0x1AEA;
		s_pooffrom4.compatdospointer = 0x1B08;
		s_pooffrom5.compatdospointer = 0x1B26;
		s_pooffrom6.compatdospointer = 0x1B44;
		s_pooffrom7.compatdospointer = 0x1B62;
		s_bonus.compatdospointer = 0x1B80;
		s_bonusrise.compatdospointer = 0x1B9E;
		s_broccowalk1.compatdospointer = 0x1BD4;
		s_broccowalk2.compatdospointer = 0x1BF2;
		s_broccowalk3.compatdospointer = 0x1C10;
		s_broccowalk4.compatdospointer = 0x1C2E;
		s_broccosmash1.compatdospointer = 0x1C4C;
		s_broccosmash2.compatdospointer = 0x1C6A;
		s_broccosmash3.compatdospointer = 0x1C88;
		s_broccosmash4.compatdospointer = 0x1CA6;
		s_broccosmash5.compatdospointer = 0x1CC4;
		s_broccosmash6.compatdospointer = 0x1CE2;
		s_broccosmash7.compatdospointer = 0x1D00;
		s_broccosmash8.compatdospointer = 0x1D1E;
		s_broccosmash9.compatdospointer = 0x1D3C;
		s_tomatbounce.compatdospointer = 0x1D5A;
		s_tomatbounce2.compatdospointer = 0x1D78;
		s_carrotwalk1.compatdospointer = 0x1D96;
		s_carrotwalk2.compatdospointer = 0x1DB4;
		s_carrotwalk3.compatdospointer = 0x1DD2;
		s_carrotwalk4.compatdospointer = 0x1DF0;
		s_carrotleap.compatdospointer = 0x1E0E;
		s_asparwalk1.compatdospointer = 0x1E2C;
		s_asparwalk2.compatdospointer = 0x1E4A;
		s_asparwalk3.compatdospointer = 0x1E68;
		s_asparwalk4.compatdospointer = 0x1E86;
		s_grapewait.compatdospointer = 0x1EA4;
		s_grapefall.compatdospointer = 0x1EC2;
		s_grapesit.compatdospointer = 0x1EE0;
		s_graperise.compatdospointer = 0x1EFE;
		s_taterwalk1.compatdospointer = 0x1F1C;
		s_taterwalk2.compatdospointer = 0x1F3A;
		s_taterwalk3.compatdospointer = 0x1F58;
		s_taterwalk4.compatdospointer = 0x1F76;
		s_taterattack1.compatdospointer = 0x1F94;
		s_taterattack2.compatdospointer = 0x1FB2;
		s_taterattack3.compatdospointer = 0x1FD0;
		s_cartroll1.compatdospointer = 0x1FEE;
		s_cartroll2.compatdospointer = 0x200C;
		s_frenchywalk1.compatdospointer = 0x202A;
		s_frenchywalk2.compatdospointer = 0x2048;
		s_frenchywalk3.compatdospointer = 0x2066;
		s_frenchywalk4.compatdospointer = 0x2084;
		s_frenchyrun1.compatdospointer = 0x20A2;
		s_frenchyrun2.compatdospointer = 0x20C0;
		s_frenchyrun3.compatdospointer = 0x20DE;
		s_frenchyrun4.compatdospointer = 0x20FC;
		s_frenchythrow1.compatdospointer = 0x211A;
		s_frenchythrow2.compatdospointer = 0x2138;
		s_frenchythrow3.compatdospointer = 0x2156;
		s_fry1.compatdospointer = 0x2174;
		s_fry2.compatdospointer = 0x2192;
		s_melonside.compatdospointer = 0x21B0;
		s_melonsidespit.compatdospointer = 0x21CE;
		s_melonsidespit2.compatdospointer = 0x21EC;
		s_melondown.compatdospointer = 0x220A;
		s_melondownspit.compatdospointer = 0x2228;
		s_melondownspit2.compatdospointer = 0x2246;
		s_melonseed1.compatdospointer = 0x2264;
		s_melonseed2.compatdospointer = 0x2282;
		s_melonseedd1.compatdospointer = 0x22A0;
		s_melonseedd2.compatdospointer = 0x22BE;
		s_squasherwalk1.compatdospointer = 0x22DC;
		s_squasherwalk2.compatdospointer = 0x22FA;
		s_squasherjump1.compatdospointer = 0x2318;
		s_squasherjump2.compatdospointer = 0x2336;
		s_squasherwait.compatdospointer = 0x2354;
		s_apelwalk1.compatdospointer = 0x2372;
		s_apelwalk2.compatdospointer = 0x2390;
		s_apelwalk3.compatdospointer = 0x23AE;
		s_apelclimb1.compatdospointer = 0x23CC;
		s_apelclimb2.compatdospointer = 0x23EA;
		s_apelslide1.compatdospointer = 0x2408;
		s_apelslide2.compatdospointer = 0x2426;
		s_apelslide3.compatdospointer = 0x2444;
		s_apelslide4.compatdospointer = 0x2462;
		s_apelfall.compatdospointer = 0x2480;
		s_peabrainfly.compatdospointer = 0x249E;
		s_peabrainwalk1.compatdospointer = 0x24BC;
		s_peabrainwalk2.compatdospointer = 0x24DA;
		s_peabrainwalk3.compatdospointer = 0x24F8;
		s_peabrainwalk4.compatdospointer = 0x2516;
		s_peapodwalk1.compatdospointer = 0x2534;
		s_peapodwalk2.compatdospointer = 0x2552;
		s_peapodwalk3.compatdospointer = 0x2570;
		s_peapodwalk4.compatdospointer = 0x258E;
		s_peapodspit1.compatdospointer = 0x25AC;
		s_peapodspit2.compatdospointer = 0x25CA;
		s_boobuswalk1.compatdospointer = 0x25E8;
		s_boobuswalk2.compatdospointer = 0x2606;
		s_boobuswalk3.compatdospointer = 0x2624;
		s_boobuswalk4.compatdospointer = 0x2642;
		s_boobusjump.compatdospointer = 0x2660;
		s_boobusdie.compatdospointer = 0x267E;
		s_boobusdie2.compatdospointer = 0x269C;
		s_boobusdie3.compatdospointer = 0x26BA;
		s_deathboom1.compatdospointer = 0x26D8;
		s_deathboom2.compatdospointer = 0x26F6;
		s_deathboom3.compatdospointer = 0x2714;
		s_deathboom4.compatdospointer = 0x2732;
		s_deathboom5.compatdospointer = 0x2750;
		s_deathboom6.compatdospointer = 0x276E;

		break;

	case BE_GAMEVER_KDREAMSE120:
		RefKeen_GetObjStatePtrFromDOSPointer = RefKeen_GetObjStatePtrFromDOSPointer_KDreamsE120;

		s_score.compatdospointer = 0x0E22;
		s_flowerpower1.compatdospointer = 0x0E40;
		s_flowerpower2.compatdospointer = 0x0E5E;
		s_boobusbomb1.compatdospointer = 0x0E7C;
		s_boobusbomb2.compatdospointer = 0x0E9A;
		s_bombexplode.compatdospointer = 0x0EB8;
		s_bombexplode2.compatdospointer = 0x0ED6;
		s_bombexplode3.compatdospointer = 0x0EF4;
		s_bombexplode4.compatdospointer = 0x0F12;
		s_bombexplode5.compatdospointer = 0x0F30;
		s_bombexplode6.compatdospointer = 0x0F4E;
		s_powerblink1.compatdospointer = 0x0F6C;
		s_powerblink2.compatdospointer = 0x0F8A;
		s_worldkeen.compatdospointer = 0x0FA8;
		s_worldkeenwave1.compatdospointer = 0x0FC6;
		s_worldkeenwave2.compatdospointer = 0x0FE4;
		s_worldkeenwave3.compatdospointer = 0x1002;
		s_worldkeenwave4.compatdospointer = 0x1020;
		s_worldkeenwave5.compatdospointer = 0x103E;
		s_worldkeenwait.compatdospointer = 0x105C;
		s_worldkeensleep1.compatdospointer = 0x107A;
		s_worldkeensleep2.compatdospointer = 0x1098;
		s_worldwalk.compatdospointer = 0x10B6;
		s_keenzee1.compatdospointer = 0x10EC;
		s_keenzee2.compatdospointer = 0x110A;
		s_keenzee3.compatdospointer = 0x1128;
		s_keenstand.compatdospointer = 0x1146;
		s_keenpauselook.compatdospointer = 0x1164;
		s_keenyawn1.compatdospointer = 0x1182;
		s_keenyawn2.compatdospointer = 0x11A0;
		s_keenyawn3.compatdospointer = 0x11BE;
		s_keenyawn4.compatdospointer = 0x11DC;
		s_keenwait1.compatdospointer = 0x11FA;
		s_keenwait2.compatdospointer = 0x1218;
		s_keenwait3.compatdospointer = 0x1236;
		s_keenwait4.compatdospointer = 0x1254;
		s_keenwait5.compatdospointer = 0x1272;
		s_keenwait6.compatdospointer = 0x1290;
		s_keengosleep1.compatdospointer = 0x12AE;
		s_keengosleep2.compatdospointer = 0x12CC;
		s_keensleep1.compatdospointer = 0x12EA;
		s_keensleep2.compatdospointer = 0x1308;
		s_keengetup.compatdospointer = 0x1326;
		s_keendie1.compatdospointer = 0x1344;
		s_keendie2.compatdospointer = 0x1362;
		s_keendie3.compatdospointer = 0x1380;
		s_keenlookup.compatdospointer = 0x139E;
		s_keenduck.compatdospointer = 0x13BC;
		s_keendrop.compatdospointer = 0x13DA;
		s_keenpole.compatdospointer = 0x13F8;
		s_keenclimb1.compatdospointer = 0x1416;
		s_keenclimb2.compatdospointer = 0x1434;
		s_keenclimb3.compatdospointer = 0x1452;
		s_keenslide1.compatdospointer = 0x1470;
		s_keenslide2.compatdospointer = 0x148E;
		s_keenslide3.compatdospointer = 0x14AC;
		s_keenslide4.compatdospointer = 0x14CA;
		s_keenpolethrow1.compatdospointer = 0x14E8;
		s_keenpolethrow2.compatdospointer = 0x1506;
		s_keenpolethrow3.compatdospointer = 0x1524;
		s_keenpolethrowup1.compatdospointer = 0x1542;
		s_keenpolethrowup2.compatdospointer = 0x1560;
		s_keenpolethrowup3.compatdospointer = 0x157E;
		s_keenpolethrowdown1.compatdospointer = 0x159C;
		s_keenpolethrowdown2.compatdospointer = 0x15BA;
		s_keenpolethrowdown3.compatdospointer = 0x15D8;
		s_keenwalk1.compatdospointer = 0x15F6;
		s_keenwalk2.compatdospointer = 0x1614;
		s_keenwalk3.compatdospointer = 0x1632;
		s_keenwalk4.compatdospointer = 0x1650;
		s_keenthrow1.compatdospointer = 0x166E;
		s_keenthrow2.compatdospointer = 0x168C;
		s_keenthrow3.compatdospointer = 0x16AA;
		s_keenthrow4.compatdospointer = 0x16C8;
		s_keenthrowup1.compatdospointer = 0x16E6;
		s_keenthrowup2.compatdospointer = 0x1704;
		s_keenthrowup3.compatdospointer = 0x1722;
		s_keenjumpup1.compatdospointer = 0x1740;
		s_keenjumpup2.compatdospointer = 0x175E;
		s_keenjumpup3.compatdospointer = 0x177C;
		s_keenjump1.compatdospointer = 0x179A;
		s_keenjump2.compatdospointer = 0x17B8;
		s_keenjump3.compatdospointer = 0x17D6;
		s_keenairthrow1.compatdospointer = 0x17F4;
		s_keenairthrow2.compatdospointer = 0x1812;
		s_keenairthrow3.compatdospointer = 0x1830;
		s_keenairthrowup1.compatdospointer = 0x184E;
		s_keenairthrowup2.compatdospointer = 0x186C;
		s_keenairthrowup3.compatdospointer = 0x188A;
		s_keenairthrowdown1.compatdospointer = 0x18A8;
		s_keenairthrowdown2.compatdospointer = 0x18C6;
		s_keenairthrowdown3.compatdospointer = 0x18E4;
		s_door.compatdospointer = 0x19A0;
		s_doorraise.compatdospointer = 0x19BE;
		s_flower1.compatdospointer = 0x19DC;
		s_flower2.compatdospointer = 0x19FA;
		s_flower3.compatdospointer = 0x1A18;
		s_flower4.compatdospointer = 0x1A36;
		s_flower5.compatdospointer = 0x1A54;
		s_flower6.compatdospointer = 0x1A72;
		s_poofto1.compatdospointer = 0x1A90;
		s_poofto2.compatdospointer = 0x1AAE;
		s_poofto3.compatdospointer = 0x1ACC;
		s_poofto4.compatdospointer = 0x1AEA;
		s_pooffrom1.compatdospointer = 0x1B08;
		s_pooffrom2.compatdospointer = 0x1B26;
		s_pooffrom3.compatdospointer = 0x1B44;
		s_pooffrom4.compatdospointer = 0x1B62;
		s_pooffrom5.compatdospointer = 0x1B80;
		s_pooffrom6.compatdospointer = 0x1B9E;
		s_pooffrom7.compatdospointer = 0x1BBC;
		s_bonus.compatdospointer = 0x1BDA;
		s_bonusrise.compatdospointer = 0x1BF8;
		s_broccowalk1.compatdospointer = 0x1C2E;
		s_broccowalk2.compatdospointer = 0x1C4C;
		s_broccowalk3.compatdospointer = 0x1C6A;
		s_broccowalk4.compatdospointer = 0x1C88;
		s_broccosmash1.compatdospointer = 0x1CA6;
		s_broccosmash2.compatdospointer = 0x1CC4;
		s_broccosmash3.compatdospointer = 0x1CE2;
		s_broccosmash4.compatdospointer = 0x1D00;
		s_broccosmash5.compatdospointer = 0x1D1E;
		s_broccosmash6.compatdospointer = 0x1D3C;
		s_broccosmash7.compatdospointer = 0x1D5A;
		s_broccosmash8.compatdospointer = 0x1D78;
		s_broccosmash9.compatdospointer = 0x1D96;
		s_tomatbounce.compatdospointer = 0x1DB4;
		s_tomatbounce2.compatdospointer = 0x1DD2;
		s_carrotwalk1.compatdospointer = 0x1DF0;
		s_carrotwalk2.compatdospointer = 0x1E0E;
		s_carrotwalk3.compatdospointer = 0x1E2C;
		s_carrotwalk4.compatdospointer = 0x1E4A;
		s_carrotleap.compatdospointer = 0x1E68;
		s_asparwalk1.compatdospointer = 0x1E86;
		s_asparwalk2.compatdospointer = 0x1EA4;
		s_asparwalk3.compatdospointer = 0x1EC2;
		s_asparwalk4.compatdospointer = 0x1EE0;
		s_grapewait.compatdospointer = 0x1EFE;
		s_grapefall.compatdospointer = 0x1F1C;
		s_grapesit.compatdospointer = 0x1F3A;
		s_graperise.compatdospointer = 0x1F58;
		s_taterwalk1.compatdospointer = 0x1F76;
		s_taterwalk2.compatdospointer = 0x1F94;
		s_taterwalk3.compatdospointer = 0x1FB2;
		s_taterwalk4.compatdospointer = 0x1FD0;
		s_taterattack1.compatdospointer = 0x1FEE;
		s_taterattack2.compatdospointer = 0x200C;
		s_taterattack3.compatdospointer = 0x202A;
		s_cartroll1.compatdospointer = 0x2048;
		s_cartroll2.compatdospointer = 0x2066;
		s_frenchywalk1.compatdospointer = 0x2084;
		s_frenchywalk2.compatdospointer = 0x20A2;
		s_frenchywalk3.compatdospointer = 0x20C0;
		s_frenchywalk4.compatdospointer = 0x20DE;
		s_frenchyrun1.compatdospointer = 0x20FC;
		s_frenchyrun2.compatdospointer = 0x211A;
		s_frenchyrun3.compatdospointer = 0x2138;
		s_frenchyrun4.compatdospointer = 0x2156;
		s_frenchythrow1.compatdospointer = 0x2174;
		s_frenchythrow2.compatdospointer = 0x2192;
		s_frenchythrow3.compatdospointer = 0x21B0;
		s_fry1.compatdospointer = 0x21CE;
		s_fry2.compatdospointer = 0x21EC;
		s_melonside.compatdospointer = 0x220A;
		s_melonsidespit.compatdospointer = 0x2228;
		s_melonsidespit2.compatdospointer = 0x2246;
		s_melondown.compatdospointer = 0x2264;
		s_melondownspit.compatdospointer = 0x2282;
		s_melondownspit2.compatdospointer = 0x22A0;
		s_melonseed1.compatdospointer = 0x22BE;
		s_melonseed2.compatdospointer = 0x22DC;
		s_melonseedd1.compatdospointer = 0x22FA;
		s_melonseedd2.compatdospointer = 0x2318;
		s_squasherwalk1.compatdospointer = 0x2336;
		s_squasherwalk2.compatdospointer = 0x2354;
		s_squasherjump1.compatdospointer = 0x2372;
		s_squasherjump2.compatdospointer = 0x2390;
		s_squasherwait.compatdospointer = 0x23AE;
		s_apelwalk1.compatdospointer = 0x23CC;
		s_apelwalk2.compatdospointer = 0x23EA;
		s_apelwalk3.compatdospointer = 0x2408;
		s_apelclimb1.compatdospointer = 0x2426;
		s_apelclimb2.compatdospointer = 0x2444;
		s_apelslide1.compatdospointer = 0x2462;
		s_apelslide2.compatdospointer = 0x2480;
		s_apelslide3.compatdospointer = 0x249E;
		s_apelslide4.compatdospointer = 0x24BC;
		s_apelfall.compatdospointer = 0x24DA;
		s_peabrainfly.compatdospointer = 0x24F8;
		s_peabrainwalk1.compatdospointer = 0x2516;
		s_peabrainwalk2.compatdospointer = 0x2534;
		s_peabrainwalk3.compatdospointer = 0x2552;
		s_peabrainwalk4.compatdospointer = 0x2570;
		s_peapodwalk1.compatdospointer = 0x258E;
		s_peapodwalk2.compatdospointer = 0x25AC;
		s_peapodwalk3.compatdospointer = 0x25CA;
		s_peapodwalk4.compatdospointer = 0x25E8;
		s_peapodspit1.compatdospointer = 0x2606;
		s_peapodspit2.compatdospointer = 0x2624;
		s_boobuswalk1.compatdospointer = 0x2642;
		s_boobuswalk2.compatdospointer = 0x2660;
		s_boobuswalk3.compatdospointer = 0x267E;
		s_boobuswalk4.compatdospointer = 0x269C;
		s_boobusjump.compatdospointer = 0x26BA;
		s_boobusdie.compatdospointer = 0x26D8;
		s_boobusdie2.compatdospointer = 0x26F6;
		s_boobusdie3.compatdospointer = 0x2714;
		s_deathboom1.compatdospointer = 0x2732;
		s_deathboom2.compatdospointer = 0x2750;
		s_deathboom3.compatdospointer = 0x276E;
		s_deathboom4.compatdospointer = 0x278C;
		s_deathboom5.compatdospointer = 0x27AA;
		s_deathboom6.compatdospointer = 0x27C8;

		break;
#endif // EGA/CGA

    case BE_GAMEVER_LAST: break;
	}
}

#ifdef REFKEEN_VER_KDREAMS_CGA_ALL

statetype* RefKeen_GetObjStatePtrFromDOSPointer_KDreamsC105(uint_fast32_t dosptr)
{
	switch (dosptr)
	{
	case 0x0D0A: return &s_score;
	case 0x0D28: return &s_flowerpower1;
	case 0x0D46: return &s_flowerpower2;
	case 0x0D64: return &s_boobusbomb1;
	case 0x0D82: return &s_boobusbomb2;
	case 0x0DA0: return &s_bombexplode;
	case 0x0DBE: return &s_bombexplode2;
	case 0x0DDC: return &s_bombexplode3;
	case 0x0DFA: return &s_bombexplode4;
	case 0x0E18: return &s_bombexplode5;
	case 0x0E36: return &s_bombexplode6;
	case 0x0E54: return &s_powerblink1;
	case 0x0E72: return &s_powerblink2;
	case 0x0E90: return &s_worldkeen;
	case 0x0EAE: return &s_worldkeenwave1;
	case 0x0ECC: return &s_worldkeenwave2;
	case 0x0EEA: return &s_worldkeenwave3;
	case 0x0F08: return &s_worldkeenwave4;
	case 0x0F26: return &s_worldkeenwave5;
	case 0x0F44: return &s_worldkeenwait;
	case 0x0F62: return &s_worldkeensleep1;
	case 0x0F80: return &s_worldkeensleep2;
	case 0x0F9E: return &s_worldwalk;
	case 0x0FD4: return &s_keenzee1;
	case 0x0FF2: return &s_keenzee2;
	case 0x1010: return &s_keenzee3;
	case 0x102E: return &s_keenstand;
	case 0x104C: return &s_keenpauselook;
	case 0x106A: return &s_keenyawn1;
	case 0x1088: return &s_keenyawn2;
	case 0x10A6: return &s_keenyawn3;
	case 0x10C4: return &s_keenyawn4;
	case 0x10E2: return &s_keenwait1;
	case 0x1100: return &s_keenwait2;
	case 0x111E: return &s_keenwait3;
	case 0x113C: return &s_keenwait4;
	case 0x115A: return &s_keenwait5;
	case 0x1178: return &s_keenwait6;
	case 0x1196: return &s_keengosleep1;
	case 0x11B4: return &s_keengosleep2;
	case 0x11D2: return &s_keensleep1;
	case 0x11F0: return &s_keensleep2;
	case 0x120E: return &s_keengetup;
	case 0x122C: return &s_keendie1;
	case 0x124A: return &s_keendie2;
	case 0x1268: return &s_keendie3;
	case 0x1286: return &s_keenlookup;
	case 0x12A4: return &s_keenduck;
	case 0x12C2: return &s_keendrop;
	case 0x12E0: return &s_keenpole;
	case 0x12FE: return &s_keenclimb1;
	case 0x131C: return &s_keenclimb2;
	case 0x133A: return &s_keenclimb3;
	case 0x1358: return &s_keenslide1;
	case 0x1376: return &s_keenslide2;
	case 0x1394: return &s_keenslide3;
	case 0x13B2: return &s_keenslide4;
	case 0x13D0: return &s_keenpolethrow1;
	case 0x13EE: return &s_keenpolethrow2;
	case 0x140C: return &s_keenpolethrow3;
	case 0x142A: return &s_keenpolethrowup1;
	case 0x1448: return &s_keenpolethrowup2;
	case 0x1466: return &s_keenpolethrowup3;
	case 0x1484: return &s_keenpolethrowdown1;
	case 0x14A2: return &s_keenpolethrowdown2;
	case 0x14C0: return &s_keenpolethrowdown3;
	case 0x14DE: return &s_keenwalk1;
	case 0x14FC: return &s_keenwalk2;
	case 0x151A: return &s_keenwalk3;
	case 0x1538: return &s_keenwalk4;
	case 0x1556: return &s_keenthrow1;
	case 0x1574: return &s_keenthrow2;
	case 0x1592: return &s_keenthrow3;
	case 0x15B0: return &s_keenthrow4;
	case 0x15CE: return &s_keenthrowup1;
	case 0x15EC: return &s_keenthrowup2;
	case 0x160A: return &s_keenthrowup3;
	case 0x1628: return &s_keenjumpup1;
	case 0x1646: return &s_keenjumpup2;
	case 0x1664: return &s_keenjumpup3;
	case 0x1682: return &s_keenjump1;
	case 0x16A0: return &s_keenjump2;
	case 0x16BE: return &s_keenjump3;
	case 0x16DC: return &s_keenairthrow1;
	case 0x16FA: return &s_keenairthrow2;
	case 0x1718: return &s_keenairthrow3;
	case 0x1736: return &s_keenairthrowup1;
	case 0x1754: return &s_keenairthrowup2;
	case 0x1772: return &s_keenairthrowup3;
	case 0x1790: return &s_keenairthrowdown1;
	case 0x17AE: return &s_keenairthrowdown2;
	case 0x17CC: return &s_keenairthrowdown3;
	case 0x1888: return &s_door;
	case 0x18A6: return &s_doorraise;
	case 0x18C4: return &s_flower1;
	case 0x18E2: return &s_flower2;
	case 0x1900: return &s_flower3;
	case 0x191E: return &s_flower4;
	case 0x193C: return &s_flower5;
	case 0x195A: return &s_flower6;
	case 0x1978: return &s_poofto1;
	case 0x1996: return &s_poofto2;
	case 0x19B4: return &s_poofto3;
	case 0x19D2: return &s_poofto4;
	case 0x19F0: return &s_pooffrom1;
	case 0x1A0E: return &s_pooffrom2;
	case 0x1A2C: return &s_pooffrom3;
	case 0x1A4A: return &s_pooffrom4;
	case 0x1A68: return &s_pooffrom5;
	case 0x1A86: return &s_pooffrom6;
	case 0x1AA4: return &s_pooffrom7;
	case 0x1AC2: return &s_bonus;
	case 0x1AE0: return &s_bonusrise;
	case 0x1B16: return &s_broccowalk1;
	case 0x1B34: return &s_broccowalk2;
	case 0x1B52: return &s_broccowalk3;
	case 0x1B70: return &s_broccowalk4;
	case 0x1B8E: return &s_broccosmash1;
	case 0x1BAC: return &s_broccosmash2;
	case 0x1BCA: return &s_broccosmash3;
	case 0x1BE8: return &s_broccosmash4;
	case 0x1C06: return &s_broccosmash5;
	case 0x1C24: return &s_broccosmash6;
	case 0x1C42: return &s_broccosmash7;
	case 0x1C60: return &s_broccosmash8;
	case 0x1C7E: return &s_broccosmash9;
	case 0x1C9C: return &s_tomatbounce;
	case 0x1CBA: return &s_tomatbounce2;
	case 0x1CD8: return &s_carrotwalk1;
	case 0x1CF6: return &s_carrotwalk2;
	case 0x1D14: return &s_carrotwalk3;
	case 0x1D32: return &s_carrotwalk4;
	case 0x1D50: return &s_carrotleap;
	case 0x1D6E: return &s_asparwalk1;
	case 0x1D8C: return &s_asparwalk2;
	case 0x1DAA: return &s_asparwalk3;
	case 0x1DC8: return &s_asparwalk4;
	case 0x1DE6: return &s_grapewait;
	case 0x1E04: return &s_grapefall;
	case 0x1E22: return &s_grapesit;
	case 0x1E40: return &s_graperise;
	case 0x1E5E: return &s_taterwalk1;
	case 0x1E7C: return &s_taterwalk2;
	case 0x1E9A: return &s_taterwalk3;
	case 0x1EB8: return &s_taterwalk4;
	case 0x1ED6: return &s_taterattack1;
	case 0x1EF4: return &s_taterattack2;
	case 0x1F12: return &s_taterattack3;
	case 0x1F30: return &s_cartroll1;
	case 0x1F4E: return &s_cartroll2;
	case 0x1F6C: return &s_frenchywalk1;
	case 0x1F8A: return &s_frenchywalk2;
	case 0x1FA8: return &s_frenchywalk3;
	case 0x1FC6: return &s_frenchywalk4;
	case 0x1FE4: return &s_frenchyrun1;
	case 0x2002: return &s_frenchyrun2;
	case 0x2020: return &s_frenchyrun3;
	case 0x203E: return &s_frenchyrun4;
	case 0x205C: return &s_frenchythrow1;
	case 0x207A: return &s_frenchythrow2;
	case 0x2098: return &s_frenchythrow3;
	case 0x20B6: return &s_fry1;
	case 0x20D4: return &s_fry2;
	case 0x20F2: return &s_melonside;
	case 0x2110: return &s_melonsidespit;
	case 0x212E: return &s_melonsidespit2;
	case 0x214C: return &s_melondown;
	case 0x216A: return &s_melondownspit;
	case 0x2188: return &s_melondownspit2;
	case 0x21A6: return &s_melonseed1;
	case 0x21C4: return &s_melonseed2;
	case 0x21E2: return &s_melonseedd1;
	case 0x2200: return &s_melonseedd2;
	case 0x221E: return &s_squasherwalk1;
	case 0x223C: return &s_squasherwalk2;
	case 0x225A: return &s_squasherjump1;
	case 0x2278: return &s_squasherjump2;
	case 0x2296: return &s_squasherwait;
	case 0x22B4: return &s_apelwalk1;
	case 0x22D2: return &s_apelwalk2;
	case 0x22F0: return &s_apelwalk3;
	case 0x230E: return &s_apelclimb1;
	case 0x232C: return &s_apelclimb2;
	case 0x234A: return &s_apelslide1;
	case 0x2368: return &s_apelslide2;
	case 0x2386: return &s_apelslide3;
	case 0x23A4: return &s_apelslide4;
	case 0x23C2: return &s_apelfall;
	case 0x23E0: return &s_peabrainfly;
	case 0x23FE: return &s_peabrainwalk1;
	case 0x241C: return &s_peabrainwalk2;
	case 0x243A: return &s_peabrainwalk3;
	case 0x2458: return &s_peabrainwalk4;
	case 0x2476: return &s_peapodwalk1;
	case 0x2494: return &s_peapodwalk2;
	case 0x24B2: return &s_peapodwalk3;
	case 0x24D0: return &s_peapodwalk4;
	case 0x24EE: return &s_peapodspit1;
	case 0x250C: return &s_peapodspit2;
	case 0x252A: return &s_boobuswalk1;
	case 0x2548: return &s_boobuswalk2;
	case 0x2566: return &s_boobuswalk3;
	case 0x2584: return &s_boobuswalk4;
	case 0x25A2: return &s_boobusjump;
	case 0x25C0: return &s_boobusdie;
	case 0x25DE: return &s_boobusdie2;
	case 0x25FC: return &s_boobusdie3;
	case 0x261A: return &s_deathboom1;
	case 0x2638: return &s_deathboom2;
	case 0x2656: return &s_deathboom3;
	case 0x2674: return &s_deathboom4;
	case 0x2692: return &s_deathboom5;
	case 0x26B0: return &s_deathboom6;
	}
	return NULL;
}

#else // EGA

statetype* RefKeen_GetObjStatePtrFromDOSPointer_KDreamsE113(uint_fast32_t dosptr)
{
	switch (dosptr)
	{
	case 0x0BB4: return &s_score;
	case 0x0BD2: return &s_flowerpower1;
	case 0x0BF0: return &s_flowerpower2;
	case 0x0C0E: return &s_boobusbomb1;
	case 0x0C2C: return &s_boobusbomb2;
	case 0x0C4A: return &s_bombexplode;
	case 0x0C68: return &s_bombexplode2;
	case 0x0C86: return &s_bombexplode3;
	case 0x0CA4: return &s_bombexplode4;
	case 0x0CC2: return &s_bombexplode5;
	case 0x0CE0: return &s_bombexplode6;
	case 0x0CFE: return &s_powerblink1;
	case 0x0D1C: return &s_powerblink2;
	case 0x0D3A: return &s_worldkeen;
	case 0x0D58: return &s_worldkeenwave1;
	case 0x0D76: return &s_worldkeenwave2;
	case 0x0D94: return &s_worldkeenwave3;
	case 0x0DB2: return &s_worldkeenwave4;
	case 0x0DD0: return &s_worldkeenwave5;
	case 0x0DEE: return &s_worldkeenwait;
	case 0x0E0C: return &s_worldkeensleep1;
	case 0x0E2A: return &s_worldkeensleep2;
	case 0x0E48: return &s_worldwalk;
	case 0x0E7E: return &s_keenzee1;
	case 0x0E9C: return &s_keenzee2;
	case 0x0EBA: return &s_keenzee3;
	case 0x0ED8: return &s_keenstand;
	case 0x0EF6: return &s_keenpauselook;
	case 0x0F14: return &s_keenyawn1;
	case 0x0F32: return &s_keenyawn2;
	case 0x0F50: return &s_keenyawn3;
	case 0x0F6E: return &s_keenyawn4;
	case 0x0F8C: return &s_keenwait1;
	case 0x0FAA: return &s_keenwait2;
	case 0x0FC8: return &s_keenwait3;
	case 0x0FE6: return &s_keenwait4;
	case 0x1004: return &s_keenwait5;
	case 0x1022: return &s_keenwait6;
	case 0x1040: return &s_keengosleep1;
	case 0x105E: return &s_keengosleep2;
	case 0x107C: return &s_keensleep1;
	case 0x109A: return &s_keensleep2;
	case 0x10B8: return &s_keengetup;
	case 0x10D6: return &s_keendie1;
	case 0x10F4: return &s_keendie2;
	case 0x1112: return &s_keendie3;
	case 0x1130: return &s_keenlookup;
	case 0x114E: return &s_keenduck;
	case 0x116C: return &s_keendrop;
	case 0x118A: return &s_keenpole;
	case 0x11A8: return &s_keenclimb1;
	case 0x11C6: return &s_keenclimb2;
	case 0x11E4: return &s_keenclimb3;
	case 0x1202: return &s_keenslide1;
	case 0x1220: return &s_keenslide2;
	case 0x123E: return &s_keenslide3;
	case 0x125C: return &s_keenslide4;
	case 0x127A: return &s_keenpolethrow1;
	case 0x1298: return &s_keenpolethrow2;
	case 0x12B6: return &s_keenpolethrow3;
	case 0x12D4: return &s_keenpolethrowup1;
	case 0x12F2: return &s_keenpolethrowup2;
	case 0x1310: return &s_keenpolethrowup3;
	case 0x132E: return &s_keenpolethrowdown1;
	case 0x134C: return &s_keenpolethrowdown2;
	case 0x136A: return &s_keenpolethrowdown3;
	case 0x1388: return &s_keenwalk1;
	case 0x13A6: return &s_keenwalk2;
	case 0x13C4: return &s_keenwalk3;
	case 0x13E2: return &s_keenwalk4;
	case 0x1400: return &s_keenthrow1;
	case 0x141E: return &s_keenthrow2;
	case 0x143C: return &s_keenthrow3;
	case 0x145A: return &s_keenthrow4;
	case 0x1478: return &s_keenthrowup1;
	case 0x1496: return &s_keenthrowup2;
	case 0x14B4: return &s_keenthrowup3;
	case 0x14D2: return &s_keenjumpup1;
	case 0x14F0: return &s_keenjumpup2;
	case 0x150E: return &s_keenjumpup3;
	case 0x152C: return &s_keenjump1;
	case 0x154A: return &s_keenjump2;
	case 0x1568: return &s_keenjump3;
	case 0x1586: return &s_keenairthrow1;
	case 0x15A4: return &s_keenairthrow2;
	case 0x15C2: return &s_keenairthrow3;
	case 0x15E0: return &s_keenairthrowup1;
	case 0x15FE: return &s_keenairthrowup2;
	case 0x161C: return &s_keenairthrowup3;
	case 0x163A: return &s_keenairthrowdown1;
	case 0x1658: return &s_keenairthrowdown2;
	case 0x1676: return &s_keenairthrowdown3;
	case 0x1732: return &s_door;
	case 0x1750: return &s_doorraise;
	case 0x176E: return &s_flower1;
	case 0x178C: return &s_flower2;
	case 0x17AA: return &s_flower3;
	case 0x17C8: return &s_flower4;
	case 0x17E6: return &s_flower5;
	case 0x1804: return &s_flower6;
	case 0x1822: return &s_poofto1;
	case 0x1840: return &s_poofto2;
	case 0x185E: return &s_poofto3;
	case 0x187C: return &s_poofto4;
	case 0x189A: return &s_pooffrom1;
	case 0x18B8: return &s_pooffrom2;
	case 0x18D6: return &s_pooffrom3;
	case 0x18F4: return &s_pooffrom4;
	case 0x1912: return &s_pooffrom5;
	case 0x1930: return &s_pooffrom6;
	case 0x194E: return &s_pooffrom7;
	case 0x196C: return &s_bonus;
	case 0x198A: return &s_bonusrise;
	case 0x19C0: return &s_broccowalk1;
	case 0x19DE: return &s_broccowalk2;
	case 0x19FC: return &s_broccowalk3;
	case 0x1A1A: return &s_broccowalk4;
	case 0x1A38: return &s_broccosmash1;
	case 0x1A56: return &s_broccosmash2;
	case 0x1A74: return &s_broccosmash3;
	case 0x1A92: return &s_broccosmash4;
	case 0x1AB0: return &s_broccosmash5;
	case 0x1ACE: return &s_broccosmash6;
	case 0x1AEC: return &s_broccosmash7;
	case 0x1B0A: return &s_broccosmash8;
	case 0x1B28: return &s_broccosmash9;
	case 0x1B46: return &s_tomatbounce;
	case 0x1B64: return &s_tomatbounce2;
	case 0x1B82: return &s_carrotwalk1;
	case 0x1BA0: return &s_carrotwalk2;
	case 0x1BBE: return &s_carrotwalk3;
	case 0x1BDC: return &s_carrotwalk4;
	case 0x1BFA: return &s_carrotleap;
	case 0x1C18: return &s_asparwalk1;
	case 0x1C36: return &s_asparwalk2;
	case 0x1C54: return &s_asparwalk3;
	case 0x1C72: return &s_asparwalk4;
	case 0x1C90: return &s_grapewait;
	case 0x1CAE: return &s_grapefall;
	case 0x1CCC: return &s_grapesit;
	case 0x1CEA: return &s_graperise;
	case 0x1D08: return &s_taterwalk1;
	case 0x1D26: return &s_taterwalk2;
	case 0x1D44: return &s_taterwalk3;
	case 0x1D62: return &s_taterwalk4;
	case 0x1D80: return &s_taterattack1;
	case 0x1D9E: return &s_taterattack2;
	case 0x1DBC: return &s_taterattack3;
	case 0x1DDA: return &s_cartroll1;
	case 0x1DF8: return &s_cartroll2;
	case 0x1E16: return &s_frenchywalk1;
	case 0x1E34: return &s_frenchywalk2;
	case 0x1E52: return &s_frenchywalk3;
	case 0x1E70: return &s_frenchywalk4;
	case 0x1E8E: return &s_frenchyrun1;
	case 0x1EAC: return &s_frenchyrun2;
	case 0x1ECA: return &s_frenchyrun3;
	case 0x1EE8: return &s_frenchyrun4;
	case 0x1F06: return &s_frenchythrow1;
	case 0x1F24: return &s_frenchythrow2;
	case 0x1F42: return &s_frenchythrow3;
	case 0x1F60: return &s_fry1;
	case 0x1F7E: return &s_fry2;
	case 0x1F9C: return &s_melonside;
	case 0x1FBA: return &s_melonsidespit;
	case 0x1FD8: return &s_melonsidespit2;
	case 0x1FF6: return &s_melondown;
	case 0x2014: return &s_melondownspit;
	case 0x2032: return &s_melondownspit2;
	case 0x2050: return &s_melonseed1;
	case 0x206E: return &s_melonseed2;
	case 0x208C: return &s_melonseedd1;
	case 0x20AA: return &s_melonseedd2;
	case 0x20C8: return &s_squasherwalk1;
	case 0x20E6: return &s_squasherwalk2;
	case 0x2104: return &s_squasherjump1;
	case 0x2122: return &s_squasherjump2;
	case 0x2140: return &s_squasherwait;
	case 0x215E: return &s_apelwalk1;
	case 0x217C: return &s_apelwalk2;
	case 0x219A: return &s_apelwalk3;
	case 0x21B8: return &s_apelclimb1;
	case 0x21D6: return &s_apelclimb2;
	case 0x21F4: return &s_apelslide1;
	case 0x2212: return &s_apelslide2;
	case 0x2230: return &s_apelslide3;
	case 0x224E: return &s_apelslide4;
	case 0x226C: return &s_apelfall;
	case 0x228A: return &s_peabrainfly;
	case 0x22A8: return &s_peabrainwalk1;
	case 0x22C6: return &s_peabrainwalk2;
	case 0x22E4: return &s_peabrainwalk3;
	case 0x2302: return &s_peabrainwalk4;
	case 0x2320: return &s_peapodwalk1;
	case 0x233E: return &s_peapodwalk2;
	case 0x235C: return &s_peapodwalk3;
	case 0x237A: return &s_peapodwalk4;
	case 0x2398: return &s_peapodspit1;
	case 0x23B6: return &s_peapodspit2;
	case 0x23D4: return &s_boobuswalk1;
	case 0x23F2: return &s_boobuswalk2;
	case 0x2410: return &s_boobuswalk3;
	case 0x242E: return &s_boobuswalk4;
	case 0x244C: return &s_boobusjump;
	case 0x246A: return &s_boobusdie;
	case 0x2488: return &s_boobusdie2;
	case 0x24A6: return &s_boobusdie3;
	case 0x24C4: return &s_deathboom1;
	case 0x24E2: return &s_deathboom2;
	case 0x2500: return &s_deathboom3;
	case 0x251E: return &s_deathboom4;
	case 0x253C: return &s_deathboom5;
	case 0x255A: return &s_deathboom6;
	}
	return NULL;
}

statetype* RefKeen_GetObjStatePtrFromDOSPointer_KDreamsE193(uint_fast32_t dosptr)
{
	switch (dosptr)
	{
	case 0x0DC8: return &s_score;
	case 0x0DE6: return &s_flowerpower1;
	case 0x0E04: return &s_flowerpower2;
	case 0x0E22: return &s_boobusbomb1;
	case 0x0E40: return &s_boobusbomb2;
	case 0x0E5E: return &s_bombexplode;
	case 0x0E7C: return &s_bombexplode2;
	case 0x0E9A: return &s_bombexplode3;
	case 0x0EB8: return &s_bombexplode4;
	case 0x0ED6: return &s_bombexplode5;
	case 0x0EF4: return &s_bombexplode6;
	case 0x0F12: return &s_powerblink1;
	case 0x0F30: return &s_powerblink2;
	case 0x0F4E: return &s_worldkeen;
	case 0x0F6C: return &s_worldkeenwave1;
	case 0x0F8A: return &s_worldkeenwave2;
	case 0x0FA8: return &s_worldkeenwave3;
	case 0x0FC6: return &s_worldkeenwave4;
	case 0x0FE4: return &s_worldkeenwave5;
	case 0x1002: return &s_worldkeenwait;
	case 0x1020: return &s_worldkeensleep1;
	case 0x103E: return &s_worldkeensleep2;
	case 0x105C: return &s_worldwalk;
	case 0x1092: return &s_keenzee1;
	case 0x10B0: return &s_keenzee2;
	case 0x10CE: return &s_keenzee3;
	case 0x10EC: return &s_keenstand;
	case 0x110A: return &s_keenpauselook;
	case 0x1128: return &s_keenyawn1;
	case 0x1146: return &s_keenyawn2;
	case 0x1164: return &s_keenyawn3;
	case 0x1182: return &s_keenyawn4;
	case 0x11A0: return &s_keenwait1;
	case 0x11BE: return &s_keenwait2;
	case 0x11DC: return &s_keenwait3;
	case 0x11FA: return &s_keenwait4;
	case 0x1218: return &s_keenwait5;
	case 0x1236: return &s_keenwait6;
	case 0x1254: return &s_keengosleep1;
	case 0x1272: return &s_keengosleep2;
	case 0x1290: return &s_keensleep1;
	case 0x12AE: return &s_keensleep2;
	case 0x12CC: return &s_keengetup;
	case 0x12EA: return &s_keendie1;
	case 0x1308: return &s_keendie2;
	case 0x1326: return &s_keendie3;
	case 0x1344: return &s_keenlookup;
	case 0x1362: return &s_keenduck;
	case 0x1380: return &s_keendrop;
	case 0x139E: return &s_keenpole;
	case 0x13BC: return &s_keenclimb1;
	case 0x13DA: return &s_keenclimb2;
	case 0x13F8: return &s_keenclimb3;
	case 0x1416: return &s_keenslide1;
	case 0x1434: return &s_keenslide2;
	case 0x1452: return &s_keenslide3;
	case 0x1470: return &s_keenslide4;
	case 0x148E: return &s_keenpolethrow1;
	case 0x14AC: return &s_keenpolethrow2;
	case 0x14CA: return &s_keenpolethrow3;
	case 0x14E8: return &s_keenpolethrowup1;
	case 0x1506: return &s_keenpolethrowup2;
	case 0x1524: return &s_keenpolethrowup3;
	case 0x1542: return &s_keenpolethrowdown1;
	case 0x1560: return &s_keenpolethrowdown2;
	case 0x157E: return &s_keenpolethrowdown3;
	case 0x159C: return &s_keenwalk1;
	case 0x15BA: return &s_keenwalk2;
	case 0x15D8: return &s_keenwalk3;
	case 0x15F6: return &s_keenwalk4;
	case 0x1614: return &s_keenthrow1;
	case 0x1632: return &s_keenthrow2;
	case 0x1650: return &s_keenthrow3;
	case 0x166E: return &s_keenthrow4;
	case 0x168C: return &s_keenthrowup1;
	case 0x16AA: return &s_keenthrowup2;
	case 0x16C8: return &s_keenthrowup3;
	case 0x16E6: return &s_keenjumpup1;
	case 0x1704: return &s_keenjumpup2;
	case 0x1722: return &s_keenjumpup3;
	case 0x1740: return &s_keenjump1;
	case 0x175E: return &s_keenjump2;
	case 0x177C: return &s_keenjump3;
	case 0x179A: return &s_keenairthrow1;
	case 0x17B8: return &s_keenairthrow2;
	case 0x17D6: return &s_keenairthrow3;
	case 0x17F4: return &s_keenairthrowup1;
	case 0x1812: return &s_keenairthrowup2;
	case 0x1830: return &s_keenairthrowup3;
	case 0x184E: return &s_keenairthrowdown1;
	case 0x186C: return &s_keenairthrowdown2;
	case 0x188A: return &s_keenairthrowdown3;
	case 0x1946: return &s_door;
	case 0x1964: return &s_doorraise;
	case 0x1982: return &s_flower1;
	case 0x19A0: return &s_flower2;
	case 0x19BE: return &s_flower3;
	case 0x19DC: return &s_flower4;
	case 0x19FA: return &s_flower5;
	case 0x1A18: return &s_flower6;
	case 0x1A36: return &s_poofto1;
	case 0x1A54: return &s_poofto2;
	case 0x1A72: return &s_poofto3;
	case 0x1A90: return &s_poofto4;
	case 0x1AAE: return &s_pooffrom1;
	case 0x1ACC: return &s_pooffrom2;
	case 0x1AEA: return &s_pooffrom3;
	case 0x1B08: return &s_pooffrom4;
	case 0x1B26: return &s_pooffrom5;
	case 0x1B44: return &s_pooffrom6;
	case 0x1B62: return &s_pooffrom7;
	case 0x1B80: return &s_bonus;
	case 0x1B9E: return &s_bonusrise;
	case 0x1BD4: return &s_broccowalk1;
	case 0x1BF2: return &s_broccowalk2;
	case 0x1C10: return &s_broccowalk3;
	case 0x1C2E: return &s_broccowalk4;
	case 0x1C4C: return &s_broccosmash1;
	case 0x1C6A: return &s_broccosmash2;
	case 0x1C88: return &s_broccosmash3;
	case 0x1CA6: return &s_broccosmash4;
	case 0x1CC4: return &s_broccosmash5;
	case 0x1CE2: return &s_broccosmash6;
	case 0x1D00: return &s_broccosmash7;
	case 0x1D1E: return &s_broccosmash8;
	case 0x1D3C: return &s_broccosmash9;
	case 0x1D5A: return &s_tomatbounce;
	case 0x1D78: return &s_tomatbounce2;
	case 0x1D96: return &s_carrotwalk1;
	case 0x1DB4: return &s_carrotwalk2;
	case 0x1DD2: return &s_carrotwalk3;
	case 0x1DF0: return &s_carrotwalk4;
	case 0x1E0E: return &s_carrotleap;
	case 0x1E2C: return &s_asparwalk1;
	case 0x1E4A: return &s_asparwalk2;
	case 0x1E68: return &s_asparwalk3;
	case 0x1E86: return &s_asparwalk4;
	case 0x1EA4: return &s_grapewait;
	case 0x1EC2: return &s_grapefall;
	case 0x1EE0: return &s_grapesit;
	case 0x1EFE: return &s_graperise;
	case 0x1F1C: return &s_taterwalk1;
	case 0x1F3A: return &s_taterwalk2;
	case 0x1F58: return &s_taterwalk3;
	case 0x1F76: return &s_taterwalk4;
	case 0x1F94: return &s_taterattack1;
	case 0x1FB2: return &s_taterattack2;
	case 0x1FD0: return &s_taterattack3;
	case 0x1FEE: return &s_cartroll1;
	case 0x200C: return &s_cartroll2;
	case 0x202A: return &s_frenchywalk1;
	case 0x2048: return &s_frenchywalk2;
	case 0x2066: return &s_frenchywalk3;
	case 0x2084: return &s_frenchywalk4;
	case 0x20A2: return &s_frenchyrun1;
	case 0x20C0: return &s_frenchyrun2;
	case 0x20DE: return &s_frenchyrun3;
	case 0x20FC: return &s_frenchyrun4;
	case 0x211A: return &s_frenchythrow1;
	case 0x2138: return &s_frenchythrow2;
	case 0x2156: return &s_frenchythrow3;
	case 0x2174: return &s_fry1;
	case 0x2192: return &s_fry2;
	case 0x21B0: return &s_melonside;
	case 0x21CE: return &s_melonsidespit;
	case 0x21EC: return &s_melonsidespit2;
	case 0x220A: return &s_melondown;
	case 0x2228: return &s_melondownspit;
	case 0x2246: return &s_melondownspit2;
	case 0x2264: return &s_melonseed1;
	case 0x2282: return &s_melonseed2;
	case 0x22A0: return &s_melonseedd1;
	case 0x22BE: return &s_melonseedd2;
	case 0x22DC: return &s_squasherwalk1;
	case 0x22FA: return &s_squasherwalk2;
	case 0x2318: return &s_squasherjump1;
	case 0x2336: return &s_squasherjump2;
	case 0x2354: return &s_squasherwait;
	case 0x2372: return &s_apelwalk1;
	case 0x2390: return &s_apelwalk2;
	case 0x23AE: return &s_apelwalk3;
	case 0x23CC: return &s_apelclimb1;
	case 0x23EA: return &s_apelclimb2;
	case 0x2408: return &s_apelslide1;
	case 0x2426: return &s_apelslide2;
	case 0x2444: return &s_apelslide3;
	case 0x2462: return &s_apelslide4;
	case 0x2480: return &s_apelfall;
	case 0x249E: return &s_peabrainfly;
	case 0x24BC: return &s_peabrainwalk1;
	case 0x24DA: return &s_peabrainwalk2;
	case 0x24F8: return &s_peabrainwalk3;
	case 0x2516: return &s_peabrainwalk4;
	case 0x2534: return &s_peapodwalk1;
	case 0x2552: return &s_peapodwalk2;
	case 0x2570: return &s_peapodwalk3;
	case 0x258E: return &s_peapodwalk4;
	case 0x25AC: return &s_peapodspit1;
	case 0x25CA: return &s_peapodspit2;
	case 0x25E8: return &s_boobuswalk1;
	case 0x2606: return &s_boobuswalk2;
	case 0x2624: return &s_boobuswalk3;
	case 0x2642: return &s_boobuswalk4;
	case 0x2660: return &s_boobusjump;
	case 0x267E: return &s_boobusdie;
	case 0x269C: return &s_boobusdie2;
	case 0x26BA: return &s_boobusdie3;
	case 0x26D8: return &s_deathboom1;
	case 0x26F6: return &s_deathboom2;
	case 0x2714: return &s_deathboom3;
	case 0x2732: return &s_deathboom4;
	case 0x2750: return &s_deathboom5;
	case 0x276E: return &s_deathboom6;
	}
	return NULL;
}

statetype* RefKeen_GetObjStatePtrFromDOSPointer_KDreamsE120(uint_fast32_t dosptr)
{
	switch (dosptr)
	{
	case 0x0E22: return &s_score;
	case 0x0E40: return &s_flowerpower1;
	case 0x0E5E: return &s_flowerpower2;
	case 0x0E7C: return &s_boobusbomb1;
	case 0x0E9A: return &s_boobusbomb2;
	case 0x0EB8: return &s_bombexplode;
	case 0x0ED6: return &s_bombexplode2;
	case 0x0EF4: return &s_bombexplode3;
	case 0x0F12: return &s_bombexplode4;
	case 0x0F30: return &s_bombexplode5;
	case 0x0F4E: return &s_bombexplode6;
	case 0x0F6C: return &s_powerblink1;
	case 0x0F8A: return &s_powerblink2;
	case 0x0FA8: return &s_worldkeen;
	case 0x0FC6: return &s_worldkeenwave1;
	case 0x0FE4: return &s_worldkeenwave2;
	case 0x1002: return &s_worldkeenwave3;
	case 0x1020: return &s_worldkeenwave4;
	case 0x103E: return &s_worldkeenwave5;
	case 0x105C: return &s_worldkeenwait;
	case 0x107A: return &s_worldkeensleep1;
	case 0x1098: return &s_worldkeensleep2;
	case 0x10B6: return &s_worldwalk;
	case 0x10EC: return &s_keenzee1;
	case 0x110A: return &s_keenzee2;
	case 0x1128: return &s_keenzee3;
	case 0x1146: return &s_keenstand;
	case 0x1164: return &s_keenpauselook;
	case 0x1182: return &s_keenyawn1;
	case 0x11A0: return &s_keenyawn2;
	case 0x11BE: return &s_keenyawn3;
	case 0x11DC: return &s_keenyawn4;
	case 0x11FA: return &s_keenwait1;
	case 0x1218: return &s_keenwait2;
	case 0x1236: return &s_keenwait3;
	case 0x1254: return &s_keenwait4;
	case 0x1272: return &s_keenwait5;
	case 0x1290: return &s_keenwait6;
	case 0x12AE: return &s_keengosleep1;
	case 0x12CC: return &s_keengosleep2;
	case 0x12EA: return &s_keensleep1;
	case 0x1308: return &s_keensleep2;
	case 0x1326: return &s_keengetup;
	case 0x1344: return &s_keendie1;
	case 0x1362: return &s_keendie2;
	case 0x1380: return &s_keendie3;
	case 0x139E: return &s_keenlookup;
	case 0x13BC: return &s_keenduck;
	case 0x13DA: return &s_keendrop;
	case 0x13F8: return &s_keenpole;
	case 0x1416: return &s_keenclimb1;
	case 0x1434: return &s_keenclimb2;
	case 0x1452: return &s_keenclimb3;
	case 0x1470: return &s_keenslide1;
	case 0x148E: return &s_keenslide2;
	case 0x14AC: return &s_keenslide3;
	case 0x14CA: return &s_keenslide4;
	case 0x14E8: return &s_keenpolethrow1;
	case 0x1506: return &s_keenpolethrow2;
	case 0x1524: return &s_keenpolethrow3;
	case 0x1542: return &s_keenpolethrowup1;
	case 0x1560: return &s_keenpolethrowup2;
	case 0x157E: return &s_keenpolethrowup3;
	case 0x159C: return &s_keenpolethrowdown1;
	case 0x15BA: return &s_keenpolethrowdown2;
	case 0x15D8: return &s_keenpolethrowdown3;
	case 0x15F6: return &s_keenwalk1;
	case 0x1614: return &s_keenwalk2;
	case 0x1632: return &s_keenwalk3;
	case 0x1650: return &s_keenwalk4;
	case 0x166E: return &s_keenthrow1;
	case 0x168C: return &s_keenthrow2;
	case 0x16AA: return &s_keenthrow3;
	case 0x16C8: return &s_keenthrow4;
	case 0x16E6: return &s_keenthrowup1;
	case 0x1704: return &s_keenthrowup2;
	case 0x1722: return &s_keenthrowup3;
	case 0x1740: return &s_keenjumpup1;
	case 0x175E: return &s_keenjumpup2;
	case 0x177C: return &s_keenjumpup3;
	case 0x179A: return &s_keenjump1;
	case 0x17B8: return &s_keenjump2;
	case 0x17D6: return &s_keenjump3;
	case 0x17F4: return &s_keenairthrow1;
	case 0x1812: return &s_keenairthrow2;
	case 0x1830: return &s_keenairthrow3;
	case 0x184E: return &s_keenairthrowup1;
	case 0x186C: return &s_keenairthrowup2;
	case 0x188A: return &s_keenairthrowup3;
	case 0x18A8: return &s_keenairthrowdown1;
	case 0x18C6: return &s_keenairthrowdown2;
	case 0x18E4: return &s_keenairthrowdown3;
	case 0x19A0: return &s_door;
	case 0x19BE: return &s_doorraise;
	case 0x19DC: return &s_flower1;
	case 0x19FA: return &s_flower2;
	case 0x1A18: return &s_flower3;
	case 0x1A36: return &s_flower4;
	case 0x1A54: return &s_flower5;
	case 0x1A72: return &s_flower6;
	case 0x1A90: return &s_poofto1;
	case 0x1AAE: return &s_poofto2;
	case 0x1ACC: return &s_poofto3;
	case 0x1AEA: return &s_poofto4;
	case 0x1B08: return &s_pooffrom1;
	case 0x1B26: return &s_pooffrom2;
	case 0x1B44: return &s_pooffrom3;
	case 0x1B62: return &s_pooffrom4;
	case 0x1B80: return &s_pooffrom5;
	case 0x1B9E: return &s_pooffrom6;
	case 0x1BBC: return &s_pooffrom7;
	case 0x1BDA: return &s_bonus;
	case 0x1BF8: return &s_bonusrise;
	case 0x1C2E: return &s_broccowalk1;
	case 0x1C4C: return &s_broccowalk2;
	case 0x1C6A: return &s_broccowalk3;
	case 0x1C88: return &s_broccowalk4;
	case 0x1CA6: return &s_broccosmash1;
	case 0x1CC4: return &s_broccosmash2;
	case 0x1CE2: return &s_broccosmash3;
	case 0x1D00: return &s_broccosmash4;
	case 0x1D1E: return &s_broccosmash5;
	case 0x1D3C: return &s_broccosmash6;
	case 0x1D5A: return &s_broccosmash7;
	case 0x1D78: return &s_broccosmash8;
	case 0x1D96: return &s_broccosmash9;
	case 0x1DB4: return &s_tomatbounce;
	case 0x1DD2: return &s_tomatbounce2;
	case 0x1DF0: return &s_carrotwalk1;
	case 0x1E0E: return &s_carrotwalk2;
	case 0x1E2C: return &s_carrotwalk3;
	case 0x1E4A: return &s_carrotwalk4;
	case 0x1E68: return &s_carrotleap;
	case 0x1E86: return &s_asparwalk1;
	case 0x1EA4: return &s_asparwalk2;
	case 0x1EC2: return &s_asparwalk3;
	case 0x1EE0: return &s_asparwalk4;
	case 0x1EFE: return &s_grapewait;
	case 0x1F1C: return &s_grapefall;
	case 0x1F3A: return &s_grapesit;
	case 0x1F58: return &s_graperise;
	case 0x1F76: return &s_taterwalk1;
	case 0x1F94: return &s_taterwalk2;
	case 0x1FB2: return &s_taterwalk3;
	case 0x1FD0: return &s_taterwalk4;
	case 0x1FEE: return &s_taterattack1;
	case 0x200C: return &s_taterattack2;
	case 0x202A: return &s_taterattack3;
	case 0x2048: return &s_cartroll1;
	case 0x2066: return &s_cartroll2;
	case 0x2084: return &s_frenchywalk1;
	case 0x20A2: return &s_frenchywalk2;
	case 0x20C0: return &s_frenchywalk3;
	case 0x20DE: return &s_frenchywalk4;
	case 0x20FC: return &s_frenchyrun1;
	case 0x211A: return &s_frenchyrun2;
	case 0x2138: return &s_frenchyrun3;
	case 0x2156: return &s_frenchyrun4;
	case 0x2174: return &s_frenchythrow1;
	case 0x2192: return &s_frenchythrow2;
	case 0x21B0: return &s_frenchythrow3;
	case 0x21CE: return &s_fry1;
	case 0x21EC: return &s_fry2;
	case 0x220A: return &s_melonside;
	case 0x2228: return &s_melonsidespit;
	case 0x2246: return &s_melonsidespit2;
	case 0x2264: return &s_melondown;
	case 0x2282: return &s_melondownspit;
	case 0x22A0: return &s_melondownspit2;
	case 0x22BE: return &s_melonseed1;
	case 0x22DC: return &s_melonseed2;
	case 0x22FA: return &s_melonseedd1;
	case 0x2318: return &s_melonseedd2;
	case 0x2336: return &s_squasherwalk1;
	case 0x2354: return &s_squasherwalk2;
	case 0x2372: return &s_squasherjump1;
	case 0x2390: return &s_squasherjump2;
	case 0x23AE: return &s_squasherwait;
	case 0x23CC: return &s_apelwalk1;
	case 0x23EA: return &s_apelwalk2;
	case 0x2408: return &s_apelwalk3;
	case 0x2426: return &s_apelclimb1;
	case 0x2444: return &s_apelclimb2;
	case 0x2462: return &s_apelslide1;
	case 0x2480: return &s_apelslide2;
	case 0x249E: return &s_apelslide3;
	case 0x24BC: return &s_apelslide4;
	case 0x24DA: return &s_apelfall;
	case 0x24F8: return &s_peabrainfly;
	case 0x2516: return &s_peabrainwalk1;
	case 0x2534: return &s_peabrainwalk2;
	case 0x2552: return &s_peabrainwalk3;
	case 0x2570: return &s_peabrainwalk4;
	case 0x258E: return &s_peapodwalk1;
	case 0x25AC: return &s_peapodwalk2;
	case 0x25CA: return &s_peapodwalk3;
	case 0x25E8: return &s_peapodwalk4;
	case 0x2606: return &s_peapodspit1;
	case 0x2624: return &s_peapodspit2;
	case 0x2642: return &s_boobuswalk1;
	case 0x2660: return &s_boobuswalk2;
	case 0x267E: return &s_boobuswalk3;
	case 0x269C: return &s_boobuswalk4;
	case 0x26BA: return &s_boobusjump;
	case 0x26D8: return &s_boobusdie;
	case 0x26F6: return &s_boobusdie2;
	case 0x2714: return &s_boobusdie3;
	case 0x2732: return &s_deathboom1;
	case 0x2750: return &s_deathboom2;
	case 0x276E: return &s_deathboom3;
	case 0x278C: return &s_deathboom4;
	case 0x27AA: return &s_deathboom5;
	case 0x27C8: return &s_deathboom6;
    default: break;
	}
	return NULL;
}

#endif // EGA/CGA

}
