if(ENABLE_SDL2)
  find_package(SDL2 2.30.0 REQUIRED)
endif()
if(NOT WIN32 AND NOT ANDROID)
  # From PCSX2: On macOS, Mono.framework contains an ancient version of libpng. We don't want that.
  # Avoid it by telling cmake to avoid finding frameworks while we search for libpng.
  if(APPLE)
    set(FIND_FRAMEWORK_BACKUP ${CMAKE_FIND_FRAMEWORK})
    set(CMAKE_FIND_FRAMEWORK NEVER)
  endif()

  find_package(Zstd REQUIRED)
  find_package(WebP REQUIRED)
  find_package(ZLIB REQUIRED)
  find_package(PNG REQUIRED)
  find_package(JPEG REQUIRED)
  find_package(CURL REQUIRED)
  if(APPLE)
    set(CMAKE_FIND_FRAMEWORK ${FIND_FRAMEWORK_BACKUP})
  endif()
endif()
if(LINUX AND NOT ANDROID)
  find_package(UDEV REQUIRED)
endif()
if(UNIX AND NOT APPLE)
  find_package(Libbacktrace)
  if(NOT LIBBACKTRACE_FOUND)
    message(WARNING "libbacktrace not found, crashes will not produce backtraces.")
  endif()
endif()
