/*
 * Wolfenstein: Enemy Territory GPL Source Code
 * Copyright (C) 1999-2010 id Software LLC, a ZeniMax Media company.
 *
 * ET: Legacy
 * Copyright (C) 2012-2024 ET:Legacy team <mail@etlegacy.com>
 *
 * This file is part of ET: Legacy - http://www.etlegacy.com
 *
 * ET: Legacy is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * ET: Legacy is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ET: Legacy. If not, see <http://www.gnu.org/licenses/>.
 *
 * In addition, Wolfenstein: Enemy Territory GPL Source Code is also
 * subject to certain additional terms. You should have received a copy
 * of these additional terms immediately following the terms and conditions
 * of the GNU General Public License which accompanied the source code.
 * If not, please request a copy in writing from id Software at the address below.
 *
 * id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.
 */
/**
 * @file sdl_icon.h
 * @brief GIMP RGBA C-Source image dump (sdl_icon.h)
 */

#ifndef INCLUDE_SDL_ICON_H
#define INCLUDE_SDL_ICON_H

static const struct
{
	unsigned int width;
	unsigned int height;
	unsigned int bytes_per_pixel;     // 2:RGB16, 3:RGB, 4:RGBA
	unsigned char pixel_data[64 * 64 * 4 + 1];
} CLIENT_WINDOW_ICON =
{
	64, 64, 4,
	"\000\000\000\000(#-\000\060$)P\060$)\265\060$)\341\060$)\371\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\371\060$)\341\060$)\265\060$)P(#-\000\000\000\000\000\063%+\000\060$)\227\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\226\063&-\000\060$)Q\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)Q\060$)\267\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\266\060$)\346\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\346\060$)\373\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\373\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377B$(\377P#&\377\062$(\377/$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377}##\377\377\036\000\377\372\036\000\377\355\037\007\377"
	"\342\037\014\377\330\040\021\377\307\040\027\377\267!\032\377\244\"\036\377\220\""
	"!\377}##\377Q#&\377\063$(\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377}##\377\376\036\000\377"
	"\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036"
	"\000\377\376\036\000\377\376\036\000\377\376\036\000\377\377\036\000\377\373\036\000\377\346"
	"\037\012\377\231\"\037\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$"
	")\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$"
	")\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$"
	")\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$"
	")\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$"
	")\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$"
	")\377\060$)\377\060$)\377\060$)\377}##\377\376\036\000\377\376\036\000\377\376\036"
	"\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376"
	"\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\375\036\000\377"
	"\227\"\037\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)"
	"\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)"
	"\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)"
	"\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)"
	"\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)"
	"\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)"
	"\377\060$)\377}##\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377"
	"\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036"
	"\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\344\037\013\377"
	"/$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377}##"
	"\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376"
	"\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377"
	"\372\036\001\377\325\040\022\377\271!\031\377\257!\032\377\061$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377}##\377\376\036\000\377\376"
	"\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377"
	"\376\036\000\377\376\036\000\377\376\036\000\377\344\037\013\377i#%\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377}##\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377"
	"\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\361\036"
	"\005\377V#&\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)"
	"\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)"
	"\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)"
	"\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)"
	"\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)"
	"\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)"
	"\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377}##\377\376\036\000\377\376"
	"\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377"
	"\376\036\000\377\376\036\000\377\257!\033\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377}##\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376"
	"\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377|##\377\060$"
	")\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$"
	")\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$"
	")\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$"
	")\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$"
	")\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$"
	")\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$"
	")\377\060$)\377\060$)\377\060$)\377\060$)\377}##\377\376\036\000\377\376\036\000\377"
	"\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036"
	"\000\377\377\036\000\377f#$\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377}##"
	"\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376"
	"\036\000\377\376\036\000\377\376\036\000\377\377\036\000\377f#$\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377}##\377\376\036\000\377\376\036\000\377\376\036\000\377"
	"\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\377\036"
	"\000\377f#$\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)"
	"\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)"
	"\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)"
	"\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)"
	"\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)"
	"\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)"
	"\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377}##\377\376\036"
	"\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376"
	"\036\000\377\376\036\000\377\377\036\000\377f#$\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377}##\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377"
	"\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\214\"\037"
	"\377s#$\377s#$\377s#$\377s#$\377s#$\377s#$\377s#$\377s#$\377s#$\377s#$\377"
	"s#$\377s#$\377s#$\377s#$\377s#$\377s#$\377s#$\377s#$\377s#$\377s#$\377s#"
	"$\377s#$\377s#$\377s#$\377s#$\377s#$\377r#$\377\063$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377}##\377\376"
	"\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377"
	"\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036"
	"\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376"
	"\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377"
	"\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036"
	"\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376"
	"\036\000\377\376\036\000\377\260!\033\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377}##\377\376\036\000\377\376"
	"\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377"
	"\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036"
	"\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376"
	"\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377"
	"\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036"
	"\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\260"
	"!\033\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377}##\377\376\036\000\377\376\036\000\377\376\036"
	"\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376"
	"\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377"
	"\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036"
	"\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376"
	"\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377"
	"\376\036\000\377\376\036\000\377\376\036\000\377\257!\033\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377}##\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377"
	"\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036"
	"\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376"
	"\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377"
	"\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036"
	"\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\375"
	"\036\000\377\257!\033\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377}##\377\376"
	"\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377"
	"\376\036\000\377\376\036\000\377\376\036\000\377\276\040\027\377\264!\032\377\264!\032"
	"\377\264!\032\377\264!\032\377\264!\032\377\264!\032\377\264!\032\377\264!\032"
	"\377\264!\032\377\264!\032\377\264!\032\377\264!\032\377\264!\032\377\264!\032"
	"\377\264!\032\377\264!\032\377\264!\032\377\264!\032\377\264!\032\377\264!\032"
	"\377\264!\032\377\264!\032\377\232\"\037\377\060$)\377\060$)\377\060$)\377\060$"
	")\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$"
	")\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$"
	")\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$"
	")\377\060$)\377\060$)\377}##\377\376\036\000\377\376\036\000\377\376\036\000\377\376"
	"\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\377\036\000\377"
	"f#$\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377}##\377\376\036\000\377\376"
	"\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377"
	"\376\036\000\377\376\036\000\377\214\"\037\377s#$\377s#$\377s#$\377s#$\377s#$\377"
	"s#$\377s#$\377s#$\377s#$\377s#$\377s#$\377s#$\377s#$\377s#$\377s#$\377s#"
	"$\377s#$\377s#$\377s#$\377q#$\377\063$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377}##\377\376\036\000\377\376\036\000\377"
	"\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036"
	"\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376"
	"\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377"
	"\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036"
	"\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\256!\033\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377}##\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036"
	"\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376"
	"\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377"
	"\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036"
	"\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\375"
	"\036\000\377\255!\033\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377}##\377\376\036\000\377\376\036\000\377\376"
	"\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377"
	"\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036"
	"\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376"
	"\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377"
	"\376\036\000\377\375\036\000\377\255!\033\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377}##\377\376"
	"\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377"
	"\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036"
	"\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376"
	"\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377"
	"\376\036\000\377\376\036\000\377\375\036\000\377\255!\033\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377}##\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377"
	"\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\271!\030"
	"\377\256!\033\377\256!\033\377\256!\033\377\256!\033\377\256!\033\377\256!\033"
	"\377\256!\033\377\256!\033\377\256!\033\377\256!\033\377\256!\033\377\256!\033"
	"\377\256!\033\377\256!\033\377\256!\033\377\226\"\037\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377}##\377\376\036\000\377\376\036\000\377\376\036\000\377\376"
	"\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\377\036\000\377"
	"f#$\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377}##\377\376\036\000\377\376"
	"\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377"
	"\376\036\000\377\376\036\000\377\223\"\037\377}##\377}##\377}##\377}##\377}##\377"
	"}##\377}##\377}##\377}##\377}##\377}##\377}##\377{##\377\064$(\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377}##\377\376\036\000\377"
	"\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036"
	"\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376"
	"\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377"
	"\376\036\000\377\376\036\000\377\376\036\000\377\375\036\000\377\254!\033\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377}##\377\376"
	"\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377"
	"\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036"
	"\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376"
	"\036\000\377\376\036\000\377\376\036\000\377\375\036\000\377\253!\033\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377}##"
	"\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376"
	"\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377"
	"\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036"
	"\000\377\376\036\000\377\376\036\000\377\375\036\000\377\253!\033\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"}##\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377"
	"\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036"
	"\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376"
	"\036\000\377\376\036\000\377\375\036\000\377\253!\033\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377g#%\377\314\040\025\377\210\"!\377\060$"
	")\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$"
	")\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$"
	")\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$"
	")\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$"
	")\377}##\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000"
	"\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\271!\030\377\256"
	"!\033\377\256!\033\377\256!\033\377\256!\033\377\256!\033\377\256!\033\377\256"
	"!\033\377\256!\033\377\224\"\037\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377z##\377\376\036\000\377\375\036\000\377\253!\034"
	"\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)"
	"\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)"
	"\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)"
	"\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)"
	"\377}##\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000"
	"\377\376\036\000\377\376\036\000\377\376\036\000\377\377\036\000\377f#$\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\226\"\040\377\376\036\000\377\376\036\000\377\371\036\002\377V#&\377\060$)\377\060$"
	")\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$"
	")\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$"
	")\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$"
	")\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377}##\377\376\036\000\377\376"
	"\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377"
	"\376\036\000\377\377\036\000\377f#$\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\322\040\023\377\376\036\000\377\376"
	"\036\000\377\376\036\000\377\217\"!\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377}##\377\376\036\000\377\376\036\000\377\376\036\000\377\376"
	"\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\377\036\000\377"
	"f#$\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\233\"\037\377\375\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\243"
	"\"\036\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"}##\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377"
	"\376\036\000\377\376\036\000\377\376\036\000\377\377\036\000\377e#$\377.$)\377.$)\377"
	".$)\377.$)\377.$)\377.$)\377.$)\377.$)\377.$)\377.$)\377.$)\377.$)\377.$"
	")\377-$)\377[#&\377\274!\031\377\374\036\000\377\376\036\000\377\376\036\000\377\376"
	"\036\000\377\376\036\000\377\264!\033\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377}##\377\376\036\000\377\376\036\000\377\376\036\000\377\376"
	"\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377"
	"\356\036\005\377\353\037\006\377\353\037\006\377\353\037\006\377\353\037\006\377\353\037"
	"\006\377\353\037\006\377\353\037\006\377\353\037\006\377\353\037\006\377\353\037\006\377\353"
	"\037\006\377\353\037\006\377\353\037\006\377\357\036\004\377\374\036\000\377\376\036\000\377"
	"\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\307\040"
	"\027\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377}##"
	"\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376"
	"\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377"
	"\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036"
	"\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376"
	"\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377"
	"\376\036\000\377\376\036\000\377\376\036\000\377\326\040\022\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377}##\377\376\036\000\377\376\036\000\377"
	"\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036"
	"\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376"
	"\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377"
	"\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036"
	"\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376"
	"\036\000\377\340\037\016\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$"
	")\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$"
	")\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$"
	")\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$"
	")\377\060$)\377}##\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377"
	"\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036"
	"\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376"
	"\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377"
	"\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036"
	"\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\355\037\007\377/"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377}##\377\376\036"
	"\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376"
	"\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377"
	"\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036"
	"\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376"
	"\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377"
	"\376\036\000\377\376\036\000\377\370\036\001\377.$(\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377}##\377\376\036\000\377\376\036\000\377\376\036\000\377"
	"\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036"
	"\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376"
	"\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377"
	"\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036"
	"\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\377"
	"\036\000\377P#&\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377}##"
	"\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376"
	"\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377"
	"\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036"
	"\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376"
	"\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377"
	"\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377|##\377\060$)\377\060$"
	")\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$"
	")\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$"
	")\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$"
	")\377\060$)\377\060$)\377\060$)\377\060$)\377}##\377\376\036\000\377\376\036\000\377"
	"\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036"
	"\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376"
	"\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377"
	"\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036"
	"\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376"
	"\036\000\377\376\036\000\377\216\"\"\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377}##\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377"
	"\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036"
	"\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376"
	"\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377"
	"\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036"
	"\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\376\036\000\377\244"
	"\"\036\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377Z#'\377\260"
	"!\035\377\260!\035\377\260!\035\377\260!\035\377\260!\035\377\260!\035\377\260"
	"!\035\377\260!\035\377\260!\035\377\260!\035\377\260!\035\377\260!\035\377\260"
	"!\035\377\260!\035\377\260!\035\377\260!\035\377\260!\035\377\260!\035\377\260"
	"!\035\377\260!\035\377\260!\035\377\260!\035\377\260!\035\377\260!\035\377\260"
	"!\035\377\260!\035\377\260!\035\377\260!\035\377\260!\035\377\260!\035\377\260"
	"!\035\377\260!\035\377|#$\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\373\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\373\060$)\344\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\344\060$)\265\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\265\060$)O\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060"
	"$)\377\060$)O\060$)\000\060$)\223\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\223"
	"\060$)\000\000\000\000\000\061%*\000\060$)L\060$)\271\060$)\351\060$)\373\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377\060$)\377"
	"\060$)\377\060$)\377\060$)\373\060$)\351\060$)\271\060$)L\061&*\000\000\000\000\000",
};

#endif // #ifndef INCLUDE_SDL_ICON_H
