/*
 * Wolfenstein: Enemy Territory GPL Source Code
 * Copyright (C) 1999-2010 id Software LLC, a ZeniMax Media company.
 *
 * ET: Legacy
 * Copyright (C) 2012-2024 ET:Legacy team <mail@etlegacy.com>
 *
 * This file is part of ET: Legacy - http://www.etlegacy.com
 *
 * ET: Legacy is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * ET: Legacy is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ET: Legacy. If not, see <http://www.gnu.org/licenses/>.
 *
 * In addition, Wolfenstein: Enemy Territory GPL Source Code is also
 * subject to certain additional terms. You should have received a copy
 * of these additional terms immediately following the terms and conditions
 * of the GNU General Public License which accompanied the source code.
 * If not, please request a copy in writing from id Software at the address below.
 *
 * id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.
 */
/**
 * @file sdl_splash.h
 * @brief GIMP RGBA C-Source image dump 1-byte-run-length-encoded (sdl_splash.h)
 */

#define SPLASH_WIDTH           300
#define SPLASH_HEIGHT          100
#define SPLASH_BYTES_PER_PIXEL 4
#define SPLASH_DATA_SIZE       SPLASH_WIDTH *SPLASH_HEIGHT *SPLASH_BYTES_PER_PIXEL

#define SPLASH_IMAGE_RUN_LENGTH_DECODE(image_buf, rle_data, size, bpp) do \
		{ unsigned int __bpp; unsigned char *__ip; const unsigned char *__il, *__rd; \
		  __bpp = (bpp); __ip = (image_buf); __il = __ip + (size) * __bpp; \
		  __rd  = (rle_data); if (__bpp > 3) { /* RGBA */ \
			  while (__ip < __il) { unsigned int __l = *(__rd++); \
									if (__l & 128) { __l                                                           = __l - 128; \
													 do { memcpy(__ip, __rd, 4); __ip += 4; } while (--__l); __rd += 4; \
									} else { __l  *= 4; memcpy(__ip, __rd, __l); \
											 __ip += __l; __rd += __l; } } \
		  } else if (__bpp == 3) { /* RGB */ \
			  while (__ip < __il) { unsigned int __l = *(__rd++); \
									if (__l & 128) { __l                                                           = __l - 128; \
													 do { memcpy(__ip, __rd, 3); __ip += 3; } while (--__l); __rd += 3; \
									} else { __l  *= 3; memcpy(__ip, __rd, __l); \
											 __ip += __l; __rd += __l; } } \
		  } else { /* RGB16 */ \
			  while (__ip < __il) { unsigned int __l = *(__rd++); \
									if (__l & 128) { __l                                                           = __l - 128; \
													 do { memcpy(__ip, __rd, 2); __ip += 2; } while (--__l); __rd += 2; \
									} else { __l  *= 2; memcpy(__ip, __rd, __l); \
											 __ip += __l; __rd += __l; } } \
		  } } while (0)

static const struct
{
	unsigned int width;
	unsigned int height;
	unsigned int bytes_per_pixel;     /* 2:RGB16, 3:RGB, 4:RGBA */
	unsigned char rle_pixel_data[15090 + 1];
} CLIENT_WINDOW_SPLASH = {
	SPLASH_WIDTH,                                                                                       SPLASH_HEIGHT, SPLASH_BYTES_PER_PIXEL,
	"\316\000\000\000\377\001\023\002\000\377\210\377\036\000\377\001\261\024\000\377\377\000\000\000\377"
	"\377\000\000\000\377\244\000\000\000\377\001\023\002\000\377\210\377\036\000\377\001\261\024\000\377"
	"\377\000\000\000\377\377\000\000\000\377\244\000\000\000\377\001\023\002\000\377\210\377\036\000\377"
	"\001\261\024\000\377\377\000\000\000\377\377\000\000\000\377\244\000\000\000\377\001\023\002\000\377\210"
	"\377\036\000\377\001\261\024\000\377\377\000\000\000\377\325\000\000\000\377\013\363\034\000\377"
	"\331\031\000\377\277\026\000\377\246\023\000\377\214\020\000\377s\015\000\377Y\012\000\377"
	"?\007\000\377&\004\000\377\015\001\000\377\001\000\000\377\303\000\000\000\377\001\023\002\000\377\210\377"
	"\036\000\377\001\261\024\000\377\377\000\000\000\377\325\000\000\000\377\211\377\036\000\377\013"
	"\376\035\000\377\360\034\000\377\330\031\000\377\277\026\000\377\245\023\000\377\213\020"
	"\000\377r\015\000\377X\012\000\377?\007\000\377%\004\000\377\015\001\000\377\272\000\000\000\377\001\023"
	"\002\000\377\210\377\036\000\377\001\261\024\000\377\377\000\000\000\377\325\000\000\000\377\223"
	"\377\036\000\377\007\375\035\000\377\360\034\000\377\327\031\000\377\300\026\000\377\224\021"
	"\000\377G\010\000\377\002\000\000\377\264\000\000\000\377\001\023\002\000\377\210\377\036\000\377\001"
	"\261\024\000\377\377\000\000\000\377\325\000\000\000\377\231\377\036\000\377\002\315\030\000\377"
	"+\005\000\377\263\000\000\000\377\001\023\002\000\377\210\377\036\000\377\001\261\024\000\377\377"
	"\000\000\000\377\325\000\000\000\377\232\377\036\000\377\002\356\034\000\377(\004\000\377\262\000\000"
	"\000\377\001\023\002\000\377\210\377\036\000\377\001\261\024\000\377\377\000\000\000\377\325\000\000"
	"\000\377\233\377\036\000\377\001\302\026\000\377\262\000\000\000\377\001\023\002\000\377\210\377"
	"\036\000\377\001\261\024\000\377\377\000\000\000\377\325\000\000\000\377\234\377\036\000\377\001,"
	"\005\000\377\261\000\000\000\377\001\023\002\000\377\210\377\036\000\377\001\261\024\000\377\377\000"
	"\000\000\377\325\000\000\000\377\234\377\036\000\377\001e\013\000\377\261\000\000\000\377\001\023\002"
	"\000\377\210\377\036\000\377\001\261\024\000\377\377\000\000\000\377\325\000\000\000\377\230\377"
	"\036\000\377\005\372\035\000\377\334\031\000\377\315\030\000\377\314\030\000\377c\013\000\377"
	"\261\000\000\000\377\001\023\002\000\377\210\377\036\000\377\001\261\024\000\377\377\000\000\000\377"
	"\325\000\000\000\377\225\377\036\000\377\004\372\035\000\377\244\023\000\377G\010\000\377\013"
	"\001\000\377\265\000\000\000\377\001\023\002\000\377\210\377\036\000\377\001\261\024\000\377\377\000"
	"\000\000\377\325\000\000\000\377\224\377\036\000\377\002\307\027\000\377(\004\000\377\270\000\000\000"
	"\377\001\023\002\000\377\210\377\036\000\377\001\261\024\000\377\377\000\000\000\377\325\000\000\000"
	"\377\223\377\036\000\377\002\265\025\000\377\007\000\000\377\271\000\000\000\377\001\023\002\000\377"
	"\210\377\036\000\377\001\261\024\000\377\377\000\000\000\377\325\000\000\000\377\222\377\036\000"
	"\377\002\337\032\000\377\016\001\000\377\272\000\000\000\377\001\023\002\000\377\210\377\036\000\377"
	"\001\261\024\000\377\377\000\000\000\377\325\000\000\000\377\222\377\036\000\377\001^\013\000\377"
	"\273\000\000\000\377\001\023\002\000\377\210\377\036\000\377\001\261\024\000\377\377\000\000\000\377"
	"\325\000\000\000\377\221\377\036\000\377\002\362\034\000\377\011\001\000\377\273\000\000\000\377\001"
	"\023\002\000\377\210\377\036\000\377\001\261\024\000\377\377\000\000\000\377\325\000\000\000\377\221"
	"\377\036\000\377\001\273\026\000\377\274\000\000\000\377\001\023\002\000\377\210\377\036\000\377"
	"\001\261\024\000\377\377\000\000\000\377\325\000\000\000\377\221\377\036\000\377\001\230\021\000\377"
	"\274\000\000\000\377\001\023\002\000\377\210\377\036\000\377\001\261\024\000\377\377\000\000\000\377"
	"\325\000\000\000\377\221\377\036\000\377\001\213\020\000\377\274\000\000\000\377\001\023\002\000\377"
	"\210\377\036\000\377\001\261\024\000\377\377\000\000\000\377\325\000\000\000\377\221\377\036\000"
	"\377\001\211\020\000\377\274\000\000\000\377\001\023\002\000\377\210\377\036\000\377\001\261\024"
	"\000\377\377\000\000\000\377\325\000\000\000\377\221\377\036\000\377\001\211\020\000\377\274\000"
	"\000\000\377\001\023\002\000\377\210\377\036\000\377\001\261\024\000\377\377\000\000\000\377\325\000"
	"\000\000\377\221\377\036\000\377\001\211\020\000\377\274\000\000\000\377\001\023\002\000\377\210\377"
	"\036\000\377\001\261\024\000\377\377\000\000\000\377\325\000\000\000\377\221\377\036\000\377\001\211"
	"\020\000\377\274\000\000\000\377\001\023\002\000\377\210\377\036\000\377\001\261\024\000\377\377"
	"\000\000\000\377\325\000\000\000\377\221\377\036\000\377\001\211\020\000\377\274\000\000\000\377\001"
	"\023\002\000\377\210\377\036\000\377\001\261\024\000\377\377\000\000\000\377\325\000\000\000\377\221"
	"\377\036\000\377\001\211\020\000\377\274\000\000\000\377\001\023\002\000\377\210\377\036\000\377"
	"\001\261\024\000\377\377\000\000\000\377\325\000\000\000\377\221\377\036\000\377\001\211\020\000\377"
	"\274\000\000\000\377\001\023\002\000\377\210\377\036\000\377\001\261\024\000\377\377\000\000\000\377"
	"\325\000\000\000\377\221\377\036\000\377\001\211\020\000\377\274\000\000\000\377\001\023\002\000\377"
	"\210\377\036\000\377\001\261\024\000\377\377\000\000\000\377\325\000\000\000\377\221\377\036\000"
	"\377\001\320\030\000\377\263\231\022\000\377\002\200\017\000\377\003\000\000\377\207\000\000\000\377"
	"\001\023\002\000\377\210\377\036\000\377\001\261\024\000\377\211\000\000\000\377\001eee\377\210"
	"\231\231\231\377\001\003\003\003\377\223\000\000\000\377\001SSS\377\233\231\231\231\377\001"
	"\064\064\064\377\217\000\000\000\377\013\007\007\007\377\070\070\070\377ddd\377\203\203\203"
	"\377\224\224\224\377\230\230\230\377\221\221\221\377}}}\377[[[\377+++\377"
	"\002\002\002\377\231\000\000\000\377\002\002\002\002\377\223\223\223\377\213\231\231\231\377"
	"\001]]]\377\230\000\000\000\377\013\003\003\003\377///\377^^^\377\177\177\177\377\222\222"
	"\222\377\230\230\230\377\223\223\223\377\201\201\201\377bbb\377\064\064\064"
	"\377\005\005\005\377\212\000\000\000\377\001OOO\377\210\231\231\231\377\001\205\205\205\377"
	"\217\000\000\000\377\001MMM\377\210\231\231\231\377\001\206\206\206\377\304\377\036"
	"\000\377\002\346\033\000\377(\004\000\377\210\000\000\000\377\001\023\002\000\377\210\377\036\000\377"
	"\001\261\024\000\377\211\000\000\000\377\001\250\250\250\377\210\377\377\377\377\001\006\006"
	"\006\377\223\000\000\000\377\001\213\213\213\377\233\377\377\377\377\001WWW\377\214\000"
	"\000\000\377\004\002\002\002\377LLL\377\255\255\255\377\363\363\363\377\211\377\377\377"
	"\377\003\351\351\351\377\231\231\231\377\064\064\064\377\227\000\000\000\377\001$$$\377"
	"\214\377\377\377\377\001\307\307\307\377\226\000\000\000\377\003;;;\377\237\237\237"
	"\377\354\354\354\377\211\377\377\377\377\004\361\361\361\377\250\250\250\377"
	"FFF\377\001\001\001\377\207\000\000\000\377\001\060\060\060\377\211\377\377\377\377\001\061\061"
	"\061\377\215\000\000\000\377\002\001\001\001\377\324\324\324\377\210\377\377\377\377\001\214"
	"\214\214\377\303\377\036\000\377\002\346\033\000\377)\004\000\377\211\000\000\000\377\001\023"
	"\002\000\377\210\377\036\000\377\001\261\024\000\377\211\000\000\000\377\001\250\250\250\377"
	"\210\377\377\377\377\001\006\006\006\377\223\000\000\000\377\001\213\213\213\377\233\377"
	"\377\377\377\001WWW\377\213\000\000\000\377\002FFF\377\322\322\322\377\217\377\377"
	"\377\377\002\267\267\267\377)))\377\225\000\000\000\377\001[[[\377\214\377\377\377"
	"\377\002\366\366\366\377\007\007\007\377\223\000\000\000\377\002\060\060\060\377\277\277\277"
	"\377\217\377\377\377\377\002\314\314\314\377===\377\207\000\000\000\377\001\306\306"
	"\306\377\210\377\377\377\377\001\231\231\231\377\215\000\000\000\377\001>>>\377\210"
	"\377\377\377\377\002\375\375\375\377%%%\377\302\377\036\000\377\002\347\033\000\377"
	")\004\000\377\212\000\000\000\377\001\023\002\000\377\210\377\036\000\377\001\261\024\000\377\211"
	"\000\000\000\377\001\250\250\250\377\210\377\377\377\377\001\006\006\006\377\223\000\000\000\377"
	"\001\213\213\213\377\233\377\377\377\377\001WWW\377\211\000\000\000\377\003\006\006\006\377"
	"\225\225\225\377\376\376\376\377\221\377\377\377\377\002\367\367\367\377ii"
	"i\377\224\000\000\000\377\001\221\221\221\377\215\377\377\377\377\001\065\065\065\377"
	"\221\000\000\000\377\003\001\001\001\377vvv\377\372\372\372\377\221\377\377\377\377\003\375"
	"\375\375\377\211\211\211\377\003\003\003\377\205\000\000\000\377\001]]]\377\210\377\377"
	"\377\377\002\362\362\362\377\017\017\017\377\214\000\000\000\377\001\246\246\246\377\210"
	"\377\377\377\377\002\271\271\271\377\000\000\000\377\301\377\036\000\377\002\347\033\000"
	"\377)\004\000\377\213\000\000\000\377\001\023\002\000\377\210\377\036\000\377\001\261\024\000\377"
	"\211\000\000\000\377\001\250\250\250\377\210\377\377\377\377\001\006\006\006\377\223\000\000"
	"\000\377\001\213\213\213\377\233\377\377\377\377\001WWW\377\210\000\000\000\377\002\012"
	"\012\012\377\273\273\273\377\225\377\377\377\377\002\212\212\212\377\001\001\001\377"
	"\222\000\000\000\377\001\310\310\310\377\215\377\377\377\377\001kkk\377\220\000\000\000\377"
	"\002\002\002\002\377\231\231\231\377\225\377\377\377\377\002\256\256\256\377\006\006\006"
	"\377\204\000\000\000\377\002\010\010\010\377\353\353\353\377\210\377\377\377\377\001j"
	"jj\377\213\000\000\000\377\002\027\027\027\377\370\370\370\377\210\377\377\377\377\002"
	"PPP\377\000\000\000\377\300\377\036\000\377\002\347\033\000\377*\004\000\377\214\000\000\000\377"
	"\001\023\002\000\377\210\377\036\000\377\001\261\024\000\377\211\000\000\000\377\001\250\250\250"
	"\377\210\377\377\377\377\001\006\006\006\377\223\000\000\000\377\001\213\213\213\377\233"
	"\377\377\377\377\001WWW\377\207\000\000\000\377\002\003\003\003\377\262\262\262\377\227\377"
	"\377\377\377\001zzz\377\221\000\000\000\377\002\007\007\007\377\367\367\367\377\215\377\377"
	"\377\377\001\242\242\242\377\220\000\000\000\377\001\213\213\213\377\227\377\377\377"
	"\377\002\242\242\242\377\001\001\001\377\204\000\000\000\377\001\213\213\213\377\210\377"
	"\377\377\377\002\321\321\321\377\001\001\001\377\212\000\000\000\377\001xxx\377\210\377\377"
	"\377\377\003\342\342\342\377\004\004\004\377\000\000\000\377\277\377\036\000\377\002\350\033"
	"\000\377+\005\000\377\215\000\000\000\377\001\023\002\000\377\210\377\036\000\377\001\261\024\000\377"
	"\211\000\000\000\377\001\250\250\250\377\210\377\377\377\377\001\006\006\006\377\223\000\000"
	"\000\377\001\213\213\213\377\233\377\377\377\377\001WWW\377\207\000\000\000\377\001yyy"
	"\377\230\377\377\377\377\002\374\374\374\377AAA\377\220\000\000\000\377\001\065\065\065"
	"\377\216\377\377\377\377\001\330\330\330\377\217\000\000\000\377\002PPP\377\376\376"
	"\376\377\230\377\377\377\377\001hhh\377\204\000\000\000\377\002$$$\377\375\375\375"
	"\377\210\377\377\377\377\001;;;\377\211\000\000\000\377\002\003\003\003\377\337\337\337\377"
	"\210\377\377\377\377\001~~~\377\202\000\000\000\377\276\377\036\000\377\002\350\033\000\377"
	"+\005\000\377\216\000\000\000\377\001\023\002\000\377\210\377\036\000\377\001\261\024\000\377\211"
	"\000\000\000\377\001\250\250\250\377\210\377\377\377\377\001\006\006\006\377\223\000\000\000\377"
	"\001\213\213\213\377\233\377\377\377\377\001WWW\377\206\000\000\000\377\002$$$\377\367"
	"\367\367\377\231\377\377\377\377\002\332\332\332\377\007\007\007\377\217\000\000\000\377"
	"\001lll\377\216\377\377\377\377\002\375\375\375\377\022\022\022\377\215\000\000\000\377"
	"\002\015\015\015\377\345\345\345\377\231\377\377\377\377\002\361\361\361\377\031"
	"\031\031\377\204\000\000\000\377\001\270\270\270\377\210\377\377\377\377\001\243\243"
	"\243\377\211\000\000\000\377\001MMM\377\210\377\377\377\377\002\372\372\372\377\032"
	"\032\032\377\202\000\000\000\377\275\377\036\000\377\002\351\033\000\377+\005\000\377\217\000\000"
	"\000\377\001\023\002\000\377\210\377\036\000\377\001\261\024\000\377\211\000\000\000\377\001\250\250"
	"\250\377\210\377\377\377\377\001\006\006\006\377\223\000\000\000\377\001\213\213\213\377"
	"\210\377\377\377\377\001CCC\377\222%%%\377\001\015\015\015\377\206\000\000\000\377\001\243"
	"\243\243\377\211\377\377\377\377\010\376\376\376\377\265\265\265\377___\377"
	"\062\062\062\377'''\377\071\071\071\377nnn\377\315\315\315\377\212\377\377\377"
	"\377\001hhh\377\217\000\000\000\377\001\242\242\242\377\217\377\377\377\377\001FFF\377"
	"\215\000\000\000\377\001yyy\377\212\377\377\377\377\007\307\307\307\377jjj\377\067\067"
	"\067\377'''\377\064\064\064\377ccc\377\273\273\273\377\212\377\377\377\377\001"
	"\222\222\222\377\204\000\000\000\377\001OOO\377\210\377\377\377\377\002\367\367\367"
	"\377\024\024\024\377\210\000\000\000\377\001\267\267\267\377\210\377\377\377\377\001\253"
	"\253\253\377\203\000\000\000\377\221\377\036\000\377\001\241\022\000\377\253\063\006\000\377"
	"\001\031\002\000\377\220\000\000\000\377\001\023\002\000\377\210\377\036\000\377\001\261\024\000\377"
	"\211\000\000\000\377\001\250\250\250\377\210\377\377\377\377\001\006\006\006\377\223\000\000"
	"\000\377\001\213\213\213\377\210\377\377\377\377\001###\377\230\000\000\000\377\002\031"
	"\031\031\377\372\372\372\377\210\377\377\377\377\002\352\352\352\377CCC\377\206"
	"\000\000\000\377\003\001\001\001\377kkk\377\373\373\373\377\210\377\377\377\377\002\327\327"
	"\327\377\001\001\001\377\216\000\000\000\377\001\331\331\331\377\217\377\377\377\377\001"
	"}}}\377\214\000\000\000\377\002\005\005\005\377\345\345\345\377\210\377\377\377\377\003\367"
	"\367\367\377___\377\001\001\001\377\206\000\000\000\377\002MMM\377\360\360\360\377\210"
	"\377\377\377\377\002\363\363\363\377\017\017\017\377\203\000\000\000\377\002\004\004\004\377"
	"\341\341\341\377\210\377\377\377\377\001ttt\377\207\000\000\000\377\002$$$\377\375"
	"\375\375\377\210\377\377\377\377\001CCC\377\203\000\000\000\377\221\377\036\000\377"
	"\001\211\020\000\377\274\000\000\000\377\001\023\002\000\377\210\377\036\000\377\001\261\024\000\377"
	"\211\000\000\000\377\001\250\250\250\377\210\377\377\377\377\001\006\006\006\377\223\000\000"
	"\000\377\001\213\213\213\377\210\377\377\377\377\001###\377\230\000\000\000\377\001ttt"
	"\377\210\377\377\377\377\002\364\364\364\377\060\060\060\377\211\000\000\000\377\001b"
	"bb\377\211\377\377\377\377\001\071\071\071\377\215\000\000\000\377\002\022\022\022\377\375"
	"\375\375\377\217\377\377\377\377\001\263\263\263\377\214\000\000\000\377\001KKK\377"
	"\210\377\377\377\377\002\375\375\375\377PPP\377\211\000\000\000\377\002>>>\377\372"
	"\372\372\377\210\377\377\377\377\001ccc\377\204\000\000\000\377\001}}}\377\210\377"
	"\377\377\377\002\332\332\332\377\002\002\002\377\206\000\000\000\377\001\214\214\214\377"
	"\210\377\377\377\377\002\327\327\327\377\002\002\002\377\203\000\000\000\377\221\377\036"
	"\000\377\001\211\020\000\377\274\000\000\000\377\001\023\002\000\377\210\377\036\000\377\001\261\024"
	"\000\377\211\000\000\000\377\001\250\250\250\377\210\377\377\377\377\001\006\006\006\377\223"
	"\000\000\000\377\001\213\213\213\377\210\377\377\377\377\001###\377\230\000\000\000\377\001"
	"\305\305\305\377\210\377\377\377\377\001sss\377\213\000\000\000\377\001\264\264\264"
	"\377\210\377\377\377\377\001\212\212\212\377\215\000\000\000\377\001GGG\377\220\377"
	"\377\377\377\002\350\350\350\377\001\001\001\377\213\000\000\000\377\001\233\233\233\377"
	"\210\377\377\377\377\001\234\234\234\377\213\000\000\000\377\001\213\213\213\377\210"
	"\377\377\377\377\001\264\264\264\377\204\000\000\000\377\002\031\031\031\377\372\372\372"
	"\377\210\377\377\377\377\001EEE\377\205\000\000\000\377\002\012\012\012\377\354\354\354"
	"\377\210\377\377\377\377\001ppp\377\204\000\000\000\377\221\377\036\000\377\001\211\020"
	"\000\377\274\000\000\000\377\001\023\002\000\377\210\377\036\000\377\001\261\024\000\377\211\000\000"
	"\000\377\001\250\250\250\377\210\377\377\377\377\001\006\006\006\377\223\000\000\000\377\001"
	"\213\213\213\377\210\377\377\377\377\001###\377\227\000\000\000\377\002\015\015\015\377"
	"\372\372\372\377\207\377\377\377\377\002\353\353\353\377\011\011\011\377\213\000"
	"\000\000\377\001\071\071\071\377\210\377\377\377\377\001\315\315\315\377\215\000\000\000\377"
	"\001}}}\377\221\377\377\377\377\001!!!\377\213\000\000\000\377\001\336\336\336\377\207"
	"\377\377\377\377\002\375\375\375\377\040\040\040\377\213\000\000\000\377\002\026\026\026"
	"\377\371\371\371\377\207\377\377\377\377\002\362\362\362\377\004\004\004\377\204"
	"\000\000\000\377\001\252\252\252\377\210\377\377\377\377\001\255\255\255\377\205\000"
	"\000\000\377\001aaa\377\210\377\377\377\377\002\365\365\365\377\021\021\021\377\204"
	"\000\000\000\377\221\377\036\000\377\001\270\025\000\377\246f\014\000\377\001Q\011\000\377\225"
	"\000\000\000\377\001\023\002\000\377\210\377\036\000\377\001\261\024\000\377\211\000\000\000\377\001\250"
	"\250\250\377\210\377\377\377\377\001\006\006\006\377\223\000\000\000\377\001\213\213\213"
	"\377\210\377\377\377\377\001###\377\227\000\000\000\377\001<<<\377\210\377\377\377"
	"\377\001\230\230\230\377\214\000\000\000\377\002\001\001\001\377\340\340\340\377\207\377"
	"\377\377\377\002\372\372\372\377\006\006\006\377\214\000\000\000\377\001\264\264\264\377"
	"\210\377\377\377\377\001\306\306\306\377\210\377\377\377\377\001WWW\377\212\000"
	"\000\000\377\002\024\024\024\377\376\376\376\377\207\377\377\377\377\001\302\302\302"
	"\377\215\000\000\000\377\001\270\270\270\377\210\377\377\377\377\001+++\377\204\000\000"
	"\000\377\001AAA\377\210\377\377\377\377\002\372\372\372\377\032\032\032\377\204\000"
	"\000\000\377\001\312\312\312\377\210\377\377\377\377\001\236\236\236\377\205\000\000"
	"\000\377\267\377\036\000\377\002\353\033\000\377/\005\000\377\225\000\000\000\377\001\023\002\000\377"
	"\210\377\036\000\377\001\261\024\000\377\211\000\000\000\377\001\250\250\250\377\210\377"
	"\377\377\377\001\006\006\006\377\223\000\000\000\377\001\213\213\213\377\210\377\377\377"
	"\377\001###\377\227\000\000\000\377\001bbb\377\210\377\377\377\377\001YYY\377\215\000\000"
	"\000\377\001\247\247\247\377\210\377\377\377\377\001(((\377\213\000\000\000\377\002\001\001"
	"\001\377\351\351\351\377\207\377\377\377\377\002\366\366\366\377```\377\210\377"
	"\377\377\377\001\216\216\216\377\212\000\000\000\377\001\071\071\071\377\210\377\377\377"
	"\377\001\203\203\203\377\215\000\000\000\377\001}}}\377\210\377\377\377\377\001QQQ\377"
	"\204\000\000\000\377\002\001\001\001\377\326\326\326\377\210\377\377\377\377\001}}}\377\203"
	"\000\000\000\377\001\065\065\065\377\211\377\377\377\377\001\065\065\065\377\205\000\000\000\377"
	"\266\377\036\000\377\002\353\033\000\377/\005\000\377\226\000\000\000\377\001\023\002\000\377\210"
	"\377\036\000\377\001\261\024\000\377\211\000\000\000\377\001\250\250\250\377\210\377\377"
	"\377\377\001\006\006\006\377\223\000\000\000\377\001\213\213\213\377\210\377\377\377\377"
	"\001###\377\227\000\000\000\377\001yyy\377\210\377\377\377\377\001\067\067\067\377\215\000"
	"\000\000\377\001\207\207\207\377\210\377\377\377\377\001>>>\377\213\000\000\000\377\001\""
	"\"\"\377\210\377\377\377\377\002\303\303\303\377$$$\377\210\377\377\377\377"
	"\001\304\304\304\377\212\000\000\000\377\001OOO\377\210\377\377\377\377\001```\377\215"
	"\000\000\000\377\001^^^\377\210\377\377\377\377\001ggg\377\205\000\000\000\377\001ooo\377\210"
	"\377\377\377\377\002\342\342\342\377\004\004\004\377\202\000\000\000\377\001\236\236\236"
	"\377\210\377\377\377\377\001\313\313\313\377\206\000\000\000\377\265\377\036\000\377"
	"\002\353\033\000\377\060\005\000\377\227\000\000\000\377\001\023\002\000\377\210\377\036\000\377\001"
	"\261\024\000\377\211\000\000\000\377\001\250\250\250\377\210\377\377\377\377\001\006\006\006"
	"\377\223\000\000\000\377\001\213\213\213\377\210\377\377\377\377\001###\377\227\000\000"
	"\000\377\001|||\377\210\377\377\377\377\001\062\062\062\377\215\000\000\000\377\001\202\202"
	"\202\377\210\377\377\377\377\001BBB\377\213\000\000\000\377\001XXX\377\210\377\377"
	"\377\377\003\213\213\213\377\002\002\002\377\353\353\353\377\207\377\377\377\377"
	"\002\366\366\366\377\005\005\005\377\211\000\000\000\377\001SSS\377\210\377\377\377\377\001"
	"[[[\377\215\000\000\000\377\001YYY\377\210\377\377\377\377\001kkk\377\205\000\000\000\377"
	"\002\021\021\021\377\364\364\364\377\210\377\377\377\377\004NNN\377\000\000\000\377\022"
	"\022\022\377\365\365\365\377\210\377\377\377\377\001bbb\377\206\000\000\000\377\264"
	"\377\036\000\377\002\354\033\000\377\060\005\000\377\230\000\000\000\377\001\023\002\000\377\210\377"
	"\036\000\377\001\261\024\000\377\211\000\000\000\377\001\250\250\250\377\210\377\377\377"
	"\377\001\006\006\006\377\223\000\000\000\377\001\213\213\213\377\210\377\377\377\377\001##"
	"#\377\227\000\000\000\377\001|||\377\210\377\377\377\377\001\062\062\062\377\215\000\000\000"
	"\377\001\202\202\202\377\210\377\377\377\377\001BBB\377\213\000\000\000\377\001\216\216"
	"\216\377\210\377\377\377\377\003SSS\377\000\000\000\377\266\266\266\377\210\377\377"
	"\377\377\001\062\062\062\377\211\000\000\000\377\001SSS\377\210\377\377\377\377\001[[[\377"
	"\215\000\000\000\377\001YYY\377\210\377\377\377\377\001kkk\377\206\000\000\000\377\001\235"
	"\235\235\377\210\377\377\377\377\003\266\266\266\377\000\000\000\377ppp\377\210\377"
	"\377\377\377\002\356\356\356\377\013\013\013\377\206\000\000\000\377\263\377\036\000\377"
	"\002\354\033\000\377\061\005\000\377\231\000\000\000\377\001\023\002\000\377\210\377\036\000\377\001"
	"\261\024\000\377\211\000\000\000\377\001\250\250\250\377\210\377\377\377\377\001\006\006\006"
	"\377\223\000\000\000\377\001\213\213\213\377\210\377\377\377\377\001###\377\227\000\000"
	"\000\377\001|||\377\210\377\377\377\377\001\062\062\062\377\215\000\000\000\377\001\202\202"
	"\202\377\210\377\377\377\377\001BBB\377\213\000\000\000\377\001\305\305\305\377\207"
	"\377\377\377\377\004\376\376\376\377\034\034\034\377\000\000\000\377\177\177\177\377"
	"\210\377\377\377\377\001iii\377\211\000\000\000\377\001SSS\377\210\377\377\377\377"
	"\001[[[\377\215\000\000\000\377\001YYY\377\210\377\377\377\377\001kkk\377\206\000\000\000\377"
	"\001\064\064\064\377\210\377\377\377\377\003\375\375\375\377###\377\327\327\327"
	"\377\210\377\377\377\377\001\220\220\220\377\207\000\000\000\377\262\377\036\000\377"
	"\002\354\033\000\377\062\005\000\377\232\000\000\000\377\001\023\002\000\377\210\377\036\000\377\001"
	"\261\024\000\377\211\000\000\000\377\001\250\250\250\377\210\377\377\377\377\001\006\006\006"
	"\377\223\000\000\000\377\001\213\213\213\377\210\377\377\377\377\001###\377\227\000\000"
	"\000\377\001|||\377\210\377\377\377\377\001\062\062\062\377\215\000\000\000\377\001XXX\377"
	"\210\253\253\253\377\001,,,\377\212\000\000\000\377\002\006\006\006\377\366\366\366\377\207"
	"\377\377\377\377\004\343\343\343\377\001\001\001\377\000\000\000\377HHH\377\210\377\377"
	"\377\377\001\237\237\237\377\211\000\000\000\377\001SSS\377\210\377\377\377\377\001["
	"[[\377\215\000\000\000\377\001<<<\377\210\253\253\253\377\001HHH\377\207\000\000\000\377"
	"\001\312\312\312\377\210\377\377\377\377\001\303\303\303\377\210\377\377\377"
	"\377\002\376\376\376\377(((\377\207\000\000\000\377\261\377\036\000\377\002\355\033\000\377"
	"\062\005\000\377\233\000\000\000\377\001\023\002\000\377\210\377\036\000\377\001\261\024\000\377\211"
	"\000\000\000\377\001\250\250\250\377\210\377\377\377\377\001\006\006\006\377\223\000\000\000\377"
	"\001\213\213\213\377\210\377\377\377\377\001###\377\227\000\000\000\377\001|||\377\210"
	"\377\377\377\377\001\062\062\062\377\241\000\000\000\377\001\063\063\063\377\210\377\377"
	"\377\377\001\255\255\255\377\202\000\000\000\377\002\023\023\023\377\375\375\375\377\207"
	"\377\377\377\377\001\326\326\326\377\211\000\000\000\377\001SSS\377\210\377\377\377"
	"\377\001[[[\377\236\000\000\000\377\001aaa\377\221\377\377\377\377\001\275\275\275\377"
	"\210\000\000\000\377\260\377\036\000\377\002\355\033\000\377\062\005\000\377\234\000\000\000\377\001"
	"\023\002\000\377\210\377\036\000\377\001\261\024\000\377\211\000\000\000\377\001\250\250\250\377"
	"\210\377\377\377\377\001\006\006\006\377\223\000\000\000\377\001\213\213\213\377\210\377"
	"\377\377\377\001###\377\227\000\000\000\377\001|||\377\210\377\377\377\377\001\062\062"
	"\062\377\241\000\000\000\377\001iii\377\210\377\377\377\377\001vvv\377\203\000\000\000\377"
	"\001\332\332\332\377\207\377\377\377\377\002\374\374\374\377\020\020\020\377\210"
	"\000\000\000\377\001SSS\377\210\377\377\377\377\001[[[\377\236\000\000\000\377\002\012\012\012"
	"\377\355\355\355\377\220\377\377\377\377\001UUU\377\210\000\000\000\377\221\377\036"
	"\000\377\001\270\025\000\377\236f\014\000\377\001,\005\000\377\235\000\000\000\377\001\023\002\000\377"
	"\210\377\036\000\377\001\261\024\000\377\211\000\000\000\377\001\250\250\250\377\210\377"
	"\377\377\377\001\006\006\006\377\223\000\000\000\377\001\213\213\213\377\210\377\377\377"
	"\377\001###\377\227\000\000\000\377\001|||\377\210\377\377\377\377\001\062\062\062\377\241"
	"\000\000\000\377\001\240\240\240\377\210\377\377\377\377\001???\377\203\000\000\000\377\001"
	"\243\243\243\377\210\377\377\377\377\001DDD\377\210\000\000\000\377\001SSS\377\210"
	"\377\377\377\377\001[[[\377\237\000\000\000\377\001\217\217\217\377\217\377\377\377"
	"\377\002\345\345\345\377\006\006\006\377\210\000\000\000\377\221\377\036\000\377\001\211\020"
	"\000\377\274\000\000\000\377\001\023\002\000\377\210\377\036\000\377\001\261\024\000\377\211\000\000"
	"\000\377\001\250\250\250\377\210\377\377\377\377\001\006\006\006\377\223\000\000\000\377\001"
	"\213\213\213\377\210\377\377\377\377\001###\377\227\000\000\000\377\001|||\377\210"
	"\377\377\377\377\001\062\062\062\377\241\000\000\000\377\001\326\326\326\377\207\377\377"
	"\377\377\002\373\373\373\377\014\014\014\377\203\000\000\000\377\001mmm\377\210\377\377"
	"\377\377\001zzz\377\210\000\000\000\377\001SSS\377\210\377\377\377\377\001[[[\377\237"
	"\000\000\000\377\002'''\377\376\376\376\377\216\377\377\377\377\001\202\202\202\377"
	"\211\000\000\000\377\221\377\036\000\377\001\211\020\000\377\274\000\000\000\377\001\023\002\000\377"
	"\210\377\036\000\377\001\261\024\000\377\211\000\000\000\377\001\250\250\250\377\210\377"
	"\377\377\377\001\006\006\006\377\223\000\000\000\377\001\213\213\213\377\210\377\377\377"
	"\377\001###\377\227\000\000\000\377\001|||\377\210\377\377\377\377\001\062\062\062\377\240"
	"\000\000\000\377\002\021\021\021\377\374\374\374\377\207\377\377\377\377\001\321\321\321"
	"\377\204\000\000\000\377\001\066\066\066\377\210\377\377\377\377\001\260\260\260\377\210"
	"\000\000\000\377\001SSS\377\210\377\377\377\377\001[[[\377\240\000\000\000\377\001\274\274"
	"\274\377\215\377\377\377\377\002\373\373\373\377\035\035\035\377\211\000\000\000\377"
	"\221\377\036\000\377\001\211\020\000\377\274\000\000\000\377\001\023\002\000\377\210\377\036\000"
	"\377\001\261\024\000\377\211\000\000\000\377\001\250\250\250\377\210\377\377\377\377\001"
	"\006\006\006\377\223\000\000\000\377\001\213\213\213\377\210\377\377\377\377\001###\377\227"
	"\000\000\000\377\001|||\377\210\377\377\377\377\001\062\062\062\377\240\000\000\000\377\001DD"
	"D\377\210\377\377\377\377\001\233\233\233\377\204\000\000\000\377\002\007\007\007\377\367"
	"\367\367\377\207\377\377\377\377\002\346\346\346\377\001\001\001\377\207\000\000\000\377"
	"\001SSS\377\210\377\377\377\377\001[[[\377\240\000\000\000\377\001SSS\377\215\377\377"
	"\377\377\001\260\260\260\377\212\000\000\000\377\221\377\036\000\377\001\241\022\000\377"
	"\231\063\006\000\377\001&\004\000\377\242\000\000\000\377\001\023\002\000\377\210\377\036\000\377\001"
	"\261\024\000\377\211\000\000\000\377\001\250\250\250\377\210\377\377\377\377\001\006\006\006"
	"\377\223\000\000\000\377\001\213\213\213\377\210\377\377\377\377\001###\377\227\000\000"
	"\000\377\001|||\377\210\377\377\377\377\001\062\062\062\377\240\000\000\000\377\001{{{\377"
	"\210\377\377\377\377\001eee\377\205\000\000\000\377\001\310\310\310\377\210\377\377"
	"\377\377\001\036\036\036\377\207\000\000\000\377\001SSS\377\210\377\377\377\377\001[[[\377"
	"\240\000\000\000\377\002\005\005\005\377\344\344\344\377\214\377\377\377\377\001GGG\377\212"
	"\000\000\000\377\252\377\036\000\377\002\357\034\000\377\066\006\000\377\242\000\000\000\377\001\023"
	"\002\000\377\210\377\036\000\377\001\261\024\000\377\211\000\000\000\377\001\250\250\250\377"
	"\210\377\377\377\377\001\006\006\006\377\223\000\000\000\377\001\213\213\213\377\210\377"
	"\377\377\377\001\267\267\267\377\215\253\253\253\377\001JJJ\377\211\000\000\000\377"
	"\001|||\377\210\377\377\377\377\001\062\062\062\377\207\000\000\000\377\001$$$\377\216\253"
	"\253\253\377\001,,,\377\211\000\000\000\377\001\261\261\261\377\210\377\377\377\377"
	"\001///\377\205\000\000\000\377\001\221\221\221\377\210\377\377\377\377\001UUU\377\207"
	"\000\000\000\377\001SSS\377\210\377\377\377\377\001[[[\377\241\000\000\000\377\001\201\201"
	"\201\377\213\377\377\377\377\002\333\333\333\377\002\002\002\377\212\000\000\000\377\251"
	"\377\036\000\377\002\360\034\000\377\066\006\000\377\243\000\000\000\377\001\023\002\000\377\210\377"
	"\036\000\377\001\261\024\000\377\211\000\000\000\377\001\250\250\250\377\210\377\377\377"
	"\377\001\006\006\006\377\223\000\000\000\377\001\213\213\213\377\226\377\377\377\377\001nn"
	"n\377\211\000\000\000\377\001|||\377\210\377\377\377\377\001\062\062\062\377\207\000\000\000"
	"\377\001\066\066\066\377\216\377\377\377\377\001BBB\377\211\000\000\000\377\001\347\347"
	"\347\377\207\377\377\377\377\002\363\363\363\377\005\005\005\377\205\000\000\000\377\001"
	"ZZZ\377\210\377\377\377\377\001\213\213\213\377\207\000\000\000\377\001SSS\377\210"
	"\377\377\377\377\001[[[\377\241\000\000\000\377\002\034\034\034\377\373\373\373\377\212"
	"\377\377\377\377\001ttt\377\213\000\000\000\377\250\377\036\000\377\002\360\034\000\377\067"
	"\006\000\377\244\000\000\000\377\001\023\002\000\377\210\377\036\000\377\001\261\024\000\377\211\000"
	"\000\000\377\001\250\250\250\377\210\377\377\377\377\001\006\006\006\377\223\000\000\000\377"
	"\001\213\213\213\377\226\377\377\377\377\001nnn\377\211\000\000\000\377\001|||\377\210"
	"\377\377\377\377\001\062\062\062\377\207\000\000\000\377\001\066\066\066\377\216\377\377"
	"\377\377\001BBB\377\210\000\000\000\377\001\037\037\037\377\210\377\377\377\377\001\302"
	"\302\302\377\206\000\000\000\377\001$$$\377\210\377\377\377\377\001\302\302\302\377"
	"\207\000\000\000\377\001SSS\377\210\377\377\377\377\001[[[\377\242\000\000\000\377\001\256"
	"\256\256\377\211\377\377\377\377\002\367\367\367\377\024\024\024\377\213\000\000\000"
	"\377\247\377\036\000\377\002\360\034\000\377\070\006\000\377\245\000\000\000\377\001\023\002\000\377"
	"\210\377\036\000\377\001\261\024\000\377\211\000\000\000\377\001\250\250\250\377\210\377"
	"\377\377\377\001\006\006\006\377\223\000\000\000\377\001\213\213\213\377\226\377\377\377"
	"\377\001nnn\377\211\000\000\000\377\001|||\377\210\377\377\377\377\001\062\062\062\377\207"
	"\000\000\000\377\001\066\066\066\377\216\377\377\377\377\001BBB\377\210\000\000\000\377\001UU"
	"U\377\210\377\377\377\377\001\214\214\214\377\206\000\000\000\377\002\002\002\002\377\352"
	"\352\352\377\207\377\377\377\377\002\364\364\364\377\004\004\004\377\206\000\000\000\377"
	"\001SSS\377\210\377\377\377\377\001[[[\377\242\000\000\000\377\001FFF\377\211\377\377"
	"\377\377\001\242\242\242\377\214\000\000\000\377\246\377\036\000\377\002\360\034\000\377"
	"\070\006\000\377\246\000\000\000\377\001\023\002\000\377\210\377\036\000\377\001\261\024\000\377\211"
	"\000\000\000\377\001\250\250\250\377\210\377\377\377\377\001\006\006\006\377\223\000\000\000\377"
	"\001\213\213\213\377\226\377\377\377\377\001nnn\377\211\000\000\000\377\001|||\377\210"
	"\377\377\377\377\001\062\062\062\377\207\000\000\000\377\001\066\066\066\377\216\377\377"
	"\377\377\001BBB\377\210\000\000\000\377\001\214\214\214\377\210\377\377\377\377\001V"
	"VV\377\207\000\000\000\377\001\265\265\265\377\210\377\377\377\377\001\060\060\060\377"
	"\206\000\000\000\377\001SSS\377\210\377\377\377\377\001[[[\377\242\000\000\000\377\002\002\002"
	"\002\377\332\332\332\377\210\377\377\377\377\001\071\071\071\377\214\000\000\000\377\245"
	"\377\036\000\377\002\360\034\000\377\071\006\000\377\247\000\000\000\377\001\023\002\000\377\210\377"
	"\036\000\377\001\261\024\000\377\211\000\000\000\377\001\250\250\250\377\210\377\377\377"
	"\377\001\006\006\006\377\223\000\000\000\377\001\213\213\213\377\226\377\377\377\377\001nn"
	"n\377\211\000\000\000\377\001|||\377\210\377\377\377\377\001\062\062\062\377\207\000\000\000"
	"\377\001\066\066\066\377\216\377\377\377\377\001BBB\377\210\000\000\000\377\001\302\302"
	"\302\377\210\377\377\377\377\001!!!\377\207\000\000\000\377\001\177\177\177\377\210"
	"\377\377\377\377\001fff\377\206\000\000\000\377\001SSS\377\210\377\377\377\377\001[["
	"[\377\243\000\000\000\377\001\250\250\250\377\210\377\377\377\377\001\005\005\005\377\214"
	"\000\000\000\377\244\377\036\000\377\002\361\034\000\377\071\006\000\377\216\000\000\000\377\004:\006"
	"\000\377\214\020\000\377b\013\000\377\026\002\000\377\226\000\000\000\377\001\023\002\000\377\210\377"
	"\036\000\377\001\261\024\000\377\211\000\000\000\377\001\250\250\250\377\210\377\377\377"
	"\377\001\006\006\006\377\223\000\000\000\377\001\213\213\213\377\226\377\377\377\377\001nn"
	"n\377\211\000\000\000\377\001|||\377\210\377\377\377\377\001\062\062\062\377\207\000\000\000"
	"\377\001\066\066\066\377\216\377\377\377\377\001BBB\377\207\000\000\000\377\002\005\005\005\377"
	"\364\364\364\377\207\377\377\377\377\002\351\351\351\377\001\001\001\377\207\000\000"
	"\000\377\001HHH\377\210\377\377\377\377\001\234\234\234\377\206\000\000\000\377\001SSS"
	"\377\210\377\377\377\377\001[[[\377\243\000\000\000\377\001\250\250\250\377\210\377"
	"\377\377\377\001\005\005\005\377\214\000\000\000\377\243\377\036\000\377\002\361\034\000\377:\006"
	"\000\377\217\000\000\000\377\001b\013\000\377\202\377\036\000\377\003\367\035\000\377\177\016\000"
	"\377\002\000\000\377\224\000\000\000\377\001\023\002\000\377\210\377\036\000\377\001\261\024\000\377"
	"\211\000\000\000\377\001\250\250\250\377\210\377\377\377\377\001\006\006\006\377\223\000\000"
	"\000\377\001\213\213\213\377\226\377\377\377\377\001nnn\377\211\000\000\000\377\001|||"
	"\377\210\377\377\377\377\001\062\062\062\377\207\000\000\000\377\001\066\066\066\377\216"
	"\377\377\377\377\001BBB\377\207\000\000\000\377\001\060\060\060\377\210\377\377\377\377"
	"\001\264\264\264\377\210\000\000\000\377\002\023\023\023\377\376\376\376\377\207\377\377"
	"\377\377\001\323\323\323\377\206\000\000\000\377\001SSS\377\210\377\377\377\377\001["
	"[[\377\243\000\000\000\377\001\250\250\250\377\210\377\377\377\377\001\005\005\005\377\214"
	"\000\000\000\377\221\377\036\000\377\001\320\030\000\377\221\231\022\000\377\001:\006\000\377\220"
	"\000\000\000\377\001c\013\000\377\204\377\036\000\377\001\224\021\000\377\224\000\000\000\377\001\023"
	"\002\000\377\210\377\036\000\377\001\261\024\000\377\211\000\000\000\377\001\250\250\250\377"
	"\210\377\377\377\377\001\006\006\006\377\223\000\000\000\377\001\213\213\213\377\210\377"
	"\377\377\377\001\063\063\063\377\215\022\022\022\377\001\010\010\010\377\211\000\000\000\377"
	"\001|||\377\210\377\377\377\377\001\062\062\062\377\207\000\000\000\377\001\004\004\004\377\205"
	"\022\022\022\377\001\213\213\213\377\210\377\377\377\377\001BBB\377\207\000\000\000\377"
	"\001ggg\377\210\377\377\377\377\001\370\370\370\377\211\355\355\355\377\001\376"
	"\376\376\377\207\377\377\377\377\002\373\373\373\377\016\016\016\377\205\000\000\000"
	"\377\001SSS\377\210\377\377\377\377\001[[[\377\243\000\000\000\377\001\250\250\250\377"
	"\210\377\377\377\377\001\005\005\005\377\214\000\000\000\377\221\377\036\000\377\001\211\020"
	"\000\377\242\000\000\000\377\001u\015\000\377\204\377\036\000\377\002\376\035\000\377B\007\000\377"
	"\223\000\000\000\377\001\023\002\000\377\210\377\036\000\377\001\261\024\000\377\211\000\000\000\377"
	"\001\250\250\250\377\210\377\377\377\377\001\006\006\006\377\223\000\000\000\377\001\213\213"
	"\213\377\210\377\377\377\377\001###\377\227\000\000\000\377\001|||\377\210\377\377"
	"\377\377\001\062\062\062\377\215\000\000\000\377\001\202\202\202\377\210\377\377\377\377"
	"\001BBB\377\207\000\000\000\377\001\235\235\235\377\233\377\377\377\377\001AAA\377\205"
	"\000\000\000\377\001SSS\377\210\377\377\377\377\001[[[\377\243\000\000\000\377\001\250\250"
	"\250\377\210\377\377\377\377\001\005\005\005\377\214\000\000\000\377\221\377\036\000\377\001"
	"\211\020\000\377\242\000\000\000\377\001\240\022\000\377\205\377\036\000\377\001\263\025\000\377"
	"\223\000\000\000\377\001\023\002\000\377\210\377\036\000\377\001\261\024\000\377\211\000\000\000\377"
	"\001\250\250\250\377\210\377\377\377\377\001\006\006\006\377\223\000\000\000\377\001\213\213"
	"\213\377\210\377\377\377\377\001###\377\227\000\000\000\377\001|||\377\210\377\377"
	"\377\377\001\062\062\062\377\215\000\000\000\377\001\202\202\202\377\210\377\377\377\377"
	"\001BBB\377\207\000\000\000\377\001\324\324\324\377\233\377\377\377\377\001www\377\205"
	"\000\000\000\377\001SSS\377\210\377\377\377\377\001[[[\377\243\000\000\000\377\001\250\250"
	"\250\377\210\377\377\377\377\001\005\005\005\377\214\000\000\000\377\221\377\036\000\377\001"
	"\211\020\000\377\241\000\000\000\377\002\001\000\000\377\341\032\000\377\205\377\036\000\377\002\366"
	"\034\000\377\007\000\000\377\222\000\000\000\377\001\023\002\000\377\210\377\036\000\377\001\261\024"
	"\000\377\211\000\000\000\377\001\250\250\250\377\210\377\377\377\377\001\006\006\006\377\223"
	"\000\000\000\377\001\213\213\213\377\210\377\377\377\377\001###\377\227\000\000\000\377\001"
	"|||\377\210\377\377\377\377\001\062\062\062\377\215\000\000\000\377\001\202\202\202\377"
	"\210\377\377\377\377\001BBB\377\206\000\000\000\377\002\016\016\016\377\374\374\374\377"
	"\233\377\377\377\377\001\256\256\256\377\205\000\000\000\377\001SSS\377\210\377\377"
	"\377\377\001[[[\377\243\000\000\000\377\001\250\250\250\377\210\377\377\377\377\001\005"
	"\005\005\377\214\000\000\000\377\221\377\036\000\377\001\211\020\000\377\241\000\000\000\377\001A\007"
	"\000\377\207\377\036\000\377\001'\004\000\377\222\000\000\000\377\001\023\002\000\377\210\377\036"
	"\000\377\001\261\024\000\377\211\000\000\000\377\001\250\250\250\377\210\377\377\377\377"
	"\001\006\006\006\377\223\000\000\000\377\001\213\213\213\377\210\377\377\377\377\001###\377"
	"\227\000\000\000\377\001|||\377\210\377\377\377\377\001\062\062\062\377\215\000\000\000\377"
	"\001\202\202\202\377\210\377\377\377\377\001BBB\377\206\000\000\000\377\001AAA\377\234"
	"\377\377\377\377\001\344\344\344\377\205\000\000\000\377\001SSS\377\210\377\377\377"
	"\377\001[[[\377\243\000\000\000\377\001\250\250\250\377\210\377\377\377\377\001\005\005\005"
	"\377\214\000\000\000\377\221\377\036\000\377\001\211\020\000\377\240\000\000\000\377\002\001\000\000"
	"\377\300\026\000\377\207\377\036\000\377\001>\007\000\377\222\000\000\000\377\001\023\002\000\377"
	"\210\377\036\000\377\001\261\024\000\377\211\000\000\000\377\001\250\250\250\377\210\377"
	"\377\377\377\001\006\006\006\377\223\000\000\000\377\001\213\213\213\377\210\377\377\377"
	"\377\001###\377\227\000\000\000\377\001|||\377\210\377\377\377\377\001\062\062\062\377\215"
	"\000\000\000\377\001\202\202\202\377\210\377\377\377\377\001BBB\377\206\000\000\000\377\001"
	"xxx\377\235\377\377\377\377\001\034\034\034\377\204\000\000\000\377\001SSS\377\210\377"
	"\377\377\377\001[[[\377\243\000\000\000\377\001\250\250\250\377\210\377\377\377\377"
	"\001\005\005\005\377\214\000\000\000\377\221\377\036\000\377\001\211\020\000\377\240\000\000\000\377"
	"\001r\015\000\377\210\377\036\000\377\001W\012\000\377\222\000\000\000\377\001\023\002\000\377\210"
	"\377\036\000\377\001\261\024\000\377\211\000\000\000\377\001\250\250\250\377\210\377\377"
	"\377\377\001\006\006\006\377\223\000\000\000\377\001\213\213\213\377\210\377\377\377\377"
	"\001###\377\227\000\000\000\377\001|||\377\210\377\377\377\377\001\062\062\062\377\215\000"
	"\000\000\377\001\202\202\202\377\210\377\377\377\377\001BBB\377\206\000\000\000\377\001\256"
	"\256\256\377\235\377\377\377\377\001RRR\377\204\000\000\000\377\001SSS\377\210\377"
	"\377\377\377\001[[[\377\243\000\000\000\377\001\250\250\250\377\210\377\377\377\377"
	"\001\005\005\005\377\214\000\000\000\377\221\377\036\000\377\001\211\020\000\377\237\000\000\000\377"
	"\002m\014\000\377\374\035\000\377\210\377\036\000\377\001q\015\000\377\222\000\000\000\377\001\023"
	"\002\000\377\210\377\036\000\377\001\261\024\000\377\211\000\000\000\377\001\250\250\250\377"
	"\210\377\377\377\377\001\006\006\006\377\223\000\000\000\377\001\213\213\213\377\210\377"
	"\377\377\377\001###\377\227\000\000\000\377\001|||\377\210\377\377\377\377\001\062\062"
	"\062\377\215\000\000\000\377\001\202\202\202\377\210\377\377\377\377\001BBB\377\206"
	"\000\000\000\377\001\345\345\345\377\207\377\377\377\377\001\367\367\367\377\214\272"
	"\272\272\377\001\313\313\313\377\210\377\377\377\377\001\211\211\211\377\204"
	"\000\000\000\377\001SSS\377\210\377\377\377\377\001[[[\377\215\000\000\000\377\001\030\030\030"
	"\377\210EEE\377\001\035\035\035\377\214\000\000\000\377\001\250\250\250\377\210\377\377"
	"\377\377\001\005\005\005\377\214\000\000\000\377\221\377\036\000\377\001\211\020\000\377\234\000"
	"\000\000\377\003\002\000\000\377?\007\000\377\271\025\000\377\212\377\036\000\377\001\212\020\000\377"
	"\222\000\000\000\377\001\023\002\000\377\210\377\036\000\377\001\261\024\000\377\211\000\000\000\377"
	"\001\250\250\250\377\210\377\377\377\377\001\006\006\006\377\223\000\000\000\377\001\213\213"
	"\213\377\210\377\377\377\377\001###\377\227\000\000\000\377\001|||\377\210\377\377"
	"\377\377\001\062\062\062\377\215\000\000\000\377\001\202\202\202\377\210\377\377\377\377"
	"\001BBB\377\205\000\000\000\377\001\035\035\035\377\210\377\377\377\377\001\300\300\300"
	"\377\214\000\000\000\377\002\036\036\036\377\376\376\376\377\207\377\377\377\377\001\277"
	"\277\277\377\204\000\000\000\377\001SSS\377\210\377\377\377\377\001[[[\377\215\000\000"
	"\000\377\001YYY\377\210\377\377\377\377\001kkk\377\214\000\000\000\377\001\250\250\250"
	"\377\210\377\377\377\377\001\005\005\005\377\214\000\000\000\377\221\377\036\000\377\001\320"
	"\030\000\377\232\231\022\000\377\003\237\022\000\377\270\025\000\377\351\033\000\377\214\377"
	"\036\000\377\001\244\023\000\377\222\000\000\000\377\001\023\002\000\377\210\377\036\000\377\001\261"
	"\024\000\377\211\000\000\000\377\001\250\250\250\377\210\377\377\377\377\001\006\006\006\377"
	"\223\000\000\000\377\001\213\213\213\377\210\377\377\377\377\001###\377\227\000\000\000\377"
	"\001|||\377\210\377\377\377\377\001\062\062\062\377\215\000\000\000\377\001\202\202\202"
	"\377\210\377\377\377\377\001BBB\377\205\000\000\000\377\001SSS\377\210\377\377\377"
	"\377\001\211\211\211\377\215\000\000\000\377\001\345\345\345\377\207\377\377\377\377"
	"\002\361\361\361\377\004\004\004\377\203\000\000\000\377\001SSS\377\210\377\377\377\377\001"
	"[[[\377\215\000\000\000\377\001YYY\377\210\377\377\377\377\001kkk\377\214\000\000\000\377"
	"\001\250\250\250\377\210\377\377\377\377\001\005\005\005\377\214\000\000\000\377\273\377"
	"\036\000\377\001\275\026\000\377\222\000\000\000\377\001\023\002\000\377\210\377\036\000\377\001\261"
	"\024\000\377\211\000\000\000\377\001\250\250\250\377\210\377\377\377\377\001\006\006\006\377"
	"\223\000\000\000\377\001\213\213\213\377\210\377\377\377\377\001###\377\227\000\000\000\377"
	"\001|||\377\210\377\377\377\377\001\062\062\062\377\215\000\000\000\377\001\202\202\202"
	"\377\210\377\377\377\377\001BBB\377\205\000\000\000\377\001\211\211\211\377\210\377"
	"\377\377\377\001SSS\377\215\000\000\000\377\001\257\257\257\377\210\377\377\377\377"
	"\001---\377\203\000\000\000\377\001SSS\377\210\377\377\377\377\001[[[\377\215\000\000\000\377"
	"\001YYY\377\210\377\377\377\377\001kkk\377\214\000\000\000\377\001\250\250\250\377\210"
	"\377\377\377\377\001\005\005\005\377\214\000\000\000\377\273\377\036\000\377\001\326\031\000\377"
	"\222\000\000\000\377\001\023\002\000\377\210\377\036\000\377\001\261\024\000\377\211\000\000\000\377"
	"\001\250\250\250\377\210\377\377\377\377\001\006\006\006\377\223\000\000\000\377\001\213\213"
	"\213\377\210\377\377\377\377\001###\377\227\000\000\000\377\001|||\377\210\377\377"
	"\377\377\001\062\062\062\377\215\000\000\000\377\001\203\203\203\377\210\377\377\377\377"
	"\001AAA\377\205\000\000\000\377\001\300\300\300\377\210\377\377\377\377\001\034\034\034"
	"\377\215\000\000\000\377\001xxx\377\210\377\377\377\377\001ccc\377\203\000\000\000\377\001"
	"RRR\377\210\377\377\377\377\001\\\\\\\377\215\000\000\000\377\001ZZZ\377\210\377\377"
	"\377\377\001jjj\377\214\000\000\000\377\001\250\250\250\377\210\377\377\377\377\001\005"
	"\005\005\377\214\000\000\000\377\273\377\036\000\377\001\360\034\000\377\222\000\000\000\377\001\023"
	"\002\000\377\210\377\036\000\377\001\261\024\000\377\211\000\000\000\377\001\250\250\250\377"
	"\210\377\377\377\377\001\006\006\006\377\223\000\000\000\377\001\213\213\213\377\210\377"
	"\377\377\377\001###\377\227\000\000\000\377\001mmm\377\210\377\377\377\377\001HHH\377"
	"\215\000\000\000\377\001\226\226\226\377\210\377\377\377\377\001\063\063\063\377\204\000"
	"\000\000\377\002\004\004\004\377\362\362\362\377\207\377\377\377\377\001\345\345\345\377"
	"\216\000\000\000\377\001BBB\377\210\377\377\377\377\001\232\232\232\377\203\000\000\000\377"
	"\001DDD\377\210\377\377\377\377\001qqq\377\215\000\000\000\377\001mmm\377\210\377\377"
	"\377\377\001\\\\\\\377\214\000\000\000\377\001\250\250\250\377\210\377\377\377\377"
	"\001\005\005\005\377\214\000\000\000\377\273\377\036\000\377\002\375\035\000\377\014\001\000\377\221"
	"\000\000\000\377\001\023\002\000\377\210\377\036\000\377\001\261\024\000\377\211\000\000\000\377\001\250"
	"\250\250\377\210\377\377\377\377\001\006\006\006\377\223\000\000\000\377\001\213\213\213"
	"\377\210\377\377\377\377\001###\377\227\000\000\000\377\001MMM\377\210\377\377\377"
	"\377\001{{{\377\215\000\000\000\377\001\306\306\306\377\210\377\377\377\377\001\023\023"
	"\023\377\204\000\000\000\377\001...\377\210\377\377\377\377\001\256\256\256\377\216"
	"\000\000\000\377\002\016\016\016\377\374\374\374\377\207\377\377\377\377\001\320\320\320"
	"\377\203\000\000\000\377\001$$$\377\210\377\377\377\377\001\244\244\244\377\215\000\000"
	"\000\377\001\234\234\234\377\210\377\377\377\377\001<<<\377\214\000\000\000\377\001\250"
	"\250\250\377\210\377\377\377\377\001\005\005\005\377\214\000\000\000\377\274\377\036\000\377"
	"\001$\004\000\377\221\000\000\000\377\001\023\002\000\377\210\377\036\000\377\001\261\024\000\377\211"
	"\000\000\000\377\001\250\250\250\377\210\377\377\377\377\001\006\006\006\377\223\000\000\000\377"
	"\001\213\213\213\377\210\377\377\377\377\001###\377\227\000\000\000\377\001\037\037\037"
	"\377\210\377\377\377\377\001\311\311\311\377\214\000\000\000\377\002\026\026\026\377\372"
	"\372\372\377\207\377\377\377\377\001\343\343\343\377\205\000\000\000\377\001ddd\377"
	"\210\377\377\377\377\001xxx\377\217\000\000\000\377\001\324\324\324\377\207\377\377"
	"\377\377\002\373\373\373\377\014\014\014\377\202\000\000\000\377\002\004\004\004\377\361\361"
	"\361\377\207\377\377\377\377\002\354\354\354\377\006\006\006\377\213\000\000\000\377\002"
	"\003\003\003\377\343\343\343\377\207\377\377\377\377\002\375\375\375\377\020\020\020"
	"\377\214\000\000\000\377\001\250\250\250\377\210\377\377\377\377\001\005\005\005\377\214"
	"\000\000\000\377\274\377\036\000\377\001=\007\000\377\221\000\000\000\377\001\023\002\000\377\210\377"
	"\036\000\377\001\261\024\000\377\211\000\000\000\377\001\250\250\250\377\210\377\377\377"
	"\377\001\006\006\006\377\223\000\000\000\377\001\213\213\213\377\210\377\377\377\377\001##"
	"#\377\227\000\000\000\377\002\001\001\001\377\340\340\340\377\207\377\377\377\377\002\376"
	"\376\376\377\067\067\067\377\213\000\000\000\377\001yyy\377\210\377\377\377\377\001\246"
	"\246\246\377\205\000\000\000\377\001\232\232\232\377\210\377\377\377\377\001AAA\377"
	"\217\000\000\000\377\001\235\235\235\377\210\377\377\377\377\001>>>\377\203\000\000\000\377"
	"\001\270\270\270\377\210\377\377\377\377\001```\377\213\000\000\000\377\001PPP\377\210"
	"\377\377\377\377\001\320\320\320\377\215\000\000\000\377\001\250\250\250\377\210\377"
	"\377\377\377\001\005\005\005\377\214\000\000\000\377\274\377\036\000\377\001V\012\000\377\221\000"
	"\000\000\377\001\023\002\000\377\210\377\036\000\377\001\261\024\000\377\211\000\000\000\377\001\250"
	"\250\250\377\210\377\377\377\377\001\006\006\006\377\223\000\000\000\377\001\213\213\213"
	"\377\210\377\377\377\377\001###\377\230\000\000\000\377\001\226\226\226\377\210\377"
	"\377\377\377\002\310\310\310\377\005\005\005\377\211\000\000\000\377\002\034\034\034\377\357"
	"\357\357\377\210\377\377\377\377\001[[[\377\205\000\000\000\377\001\321\321\321\377"
	"\207\377\377\377\377\002\373\373\373\377\016\016\016\377\217\000\000\000\377\001ggg\377"
	"\210\377\377\377\377\001uuu\377\203\000\000\000\377\001mmm\377\210\377\377\377\377"
	"\002\344\344\344\377\022\022\022\377\211\000\000\000\377\002\012\012\012\377\330\330\330"
	"\377\210\377\377\377\377\001\205\205\205\377\215\000\000\000\377\001\250\250\250\377"
	"\210\377\377\377\377\001\005\005\005\377\214\000\000\000\377\274\377\036\000\377\001p\015\000\377"
	"\221\000\000\000\377\001\023\002\000\377\210\377\036\000\377\001\261\024\000\377\211\000\000\000\377"
	"\001\250\250\250\377\210\377\377\377\377\001\006\006\006\377\223\000\000\000\377\001\213\213"
	"\213\377\210\377\377\377\377\001###\377\230\000\000\000\377\001===\377\211\377\377"
	"\377\377\002\240\240\240\377\004\004\004\377\207\000\000\000\377\002\023\023\023\377\314\314"
	"\314\377\210\377\377\377\377\002\363\363\363\377\016\016\016\377\204\000\000\000\377"
	"\002\014\014\014\377\373\373\373\377\207\377\377\377\377\001\323\323\323\377\220"
	"\000\000\000\377\001\060\060\060\377\210\377\377\377\377\001\253\253\253\377\203\000\000\000"
	"\377\002\030\030\030\377\372\372\372\377\210\377\377\377\377\002\300\300\300\377"
	"\016\016\016\377\207\000\000\000\377\002\007\007\007\377\256\256\256\377\210\377\377\377\377"
	"\002\376\376\376\377,,,\377\215\000\000\000\377\001\250\250\250\377\210\377\377\377"
	"\377\001\005\005\005\377\214\000\000\000\377\274\377\036\000\377\001\211\020\000\377\221\000\000\000"
	"\377\001\023\002\000\377\210\377\036\000\377\001\261\024\000\377\211\000\000\000\377\001\250\250"
	"\250\377\210\377\377\377\377\001\006\006\006\377\223\000\000\000\377\001\213\213\213\377"
	"\210\377\377\377\377\001###\377\230\000\000\000\377\002\001\001\001\377\321\321\321\377\211"
	"\377\377\377\377\003\304\304\304\377;;;\377\001\001\001\377\203\000\000\000\377\003\004\004\004"
	"\377TTT\377\337\337\337\377\211\377\377\377\377\001\227\227\227\377\205\000\000"
	"\000\377\001???\377\210\377\377\377\377\001\234\234\234\377\220\000\000\000\377\002\005\005"
	"\005\377\364\364\364\377\207\377\377\377\377\001\342\342\342\377\204\000\000\000\377"
	"\001\250\250\250\377\211\377\377\377\377\003\331\331\331\377NNN\377\003\003\003\377"
	"\203\000\000\000\377\003\001\001\001\377AAA\377\314\314\314\377\211\377\377\377\377\001\301"
	"\301\301\377\216\000\000\000\377\001\250\250\250\377\210\377\377\377\377\001\005\005\005"
	"\377\214\000\000\000\377\274\377\036\000\377\001\243\023\000\377\221\000\000\000\377\001\023\002\000"
	"\377\210\377\036\000\377\001\261\024\000\377\211\000\000\000\377\001\250\250\250\377\210"
	"\377\377\377\377\001\251\251\251\377\216\247\247\247\377\001>>>\377\204\000\000\000"
	"\377\001\213\213\213\377\210\377\377\377\377\001\263\263\263\377\222\247\247"
	"\247\377\001\071\071\071\377\206\000\000\000\377\001UUU\377\213\377\377\377\377\005\342"
	"\342\342\377\265\265\265\377\251\251\251\377\274\274\274\377\355\355\355"
	"\377\212\377\377\377\377\002\370\370\370\377\"\"\"\377\205\000\000\000\377\001uuu\377"
	"\210\377\377\377\377\001fff\377\221\000\000\000\377\001\302\302\302\377\207\377\377"
	"\377\377\002\376\376\376\377\032\032\032\377\203\000\000\000\377\002///\377\374\374\374"
	"\377\212\377\377\377\377\005\353\353\353\377\272\272\272\377\251\251\251\377"
	"\267\267\267\377\345\345\345\377\213\377\377\377\377\001DDD\377\216\000\000\000\377"
	"\001\250\250\250\377\210\377\377\377\377\001\005\005\005\377\214\000\000\000\377\274\377"
	"\036\000\377\001\274\026\000\377\221\000\000\000\377\001\023\002\000\377\210\377\036\000\377\001\261"
	"\024\000\377\211\000\000\000\377\001\250\250\250\377\227\377\377\377\377\001^^^\377\204"
	"\000\000\000\377\001\213\213\213\377\233\377\377\377\377\001WWW\377\206\000\000\000\377\002"
	"\001\001\001\377\274\274\274\377\231\377\377\377\377\001\203\203\203\377\206\000\000"
	"\000\377\001\254\254\254\377\210\377\377\377\377\001///\377\221\000\000\000\377\001\214"
	"\214\214\377\210\377\377\377\377\001OOO\377\204\000\000\000\377\001\224\224\224\377"
	"\231\377\377\377\377\001\254\254\254\377\217\000\000\000\377\001\250\250\250\377\210"
	"\377\377\377\377\001\005\005\005\377\214\000\000\000\377\274\377\036\000\377\001\325\031\000\377"
	"\221\000\000\000\377\001\023\002\000\377\210\377\036\000\377\001\261\024\000\377\211\000\000\000\377"
	"\001\250\250\250\377\227\377\377\377\377\001^^^\377\204\000\000\000\377\001\213\213\213"
	"\377\233\377\377\377\377\001WWW\377\207\000\000\000\377\002\035\035\035\377\351\351\351"
	"\377\227\377\377\377\377\002\306\306\306\377\006\006\006\377\206\000\000\000\377\001\342"
	"\342\342\377\207\377\377\377\377\002\363\363\363\377\005\005\005\377\221\000\000\000\377"
	"\001UUU\377\210\377\377\377\377\001\206\206\206\377\204\000\000\000\377\002\013\013\013"
	"\377\322\322\322\377\227\377\377\377\377\002\341\341\341\377\025\025\025\377\217"
	"\000\000\000\377\001\250\250\250\377\210\377\377\377\377\001\005\005\005\377\214\000\000\000\377"
	"\274\377\036\000\377\002\356\034\000\377\001\000\000\377\220\000\000\000\377\001\023\002\000\377\210"
	"\377\036\000\377\001\261\024\000\377\211\000\000\000\377\001\250\250\250\377\227\377\377"
	"\377\377\001^^^\377\204\000\000\000\377\001\213\213\213\377\233\377\377\377\377\001W"
	"WW\377\210\000\000\000\377\002\070\070\070\377\362\362\362\377\225\377\377\377\377\002"
	"\330\330\330\377\027\027\027\377\206\000\000\000\377\002\032\032\032\377\376\376\376\377"
	"\207\377\377\377\377\001\301\301\301\377\222\000\000\000\377\001\037\037\037\377\210\377"
	"\377\377\377\001\274\274\274\377\205\000\000\000\377\002\037\037\037\377\341\341\341\377"
	"\225\377\377\377\377\002\354\354\354\377---\377\220\000\000\000\377\001\250\250\250"
	"\377\210\377\377\377\377\001\005\005\005\377\214\000\000\000\377\274\377\036\000\377\002\375"
	"\035\000\377\013\001\000\377\220\000\000\000\377\001\023\002\000\377\210\377\036\000\377\001\261\024"
	"\000\377\211\000\000\000\377\001\250\250\250\377\227\377\377\377\377\001^^^\377\204\000"
	"\000\000\377\001\213\213\213\377\233\377\377\377\377\001WWW\377\211\000\000\000\377\002\065"
	"\065\065\377\345\345\345\377\223\377\377\377\377\002\310\310\310\377\030\030\030"
	"\377\207\000\000\000\377\001PPP\377\210\377\377\377\377\001\213\213\213\377\223\000\000"
	"\000\377\001\347\347\347\377\207\377\377\377\377\002\360\360\360\377\003\003\003\377"
	"\205\000\000\000\377\002\037\037\037\377\321\321\321\377\223\377\377\377\377\002\336\336"
	"\336\377,,,\377\221\000\000\000\377\001\250\250\250\377\210\377\377\377\377\001\005\005"
	"\005\377\214\000\000\000\377\275\377\036\000\377\001#\004\000\377\220\000\000\000\377\001\023\002\000\377"
	"\210\377\036\000\377\001\261\024\000\377\211\000\000\000\377\001\250\250\250\377\227\377"
	"\377\377\377\001^^^\377\204\000\000\000\377\001\213\213\213\377\233\377\377\377\377"
	"\001WWW\377\212\000\000\000\377\003\026\026\026\377\253\253\253\377\376\376\376\377\217"
	"\377\377\377\377\003\371\371\371\377\206\206\206\377\007\007\007\377\210\000\000\000\377"
	"\001\207\207\207\377\210\377\377\377\377\001TTT\377\223\000\000\000\377\001\260\260\260"
	"\377\210\377\377\377\377\001***\377\206\000\000\000\377\003\012\012\012\377\220\220\220"
	"\377\373\373\373\377\217\377\377\377\377\003\376\376\376\377\240\240\240\377"
	"\021\021\021\377\222\000\000\000\377\001\250\250\250\377\210\377\377\377\377\001\005\005\005"
	"\377\214\000\000\000\377\275\377\036\000\377\001<\007\000\377\220\000\000\000\377\001\023\002\000\377"
	"\210\377\036\000\377\001\261\024\000\377\211\000\000\000\377\001\250\250\250\377\227\377"
	"\377\377\377\001^^^\377\204\000\000\000\377\001\213\213\213\377\233\377\377\377\377"
	"\001WWW\377\214\000\000\000\377\003<<<\377\262\262\262\377\373\373\373\377\213\377"
	"\377\377\377\003\363\363\363\377\232\232\232\377$$$\377\212\000\000\000\377\001\275"
	"\275\275\377\210\377\377\377\377\001\036\036\036\377\223\000\000\000\377\001zzz\377\210"
	"\377\377\377\377\001aaa\377\210\000\000\000\377\003***\377\241\241\241\377\366\366"
	"\366\377\213\377\377\377\377\003\371\371\371\377\254\254\254\377\065\065\065\377"
	"\224\000\000\000\377\001\250\250\250\377\210\377\377\377\377\001\005\005\005\377\214\000\000"
	"\000\377\275\377\036\000\377\001V\012\000\377\220\000\000\000\377\001\023\002\000\377\210\377\036"
	"\000\377\001\261\024\000\377\211\000\000\000\377\001\250\250\250\377\227\377\377\377\377"
	"\001^^^\377\204\000\000\000\377\001\213\213\213\377\233\377\377\377\377\001WWW\377\216"
	"\000\000\000\377\015\030\030\030\377aaa\377\236\236\236\377\312\312\312\377\350\350"
	"\350\377\372\372\372\377\376\376\376\377\367\367\367\377\343\343\343\377"
	"\301\301\301\377\221\221\221\377RRR\377\014\014\014\377\213\000\000\000\377\002\003\003"
	"\003\377\360\360\360\377\207\377\377\377\377\002\346\346\346\377\001\001\001\377\223"
	"\000\000\000\377\001CCC\377\210\377\377\377\377\001\227\227\227\377\212\000\000\000\377\015"
	"\017\017\017\377VVV\377\225\225\225\377\304\304\304\377\344\344\344\377\370"
	"\370\370\377\376\376\376\377\371\371\371\377\347\347\347\377\310\310\310"
	"\377\232\232\232\377]]]\377\024\024\024\377\226\000\000\000\377\001\250\250\250\377"
	"\210\377\377\377\377\001\005\005\005\377\332\000\000\000\377\001\023\002\000\377\210\377\036\000"
	"\377\001\261\024\000\377\377\000\000\000\377\377\000\000\000\377\244\000\000\000\377\001\023\002\000\377"
	"\210\377\036\000\377\001\261\024\000\377\377\000\000\000\377\377\000\000\000\377\244\000\000\000\377"
	"\001\023\002\000\377\210\377\036\000\377\001\261\024\000\377\377\000\000\000\377\377\000\000\000\377"
	"\244\000\000\000\377\001\023\002\000\377\210\377\036\000\377\001\261\024\000\377\377\000\000\000\377"
	"\377\000\000\000\377\244\000\000\000\377\001\023\002\000\377\210\377\036\000\377\001\261\024\000\377"
	"\377\000\000\000\377\377\000\000\000\377\244\000\000\000\377\001\023\002\000\377\210\377\036\000\377"
	"\001\261\024\000\377\377\000\000\000\377\377\000\000\000\377\244\000\000\000\377\001\023\002\000\377\210"
	"\377\036\000\377\001\261\024\000\377\377\000\000\000\377\377\000\000\000\377\244\000\000\000\377\001"
	"\023\002\000\377\210\377\036\000\377\001\261\024\000\377\377\000\000\000\377\325\000\000\000\377",
};

static const char *CLIENT_WINDOW_SPLASH_SVG = "<svg xmlns=\"http://www.w3.org/2000/svg\" xml:space=\"preserve\" width=\"280\" height=\"102\"><path fill=\"#ff1e00\" d=\"M49.108 67.32s0 8.16-8.185 8.16H16.37v-8.16h16.37l8.184-8.16H16.369v-4.08h28.646l8.185-8.16H16.369v-4.08h40.924l8.184-8.16H16.37v-8.16c0-8.161 8.185-8.16 8.185-8.16H26.6c0-6.12-6.138-6.12-6.138-6.12L0 10.2v81.6h57.293l-2.046-20.4s0-6.12-6.139-6.12M81.847 0v102h-8.185V0z\"/><path fill=\"#ffffff\" d=\"M98.958 84.694V34.672h-8.103v57.12h22.427v-7.098zM144.051 41.854v-7.181h-26.027v57.12h26.027v-7.099h-17.924v-17.87h13.341v-7.181h-13.341V41.854zM163.695 91.793c5.974 0 10.64-2.611 13.013-7.344 1.719-3.509 1.8-6.61 1.8-6.936v-17.87h-13.504v7.18h5.32v10.69c0 1.305-.818 7.18-6.63 7.18-5.81 0-6.71-5.956-6.71-7.18v-28.56c0-1.224.9-7.099 6.71-7.099 5.812 0 6.63 5.794 6.63 7.1v3.59h8.185v-3.59c0-.327-.082-3.428-1.8-6.937-2.374-4.733-7.04-7.344-13.014-7.344-5.975 0-10.64 2.611-13.014 7.344-1.719 3.509-1.8 6.61-1.8 6.936v28.56c0 .326.081 3.427 1.8 6.936 2.373 4.733 7.039 7.344 13.014 7.344zM208.923 91.793h8.267l-12.277-57.12H193.29l-12.277 57.12h8.267l3.846-17.87h11.95zm-14.241-24.97c1.473-6.936 2.864-13.546 4.42-20.481l4.42 20.481zM232.912 91.793c5.975 0 10.64-2.611 13.014-7.344 1.719-3.509 1.8-6.61 1.8-6.936v-3.59h-8.184v3.59c0 1.305-.819 7.18-6.63 7.18s-6.711-5.956-6.711-7.18v-28.56c0-1.224.9-7.099 6.711-7.099s6.63 5.794 6.63 7.1v3.59h8.185v-3.59c0-.327-.082-3.428-1.801-6.937-2.374-4.733-7.039-7.344-13.014-7.344s-10.64 2.611-13.013 7.344c-1.72 3.509-1.801 6.61-1.801 6.936v28.56c0 .326.082 3.427 1.8 6.936 2.374 4.733 7.04 7.344 13.014 7.344zM271.241 34.681c-2.455 6.038-4.993 11.914-7.448 17.952l-7.366-17.952h-8.758l12.114 29.294V91.8h8.102V63.975L280 34.681z\"/></svg>\0";
