/* Autogenerated from insts.td. DO NOT EDIT */
#include <jit/jit.h>
#include <stdint.h>

// This is passed as an array of uint32_t
typedef struct state_s {
	uint32_t reg[32];
	uint32_t pc;
	uint32_t hi, lo;
} state_t;

bool decompile(jit_function_t func, jit_value_t state, uint32_t pc, uint32_t inst, bool &branched);

jit_value_t _make_uint(jit_function_t func, uint32_t val) {
	return jit_value_create_nint_constant(func, jit_type_uint, val);
}
#define make_uint(val) _make_uint(func, (val))

jit_type_t sig_1, sig_2, sig_3;
void store_memory(int size, uint32_t ptr, uint32_t val) {
}

void call_store_memory(jit_function_t func, int size, jit_value_t ptr, jit_value_t val) {
	jit_value_t args[] = {make_uint(size), ptr, val};
	jit_insn_call_native(func, 0, (void *) store_memory, sig_3, args, 3, 0);
}

uint32_t load_memory(int size, uint32_t ptr) {
	return 0;
}

jit_value_t call_load_memory(jit_function_t func, int size, jit_value_t ptr) {
	jit_value_t args[] = {make_uint(size), ptr};
	return jit_insn_call_native(func, 0, (void *) load_memory, sig_2, args, 2, 0);
}

uint32_t read_copreg(int cop, int reg) {
	return 0;
}

jit_value_t call_read_copreg(jit_function_t func, int cop, int reg) {
	jit_value_t args[] = {make_uint(cop), make_uint(reg)};
	return jit_insn_call_native(func, 0, (void *) read_copreg, sig_2, args, 2, 0);
}

uint32_t read_copcreg(int cop, int reg) {
	return 0;
}

jit_value_t call_read_copcreg(jit_function_t func, int cop, int reg) {
	jit_value_t args[] = {make_uint(cop), make_uint(reg)};
	return jit_insn_call_native(func, 0, (void *) read_copcreg, sig_2, args, 2, 0);
}

void write_copreg(int cop, int reg, uint32_t val) {
}

void call_write_copreg(jit_function_t func, int cop, int reg, jit_value_t val) {
	jit_value_t args[] = {make_uint(cop), make_uint(reg), val};
	jit_insn_call_native(func, 0, (void *) write_copreg, sig_3, args, 3, 0);
}

void write_copcreg(int cop, int reg, uint32_t val) {
}

void call_write_copcreg(jit_function_t func, int cop, int reg, jit_value_t val) {
	jit_value_t args[] = {make_uint(cop), make_uint(reg), val};
	jit_insn_call_native(func, 0, (void *) write_copcreg, sig_3, args, 3, 0);
}

void copfun(int cop, int cofun) {
}

jit_value_t call_copfun(jit_function_t func, int cop, int cofun) {
	jit_value_t args[] = {make_uint(cop), make_uint(cofun)};
	return jit_insn_call_native(func, 0, (void *) copfun, sig_2, args, 2, 0);
}

int32_t signext(int size, uint32_t imm) {
	if(size == 8)
		return (int32_t) ((int8_t) ((uint8_t) imm));
	else if(size == 16)
		return (int32_t) ((int16_t) ((uint16_t) imm));
	return (int32_t) imm;
}

jit_value_t call_signext(jit_function_t func, int size, jit_value_t val) {
	jit_value_t args[] = {make_uint(size), val};
	return jit_insn_call_native(func, 0, (void *) signext, sig_2, args, 2, 0);
}

void syscall(int code) {
}

void call_syscall(jit_function_t func, uint32_t code) {
	jit_value_t args[] = {make_uint(code)};
	jit_insn_call_native(func, 0, (void *) syscall, sig_1, args, 1, 0);
}

void break_(int code) {
}

void call_break(jit_function_t func, uint32_t code) {
	jit_value_t args[] = {make_uint(code)};
	jit_insn_call_native(func, 0, (void *) break_, sig_1, args, 1, 0);
}

void branch(uint32_t target) {
}

void call_branch(jit_function_t func, jit_value_t val) {
	jit_value_t args[] = {val};
	jit_insn_call_native(func, 0, (void *) branch, sig_1, args, 1, 0);
}

void overflow(uint32_t a, uint32_t b, int dir) {
}

void call_overflow(jit_function_t func, jit_value_t a, jit_value_t b, int dir) {
	jit_value_t args[] = {a, b, make_uint(dir)};
	jit_insn_call_native(func, 0, (void *) overflow, sig_3, args, 3, 0);
}


int main() {
	bool branched = false;
	auto context = jit_context_create();
	jit_context_build_start(context);

	jit_type_t s3params[3];
	s3params[0] = jit_type_uint;
	s3params[1] = jit_type_uint;
	s3params[2] = jit_type_uint;
	sig_3 = jit_type_create_signature(jit_abi_cdecl, jit_type_uint, s3params, 3, 1);
	
	jit_type_t sparams[2];
	sparams[0] = jit_type_uint;
	sparams[1] = jit_type_uint;
	sig_2 = jit_type_create_signature(jit_abi_cdecl, jit_type_uint, sparams, 2, 1);
	
	jit_type_t lparams[2];
	lparams[0] = jit_type_uint;
	sig_1 = jit_type_create_signature(jit_abi_cdecl, jit_type_uint, lparams, 1, 1);
	
	jit_type_t params[1];
	params[0] = jit_type_create_pointer(jit_type_uint, 0);
	auto signature = jit_type_create_signature(jit_abi_cdecl, jit_type_int, params, 1, 1);

	auto func = jit_function_create(context, signature);
	auto statevar = jit_value_get_param(func, 0);
	decompile(func, statevar, 0xDEADBEE0, 0x0, branched);
	return 0;
}
bool decompile(jit_function_t func, jit_value_t state, uint32_t pc, uint32_t inst, bool &branched) {
	switch((inst) >> (0x1a)) {
		case 0x0: {
			switch((inst) & (0x3f)) {
				case 0x0: {
					/* SLL */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t rt = ((inst) >> (0x10)) & (0x1f);
					uint32_t rd = ((inst) >> (0xb)) & (0x1f);
					uint32_t shamt = ((inst) >> (0x6)) & (0x1f);
					if((rd) != (0x0)) { jit_insn_store_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rd), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_insn_shl(func, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint), jit_value_create_nint_constant(func, jit_type_uint, shamt))); }
					return(true);
					break;
				}
				case 0x2: {
					/* SRL */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t rt = ((inst) >> (0x10)) & (0x1f);
					uint32_t rd = ((inst) >> (0xb)) & (0x1f);
					uint32_t shamt = ((inst) >> (0x6)) & (0x1f);
					if((rd) != (0x0)) { jit_insn_store_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rd), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_insn_ushr(func, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint), jit_value_create_nint_constant(func, jit_type_uint, shamt))); }
					return(true);
					break;
				}
				case 0x3: {
					/* SRA */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t rt = ((inst) >> (0x10)) & (0x1f);
					uint32_t rd = ((inst) >> (0xb)) & (0x1f);
					uint32_t shamt = ((inst) >> (0x6)) & (0x1f);
					if((rd) != (0x0)) { jit_insn_store_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rd), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_insn_sshr(func, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint), jit_value_create_nint_constant(func, jit_type_uint, shamt))); }
					return(true);
					break;
				}
				case 0x4: {
					/* SLLV */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t rs = ((inst) >> (0x15)) & (0x1f);
					uint32_t rt = ((inst) >> (0x10)) & (0x1f);
					uint32_t rd = ((inst) >> (0xb)) & (0x1f);
					if((rd) != (0x0)) { jit_insn_store_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rd), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_insn_shl(func, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint), jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rs), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint))); }
					return(true);
					break;
				}
				case 0x6: {
					/* SRLV */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t rs = ((inst) >> (0x15)) & (0x1f);
					uint32_t rt = ((inst) >> (0x10)) & (0x1f);
					uint32_t rd = ((inst) >> (0xb)) & (0x1f);
					if((rd) != (0x0)) { jit_insn_store_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rd), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_insn_ushr(func, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint), jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rs), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint))); }
					return(true);
					break;
				}
				case 0x7: {
					/* SRAV */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t rs = ((inst) >> (0x15)) & (0x1f);
					uint32_t rt = ((inst) >> (0x10)) & (0x1f);
					uint32_t rd = ((inst) >> (0xb)) & (0x1f);
					if((rd) != (0x0)) { jit_insn_store_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rd), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_insn_sshr(func, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint), jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rs), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint))); }
					return(true);
					break;
				}
				case 0x8: {
					/* JR */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t rs = ((inst) >> (0x15)) & (0x1f);
					call_branch(func, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rs), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint));
					branched = true;
					return(true);
					break;
				}
				case 0x9: {
					/* JALR */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t rs = ((inst) >> (0x15)) & (0x1f);
					uint32_t rd = ((inst) >> (0xb)) & (0x1f);
					if((rd) != (0x0)) { jit_insn_store_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rd), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_insn_add(func, jit_insn_add(func, jit_value_create_nint_constant(func, jit_type_uint, pc), jit_value_create_nint_constant(func, jit_type_uint, 0x4)), jit_value_create_nint_constant(func, jit_type_uint, 0x4))); }
					call_branch(func, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rs), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint));
					branched = true;
					return(true);
					break;
				}
				case 0xc: {
					/* SYSCALL */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t code = ((inst) >> (0x6)) & (0xfffff);
					call_syscall(func, code);
					return(true);
					break;
				}
				case 0xd: {
					/* BREAK */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t code = ((inst) >> (0x6)) & (0xfffff);
					call_break(func, code);
					return(true);
					break;
				}
				case 0x10: {
					/* MFHI */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t rd = ((inst) >> (0xb)) & (0x1f);
					if((rd) != (0x0)) { jit_insn_store_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rd), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_insn_load_relative(func, state, 33*4, jit_type_uint)); }
					return(true);
					break;
				}
				case 0x11: {
					/* MTHI */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t rd = ((inst) >> (0xb)) & (0x1f);
					jit_insn_store_relative(func, state, 33*4, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rd), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint));
					return(true);
					break;
				}
				case 0x12: {
					/* MFLO */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t rd = ((inst) >> (0xb)) & (0x1f);
					if((rd) != (0x0)) { jit_insn_store_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rd), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_insn_load_relative(func, state, 34*4, jit_type_uint)); }
					return(true);
					break;
				}
				case 0x13: {
					/* MTLO */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t rd = ((inst) >> (0xb)) & (0x1f);
					jit_insn_store_relative(func, state, 34*4, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rd), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint));
					return(true);
					break;
				}
				case 0x18: {
					/* MULT */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t rs = ((inst) >> (0x15)) & (0x1f);
					uint32_t rt = ((inst) >> (0x10)) & (0x1f);
					/* Unhandled list */
					return(true);
					break;
				}
				case 0x19: {
					/* MULTU */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t rs = ((inst) >> (0x15)) & (0x1f);
					uint32_t rt = ((inst) >> (0x10)) & (0x1f);
					/* Unhandled list */
					return(true);
					break;
				}
				case 0x1a: {
					/* DIV */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t rs = ((inst) >> (0x15)) & (0x1f);
					uint32_t rt = ((inst) >> (0x10)) & (0x1f);
					jit_insn_store_relative(func, state, 34*4, jit_insn_div(func, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rs), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint), jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint)));
					jit_insn_store_relative(func, state, 33*4, jit_insn_rem(func, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rs), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint), jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint)));
					return(true);
					break;
				}
				case 0x1b: {
					/* DIVU */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t rs = ((inst) >> (0x15)) & (0x1f);
					uint32_t rt = ((inst) >> (0x10)) & (0x1f);
					jit_insn_store_relative(func, state, 34*4, jit_insn_div(func, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rs), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint), jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint)));
					jit_insn_store_relative(func, state, 33*4, jit_insn_rem(func, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rs), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint), jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint)));
					return(true);
					break;
				}
				case 0x20: {
					/* ADD */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t rs = ((inst) >> (0x15)) & (0x1f);
					uint32_t rt = ((inst) >> (0x10)) & (0x1f);
					uint32_t rd = ((inst) >> (0xb)) & (0x1f);
					call_overflow(func, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rs), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint), jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint), 1);
					if((rd) != (0x0)) { jit_insn_store_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rd), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_insn_add(func, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rs), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint), jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint))); }
					return(true);
					break;
				}
				case 0x21: {
					/* ADDU */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t rs = ((inst) >> (0x15)) & (0x1f);
					uint32_t rt = ((inst) >> (0x10)) & (0x1f);
					uint32_t rd = ((inst) >> (0xb)) & (0x1f);
					if((rd) != (0x0)) { jit_insn_store_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rd), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_insn_add(func, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rs), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint), jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint))); }
					return(true);
					break;
				}
				case 0x22: {
					/* SUB */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t rs = ((inst) >> (0x15)) & (0x1f);
					uint32_t rt = ((inst) >> (0x10)) & (0x1f);
					uint32_t rd = ((inst) >> (0xb)) & (0x1f);
					call_overflow(func, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rs), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint), jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint), -1);
					if((rd) != (0x0)) { jit_insn_store_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rd), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_insn_sub(func, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rs), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint), jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint))); }
					return(true);
					break;
				}
				case 0x23: {
					/* SUBU */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t rs = ((inst) >> (0x15)) & (0x1f);
					uint32_t rt = ((inst) >> (0x10)) & (0x1f);
					uint32_t rd = ((inst) >> (0xb)) & (0x1f);
					if((rd) != (0x0)) { jit_insn_store_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rd), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_insn_sub(func, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rs), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint), jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint))); }
					return(true);
					break;
				}
				case 0x24: {
					/* AND */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t rs = ((inst) >> (0x15)) & (0x1f);
					uint32_t rt = ((inst) >> (0x10)) & (0x1f);
					uint32_t rd = ((inst) >> (0xb)) & (0x1f);
					if((rd) != (0x0)) { jit_insn_store_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rd), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_insn_and(func, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rs), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint), jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint))); }
					return(true);
					break;
				}
				case 0x25: {
					/* OR */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t rs = ((inst) >> (0x15)) & (0x1f);
					uint32_t rt = ((inst) >> (0x10)) & (0x1f);
					uint32_t rd = ((inst) >> (0xb)) & (0x1f);
					if((rd) != (0x0)) { jit_insn_store_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rd), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_insn_or(func, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rs), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint), jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint))); }
					return(true);
					break;
				}
				case 0x26: {
					/* XOR */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t rs = ((inst) >> (0x15)) & (0x1f);
					uint32_t rt = ((inst) >> (0x10)) & (0x1f);
					uint32_t rd = ((inst) >> (0xb)) & (0x1f);
					if((rd) != (0x0)) { jit_insn_store_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rd), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_insn_xor(func, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rs), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint), jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint))); }
					return(true);
					break;
				}
				case 0x27: {
					/* NOR */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t rs = ((inst) >> (0x15)) & (0x1f);
					uint32_t rt = ((inst) >> (0x10)) & (0x1f);
					uint32_t rd = ((inst) >> (0xb)) & (0x1f);
					if((rd) != (0x0)) { jit_insn_store_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rd), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_insn_not(func, jit_insn_or(func, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rs), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint), jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint)))); }
					return(true);
					break;
				}
				case 0x2a: {
					/* SLT */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t rs = ((inst) >> (0x15)) & (0x1f);
					uint32_t rt = ((inst) >> (0x10)) & (0x1f);
					uint32_t rd = ((inst) >> (0xb)) & (0x1f);
					jit_label_t temp_1 = jit_label_undefined, temp_2 = jit_label_undefined;
					jit_insn_branch_if(func, jit_insn_lt(func, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rs), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint), jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint)), &temp_1);
					jit_label_t temp_3 = jit_label_undefined;
					jit_insn_branch_if_not(func, jit_insn_ne(func, jit_value_create_nint_constant(func, jit_type_uint, rd), jit_value_create_nint_constant(func, jit_type_uint, 0x0)), &temp_3);
					jit_insn_store_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rd), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_value_create_nint_constant(func, jit_type_uint, 0x1));
					jit_insn_label(func, &temp_3);
					jit_insn_branch(func, &temp_2);
					jit_insn_label(func, &temp_1);
					jit_label_t temp_4 = jit_label_undefined;
					jit_insn_branch_if_not(func, jit_insn_ne(func, jit_value_create_nint_constant(func, jit_type_uint, rd), jit_value_create_nint_constant(func, jit_type_uint, 0x0)), &temp_4);
					jit_insn_store_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rd), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_value_create_nint_constant(func, jit_type_uint, 0x0));
					jit_insn_label(func, &temp_4);
					jit_insn_label(func, &temp_2);
					return(true);
					break;
				}
				case 0x2b: {
					/* SLTU */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t rs = ((inst) >> (0x15)) & (0x1f);
					uint32_t rt = ((inst) >> (0x10)) & (0x1f);
					uint32_t rd = ((inst) >> (0xb)) & (0x1f);
					jit_label_t temp_5 = jit_label_undefined, temp_6 = jit_label_undefined;
					jit_insn_branch_if(func, jit_insn_lt(func, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rs), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint), jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint)), &temp_5);
					jit_label_t temp_7 = jit_label_undefined;
					jit_insn_branch_if_not(func, jit_insn_ne(func, jit_value_create_nint_constant(func, jit_type_uint, rd), jit_value_create_nint_constant(func, jit_type_uint, 0x0)), &temp_7);
					jit_insn_store_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rd), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_value_create_nint_constant(func, jit_type_uint, 0x1));
					jit_insn_label(func, &temp_7);
					jit_insn_branch(func, &temp_6);
					jit_insn_label(func, &temp_5);
					jit_label_t temp_8 = jit_label_undefined;
					jit_insn_branch_if_not(func, jit_insn_ne(func, jit_value_create_nint_constant(func, jit_type_uint, rd), jit_value_create_nint_constant(func, jit_type_uint, 0x0)), &temp_8);
					jit_insn_store_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rd), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_value_create_nint_constant(func, jit_type_uint, 0x0));
					jit_insn_label(func, &temp_8);
					jit_insn_label(func, &temp_6);
					return(true);
					break;
				}
			}
			break;
		}
		case 0x1: {
			switch(((inst) >> (0x10)) & (0x1f)) {
				case 0x0: {
					/* BLTZ */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t rs = ((inst) >> (0x15)) & (0x1f);
					uint32_t imm = (inst) & (0xffff);
					uint32_t target = ((pc) + (0x4)) + (signext(0x12, (imm) << (0x2)));
					jit_label_t temp_9 = jit_label_undefined;
					jit_insn_branch_if_not(func, jit_insn_lt(func, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rs), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint), jit_value_create_nint_constant(func, jit_type_uint, 0x0)), &temp_9);
					call_branch(func, jit_value_create_nint_constant(func, jit_type_uint, target));
					jit_insn_label(func, &temp_9);
					branched = true;
					return(true);
					break;
				}
				case 0x1: {
					/* BGEZ */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t rs = ((inst) >> (0x15)) & (0x1f);
					uint32_t imm = (inst) & (0xffff);
					uint32_t target = ((pc) + (0x4)) + (signext(0x12, (imm) << (0x2)));
					jit_label_t temp_10 = jit_label_undefined;
					jit_insn_branch_if_not(func, jit_insn_ge(func, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rs), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint), jit_value_create_nint_constant(func, jit_type_uint, 0x0)), &temp_10);
					call_branch(func, jit_value_create_nint_constant(func, jit_type_uint, target));
					jit_insn_label(func, &temp_10);
					branched = true;
					return(true);
					break;
				}
				case 0x10: {
					/* BLTZAL */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t rs = ((inst) >> (0x15)) & (0x1f);
					uint32_t imm = (inst) & (0xffff);
					if((0x1f) != (0x0)) { jit_insn_store_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, 0x1f), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_insn_add(func, jit_value_create_nint_constant(func, jit_type_uint, pc), jit_value_create_nint_constant(func, jit_type_uint, 0x4))); }
					uint32_t target = ((pc) + (0x4)) + (signext(0x12, (imm) << (0x2)));
					jit_label_t temp_11 = jit_label_undefined;
					jit_insn_branch_if_not(func, jit_insn_lt(func, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rs), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint), jit_value_create_nint_constant(func, jit_type_uint, 0x0)), &temp_11);
					call_branch(func, jit_value_create_nint_constant(func, jit_type_uint, target));
					jit_insn_label(func, &temp_11);
					branched = true;
					return(true);
					break;
				}
				case 0x11: {
					/* BGEZAL */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t rs = ((inst) >> (0x15)) & (0x1f);
					uint32_t imm = (inst) & (0xffff);
					if((0x1f) != (0x0)) { jit_insn_store_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, 0x1f), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_insn_add(func, jit_value_create_nint_constant(func, jit_type_uint, pc), jit_value_create_nint_constant(func, jit_type_uint, 0x4))); }
					uint32_t target = ((pc) + (0x4)) + (signext(0x12, (imm) << (0x2)));
					jit_label_t temp_12 = jit_label_undefined;
					jit_insn_branch_if_not(func, jit_insn_ge(func, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rs), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint), jit_value_create_nint_constant(func, jit_type_uint, 0x0)), &temp_12);
					call_branch(func, jit_value_create_nint_constant(func, jit_type_uint, target));
					jit_insn_label(func, &temp_12);
					branched = true;
					return(true);
					break;
				}
			}
			break;
		}
		case 0x2: {
			/* J */
			jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
			uint32_t imm = (inst) & (0x3ffffff);
			uint32_t target = (((pc) + (0x4)) & (0xf0000000)) + (0x1c);
			call_branch(func, jit_value_create_nint_constant(func, jit_type_uint, target));
			branched = true;
			return(true);
			break;
		}
		case 0x3: {
			/* JAL */
			jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
			uint32_t imm = (inst) & (0x3ffffff);
			if((0x1f) != (0x0)) { jit_insn_store_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, 0x1f), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_insn_add(func, jit_insn_add(func, jit_value_create_nint_constant(func, jit_type_uint, pc), jit_value_create_nint_constant(func, jit_type_uint, 0x4)), jit_value_create_nint_constant(func, jit_type_uint, 0x4))); }
			uint32_t target = (((pc) + (0x4)) & (0xf0000000)) + (0x1c);
			call_branch(func, jit_value_create_nint_constant(func, jit_type_uint, target));
			branched = true;
			return(true);
			break;
		}
		case 0x4: {
			/* BEQ */
			jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
			uint32_t rs = ((inst) >> (0x15)) & (0x1f);
			uint32_t rt = ((inst) >> (0x10)) & (0x1f);
			uint32_t imm = (inst) & (0xffff);
			uint32_t target = ((pc) + (0x4)) + (signext(0x12, (imm) << (0x2)));
			jit_label_t temp_13 = jit_label_undefined;
			jit_insn_branch_if_not(func, jit_insn_eq(func, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rs), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint), jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint)), &temp_13);
			call_branch(func, jit_value_create_nint_constant(func, jit_type_uint, target));
			jit_insn_label(func, &temp_13);
			branched = true;
			return(true);
			break;
		}
		case 0x5: {
			/* BNE */
			jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
			uint32_t rs = ((inst) >> (0x15)) & (0x1f);
			uint32_t rt = ((inst) >> (0x10)) & (0x1f);
			uint32_t imm = (inst) & (0xffff);
			uint32_t target = ((pc) + (0x4)) + (signext(0x12, (imm) << (0x2)));
			jit_label_t temp_14 = jit_label_undefined;
			jit_insn_branch_if_not(func, jit_insn_ne(func, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rs), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint), jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint)), &temp_14);
			call_branch(func, jit_value_create_nint_constant(func, jit_type_uint, target));
			jit_insn_label(func, &temp_14);
			branched = true;
			return(true);
			break;
		}
		case 0x6: {
			switch(((inst) >> (0x10)) & (0x1f)) {
				case 0x0: {
					/* BLEZ */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t rs = ((inst) >> (0x15)) & (0x1f);
					uint32_t imm = (inst) & (0xffff);
					uint32_t target = ((pc) + (0x4)) + (signext(0x12, (imm) << (0x2)));
					jit_label_t temp_15 = jit_label_undefined;
					jit_insn_branch_if_not(func, jit_insn_le(func, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rs), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint), jit_value_create_nint_constant(func, jit_type_uint, 0x0)), &temp_15);
					call_branch(func, jit_value_create_nint_constant(func, jit_type_uint, target));
					jit_insn_label(func, &temp_15);
					branched = true;
					return(true);
					break;
				}
			}
			break;
		}
		case 0x7: {
			switch(((inst) >> (0x10)) & (0x1f)) {
				case 0x0: {
					/* BGTZ */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t rs = ((inst) >> (0x15)) & (0x1f);
					uint32_t imm = (inst) & (0xffff);
					uint32_t target = ((pc) + (0x4)) + (signext(0x12, (imm) << (0x2)));
					jit_label_t temp_16 = jit_label_undefined;
					jit_insn_branch_if_not(func, jit_insn_gt(func, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rs), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint), jit_value_create_nint_constant(func, jit_type_uint, 0x0)), &temp_16);
					call_branch(func, jit_value_create_nint_constant(func, jit_type_uint, target));
					jit_insn_label(func, &temp_16);
					branched = true;
					return(true);
					break;
				}
			}
			break;
		}
		case 0x8: {
			/* ADDI */
			jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
			uint32_t rs = ((inst) >> (0x15)) & (0x1f);
			uint32_t rt = ((inst) >> (0x10)) & (0x1f);
			uint32_t imm = (inst) & (0xffff);
			uint32_t eimm = signext(0x10, imm);
			call_overflow(func, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rs), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint), jit_value_create_nint_constant(func, jit_type_uint, eimm), 1);
			if((rt) != (0x0)) { jit_insn_store_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_insn_add(func, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rs), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint), jit_value_create_nint_constant(func, jit_type_uint, eimm))); }
			return(true);
			break;
		}
		case 0x9: {
			/* ADDIU */
			jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
			uint32_t rs = ((inst) >> (0x15)) & (0x1f);
			uint32_t rt = ((inst) >> (0x10)) & (0x1f);
			uint32_t imm = (inst) & (0xffff);
			uint32_t eimm = signext(0x10, imm);
			if((rt) != (0x0)) { jit_insn_store_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_insn_add(func, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rs), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint), jit_value_create_nint_constant(func, jit_type_uint, eimm))); }
			return(true);
			break;
		}
		case 0xa: {
			/* SLTI */
			jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
			uint32_t rs = ((inst) >> (0x15)) & (0x1f);
			uint32_t rt = ((inst) >> (0x10)) & (0x1f);
			uint32_t imm = (inst) & (0xffff);
			uint32_t eimm = signext(0x10, imm);
			jit_label_t temp_17 = jit_label_undefined, temp_18 = jit_label_undefined;
			jit_insn_branch_if(func, jit_insn_lt(func, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rs), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint), jit_value_create_nint_constant(func, jit_type_uint, eimm)), &temp_17);
			jit_label_t temp_19 = jit_label_undefined;
			jit_insn_branch_if_not(func, jit_insn_ne(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 0x0)), &temp_19);
			jit_insn_store_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_value_create_nint_constant(func, jit_type_uint, 0x1));
			jit_insn_label(func, &temp_19);
			jit_insn_branch(func, &temp_18);
			jit_insn_label(func, &temp_17);
			jit_label_t temp_20 = jit_label_undefined;
			jit_insn_branch_if_not(func, jit_insn_ne(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 0x0)), &temp_20);
			jit_insn_store_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_value_create_nint_constant(func, jit_type_uint, 0x0));
			jit_insn_label(func, &temp_20);
			jit_insn_label(func, &temp_18);
			return(true);
			break;
		}
		case 0xb: {
			/* SLTIU */
			jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
			uint32_t rs = ((inst) >> (0x15)) & (0x1f);
			uint32_t rt = ((inst) >> (0x10)) & (0x1f);
			uint32_t imm = (inst) & (0xffff);
			uint32_t eimm = signext(0x10, imm);
			jit_label_t temp_21 = jit_label_undefined, temp_22 = jit_label_undefined;
			jit_insn_branch_if(func, jit_insn_lt(func, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rs), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint), jit_value_create_nint_constant(func, jit_type_uint, eimm)), &temp_21);
			jit_label_t temp_23 = jit_label_undefined;
			jit_insn_branch_if_not(func, jit_insn_ne(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 0x0)), &temp_23);
			jit_insn_store_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_value_create_nint_constant(func, jit_type_uint, 0x1));
			jit_insn_label(func, &temp_23);
			jit_insn_branch(func, &temp_22);
			jit_insn_label(func, &temp_21);
			jit_label_t temp_24 = jit_label_undefined;
			jit_insn_branch_if_not(func, jit_insn_ne(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 0x0)), &temp_24);
			jit_insn_store_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_value_create_nint_constant(func, jit_type_uint, 0x0));
			jit_insn_label(func, &temp_24);
			jit_insn_label(func, &temp_22);
			return(true);
			break;
		}
		case 0xc: {
			/* ANDI */
			jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
			uint32_t rs = ((inst) >> (0x15)) & (0x1f);
			uint32_t rt = ((inst) >> (0x10)) & (0x1f);
			uint32_t imm = (inst) & (0xffff);
			uint32_t eimm = 0x10;
			if((rt) != (0x0)) { jit_insn_store_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_insn_and(func, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rs), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint), jit_value_create_nint_constant(func, jit_type_uint, eimm))); }
			return(true);
			break;
		}
		case 0xd: {
			/* ORI */
			jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
			uint32_t rs = ((inst) >> (0x15)) & (0x1f);
			uint32_t rt = ((inst) >> (0x10)) & (0x1f);
			uint32_t imm = (inst) & (0xffff);
			uint32_t eimm = 0x10;
			if((rt) != (0x0)) { jit_insn_store_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_insn_or(func, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rs), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint), jit_value_create_nint_constant(func, jit_type_uint, eimm))); }
			return(true);
			break;
		}
		case 0xe: {
			/* XORI */
			jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
			uint32_t rs = ((inst) >> (0x15)) & (0x1f);
			uint32_t rt = ((inst) >> (0x10)) & (0x1f);
			uint32_t imm = (inst) & (0xffff);
			uint32_t eimm = 0x10;
			if((rt) != (0x0)) { jit_insn_store_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_insn_xor(func, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rs), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint), jit_value_create_nint_constant(func, jit_type_uint, eimm))); }
			return(true);
			break;
		}
		case 0xf: {
			/* LUI */
			jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
			uint32_t rt = ((inst) >> (0x10)) & (0x1f);
			uint32_t imm = (inst) & (0xffff);
			if((rt) != (0x0)) { jit_insn_store_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_insn_shl(func, jit_value_create_nint_constant(func, jit_type_uint, imm), jit_value_create_nint_constant(func, jit_type_uint, 0x10))); }
			return(true);
			break;
		}
		case 0x10: {
			switch(((inst) >> (0x15)) & (0x1f)) {
				case 0x0: {
					/* MFCzanonymous_0 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t rt = ((inst) >> (0x10)) & (0x1f);
					uint32_t rd = ((inst) >> (0xb)) & (0x1f);
					if((rt) != (0x0)) { jit_insn_store_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, call_read_copreg(func, cop, rd)); }
					return(true);
					break;
				}
				case 0x2: {
					/* CFCzanonymous_0 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t rt = ((inst) >> (0x10)) & (0x1f);
					uint32_t rd = ((inst) >> (0xb)) & (0x1f);
					if((rt) != (0x0)) { jit_insn_store_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, call_read_copcreg(func, cop, rd)); }
					return(true);
					break;
				}
				case 0x4: {
					/* MTCzanonymous_0 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t rt = ((inst) >> (0x10)) & (0x1f);
					uint32_t rd = ((inst) >> (0xb)) & (0x1f);
					call_write_copreg(func, cop, rd, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint));
					return(true);
					break;
				}
				case 0x6: {
					/* CTCzanonymous_0 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t rt = ((inst) >> (0x10)) & (0x1f);
					uint32_t rd = ((inst) >> (0xb)) & (0x1f);
					call_write_copcreg(func, cop, rd, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint));
					return(true);
					break;
				}
				case 0x10: {
					/* COPzanonymous_4anonymous_0 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x11: {
					/* COPzanonymous_5anonymous_0 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x12: {
					/* COPzanonymous_6anonymous_0 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x13: {
					/* COPzanonymous_7anonymous_0 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x14: {
					/* COPzanonymous_8anonymous_0 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x15: {
					/* COPzanonymous_9anonymous_0 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x16: {
					/* COPzanonymous_10anonymous_0 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x17: {
					/* COPzanonymous_11anonymous_0 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x18: {
					/* COPzanonymous_12anonymous_0 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x19: {
					/* COPzanonymous_13anonymous_0 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x1a: {
					/* COPzanonymous_14anonymous_0 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x1b: {
					/* COPzanonymous_15anonymous_0 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x1c: {
					/* COPzanonymous_16anonymous_0 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x1d: {
					/* COPzanonymous_17anonymous_0 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x1e: {
					/* COPzanonymous_18anonymous_0 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x1f: {
					/* COPzanonymous_19anonymous_0 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
			}
			break;
		}
		case 0x11: {
			switch(((inst) >> (0x15)) & (0x1f)) {
				case 0x0: {
					/* MFCzanonymous_1 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t rt = ((inst) >> (0x10)) & (0x1f);
					uint32_t rd = ((inst) >> (0xb)) & (0x1f);
					if((rt) != (0x0)) { jit_insn_store_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, call_read_copreg(func, cop, rd)); }
					return(true);
					break;
				}
				case 0x2: {
					/* CFCzanonymous_1 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t rt = ((inst) >> (0x10)) & (0x1f);
					uint32_t rd = ((inst) >> (0xb)) & (0x1f);
					if((rt) != (0x0)) { jit_insn_store_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, call_read_copcreg(func, cop, rd)); }
					return(true);
					break;
				}
				case 0x4: {
					/* MTCzanonymous_1 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t rt = ((inst) >> (0x10)) & (0x1f);
					uint32_t rd = ((inst) >> (0xb)) & (0x1f);
					call_write_copreg(func, cop, rd, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint));
					return(true);
					break;
				}
				case 0x6: {
					/* CTCzanonymous_1 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t rt = ((inst) >> (0x10)) & (0x1f);
					uint32_t rd = ((inst) >> (0xb)) & (0x1f);
					call_write_copcreg(func, cop, rd, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint));
					return(true);
					break;
				}
				case 0x10: {
					/* COPzanonymous_4anonymous_1 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x11: {
					/* COPzanonymous_5anonymous_1 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x12: {
					/* COPzanonymous_6anonymous_1 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x13: {
					/* COPzanonymous_7anonymous_1 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x14: {
					/* COPzanonymous_8anonymous_1 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x15: {
					/* COPzanonymous_9anonymous_1 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x16: {
					/* COPzanonymous_10anonymous_1 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x17: {
					/* COPzanonymous_11anonymous_1 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x18: {
					/* COPzanonymous_12anonymous_1 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x19: {
					/* COPzanonymous_13anonymous_1 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x1a: {
					/* COPzanonymous_14anonymous_1 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x1b: {
					/* COPzanonymous_15anonymous_1 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x1c: {
					/* COPzanonymous_16anonymous_1 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x1d: {
					/* COPzanonymous_17anonymous_1 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x1e: {
					/* COPzanonymous_18anonymous_1 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x1f: {
					/* COPzanonymous_19anonymous_1 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
			}
			break;
		}
		case 0x12: {
			switch(((inst) >> (0x15)) & (0x1f)) {
				case 0x0: {
					/* MFCzanonymous_2 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t rt = ((inst) >> (0x10)) & (0x1f);
					uint32_t rd = ((inst) >> (0xb)) & (0x1f);
					if((rt) != (0x0)) { jit_insn_store_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, call_read_copreg(func, cop, rd)); }
					return(true);
					break;
				}
				case 0x2: {
					/* CFCzanonymous_2 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t rt = ((inst) >> (0x10)) & (0x1f);
					uint32_t rd = ((inst) >> (0xb)) & (0x1f);
					if((rt) != (0x0)) { jit_insn_store_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, call_read_copcreg(func, cop, rd)); }
					return(true);
					break;
				}
				case 0x4: {
					/* MTCzanonymous_2 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t rt = ((inst) >> (0x10)) & (0x1f);
					uint32_t rd = ((inst) >> (0xb)) & (0x1f);
					call_write_copreg(func, cop, rd, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint));
					return(true);
					break;
				}
				case 0x6: {
					/* CTCzanonymous_2 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t rt = ((inst) >> (0x10)) & (0x1f);
					uint32_t rd = ((inst) >> (0xb)) & (0x1f);
					call_write_copcreg(func, cop, rd, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint));
					return(true);
					break;
				}
				case 0x10: {
					/* COPzanonymous_4anonymous_2 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x11: {
					/* COPzanonymous_5anonymous_2 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x12: {
					/* COPzanonymous_6anonymous_2 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x13: {
					/* COPzanonymous_7anonymous_2 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x14: {
					/* COPzanonymous_8anonymous_2 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x15: {
					/* COPzanonymous_9anonymous_2 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x16: {
					/* COPzanonymous_10anonymous_2 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x17: {
					/* COPzanonymous_11anonymous_2 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x18: {
					/* COPzanonymous_12anonymous_2 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x19: {
					/* COPzanonymous_13anonymous_2 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x1a: {
					/* COPzanonymous_14anonymous_2 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x1b: {
					/* COPzanonymous_15anonymous_2 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x1c: {
					/* COPzanonymous_16anonymous_2 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x1d: {
					/* COPzanonymous_17anonymous_2 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x1e: {
					/* COPzanonymous_18anonymous_2 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x1f: {
					/* COPzanonymous_19anonymous_2 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
			}
			break;
		}
		case 0x13: {
			switch(((inst) >> (0x15)) & (0x1f)) {
				case 0x0: {
					/* MFCzanonymous_3 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t rt = ((inst) >> (0x10)) & (0x1f);
					uint32_t rd = ((inst) >> (0xb)) & (0x1f);
					if((rt) != (0x0)) { jit_insn_store_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, call_read_copreg(func, cop, rd)); }
					return(true);
					break;
				}
				case 0x2: {
					/* CFCzanonymous_3 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t rt = ((inst) >> (0x10)) & (0x1f);
					uint32_t rd = ((inst) >> (0xb)) & (0x1f);
					if((rt) != (0x0)) { jit_insn_store_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, call_read_copcreg(func, cop, rd)); }
					return(true);
					break;
				}
				case 0x4: {
					/* MTCzanonymous_3 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t rt = ((inst) >> (0x10)) & (0x1f);
					uint32_t rd = ((inst) >> (0xb)) & (0x1f);
					call_write_copreg(func, cop, rd, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint));
					return(true);
					break;
				}
				case 0x6: {
					/* CTCzanonymous_3 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t rt = ((inst) >> (0x10)) & (0x1f);
					uint32_t rd = ((inst) >> (0xb)) & (0x1f);
					call_write_copcreg(func, cop, rd, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint));
					return(true);
					break;
				}
				case 0x10: {
					/* COPzanonymous_4anonymous_3 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x11: {
					/* COPzanonymous_5anonymous_3 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x12: {
					/* COPzanonymous_6anonymous_3 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x13: {
					/* COPzanonymous_7anonymous_3 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x14: {
					/* COPzanonymous_8anonymous_3 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x15: {
					/* COPzanonymous_9anonymous_3 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x16: {
					/* COPzanonymous_10anonymous_3 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x17: {
					/* COPzanonymous_11anonymous_3 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x18: {
					/* COPzanonymous_12anonymous_3 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x19: {
					/* COPzanonymous_13anonymous_3 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x1a: {
					/* COPzanonymous_14anonymous_3 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x1b: {
					/* COPzanonymous_15anonymous_3 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x1c: {
					/* COPzanonymous_16anonymous_3 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x1d: {
					/* COPzanonymous_17anonymous_3 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x1e: {
					/* COPzanonymous_18anonymous_3 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
				case 0x1f: {
					/* COPzanonymous_19anonymous_3 */
					jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
					uint32_t cop = ((inst) >> (0x1a)) & (0x3);
					uint32_t cofun = (inst) & (0x1ffffff);
					call_copfun(func, cop, cofun);
					return(true);
					break;
				}
			}
			break;
		}
		case 0x20: {
			/* LB */
			jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
			uint32_t rs = ((inst) >> (0x15)) & (0x1f);
			uint32_t rt = ((inst) >> (0x10)) & (0x1f);
			uint32_t imm = (inst) & (0xffff);
			uint32_t offset = signext(0x10, imm);
			if((rt) != (0x0)) { jit_insn_store_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, call_signext(func, 8, call_load_memory(func, 8, jit_insn_add(func, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rs), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint), jit_value_create_nint_constant(func, jit_type_uint, offset))))); }
			return(true);
			break;
		}
		case 0x21: {
			/* LH */
			jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
			uint32_t rs = ((inst) >> (0x15)) & (0x1f);
			uint32_t rt = ((inst) >> (0x10)) & (0x1f);
			uint32_t imm = (inst) & (0xffff);
			uint32_t offset = signext(0x10, imm);
			if((rt) != (0x0)) { jit_insn_store_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, call_signext(func, 16, call_load_memory(func, 16, jit_insn_add(func, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rs), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint), jit_value_create_nint_constant(func, jit_type_uint, offset))))); }
			return(true);
			break;
		}
		case 0x23: {
			/* LW */
			jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
			uint32_t rs = ((inst) >> (0x15)) & (0x1f);
			uint32_t rt = ((inst) >> (0x10)) & (0x1f);
			uint32_t imm = (inst) & (0xffff);
			uint32_t offset = signext(0x10, imm);
			if((rt) != (0x0)) { jit_insn_store_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, call_load_memory(func, 32, jit_insn_add(func, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rs), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint), jit_value_create_nint_constant(func, jit_type_uint, offset)))); }
			return(true);
			break;
		}
		case 0x24: {
			/* LBU */
			jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
			uint32_t rs = ((inst) >> (0x15)) & (0x1f);
			uint32_t rt = ((inst) >> (0x10)) & (0x1f);
			uint32_t imm = (inst) & (0xffff);
			uint32_t offset = signext(0x10, imm);
			if((rt) != (0x0)) { jit_insn_store_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, call_load_memory(func, 8, jit_insn_add(func, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rs), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint), jit_value_create_nint_constant(func, jit_type_uint, offset)))); }
			return(true);
			break;
		}
		case 0x25: {
			/* LHU */
			jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
			uint32_t rs = ((inst) >> (0x15)) & (0x1f);
			uint32_t rt = ((inst) >> (0x10)) & (0x1f);
			uint32_t imm = (inst) & (0xffff);
			uint32_t offset = signext(0x10, imm);
			if((rt) != (0x0)) { jit_insn_store_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, call_load_memory(func, 16, jit_insn_add(func, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rs), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint), jit_value_create_nint_constant(func, jit_type_uint, offset)))); }
			return(true);
			break;
		}
		case 0x28: {
			/* SB */
			jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
			uint32_t rs = ((inst) >> (0x15)) & (0x1f);
			uint32_t rt = ((inst) >> (0x10)) & (0x1f);
			uint32_t imm = (inst) & (0xffff);
			uint32_t offset = signext(0x10, imm);
			call_store_memory(func, 8, jit_insn_add(func, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rs), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint), jit_value_create_nint_constant(func, jit_type_uint, offset)), jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint));
			return(true);
			break;
		}
		case 0x29: {
			/* SH */
			jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
			uint32_t rs = ((inst) >> (0x15)) & (0x1f);
			uint32_t rt = ((inst) >> (0x10)) & (0x1f);
			uint32_t imm = (inst) & (0xffff);
			uint32_t offset = signext(0x10, imm);
			call_store_memory(func, 16, jit_insn_add(func, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rs), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint), jit_value_create_nint_constant(func, jit_type_uint, offset)), jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint));
			return(true);
			break;
		}
		case 0x2b: {
			/* SW */
			jit_insn_store_relative(func, state, 32*4, jit_value_create_nint_constant(func, jit_type_uint, pc));
			uint32_t rs = ((inst) >> (0x15)) & (0x1f);
			uint32_t rt = ((inst) >> (0x10)) & (0x1f);
			uint32_t imm = (inst) & (0xffff);
			uint32_t offset = signext(0x10, imm);
			call_store_memory(func, 32, jit_insn_add(func, jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rs), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint), jit_value_create_nint_constant(func, jit_type_uint, offset)), jit_insn_load_relative(func, jit_insn_add(func, state, jit_insn_mul(func, jit_value_create_nint_constant(func, jit_type_uint, rt), jit_value_create_nint_constant(func, jit_type_uint, 4))), 0, jit_type_uint));
			return(true);
			break;
		}
	}
	return false;
}
