from .. import usbhid


profile = {
    "name": "SteelSeries Aerox 5",
    "models": [
        {
            "name": "SteelSeries Aerox 5",
            "vendor_id": 0x1038,
            "product_id": 0x1850,
            "endpoint": 3,
        },
    ],
    "settings": {
        "sensitivity": {
            "label": "Sensibility presets",
            "description": "Set sensitivity preset (DPI)",
            "cli": ["-s", "--sensitivity"],
            "report_type": usbhid.HID_REPORT_TYPE_OUTPUT,
            "command": [0x2D],
            "value_type": "multidpi_range",
            "input_range": [100, 18000, 100],
            "output_range": [0x00, 0xD6, 1.2],
            "dpi_length_byte": 1,
            "first_preset": 0,
            "count_mode": "number",
            "max_preset_count": 5,
            "default": "400, 800, 1200, 2400, 3200",
        },
        "polling_rate": {
            "label": "Polling rate",
            "description": "Set polling rate (Hz)",
            "cli": ["-p", "--polling-rate"],
            "report_type": usbhid.HID_REPORT_TYPE_OUTPUT,
            "command": [0x2B],
            "value_type": "choice",
            "choices": {
                125: 0x04,
                250: 0x03,
                500: 0x02,
                1000: 0x01,
            },
            "default": 1000,
        },
        "z1_color": {
            "label": "Strip top LED color",
            "description": "Set the color of the top LED",
            "cli": ["--top-color", "--z1"],
            "report_type": usbhid.HID_REPORT_TYPE_OUTPUT,
            "command": [0x21, 0x01],
            "value_type": "rgbcolor",
            "default": "red",
        },
        "z2_color": {
            "label": "Strip middle LED color",
            "description": "Set the color of the middle LED",
            "cli": ["--middle-color", "--z2"],
            "report_type": usbhid.HID_REPORT_TYPE_OUTPUT,
            "command": [0x21, 0x02, 0x00, 0x00, 0x00],
            "value_type": "rgbcolor",
            "default": "lime",
        },
        "z3_color": {
            "label": "Strip bottom LED color",
            "description": "Set the color of the bottom LED",
            "cli": ["--bottom-color", "--z3"],
            "report_type": usbhid.HID_REPORT_TYPE_OUTPUT,
            "command": [0x21, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00],
            "value_type": "rgbcolor",
            "default": "blue",
        },
        "reactive_color": {
            "label": "Reactive color",
            "description": "Set the color of the LEDs in reaction to a button click",
            "cli": ["-a", "--reactive-color"],
            "report_type": usbhid.HID_REPORT_TYPE_OUTPUT,
            "command": [0x26],
            "value_type": "reactive_rgbcolor",
            "default": "off",
        },
        "led_brightness": {
            "label": "LED Brightness",
            "description": "Set the brightness of the LEDs",
            "cli": ["-l", "--led-brightness"],
            "report_type": usbhid.HID_REPORT_TYPE_OUTPUT,
            "command": [0x23],
            "value_type": "range",
            "input_range": [0, 100, 1],
            "output_range": [0x00, 0x64, 1],
            "default": 100,
        },
        "rainbow_effect": {
            "label": "rainbow effect",
            "description": "Set the rainbow effect (can be cleared by setting a color)",
            "cli": ["-e", "--rainbow-effect"],
            "report_type": usbhid.HID_REPORT_TYPE_OUTPUT,
            "command": [0x22],
            "value_type": "choice",
            # fmt: off
            "choices": {
                "all":           0b111,
                "bottom":        0b100,
                "middle":        0b010,
                "top":           0b001,
                "bottom-middle": 0b110,
                "middle-top":    0b011,
                "bottom-top":    0b101,
            },
            # fmt: on
            "default": "all",
        },
        "buttons_mapping": {
            "label": "Buttons mapping",
            "description": "Set the mapping of the buttonsX",
            "cli": ["-b", "--buttons"],
            "report_type": usbhid.HID_REPORT_TYPE_OUTPUT,
            "command": [0x2A],
            "value_type": "buttons",
            # fmt: off
            "buttons": {
                "Button1":    {"id": 0x01, "offset": 0x00, "default": "button1"},
                "Button2":    {"id": 0x02, "offset": 0x05, "default": "button2"},
                "Button3":    {"id": 0x03, "offset": 0x0A, "default": "button3"},
                "Button4":    {"id": 0x04, "offset": 0x0F, "default": "button4"},
                "Button5":    {"id": 0x05, "offset": 0x14, "default": "button5"},
                "Button6":    {"id": 0x06, "offset": 0x19, "default": "dpi"},
                "Button7":    {"id": 0x00, "offset": 0x1E, "default": "disabled"},
                "Button8":    {"id": 0x00, "offset": 0x23, "default": "disabled"},
                "Button9":    {"id": 0x00, "offset": 0x28, "default": "disabled"},
                "ScrollUp"  : {"id": 0x31, "offset": 0x2D, "default": "scrollup"},
                "ScrollDown": {"id": 0x32, "offset": 0x32, "default": "scrolldown"},
            },
            "button_field_length": 5,
            "button_disable":     0x00,
            "button_keyboard":    0x51,
            "button_multimedia":  0x61,
            "button_dpi_switch":  0x30,
            "button_scroll_up":   None,
            "button_scroll_down": None,
            # fmt: on
            "default": "buttons(button1=button1; button2=button2; button3=button3; button4=button4; button5=button5; button6=dpi; button7=disabled; button8=disabled; button9=disabled; scrollup=scrollup; scrolldown=scrolldown; layout=qwerty)",
        },
        "default_lighting": {
            "label": "Default lighting",
            "description": "Set default lighting at mouse startup",
            "cli": ["-d", "--default-lighting"],
            "report_type": usbhid.HID_REPORT_TYPE_OUTPUT,
            "command": [0x27],
            "value_type": "choice",
            "choices": {
                "off": [0x00, 0x00],
                "reactive": [0x00, 0x01],
                "rainbow": [0x01, 0x00],
                "reactive-rainbow": [0x01, 0x01],
            },
            "default": "rainbow",
        },
    },
    "save_command": {
        "report_type": usbhid.HID_REPORT_TYPE_OUTPUT,
        "command": [0x11, 0x00],
    },
}
