import pytest

from rivalcfg import udev


class TestCheckUdevRules(object):
    @pytest.fixture
    def rules(self):
        return "# Generated by rivalcfg v42.0.0\nFoo\nBar...\n"

    def test_right_version(self, rules):
        assert udev.are_rules_up_to_date(rules, current_version="42.0.0") is True

    def test_wrong_version(self, rules):
        assert udev.are_rules_up_to_date(rules, current_version="13.37.0") is False


class TestReadWriteUdevRulesFile(object):
    def test_write_and_read_file(self, tmp_path):
        path = tmp_path / "test.rules"
        udev.write_rules_file(path=path)
        assert udev.is_rules_file_up_to_date(path=path) is True
