#include <cstring>

#include "dfKeywords.h"
#include <TFE_System/system.h>

// These strings are taken directly from the Dark Forces EXE.
static const char* c_keywords[] =
{
	"VISIBLE:",
	"SHADED:",
	"LIGHT:",
	"PARENT:",
	"D_X:",
	"D_Y:",
	"D_Z:",
	"D_PITCH:",
	"D_YAW:",
	"D_ROLL:",
	"D_VIEW_PITCH:",
	"D_VIEW_YAW:",
	"D_VIEW_ROLL:",
	"VIEW_PITCH:",
	"VIEW_YAW:",
	"VIEW_ROLL:",
	"TYPE:",
	"LOGIC:",
	"VUE:",
	"VUE_APPEND:",
	"EYE:",
	"BOSS:",
	"UPDATE",
	"EYE_D_XYZ:",
	"EYE_D_PYR:",
	"SYNC:",
	"FRAME_RATE:",
	"START:",
	"STOP_Y:",
	"STOP:",
	"SPEED:",
	"MASTER:",
	"ANGLE:",
	"PAUSE:",
	"ADJOIN:",
	"TEXTURE:",
	"SLAVE:",
	"TRIGGER_ACTION:",
	"CONDITION:",
	"CLIENT:",
	"MESSAGE:",
	"TEXT:",
	"EVENT:",
	"EVENT_MASK:",
	"ENTITY_MASK:",
	"OBJECT_MASK:",
	"CENTER:",
	"KEY",
	"ADDON:",
	"FLAGS:",
	"SOUND:",
	"PAGE:",
	"SOUND",
	"SYSTEM",
	"SAFE",
	"LEVEL",
	"AMB_SOUND:",
	"ELEVATOR",
	"BASIC",
	"BASIC_AUTO",
	"ENCLOSED",
	"INV",
	"MID",
	"DOOR",
	"DOOR_INV",
	"DOOR_MID",
	"MORPH_SPIN1",
	"MORPH_SPIN2",
	"MORPH_MOVE1",
	"MORPH_MOVE2",
	"MOVE_CEILING",
	"MOVE_FLOOR",
	"MOVE_FC",
	"MOVE_OFFSET",
	"MOVE_WALL",
	"ROTATE_WALL",
	"SCROLL_WALL",
	"SCROLL_FLOOR",
	"SCROLL_CEILING",
	"CHANGE_LIGHT",
	"CHANGE_WALL_LIGHT",
	"TRIGGER",
	"SWITCH1",
	"TOGGLE",
	"SINGLE",
	"STANDARD",
	"TELEPORTER",
	"ENTITY_ENTER",
	"SECTOR",
	"LINE",
	"TARGET:",
	"MOVE:",
	"CHUTE",
	"TRIGGER",	// 93 -- repeated for some reason.
	"NEXT_STOP",
	"PREV_STOP",
	"GOTO_STOP",
	"MASTER_ON",
	"MASTER_OFF",
	"DONE",
	"SET_BITS",
	"CLEAR_BITS",
	"COMPLETE",
	"LIGHTS",
	"WAKEUP",
	"NONE",
	"STORM",
	"ENTITY",
	"PLAYER",
	"TROOP",
	"STORM1",
	"INT_DROID",
	"PROBE_DROID",
	"D_TROOP1",
	"D_TROOP2",
	"D_TROOP3",
	"BOBA_FETT",
	"COMMANDO",
	"I_OFFICER",
	"I_OFFICER1",
	"I_OFFICER2",
	"I_OFFICER3",
	"I_OFFICER4",
	"I_OFFICER5",
	"I_OFFICER6",
	"I_OFFICER7",
	"I_OFFICER8",
	"I_OFFICER9",
	"I_OFFICERR",
	"I_OFFICERY",
	"I_OFFICERB",
	"G_GUARD",
	"REE_YEES",
	"REE_YEES2",
	"BOSSK",
	"BARREL",
	"LAND_MINE",
	"KELL",
	"SEWER1",
	"REMOTE",
	"TURRET",
	"MOUSEBOT",
	"WELDER",
	"SCENERY",
	"ANIM",
	"KEY:",
	"GENERATOR",
	"TRUE",
	"FALSE",
	"3D",
	"SPRITE",
	"FRAME",
	"SPIRIT",
	"ITEM",
	"DISPATCH",
	"RADIUS:",
	"HEIGHT:",
	"BATTERY",
	"BLUE",
	"CANNON",
	"CLEATS",
	"CODE1",
	"CODE2",
	"CODE3",
	"CODE4",
	"CODE5",
	"CODE6",
	"CODE7",
	"CODE8",
	"CODE9",
	"CONCUSSION",
	"DETONATOR",
	"DETONATORS",
	"DT_WEAPON",
	"DATATAPE",
	"ENERGY",
	"FUSION",
	"GOGGLES",
	"MASK",
	"MINE",
	"MINES",
	"MISSILE",
	"MISSILES",
	"MORTAR",
	"NAVA",
	"PHRIK",
	"PLANS",
	"PLASMA",
	"POWER",
	"RED",
	"RIFLE",
	"SHELL",
	"SHELLS",
	"SHIELD",
	"INVINCIBLE",
	"REVIVE",
	"SUPERCHARGE",
	"LIFE",
	"MEDKIT",
	"PILE",
	"YELLOW",
	"AUTOGUN",
	"DELAY:",
	"INTERVAL:",
	"MAX_ALIVE:",
	"MIN_DIST:",
	"MAX_DIST:",
	"NUM_TERMINATE:",
	"WANDER_TIME:",
	"PLUGIN:",
	"THINKER",
	"FOLLOW",
	"FOLLOW_Y",
	"RANDOM_YAW",
	"MOVER",
	"SHAKER",
	"PERSONALITY",
	"SEQEND",
	"M_TRIGGER",
	// TFE
	"SCRIPTCALL:",
};

#define KEYWORD_COUNT TFE_ARRAYSIZE(c_keywords)

KEYWORD getKeywordIndex(const char* keywordString)
{
	s32 result = -1;
	for (s32 i = 0; i < KEYWORD_COUNT; i++)
	{
		const char* keyword = c_keywords[i];
		if (toupper(keywordString[0]) == keyword[0])
		{
			if (!strcasecmp(keywordString, keyword))
			{
				result = i;
				break;
			}
		}
	}
	return KEYWORD(result);
}
