#pragma once
#include <TFE_System/types.h>

namespace TFE_Audio
{
#pragma pack(push)
#pragma pack(1)
	struct TimbreBankOp
	{
		u8 waveEnable;
		u8 level;
		u8 attackDelay;
		u8 sustainRelease;
		u8 waveSelect;
	};
	struct TimbreBank
	{
		union
		{
			struct
			{
				TimbreBankOp op1;
				TimbreBankOp op2;
				u8 feedback;
				u8 centerLevel;
			};
			u8 data[12];
		};
	};
#pragma pack(pop)

	struct fmVelocityAdjust
	{
		s32 offset;
		s32 div;
		s32 mask;
	};
		
	static s32 s_fmFreqIndexToPitch[192] =
	{
		0x0102, 0x0102, 0x0103, 0x0104, 0x0105, 0x0106,	0x0107, 0x0108, 0x0109, 0x010A,	0x010B, 0x010C, 0x010D, 0x010E,	0x010F, 0x0110,
		0x0111, 0x0112,	0x0113, 0x0114, 0x0115, 0x0116,	0x0117, 0x0118, 0x0119, 0x011A,	0x011B, 0x011C, 0x011D, 0x011E,	0x011F, 0x0120,
		0x0121, 0x0122, 0x0123, 0x0124, 0x0125, 0x0126, 0x0127, 0x0129, 0x012A, 0x012B, 0x012C, 0x012D, 0x012E, 0x012F, 0x0130, 0x0131,
		0x0132, 0x0133, 0x0135, 0x0136, 0x0137, 0x0138, 0x0139, 0x013A, 0x013B, 0x013C, 0x013E, 0x013F, 0x0140, 0x0141, 0x0142, 0x0143,
		0x0144, 0x0146, 0x0147, 0x0148, 0x0149, 0x014A, 0x014C, 0x014D, 0x014E, 0x014F, 0x0151, 0x0152, 0x0153, 0x0154, 0x0155, 0x0157,
		0x0158, 0x0159, 0x015A, 0x015C, 0x015D, 0x015E, 0x015F, 0x0161, 0x0162, 0x0163, 0x0165, 0x0166, 0x0167, 0x0168, 0x016A, 0x016B,
		0x016C, 0x016E, 0x016F, 0x0170, 0x0172, 0x0173, 0x0174, 0x0176, 0x0177, 0x0178, 0x017A, 0x017B, 0x017D, 0x017E, 0x017F, 0x0181,
		0x0182, 0x0183, 0x0185, 0x0186, 0x0188, 0x0189, 0x018B, 0x018C, 0x018D, 0x018F, 0x0190, 0x0192, 0x0193, 0x0195, 0x0196, 0x0198,
		0x0199, 0x019B, 0x019C, 0x019E, 0x019F, 0x01A1, 0x01A2, 0x01A4, 0x01A5, 0x01A7, 0x01A8, 0x01AA, 0x01AB, 0x01AD, 0x01AE, 0x01B0,
		0x01B1, 0x01B3, 0x01B5, 0x01B6, 0x01B8, 0x01B9, 0x01BB, 0x01BD, 0x01BE, 0x01C0, 0x01C1, 0x01C3, 0x01C5, 0x01C6, 0x01C8, 0x01CA,
		0x01CB, 0x01CD, 0x01CF, 0x01D0, 0x01D2, 0x01D4, 0x01D5, 0x01D7, 0x01D9, 0x01DA, 0x01DC, 0x01DE, 0x01E0, 0x01E1, 0x01E3, 0x01E5,
		0x01E6, 0x01E8, 0x01EA, 0x01EC, 0x01EE, 0x01EF, 0x01F1, 0x01F3, 0x01F5, 0x01F7, 0x01F8, 0x01FA, 0x01FC, 0x01FE, 0x0200, 0x0202
	};
	static s32 s_fmVelocityToVolumeMapping[64] =
	{
		0x00, 0x04, 0x07, 0x0b, 0x0d, 0x10, 0x12, 0x14, 0x16, 0x18, 0x1a, 0x1b, 0x1d, 0x1e, 0x1f, 0x21,
		0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2c, 0x2d, 0x2e, 0x2f, 0x2f,
		0x30, 0x31, 0x31, 0x32, 0x33, 0x33, 0x34, 0x35, 0x35, 0x36, 0x36, 0x37, 0x37, 0x38, 0x38, 0x39,
		0x39, 0x3a, 0x3a, 0x3b, 0x3b, 0x3c, 0x3c, 0x3c, 0x3d, 0x3d, 0x3e, 0x3e, 0x3f, 0x3f, 0x3f, 0x3f
	};
	static u8 s_fmKeyPitchToFreqIndex[128] =
	{
		0x00, 0x10, 0x20, 0x30, 0x40, 0x50, 0x60, 0x70, 0x80, 0x90, 0xA0, 0xB0, 0x00, 0x10, 0x20, 0x30,
		0x40, 0x50, 0x60, 0x70, 0x80, 0x90, 0xA0, 0xB0, 0x00, 0x10, 0x20, 0x30, 0x40, 0x50, 0x60, 0x70,
		0x80, 0x90, 0xA0, 0xB0, 0x00, 0x10, 0x20, 0x30, 0x40, 0x50, 0x60, 0x70, 0x80, 0x90, 0xA0, 0xB0,
		0x00, 0x10, 0x20, 0x30, 0x40, 0x50, 0x60, 0x70, 0x80, 0x90, 0xA0, 0xB0, 0x00, 0x10, 0x20, 0x30,
		0x40, 0x50, 0x60, 0x70, 0x80, 0x90, 0xA0, 0xB0, 0x00, 0x10, 0x20, 0x30, 0x40, 0x50, 0x60, 0x70,
		0x80, 0x90, 0xA0, 0xB0, 0x00, 0x10, 0x20, 0x30, 0x40, 0x50, 0x60, 0x70, 0x80, 0x90, 0xA0, 0xB0,
		0x00, 0x10, 0x20, 0x30, 0x40, 0x50, 0x60, 0x70, 0x80, 0x90, 0xA0, 0xB0, 0x00, 0x10, 0x20, 0x30,
		0x40, 0x50, 0x60, 0x70, 0x80, 0x90, 0xA0, 0xB0, 0x00, 0x10, 0x20, 0x30, 0x40, 0x50, 0x60, 0x70
	};
	static u8 s_fmKeyPitchHi[128] =
	{
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
		0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
		0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x04, 0x04, 0x04, 0x04,
		0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
		0x05, 0x05, 0x05, 0x05, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
		0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
		0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
	};
	static u8 s_fmKeyToDrumTimbre[128] =
	{
		0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
		0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
		0xFF, 0xFF, 0xFF, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C,
		0x0D, 0x0E, 0x0F, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0xFF, 0xFF, 0x17, 0x18, 0x19, 0x1A,
		0x1B, 0x1C, 0x1D, 0x1E, 0x1F, 0x20, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x21, 0x22, 0x23, 0xFF, 0xFF,
		0x24, 0x25, 0xFF, 0xFF, 0xFF, 0x26, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
		0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
		0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	};

	static s32 s_fmVoiceOperators[2][9] =
	{
		{ 0x00, 0x01, 0x02, 0x08, 0x09, 0x0a, 0x10, 0x11, 0x12 },
		{ 0x03, 0x04, 0x05, 0x0b, 0x0c, 0x0d, 0x13, 0x14, 0x15 }
	};
		
	static fmVelocityAdjust s_fmBankAdjust[28] =
	{
		{ 0x06, 0x00, 0x3F },
		{ 0x09, 0x03, 0xF8 },
		{ 0x06, 0x06, 0xC0 },
		{ 0x05, 0x00, 0x0F },
		{ 0x07, 0x04, 0xF0 },
		{ 0x07, 0x00, 0x0F },
		{ 0x08, 0x04, 0xF0 },
		{ 0x08, 0x00, 0x0F },
		{ 0x09, 0x00, 0x07 },
		{ 0x05, 0x07, 0x80 },
		{ 0x05, 0x06, 0x40 },
		{ 0x05, 0x05, 0x20 },
		{ 0x05, 0x04, 0x10 },
		{ 0x01, 0x00, 0x3F },
		{ 0x04, 0x03, 0xF8 },
		{ 0x01, 0x06, 0xC0 },
		{ 0x00, 0x00, 0x0F },
		{ 0x02, 0x04, 0xF0 },
		{ 0x02, 0x00, 0x0F },
		{ 0x03, 0x04, 0xF0 },
		{ 0x03, 0x00, 0x0F },
		{ 0x04, 0x00, 0x07 },
		{ 0x00, 0x07, 0x80 },
		{ 0x00, 0x06, 0x40 },
		{ 0x00, 0x05, 0x20 },
		{ 0x00, 0x04, 0x10 },
		{ 0x0A, 0x00, 0x01 },
		{ 0x0A, 0x01, 0x0E }
	};

	static TimbreBank s_timbreBanksRight[167] =
	{
		{ /*op1*/0x12, 0xA3, 0x00, 0xCD, 0x30, /*op2*/0x12, 0x8E, 0x4E, 0x8A, 0xF8, /*shared*/0x0E, 0x23 },
		{ /*op1*/0x22, 0x53, 0x0E, 0x8A, 0x60, /*op2*/0x14, 0x06, 0x1D, 0x7A, 0xB8, /*shared*/0x06, 0x00 },
		{ /*op1*/0x06, 0x04, 0x1C, 0x79, 0x90, /*op2*/0x02, 0x00, 0x4C, 0x79, 0xB0, /*shared*/0x0A, 0x00 },
		{ /*op1*/0xC2, 0x8E, 0x0C, 0x89, 0x92, /*op2*/0xC2, 0x16, 0x0C, 0x49, 0xF9, /*shared*/0x08, 0x23 },
		{ /*op1*/0xC2, 0x19, 0x0D, 0x6A, 0x48, /*op2*/0xC4, 0x16, 0x4D, 0x69, 0xF8, /*shared*/0x04, 0x00 },
		{ /*op1*/0x06, 0x1E, 0x1C, 0x99, 0x00, /*op2*/0x02, 0x0C, 0x4C, 0x79, 0xF8, /*shared*/0x0C, 0x00 },
		{ /*op1*/0x84, 0x4E, 0x3B, 0x5A, 0xB3, /*op2*/0x81, 0x0E, 0x3C, 0x5A, 0xFB, /*shared*/0x0F, 0x00 },
		{ /*op1*/0xC6, 0x01, 0x2D, 0xA7, 0x91, /*op2*/0xC2, 0x06, 0x0C, 0x7A, 0xF1, /*shared*/0x06, 0x00 },
		{ /*op1*/0x8C, 0x80, 0x05, 0xEA, 0xB1, /*op2*/0x82, 0x0A, 0x3C, 0xAA, 0xC8, /*shared*/0x07, 0x00 },
		{ /*op1*/0x85, 0x40, 0x0D, 0xEC, 0xE1, /*op2*/0x84, 0x58, 0x3E, 0xCB, 0xF8, /*shared*/0x01, 0x00 },
		{ /*op1*/0x8A, 0x80, 0x0B, 0xDC, 0xB0, /*op2*/0x84, 0x58, 0x3D, 0xEA, 0xF8, /*shared*/0x01, 0x00 }, // 10
		{ /*op1*/0xCB, 0x50, 0x0A, 0xDD, 0x48, /*op2*/0x82, 0x8E, 0x0C, 0x79, 0xE0, /*shared*/0x0E, 0x1B },
		{ /*op1*/0x2A, 0x0E, 0x17, 0x89, 0x50, /*op2*/0x22, 0x0C, 0x1B, 0x09, 0xE0, /*shared*/0x0A, 0x00 },
		{ /*op1*/0xE7, 0x9B, 0x08, 0x08, 0x4A, /*op2*/0xE2, 0x06, 0x0A, 0x08, 0xE0, /*shared*/0x0A, 0x00 },
		{ /*op1*/0xC5, 0x1A, 0x0F, 0x0D, 0x10, /*op2*/0x84, 0x0A, 0x00, 0xEC, 0xB8, /*shared*/0x04, 0x00 },
		{ /*op1*/0x75, 0x00, 0x0E, 0xCB, 0xB2, /*op2*/0xE2, 0x1E, 0x0A, 0xC9, 0xF9, /*shared*/0x0A, 0x10 },
		{ /*op1*/0xE1, 0x1B, 0x38, 0xD9, 0xD8, /*op2*/0xE4, 0x9E, 0x4A, 0xD9, 0xFA, /*shared*/0x09, 0x00 },
		{ /*op1*/0x06, 0x5B, 0x0B, 0xE7, 0xF8, /*op2*/0xE1, 0xA5, 0x1C, 0xF9, 0xF9, /*shared*/0x07, 0x00 },
		{ /*op1*/0xE2, 0x13, 0x0C, 0xF7, 0xF9, /*op2*/0xE3, 0x5B, 0x4F, 0xC7, 0xFA, /*shared*/0x05, 0x00 },
		{ /*op1*/0x01, 0x8C, 0x9F, 0xDA, 0xE0, /*op2*/0xE4, 0x50, 0x9F, 0xDA, 0xD2, /*shared*/0x09, 0x00 },
		{ /*op1*/0x06, 0x48, 0x7D, 0xAA, 0x81, /*op2*/0xE2, 0x1E, 0x4F, 0xA9, 0xFA, /*shared*/0x0C, 0x00 }, // 20
		{ /*op1*/0xE5, 0x4B, 0x8D, 0xB8, 0x82, /*op2*/0xA2, 0x0F, 0x3F, 0xC7, 0xC1, /*shared*/0x0C, 0x00 },
		{ /*op1*/0xF2, 0x2A, 0x9F, 0xDB, 0x01, /*op2*/0xE1, 0x04, 0x8F, 0xD7, 0xC2, /*shared*/0x0A, 0x00 },
		{ /*op1*/0xE4, 0x88, 0x9C, 0x50, 0xC8, /*op2*/0xE2, 0x18, 0x70, 0xC4, 0xF8, /*shared*/0x0B, 0x00 },
		{ /*op1*/0x02, 0x88, 0x09, 0xA7, 0x80, /*op2*/0xC1, 0x1C, 0x3D, 0x88, 0xFA, /*shared*/0x02, 0x18 },
		{ /*op1*/0x42, 0x55, 0x3E, 0x8C, 0x48, /*op2*/0xC4, 0x0B, 0x0D, 0xA9, 0xE1, /*shared*/0x04, 0x18 },
		{ /*op1*/0xC2, 0x00, 0x2B, 0x17, 0xA1, /*op2*/0xC2, 0x1E, 0x4D, 0x97, 0xF8, /*shared*/0x00, 0x19 },
		{ /*op1*/0xC6, 0x01, 0x2D, 0x77, 0x90, /*op2*/0xC2, 0x06, 0x0E, 0x97, 0xF1, /*shared*/0x06, 0x00 },
		{ /*op1*/0xC2, 0x0C, 0x06, 0x06, 0xA9, /*op2*/0xC2, 0x3F, 0x09, 0x86, 0xF9, /*shared*/0x0A, 0x0A },
		{ /*op1*/0xE2, 0x32, 0x6D, 0x9A, 0x00, /*op2*/0xE4, 0x20, 0x0E, 0x98, 0xF9, /*shared*/0x0A, 0x00 },
		{ /*op1*/0xE2, 0x30, 0x7F, 0xAA, 0x01, /*op2*/0xE4, 0x17, 0x5D, 0x78, 0xFB, /*shared*/0x08, 0x00 }, // 30
		{ /*op1*/0xC4, 0x29, 0x4F, 0xCA, 0x03, /*op2*/0xC8, 0x0D, 0x0C, 0xB7, 0xF9, /*shared*/0x00, 0x0B },
		{ /*op1*/0xC2, 0x40, 0x3C, 0x96, 0xB0, /*op2*/0xC4, 0xDE, 0x0E, 0xC7, 0xF8, /*shared*/0x00, 0x20 },
		{ /*op1*/0x32, 0x13, 0x2D, 0xD9, 0x78, /*op2*/0xE2, 0x18, 0x2E, 0xB8, 0xF8, /*shared*/0x08, 0x00 },
		{ /*op1*/0xE2, 0x8E, 0x0A, 0xE9, 0x98, /*op2*/0xE4, 0x18, 0x5E, 0xB8, 0xF8, /*shared*/0x06, 0x28 },
		{ /*op1*/0xF2, 0x0A, 0x0D, 0xD7, 0x80, /*op2*/0xE4, 0x1F, 0x5E, 0xB8, 0xF8, /*shared*/0x0A, 0x00 },
		{ /*op1*/0xF2, 0x09, 0x4B, 0xD6, 0x90, /*op2*/0xE4, 0x1F, 0x1C, 0xB8, 0xF8, /*shared*/0x0A, 0x28 },
		{ /*op1*/0x62, 0x11, 0x0C, 0xE6, 0x78, /*op2*/0xE4, 0x1F, 0x0C, 0xC8, 0xF8, /*shared*/0x0A, 0x00 },
		{ /*op1*/0xC2, 0x31, 0x59, 0xD9, 0x11, /*op2*/0xC2, 0x1A, 0x7C, 0xB8, 0xF8, /*shared*/0x0C, 0x00 },
		{ /*op1*/0xE2, 0xEA, 0x8D, 0x66, 0x20, /*op2*/0xE2, 0x1F, 0x0E, 0x68, 0xF8, /*shared*/0x08, 0x00 },
		{ /*op1*/0xA2, 0x40, 0x5D, 0xBA, 0x7B, /*op2*/0xE2, 0x00, 0x8F, 0xD8, 0xF1, /*shared*/0x00, 0x00 }, // 40
		{ /*op1*/0xE2, 0x40, 0x3D, 0xDA, 0x73, /*op2*/0xE1, 0x00, 0x7E, 0xD8, 0xF2, /*shared*/0x04, 0x00 },
		{ /*op1*/0x62, 0x00, 0x6D, 0xFA, 0xB9, /*op2*/0xE2, 0x00, 0x8F, 0xC8, 0xF1, /*shared*/0x04, 0x00 },
		{ /*op1*/0xE1, 0x00, 0x4E, 0xDB, 0x92, /*op2*/0xE3, 0x18, 0x6F, 0xE9, 0xFA, /*shared*/0x00, 0x00 },
		{ /*op1*/0x62, 0xA0, 0x7D, 0xCD, 0x19, /*op2*/0x62, 0x91, 0x9E, 0xE7, 0x80, /*shared*/0x00, 0x00 },
		{ /*op1*/0xD2, 0xA2, 0x8A, 0x8A, 0x31, /*op2*/0xD2, 0x0C, 0x0A, 0xCA, 0xF8, /*shared*/0x08, 0x04 },
		{ /*op1*/0x12, 0x56, 0x2A, 0xCC, 0x3A, /*op2*/0x12, 0x90, 0x7D, 0xCC, 0xF8, /*shared*/0x0E, 0x03 },
		{ /*op1*/0x00, 0xBC, 0x17, 0xAB, 0x12, /*op2*/0x03, 0xC9, 0x5B, 0xBA, 0xF8, /*shared*/0x06, 0x04 },
		{ /*op1*/0x22, 0x9F, 0x7D, 0xCD, 0x21, /*op2*/0x62, 0x8B, 0x9E, 0xE7, 0xF8, /*shared*/0x0C, 0x00 },
		{ /*op1*/0x62, 0x9E, 0x7D, 0xCD, 0x19, /*op2*/0x62, 0x96, 0x9E, 0xE7, 0x80, /*shared*/0x00, 0x00 },
		{ /*op1*/0xE2, 0x45, 0x7F, 0xFB, 0xA0, /*op2*/0xF2, 0x04, 0x9F, 0xFB, 0xF9, /*shared*/0x0A, 0x00 }, // 50
		{ /*op1*/0xE4, 0xA0, 0xCE, 0x5B, 0x02, /*op2*/0xE2, 0x32, 0x7F, 0xFB, 0x79, /*shared*/0x04, 0x00 },
		{ /*op1*/0xE4, 0x99, 0xAC, 0xC9, 0x21, /*op2*/0xE2, 0x9E, 0x9D, 0xE9, 0xF8, /*shared*/0x00, 0x00 },
		{ /*op1*/0xEA, 0xA0, 0xAC, 0x67, 0x02, /*op2*/0xE2, 0x00, 0x7C, 0x7A, 0xF8, /*shared*/0x06, 0x00 },
		{ /*op1*/0xE7, 0x94, 0xAD, 0xB7, 0x03, /*op2*/0xE2, 0x00, 0x7C, 0xBA, 0xF8, /*shared*/0x00, 0x00 },
		{ /*op1*/0xC3, 0x3F, 0x4B, 0xE9, 0xFA, /*op2*/0xC1, 0x3F, 0x9B, 0xF9, 0xFB, /*shared*/0x0B, 0x06 },
		{ /*op1*/0x22, 0x1C, 0x8D, 0xE9, 0x10, /*op2*/0x32, 0x08, 0xAE, 0xD9, 0xF8, /*shared*/0x0E, 0x00 },
		{ /*op1*/0x22, 0x9E, 0x8D, 0xEC, 0x10, /*op2*/0x34, 0x89, 0xAD, 0xD8, 0xF8, /*shared*/0x0E, 0x00 },
		{ /*op1*/0xF2, 0x00, 0xAF, 0x88, 0xB0, /*op2*/0xF2, 0x54, 0x6E, 0xC9, 0xF8, /*shared*/0x0A, 0x00 },
		{ /*op1*/0xF2, 0x2A, 0x9F, 0x98, 0x01, /*op2*/0xE2, 0x84, 0x4E, 0x78, 0xD8, /*shared*/0x0E, 0x00 },
		{ /*op1*/0x22, 0x9C, 0x9D, 0xEA, 0x10, /*op2*/0x22, 0x07, 0x9C, 0xE8, 0xF8, /*shared*/0x0E, 0x00 }, // 60
		{ /*op1*/0xE2, 0x2A, 0x7F, 0xB8, 0x01, /*op2*/0xE4, 0x00, 0x0D, 0xC5, 0xF8, /*shared*/0x0C, 0x00 },
		{ /*op1*/0xE4, 0x28, 0x8E, 0xE8, 0x01, /*op2*/0xF2, 0x00, 0x4D, 0xD6, 0xF9, /*shared*/0x0C, 0x00 },
		{ /*op1*/0xB2, 0x93, 0xAE, 0xAA, 0x49, /*op2*/0xB2, 0x0F, 0xAE, 0xE9, 0xF8, /*shared*/0x0E, 0x00 },
		{ /*op1*/0xE2, 0x6B, 0x6E, 0x99, 0x01, /*op2*/0xE2, 0x1F, 0x8D, 0xC8, 0xFA, /*shared*/0x08, 0x00 },
		{ /*op1*/0xE2, 0x2E, 0x20, 0xD9, 0x01, /*op2*/0xF2, 0x0F, 0x90, 0xF8, 0xF0, /*shared*/0x0E, 0x00 },
		{ /*op1*/0xE4, 0x28, 0x7E, 0xF8, 0x01, /*op2*/0xE2, 0x23, 0x8E, 0xE8, 0xF9, /*shared*/0x08, 0x00 },
		{ /*op1*/0xB8, 0x28, 0x9E, 0x98, 0x01, /*op2*/0x62, 0x00, 0x3D, 0xC8, 0xF9, /*shared*/0x08, 0x00 },
		{ /*op1*/0x62, 0x11, 0x8E, 0xC9, 0x49, /*op2*/0xE3, 0x15, 0x7E, 0xD8, 0xFA, /*shared*/0x0A, 0x00 },
		{ /*op1*/0xE2, 0x04, 0x7F, 0xFE, 0x80, /*op2*/0xE6, 0x98, 0x8F, 0xF9, 0xF9, /*shared*/0x08, 0x00 },
		{ /*op1*/0xE2, 0x16, 0x7D, 0xDA, 0x51, /*op2*/0xEA, 0x1E, 0x8D, 0xD8, 0xF9, /*shared*/0x06, 0x00 }, // 70
		{ /*op1*/0xA4, 0x96, 0x9D, 0xD9, 0x40, /*op2*/0xA2, 0x8C, 0x9E, 0xE8, 0xF8, /*shared*/0x0C, 0x00 },
		{ /*op1*/0xF2, 0x93, 0x64, 0xC9, 0x90, /*op2*/0xE2, 0x1E, 0x7E, 0xC8, 0xF8, /*shared*/0x04, 0x00 },
		{ /*op1*/0xB2, 0x65, 0x6D, 0xE9, 0x10, /*op2*/0xA2, 0x07, 0x9D, 0xE8, 0xF8, /*shared*/0x08, 0x00 },
		{ /*op1*/0xE4, 0x00, 0x77, 0xC5, 0xA8, /*op2*/0xE2, 0x00, 0x9E, 0xD7, 0xE0, /*shared*/0x06, 0x00 },
		{ /*op1*/0xE4, 0x80, 0x86, 0xB9, 0xC8, /*op2*/0xE2, 0x05, 0x9F, 0xD7, 0xF0, /*shared*/0x0A, 0x00 },
		{ /*op1*/0xE2, 0x00, 0x68, 0x68, 0xAA, /*op2*/0xE2, 0x08, 0x9B, 0xB3, 0xF8, /*shared*/0x08, 0x00 },
		{ /*op1*/0xE4, 0x00, 0xA6, 0x87, 0x81, /*op2*/0xE2, 0x0A, 0x7E, 0xC9, 0xF8, /*shared*/0x06, 0x00 },
		{ /*op1*/0xE4, 0x80, 0x9A, 0xB8, 0x90, /*op2*/0xE2, 0x00, 0x9E, 0xF9, 0xC0, /*shared*/0x09, 0x00 },
		{ /*op1*/0xE2, 0x80, 0x8E, 0x64, 0xD0, /*op2*/0xE2, 0x28, 0x6F, 0x73, 0xF8, /*shared*/0x01, 0x00 },
		{ /*op1*/0xE8, 0x00, 0x4D, 0x99, 0xA8, /*op2*/0xE6, 0x80, 0x00, 0xF8, 0xF8, /*shared*/0x0C, 0x00 }, // 80
		{ /*op1*/0xE3, 0x0C, 0x4F, 0xB9, 0xC3, /*op2*/0xE2, 0x15, 0x0F, 0xC8, 0xF9, /*shared*/0x06, 0x00 },
		{ /*op1*/0xE4, 0x00, 0x09, 0x68, 0x92, /*op2*/0xE2, 0x2B, 0x9E, 0xF3, 0xF8, /*shared*/0x0E, 0x00 },
		{ /*op1*/0xE1, 0x0A, 0x9F, 0xCA, 0xB2, /*op2*/0xE2, 0x25, 0x0E, 0x89, 0xF8, /*shared*/0x06, 0x00 },
		{ /*op1*/0xE1, 0x06, 0x7F, 0xD1, 0xC2, /*op2*/0xE6, 0x1F, 0x3F, 0xD0, 0xF9, /*shared*/0x06, 0x00 },
		{ /*op1*/0xE5, 0x5E, 0xAE, 0xBB, 0x03, /*op2*/0xE2, 0x1C, 0x2E, 0xD9, 0xF9, /*shared*/0x06, 0x00 },
		{ /*op1*/0xF3, 0x29, 0x7F, 0xD7, 0xF9, /*op2*/0xF1, 0x21, 0x3F, 0xD7, 0xFA, /*shared*/0x0B, 0x00 },
		{ /*op1*/0xE2, 0x68, 0x2E, 0xCB, 0x30, /*op2*/0xE4, 0x3C, 0x5F, 0xEA, 0x78, /*shared*/0x08, 0x00 },
		{ /*op1*/0x28, 0x49, 0x0C, 0xCB, 0x40, /*op2*/0xE2, 0x11, 0x5B, 0xD9, 0x48, /*shared*/0x05, 0x00 },
		{ /*op1*/0xE2, 0x02, 0xDE, 0xAB, 0x90, /*op2*/0xE2, 0x5E, 0xCF, 0xBA, 0xF9, /*shared*/0x04, 0x00 },
		{ /*op1*/0xE2, 0x26, 0x7D, 0xCB, 0x31, /*op2*/0xE2, 0x1E, 0x0E, 0xB9, 0xF8, /*shared*/0x0A, 0x00 }, // 90
		{ /*op1*/0xEA, 0x0C, 0xAD, 0xAB, 0x61, /*op2*/0xE2, 0x16, 0x7E, 0xBA, 0xF8, /*shared*/0x0A, 0x00 },
		{ /*op1*/0xEB, 0x80, 0x8C, 0xCB, 0x72, /*op2*/0xE2, 0x06, 0x9F, 0xCA, 0xF8, /*shared*/0x08, 0x00 },
		{ /*op1*/0xE6, 0x9C, 0xCD, 0xBB, 0x31, /*op2*/0xE1, 0x5F, 0x4E, 0xCA, 0xFA, /*shared*/0x0A, 0x00 },
		{ /*op1*/0xEA, 0x89, 0x9D, 0xAB, 0x82, /*op2*/0xE2, 0x1E, 0x9F, 0xBA, 0xF8, /*shared*/0x0A, 0x00 },
		{ /*op1*/0x2A, 0x48, 0xED, 0xCA, 0x80, /*op2*/0x22, 0x0C, 0xBF, 0xBA, 0xF9, /*shared*/0x00, 0x00 },
		{ /*op1*/0xEA, 0x40, 0x98, 0xB9, 0x90, /*op2*/0xE2, 0x0A, 0x0E, 0xC8, 0xF8, /*shared*/0x0C, 0x00 },
		{ /*op1*/0xE1, 0x1A, 0xBF, 0xAB, 0xF2, /*op2*/0xE3, 0x5D, 0xCE, 0xAA, 0xF9, /*shared*/0x09, 0x00 },
		{ /*op1*/0xC9, 0x06, 0x0B, 0x0B, 0xA0, /*op2*/0xC2, 0x5E, 0x0C, 0x0A, 0xF8, /*shared*/0x0C, 0x1C },
		{ /*op1*/0x64, 0x1C, 0x39, 0xBA, 0x10, /*op2*/0x62, 0x4C, 0x5C, 0xDA, 0xF8, /*shared*/0x0E, 0x00 },
		{ /*op1*/0xCC, 0x00, 0x7D, 0xDA, 0x80, /*op2*/0xC2, 0x00, 0x5E, 0x9B, 0xB0, /*shared*/0x0C, 0x00 }, // 100
		{ /*op1*/0xE4, 0xC6, 0xEE, 0xCB, 0x93, /*op2*/0xE2, 0x16, 0xDE, 0xDA, 0xF8, /*shared*/0x08, 0x00 },
		{ /*op1*/0xDA, 0x00, 0x8F, 0xAC, 0xA2, /*op2*/0xE2, 0x1E, 0x8D, 0x8A, 0xF9, /*shared*/0x02, 0x00 },
		{ /*op1*/0x62, 0x88, 0x6C, 0x7C, 0x80, /*op2*/0xE6, 0x20, 0x0F, 0xDB, 0xF9, /*shared*/0x08, 0x00 },
		{ /*op1*/0xC8, 0x08, 0xBD, 0x5B, 0x8B, /*op2*/0xC2, 0x61, 0x0D, 0xAB, 0xF9, /*shared*/0x08, 0x12 },
		{ /*op1*/0x75, 0x00, 0x0E, 0xCB, 0xB2, /*op2*/0xE2, 0x1E, 0x0A, 0xC9, 0xF9, /*shared*/0x0A, 0x10 },
		{ /*op1*/0x41, 0x00, 0x0E, 0xEA, 0xA3, /*op2*/0xC2, 0x00, 0x08, 0xCA, 0xF8, /*shared*/0x08, 0x07 },
		{ /*op1*/0xC1, 0x40, 0x0C, 0x59, 0xD2, /*op2*/0xC2, 0x80, 0x3C, 0xAB, 0xF8, /*shared*/0x08, 0x0D },
		{ /*op1*/0x4B, 0x00, 0x0A, 0xF5, 0xC1, /*op2*/0xC2, 0x19, 0x0C, 0xE9, 0xF8, /*shared*/0x08, 0x07 },
		{ /*op1*/0x62, 0x00, 0x7F, 0xD8, 0xA8, /*op2*/0xEA, 0x00, 0x8F, 0xD8, 0xF9, /*shared*/0x0A, 0x00 },
		{ /*op1*/0xE1, 0x00, 0x7F, 0xD9, 0xAA, /*op2*/0xE1, 0x00, 0x8F, 0xD8, 0xFA, /*shared*/0x06, 0x00 }, // 110
		{ /*op1*/0xE1, 0x00, 0x7F, 0xD9, 0xAA, /*op2*/0xE1, 0x00, 0x8F, 0xD8, 0xFA, /*shared*/0x06, 0x00 },
		{ /*op1*/0xCF, 0x40, 0x09, 0xEA, 0xA8, /*op2*/0xC4, 0x00, 0x0C, 0xDB, 0xC8, /*shared*/0x08, 0x02 },
		{ /*op1*/0xCF, 0x40, 0x0C, 0xAA, 0xA8, /*op2*/0xC4, 0x00, 0x18, 0xF9, 0xC8, /*shared*/0x0C, 0x02 },
		{ /*op1*/0xC9, 0x0E, 0x88, 0xD9, 0x7A, /*op2*/0xC2, 0x08, 0x1A, 0xEA, 0xD8, /*shared*/0x0C, 0x05 },
		{ /*op1*/0x03, 0x00, 0x15, 0x00, 0xC8, /*op2*/0x02, 0x00, 0x08, 0x00, 0xF8, /*shared*/0x09, 0x02 },
		{ /*op1*/0x01, 0x00, 0x47, 0xD7, 0xD8, /*op2*/0x01, 0x3F, 0x0C, 0xFB, 0xF8, /*shared*/0x0A, 0x04 },
		{ /*op1*/0x00, 0x00, 0x36, 0x67, 0xF8, /*op2*/0x01, 0x3F, 0x0E, 0xFA, 0xF8, /*shared*/0x00, 0x05 },
		{ /*op1*/0x02, 0x00, 0x36, 0x68, 0xF8, /*op2*/0x01, 0x3F, 0x0E, 0xFA, 0xF8, /*shared*/0x00, 0x05 },
		{ /*op1*/0xCB, 0x00, 0xAF, 0x00, 0xFA, /*op2*/0xC0, 0x00, 0xC0, 0x06, 0xFB, /*shared*/0x0E, 0x0F },
		{ /*op1*/0x05, 0x0D, 0x80, 0xA6, 0xFB, /*op2*/0x0B, 0x38, 0xA9, 0xD8, 0x00, /*shared*/0x0E, 0x04 }, // 120
		{ /*op1*/0x0F, 0x00, 0x90, 0xFA, 0xD0, /*op2*/0x06, 0x00, 0xA7, 0x39, 0xA8, /*shared*/0x0E, 0x06 },
		{ /*op1*/0xC9, 0x15, 0xDD, 0xFF, 0xF8, /*op2*/0x00, 0x00, 0xE7, 0xFC, 0xD8, /*shared*/0x0E, 0x38 },
		{ /*op1*/0x48, 0x3C, 0x30, 0xF6, 0x03, /*op2*/0x0A, 0x38, 0x97, 0xE8, 0x00, /*shared*/0x0E, 0x04 },
		{ /*op1*/0x07, 0x80, 0x0B, 0xC8, 0xC9, /*op2*/0x02, 0x3F, 0x0C, 0xEA, 0xF8, /*shared*/0x0F, 0x05 },
		{ /*op1*/0x00, 0x21, 0x66, 0x40, 0x03, /*op2*/0x00, 0x3F, 0x47, 0x00, 0x00, /*shared*/0x0E, 0x02 },
		{ /*op1*/0x08, 0x00, 0x0B, 0x3C, 0xF8, /*op2*/0x08, 0x3F, 0x06, 0xF3, 0x00, /*shared*/0x0E, 0x02 },
		{ /*op1*/0x00, 0x3F, 0x4C, 0xFB, 0x00, /*op2*/0x00, 0x3F, 0x0A, 0xE9, 0xF8, /*shared*/0x0E, 0x05 },
		{ /*op1*/0x1A, 0x3F, 0x15, 0x05, 0xF8, /*op2*/0x02, 0x21, 0x2B, 0xE4, 0xF8, /*shared*/0x0E, 0x06 },
		{ /*op1*/0x04, 0x3F, 0x42, 0x00, 0x00, /*op2*/0x02, 0x06, 0x1A, 0xE9, 0xE0, /*shared*/0x0E, 0x07 },
		{ /*op1*/0x0A, 0x3F, 0x0B, 0x01, 0xF8, /*op2*/0x1F, 0x1C, 0x46, 0xD0, 0xF8, /*shared*/0x0E, 0x01 }, // 130
		{ /*op1*/0x01, 0x3C, 0x0F, 0xFF, 0x80, /*op2*/0x14, 0x06, 0x68, 0xB9, 0xC0, /*shared*/0x0E, 0x02 },
		{ /*op1*/0x0F, 0x3F, 0x0B, 0x00, 0xF8, /*op2*/0x1F, 0x0F, 0x19, 0xD0, 0xF8, /*shared*/0x0E, 0x02 },
		{ /*op1*/0x01, 0x3C, 0x0F, 0xFF, 0x80, /*op2*/0x14, 0x06, 0x68, 0xB9, 0xC0, /*shared*/0x0E, 0x02 },
		{ /*op1*/0x01, 0x3F, 0x42, 0x85, 0x7A, /*op2*/0x02, 0x0B, 0x0A, 0xD8, 0xF8, /*shared*/0x0A, 0x03 },
		{ /*op1*/0xCF, 0x7F, 0x08, 0xFF, 0xFA, /*op2*/0x00, 0xC7, 0x2D, 0xF7, 0xE3, /*shared*/0x0E, 0x02 },
		{ /*op1*/0x01, 0x3F, 0x42, 0x85, 0x7A, /*op2*/0x02, 0x0B, 0x0A, 0xD8, 0xF8, /*shared*/0x0A, 0x03 },
		{ /*op1*/0xCF, 0x7F, 0x08, 0xCF, 0xFA, /*op2*/0x00, 0x45, 0x2A, 0xF8, 0x93, /*shared*/0x0E, 0x0C },
		{ /*op1*/0x01, 0x3F, 0x42, 0x85, 0x7A, /*op2*/0x02, 0x0B, 0x0A, 0xD8, 0xF8, /*shared*/0x0A, 0x03 },
		{ /*op1*/0xCF, 0x7F, 0x08, 0xCD, 0xFA, /*op2*/0x00, 0x40, 0x1A, 0x69, 0xC3, /*shared*/0x0E, 0x0C },
		{ /*op1*/0x01, 0x3F, 0x42, 0x85, 0x7A, /*op2*/0x02, 0x0B, 0x0A, 0xD8, 0xF8, /*shared*/0x0A, 0x03 }, // 140
		{ /*op1*/0x01, 0x3F, 0x42, 0x85, 0x7A, /*op2*/0x02, 0x0B, 0x0A, 0xD8, 0xF8, /*shared*/0x0A, 0x03 },
		{ /*op1*/0xCF, 0x3F, 0x2B, 0xFB, 0xFA, /*op2*/0xC0, 0x1E, 0x1A, 0xCA, 0xFB, /*shared*/0x0E, 0x10 },
		{ /*op1*/0x01, 0x3F, 0x42, 0x85, 0x7A, /*op2*/0x02, 0x0B, 0x0A, 0xD8, 0xF8, /*shared*/0x0A, 0x03 },
		{ /*op1*/0xCF, 0x3F, 0x0F, 0x5E, 0xF8, /*op2*/0xC6, 0x13, 0x00, 0xCA, 0xFB, /*shared*/0x04, 0x03 },
		{ /*op1*/0xCF, 0x3F, 0x7E, 0x9D, 0xF8, /*op2*/0xC8, 0xC0, 0x0A, 0xBA, 0xE8, /*shared*/0x0E, 0x06 },
		{ /*op1*/0xCF, 0x3F, 0x4D, 0x9F, 0xF8, /*op2*/0xC6, 0x00, 0x08, 0xDA, 0xB3, /*shared*/0x04, 0x04 },
		{ /*op1*/0xCF, 0x3F, 0x5D, 0xAA, 0xF2, /*op2*/0xC0, 0xA4, 0x67, 0x99, 0xF8, /*shared*/0x0A, 0x02 },
		{ /*op1*/0xCF, 0x3F, 0x4A, 0xFD, 0xF8, /*op2*/0xCF, 0x00, 0x59, 0xEA, 0xF8, /*shared*/0x0E, 0x02 },
		{ /*op1*/0x0F, 0x18, 0x0A, 0xFA, 0xAB, /*op2*/0x06, 0x07, 0x06, 0x39, 0xF8, /*shared*/0x0A, 0x02 },
		{ /*op1*/0xCF, 0x3F, 0x2B, 0xFC, 0xF8, /*op2*/0xCC, 0xC6, 0x0B, 0xEA, 0xFB, /*shared*/0x0E, 0x10 }, // 150
		{ /*op1*/0x05, 0x1A, 0x04, 0x00, 0xF8, /*op2*/0x12, 0x10, 0x0C, 0xEA, 0xF8, /*shared*/0x0E, 0x07 },
		{ /*op1*/0x04, 0x19, 0x04, 0x00, 0xF8, /*op2*/0x12, 0x10, 0x2C, 0xEA, 0xF8, /*shared*/0x0E, 0x04 },
		{ /*op1*/0x04, 0x0A, 0x04, 0x00, 0xD8, /*op2*/0x01, 0x07, 0x0D, 0xFA, 0xE8, /*shared*/0x0E, 0x07 },
		{ /*op1*/0x15, 0x14, 0x05, 0x00, 0xF9, /*op2*/0x01, 0x07, 0x5C, 0xE9, 0xF8, /*shared*/0x0E, 0x05 },
		{ /*op1*/0x10, 0x10, 0x05, 0x08, 0xF8, /*op2*/0x01, 0x08, 0x0D, 0xEA, 0xF8, /*shared*/0x0E, 0x05 },
		{ /*op1*/0x11, 0x00, 0x06, 0x87, 0xFB, /*op2*/0x02, 0x40, 0x09, 0x59, 0xD0, /*shared*/0x0E, 0x08 },
		{ /*op1*/0x13, 0x26, 0x04, 0x6A, 0xFB, /*op2*/0x01, 0x00, 0x08, 0x5A, 0xF8, /*shared*/0x0E, 0x08 },
		{ /*op1*/0xCF, 0x4E, 0x0C, 0xAA, 0xA0, /*op2*/0xC4, 0x00, 0x18, 0xF9, 0xA8, /*shared*/0x04, 0x02 },
		{ /*op1*/0xCF, 0x4E, 0x0C, 0xAA, 0xA0, /*op2*/0xC3, 0x00, 0x18, 0xF8, 0xA8, /*shared*/0x04, 0x02 },
		{ /*op1*/0xCB, 0x3F, 0x8F, 0x00, 0xFA, /*op2*/0xC5, 0x00, 0x98, 0xD6, 0xBB, /*shared*/0x0E, 0x0D }, // 160
		{ /*op1*/0x0C, 0x18, 0x87, 0xB3, 0xFB, /*op2*/0x19, 0x10, 0x55, 0x75, 0xF8, /*shared*/0x0E, 0x02 },
		{ /*op1*/0x05, 0x11, 0x15, 0x00, 0xC8, /*op2*/0x02, 0x08, 0x08, 0x00, 0xB8, /*shared*/0x09, 0x02 },
		{ /*op1*/0x04, 0x08, 0x15, 0x00, 0x90, /*op2*/0x01, 0x08, 0x08, 0x00, 0xC0, /*shared*/0x08, 0x02 },
		{ /*op1*/0xDA, 0x00, 0x53, 0x30, 0xD0, /*op2*/0x07, 0x1E, 0x49, 0xC4, 0xFA, /*shared*/0x03, 0x00 },
		{ /*op1*/0x1C, 0x00, 0x07, 0xBC, 0xD8, /*op2*/0x0C, 0x14, 0x0B, 0x6A, 0xFA, /*shared*/0x0B, 0x03 },
		{ /*op1*/0x0A, 0x0E, 0x7F, 0x00, 0xF9, /*op2*/0x13, 0x20, 0x28, 0x03, 0xF8, /*shared*/0x06, 0x00 },
	};
	static TimbreBank s_timbreBanksLeft[167] =
	{
		{ /*op1*/0x12, 0xA6, 0x00, 0xCD, 0x30, /*op2*/0x12, 0x8E, 0x4E, 0x8A, 0xF8, /*shared*/0x0C, 0x23 },
		{ /*op1*/0x22, 0x5A, 0x0E, 0x8A, 0x40, /*op2*/0x14, 0x2F, 0x0E, 0x7A, 0x88, /*shared*/0x06, 0x00 },
		{ /*op1*/0x04, 0x28, 0x5D, 0xB8, 0x01, /*op2*/0x02, 0x18, 0x3C, 0x70, 0x90, /*shared*/0x0A, 0x00 },
		{ /*op1*/0x04, 0x28, 0x5D, 0xB8, 0x01, /*op2*/0x02, 0x18, 0x3C, 0x70, 0x90, /*shared*/0x0A, 0x00 },
		{ /*op1*/0xC4, 0x4E, 0x3C, 0x6A, 0x48, /*op2*/0xC4, 0x04, 0x2C, 0xC9, 0xB0, /*shared*/0x06, 0x00 },
		{ /*op1*/0x04, 0xC8, 0x1C, 0x6B, 0x70, /*op2*/0x02, 0x80, 0x4C, 0x89, 0xA1, /*shared*/0x0C, 0x00 },
		{ /*op1*/0x01, 0x00, 0x01, 0x00, 0x00, /*op2*/0x81, 0x48, 0x3B, 0x89, 0x65, /*shared*/0x01, 0x00 },
		{ /*op1*/0x84, 0x40, 0x3B, 0x5A, 0x83, /*op2*/0x81, 0x00, 0x3B, 0x5A, 0x9B, /*shared*/0x01, 0x00 },
		{ /*op1*/0x00, 0x00, 0x00, 0x00, 0x00, /*op2*/0x8F, 0x14, 0x34, 0x8B, 0xB0, /*shared*/0x09, 0x00 },
		{ /*op1*/0x8A, 0x40, 0x09, 0x2B, 0x00, /*op2*/0x84, 0xFF, 0x3C, 0x6A, 0x00, /*shared*/0x05, 0x00 },
		{ /*op1*/0x8A, 0xC0, 0x0C, 0xDC, 0x00, /*op2*/0x84, 0x58, 0x3D, 0xDA, 0xF8, /*shared*/0x01, 0x00 }, // 10
		{ /*op1*/0x0A, 0x55, 0x28, 0xAD, 0x48, /*op2*/0x82, 0x8E, 0x0C, 0x79, 0xE0, /*shared*/0x00, 0x1B },
		{ /*op1*/0x2A, 0x1A, 0x19, 0x8A, 0x00, /*op2*/0x22, 0x38, 0x0B, 0x0A, 0x00, /*shared*/0x0A, 0x00 },
		{ /*op1*/0xE7, 0x9B, 0x08, 0x08, 0x4A, /*op2*/0xE2, 0x2F, 0x0A, 0x08, 0x68, /*shared*/0x0A, 0x00 },
		{ /*op1*/0xC5, 0x12, 0x0F, 0x0D, 0x10, /*op2*/0x84, 0x0B, 0x00, 0xEB, 0xC0, /*shared*/0x0E, 0x00 },
		{ /*op1*/0x86, 0x40, 0x5D, 0x5A, 0x81, /*op2*/0x81, 0x00, 0x0B, 0x5A, 0xFB, /*shared*/0x00, 0x00 },
		{ /*op1*/0xE6, 0x40, 0x0A, 0xA7, 0x04, /*op2*/0xE2, 0x97, 0x3D, 0x79, 0xF9, /*shared*/0x01, 0x00 },
		{ /*op1*/0xC9, 0x02, 0x16, 0x9A, 0xAB, /*op2*/0xC4, 0x15, 0x46, 0xBA, 0xF8, /*shared*/0x04, 0x00 },
		{ /*op1*/0xE9, 0x04, 0x2A, 0x48, 0x45, /*op2*/0xE4, 0x12, 0x6C, 0x39, 0xF8, /*shared*/0x08, 0x00 },
		{ /*op1*/0x02, 0x80, 0x9F, 0xDA, 0x00, /*op2*/0xE3, 0x50, 0x9F, 0xD9, 0xFA, /*shared*/0x03, 0x00 },
		{ /*op1*/0x00, 0x00, 0x00, 0x00, 0x00, /*op2*/0xE5, 0x0E, 0x9F, 0xD6, 0xF9, /*shared*/0x07, 0x00 }, // 20
		{ /*op1*/0x06, 0x4C, 0xAC, 0x56, 0x31, /*op2*/0x02, 0x08, 0x8D, 0x46, 0xDC, /*shared*/0x00, 0x00 },
		{ /*op1*/0xF2, 0x00, 0x9F, 0xDB, 0xA9, /*op2*/0xE1, 0x00, 0x8F, 0xD7, 0xBA, /*shared*/0x0A, 0x00 },
		{ /*op1*/0xE6, 0x00, 0x00, 0x50, 0x00, /*op2*/0xE6, 0x12, 0x7C, 0xA9, 0xF2, /*shared*/0x07, 0x00 },
		{ /*op1*/0x02, 0xA3, 0x0D, 0xDA, 0x01, /*op2*/0xC2, 0x35, 0x5D, 0x58, 0x00, /*shared*/0x06, 0x18 },
		{ /*op1*/0x42, 0x54, 0x6F, 0xEB, 0x61, /*op2*/0xD4, 0x02, 0x2E, 0xA9, 0xC8, /*shared*/0x00, 0x18 },
		{ /*op1*/0xC2, 0x00, 0x08, 0xB3, 0x99, /*op2*/0xC2, 0x06, 0x2B, 0x58, 0xFA, /*shared*/0x08, 0x19 },
		{ /*op1*/0xC4, 0x00, 0x2D, 0xA7, 0x91, /*op2*/0xC2, 0x02, 0x0E, 0xA7, 0xD1, /*shared*/0x00, 0x00 },
		{ /*op1*/0xC2, 0x0C, 0x06, 0x06, 0xA9, /*op2*/0xC2, 0x3F, 0x09, 0x86, 0xF9, /*shared*/0x0A, 0x0A },
		{ /*op1*/0xC2, 0x2F, 0x6F, 0x79, 0x00, /*op2*/0xC8, 0x0F, 0x5E, 0x98, 0xB9, /*shared*/0x0A, 0x00 },
		{ /*op1*/0xC2, 0x30, 0x4F, 0xCA, 0x01, /*op2*/0xC4, 0x0D, 0x0E, 0xB8, 0xFB, /*shared*/0x08, 0x00 }, // 30
		{ /*op1*/0xC4, 0x29, 0x4F, 0xCA, 0x03, /*op2*/0xC8, 0x0D, 0x0C, 0xB7, 0xF9, /*shared*/0x00, 0x0B },
		{ /*op1*/0xC2, 0x04, 0x58, 0xC9, 0x90, /*op2*/0xC2, 0x94, 0x2C, 0xB9, 0xF0, /*shared*/0x00, 0x20 },
		{ /*op1*/0x32, 0x13, 0x2D, 0xD7, 0x58, /*op2*/0xE2, 0x0F, 0x2E, 0xB8, 0xF8, /*shared*/0x0A, 0x00 },
		{ /*op1*/0x22, 0x86, 0x0D, 0xD7, 0xA0, /*op2*/0xE4, 0x18, 0x5E, 0xB8, 0xF8, /*shared*/0x06, 0x28 },
		{ /*op1*/0xD2, 0x06, 0x9A, 0xD7, 0xA0, /*op2*/0xC2, 0x1F, 0x59, 0xB8, 0xF8, /*shared*/0x04, 0x00 },
		{ /*op1*/0xF2, 0x09, 0x4B, 0xD6, 0x90, /*op2*/0xE4, 0x1F, 0x1C, 0xB8, 0xF8, /*shared*/0x0A, 0x28 },
		{ /*op1*/0x62, 0x11, 0x0C, 0xE6, 0x78, /*op2*/0xE4, 0x1F, 0x0C, 0xC8, 0xF8, /*shared*/0x0A, 0x00 },
		{ /*op1*/0xE2, 0x12, 0x3D, 0xE6, 0x68, /*op2*/0xE4, 0x1F, 0x7D, 0xB8, 0xF8, /*shared*/0x0A, 0x00 },
		{ /*op1*/0xE2, 0x13, 0x3D, 0xE6, 0x68, /*op2*/0xE4, 0x1F, 0x5D, 0xB8, 0xF9, /*shared*/0x08, 0x00 },
		{ /*op1*/0xA2, 0x40, 0x5D, 0xBA, 0x7B, /*op2*/0xE2, 0x00, 0x8F, 0xD8, 0xF1, /*shared*/0x00, 0x00 }, // 40
		{ /*op1*/0xE2, 0x40, 0x3D, 0xDA, 0x73, /*op2*/0xE1, 0x00, 0x7E, 0xD8, 0xF2, /*shared*/0x04, 0x00 },
		{ /*op1*/0x62, 0x00, 0x6D, 0xFA, 0xB9, /*op2*/0xE2, 0x00, 0x8F, 0xC8, 0xF1, /*shared*/0x04, 0x00 },
		{ /*op1*/0xE1, 0x00, 0x4E, 0xDB, 0xCA, /*op2*/0xE2, 0x00, 0x6F, 0xE9, 0xFA, /*shared*/0x06, 0x00 },
		{ /*op1*/0x62, 0xA0, 0x7D, 0xCD, 0x19, /*op2*/0x62, 0x91, 0x9E, 0xE7, 0x80, /*shared*/0x00, 0x00 },
		{ /*op1*/0xD2, 0x9B, 0x8A, 0xCA, 0x30, /*op2*/0xD2, 0x0C, 0x0A, 0xBB, 0xF9, /*shared*/0x00, 0x04 },
		{ /*op1*/0x12, 0x8F, 0x2A, 0xCC, 0x3C, /*op2*/0x12, 0x90, 0x7D, 0xCB, 0xF8, /*shared*/0x0E, 0x03 },
		{ /*op1*/0x00, 0xBC, 0x17, 0xAB, 0x12, /*op2*/0x03, 0xC9, 0x5B, 0xBA, 0xF8, /*shared*/0x06, 0x04 },
		{ /*op1*/0xA2, 0x9C, 0x7D, 0xCD, 0x21, /*op2*/0xA4, 0xC7, 0x9E, 0xE7, 0xF8, /*shared*/0x0E, 0x00 },
		{ /*op1*/0x62, 0x9E, 0x7D, 0xCD, 0x19, /*op2*/0x62, 0x96, 0x9E, 0xE7, 0x80, /*shared*/0x00, 0x00 },
		{ /*op1*/0xE2, 0x40, 0x8F, 0xFA, 0xA0, /*op2*/0xF2, 0x04, 0x7F, 0xFA, 0xF9, /*shared*/0x0A, 0x00 }, // 50
		{ /*op1*/0xE4, 0xA0, 0xCE, 0x5B, 0x02, /*op2*/0xE2, 0x32, 0x7F, 0xFB, 0x79, /*shared*/0x04, 0x00 },
		{ /*op1*/0xE2, 0x94, 0xAC, 0xC9, 0x21, /*op2*/0xE2, 0x9E, 0x9D, 0xE9, 0xF8, /*shared*/0x0E, 0x00 },
		{ /*op1*/0xEA, 0xA0, 0xAC, 0x67, 0x02, /*op2*/0xE2, 0x00, 0x7C, 0x7A, 0xF8, /*shared*/0x06, 0x00 },
		{ /*op1*/0xE7, 0x94, 0xAD, 0xB7, 0x03, /*op2*/0xE2, 0x00, 0x7C, 0xBA, 0xF8, /*shared*/0x00, 0x00 },
		{ /*op1*/0xC3, 0x3F, 0x4B, 0xE9, 0xFA, /*op2*/0xC1, 0x3F, 0x9B, 0xF9, 0xFB, /*shared*/0x0B, 0x06 },
		{ /*op1*/0x22, 0x16, 0x9B, 0xA9, 0x10, /*op2*/0x32, 0x08, 0xAC, 0xD9, 0xFC, /*shared*/0x02, 0x00 },
		{ /*op1*/0x22, 0xA1, 0x7C, 0xDC, 0x10, /*op2*/0x34, 0x89, 0xAD, 0xD8, 0xF8, /*shared*/0x0C, 0x00 },
		{ /*op1*/0xD2, 0x00, 0x7B, 0x88, 0xA8, /*op2*/0xD2, 0x4C, 0x69, 0xE9, 0xF8, /*shared*/0x06, 0x00 },
		{ /*op1*/0xD2, 0x02, 0x85, 0x89, 0xC8, /*op2*/0xD2, 0x94, 0x77, 0x49, 0xF9, /*shared*/0x08, 0x00 },
		{ /*op1*/0x22, 0x9F, 0x9D, 0xEA, 0x10, /*op2*/0x22, 0x07, 0x9C, 0xE8, 0xF8, /*shared*/0x06, 0x00 }, // 60
		{ /*op1*/0xE2, 0x2A, 0x7F, 0xB8, 0x01, /*op2*/0xE4, 0x00, 0x0D, 0xC5, 0xF8, /*shared*/0x0C, 0x00 },
		{ /*op1*/0xE4, 0x28, 0x8E, 0xE8, 0x01, /*op2*/0xF2, 0x00, 0x4D, 0xD6, 0xF9, /*shared*/0x0C, 0x00 },
		{ /*op1*/0xB2, 0x8E, 0xBA, 0xDA, 0x3D, /*op2*/0xB2, 0x0F, 0xAE, 0xE9, 0xF8, /*shared*/0x0E, 0x00 },
		{ /*op1*/0xB4, 0x26, 0x6E, 0x98, 0x01, /*op2*/0x62, 0x00, 0x7D, 0xC8, 0xF9, /*shared*/0x00, 0x00 },
		{ /*op1*/0xD2, 0x10, 0x69, 0x18, 0xCF, /*op2*/0xD4, 0x14, 0x5B, 0x04, 0xFD, /*shared*/0x0A, 0x00 },
		{ /*op1*/0xE4, 0x28, 0x7E, 0xF8, 0x01, /*op2*/0xE2, 0x23, 0x8E, 0xE8, 0xF9, /*shared*/0x08, 0x00 },
		{ /*op1*/0xB8, 0x28, 0x9E, 0x98, 0x01, /*op2*/0x62, 0x00, 0x3D, 0xC8, 0xF9, /*shared*/0x08, 0x00 },
		{ /*op1*/0x62, 0x00, 0x8E, 0xC9, 0x79, /*op2*/0xE6, 0x00, 0x7E, 0xD8, 0xD0, /*shared*/0x0A, 0x00 },
		{ /*op1*/0xC2, 0x00, 0x97, 0xF9, 0x90, /*op2*/0xC9, 0x80, 0x69, 0x98, 0xA0, /*shared*/0x00, 0x00 },
		{ /*op1*/0x02, 0x04, 0x8A, 0xD8, 0x80, /*op2*/0x0C, 0x12, 0x85, 0xD8, 0xF8, /*shared*/0x0A, 0x00 }, // 70
		{ /*op1*/0xA8, 0x8E, 0x9D, 0xD9, 0x40, /*op2*/0xA2, 0x8C, 0x9E, 0xE8, 0xF8, /*shared*/0x00, 0x00 },
		{ /*op1*/0xE4, 0x80, 0x6C, 0xD9, 0x60, /*op2*/0xE2, 0x00, 0x8D, 0xC8, 0xF8, /*shared*/0x00, 0x00 },
		{ /*op1*/0xA2, 0x6C, 0x79, 0xB9, 0x00, /*op2*/0xA2, 0x07, 0x9D, 0xE8, 0xF8, /*shared*/0x0A, 0x00 },
		{ /*op1*/0xE4, 0x00, 0x77, 0xC5, 0xA8, /*op2*/0xE2, 0x00, 0x9E, 0xD7, 0xE0, /*shared*/0x06, 0x00 },
		{ /*op1*/0xC2, 0x80, 0x94, 0x09, 0x78, /*op2*/0xC2, 0x00, 0x97, 0x97, 0xF8, /*shared*/0x04, 0x00 },
		{ /*op1*/0xC2, 0x00, 0x86, 0x68, 0xA0, /*op2*/0xC2, 0x00, 0x77, 0x47, 0xE0, /*shared*/0x04, 0x00 },
		{ /*op1*/0xE2, 0x00, 0x89, 0x40, 0x79, /*op2*/0xE2, 0x00, 0x7E, 0xC9, 0x90, /*shared*/0x06, 0x00 },
		{ /*op1*/0xE6, 0x80, 0x9D, 0xB8, 0x51, /*op2*/0xE2, 0x00, 0x9E, 0xF9, 0xA0, /*shared*/0x01, 0x00 },
		{ /*op1*/0xE2, 0x80, 0x8E, 0x64, 0xD0, /*op2*/0xE2, 0x28, 0x6F, 0x73, 0xF8, /*shared*/0x01, 0x00 },
		{ /*op1*/0xE8, 0x00, 0x7D, 0x99, 0xA8, /*op2*/0xE6, 0x80, 0x80, 0xF8, 0xF8, /*shared*/0x0C, 0x00 }, // 80
		{ /*op1*/0xE6, 0x00, 0x9F, 0xB9, 0xD9, /*op2*/0xE1, 0x00, 0x8F, 0xC8, 0xF9, /*shared*/0x02, 0x00 },
		{ /*op1*/0xE4, 0x00, 0x09, 0x68, 0x92, /*op2*/0xE2, 0x2B, 0x9E, 0xF3, 0xF8, /*shared*/0x0E, 0x00 },
		{ /*op1*/0xC4, 0x00, 0x99, 0xE8, 0x73, /*op2*/0xE2, 0x25, 0x6F, 0x93, 0xF8, /*shared*/0x0E, 0x00 },
		{ /*op1*/0xE2, 0x00, 0x4F, 0xDA, 0xC8, /*op2*/0xE2, 0x00, 0x0F, 0xD8, 0xD0, /*shared*/0x06, 0x00 },
		{ /*op1*/0xEC, 0x60, 0x9D, 0xC7, 0x00, /*op2*/0xE2, 0x21, 0x7F, 0xC9, 0xF8, /*shared*/0x06, 0x00 },
		{ /*op1*/0xE3, 0x00, 0x0F, 0xF7, 0xF9, /*op2*/0xE1, 0x3F, 0x0F, 0xA7, 0x01, /*shared*/0x0D, 0x00 },
		{ /*op1*/0xE4, 0xA9, 0x0F, 0xA8, 0x02, /*op2*/0xE2, 0x3C, 0x5F, 0xDA, 0x78, /*shared*/0x0E, 0x00 },
		{ /*op1*/0x28, 0x49, 0x0C, 0xCB, 0x40, /*op2*/0xE2, 0x11, 0x5B, 0xD9, 0x48, /*shared*/0x05, 0x00 },
		{ /*op1*/0xE1, 0x00, 0xDF, 0x8A, 0xAA, /*op2*/0xE2, 0x5E, 0xCF, 0xBA, 0xFA, /*shared*/0x08, 0x00 },
		{ /*op1*/0xE2, 0x00, 0x0B, 0x68, 0xC0, /*op2*/0xE2, 0x01, 0x9E, 0xB8, 0xF8, /*shared*/0x0A, 0x00 }, // 90
		{ /*op1*/0xEA, 0x00, 0xAE, 0xAB, 0x91, /*op2*/0xE2, 0x00, 0xAE, 0xBA, 0xD8, /*shared*/0x08, 0x00 },
		{ /*op1*/0xEB, 0xC3, 0x9C, 0xCB, 0xA2, /*op2*/0xE2, 0x4C, 0xAE, 0xCA, 0xFA, /*shared*/0x08, 0x00 },
		{ /*op1*/0xE2, 0x80, 0x8E, 0xCB, 0xC0, /*op2*/0xE2, 0x90, 0xAE, 0xCA, 0xFB, /*shared*/0x0A, 0x00 },
		{ /*op1*/0xE4, 0x00, 0x9E, 0xAA, 0x79, /*op2*/0xE1, 0x43, 0x0F, 0xBA, 0xFA, /*shared*/0x04, 0x00 },
		{ /*op1*/0xE3, 0x80, 0xDB, 0xCA, 0x40, /*op2*/0xE2, 0x08, 0xDF, 0xBA, 0xC1, /*shared*/0x04, 0x00 },
		{ /*op1*/0xEA, 0x00, 0x68, 0xB8, 0x90, /*op2*/0xE2, 0x0A, 0x8E, 0xB8, 0xF8, /*shared*/0x0C, 0x00 },
		{ /*op1*/0x62, 0x00, 0xCE, 0x9A, 0xA8, /*op2*/0xE2, 0x45, 0xCF, 0xCA, 0xA0, /*shared*/0x0A, 0x00 },
		{ /*op1*/0xCD, 0x00, 0x0B, 0x00, 0x90, /*op2*/0xC2, 0x58, 0x0C, 0x00, 0xF8, /*shared*/0x0C, 0x1C },
		{ /*op1*/0x64, 0x18, 0xBB, 0xAA, 0x10, /*op2*/0x62, 0x4C, 0x5C, 0xDA, 0xF8, /*shared*/0x0E, 0x00 },
		{ /*op1*/0xE6, 0x0A, 0x4C, 0xC9, 0x60, /*op2*/0xE2, 0x07, 0x0C, 0x7A, 0xB8, /*shared*/0x08, 0x00 }, // 100
		{ /*op1*/0xED, 0x48, 0xDE, 0xD8, 0xB4, /*op2*/0xE1, 0x00, 0xDD, 0xAA, 0xA9, /*shared*/0x00, 0x00 },
		{ /*op1*/0xEF, 0x00, 0x8C, 0xAA, 0x67, /*op2*/0x25, 0x00, 0x9D, 0xAB, 0xC1, /*shared*/0x08, 0x00 },
		{ /*op1*/0x62, 0x84, 0xBB, 0xAA, 0xCA, /*op2*/0xCF, 0x41, 0xAC, 0xDA, 0xF8, /*shared*/0x08, 0x00 },
		{ /*op1*/0xC2, 0x03, 0x6A, 0x5B, 0xA4, /*op2*/0xC2, 0x0D, 0x2A, 0xBB, 0xFC, /*shared*/0x00, 0x12 },
		{ /*op1*/0x62, 0x00, 0x04, 0x9A, 0xE8, /*op2*/0xE2, 0x00, 0x0A, 0x48, 0xFD, /*shared*/0x04, 0x10 },
		{ /*op1*/0x41, 0x00, 0x0E, 0xEA, 0xA3, /*op2*/0xC2, 0x00, 0x08, 0xCA, 0xF8, /*shared*/0x08, 0x07 },
		{ /*op1*/0xC1, 0x40, 0x0C, 0x59, 0xD2, /*op2*/0xC2, 0x80, 0x3C, 0xAB, 0xF8, /*shared*/0x08, 0x0D },
		{ /*op1*/0x4B, 0x00, 0x0A, 0xF5, 0xC1, /*op2*/0xC2, 0x19, 0x0C, 0xE9, 0xF8, /*shared*/0x08, 0x07 },
		{ /*op1*/0x62, 0x00, 0x7F, 0xD8, 0xA8, /*op2*/0xEA, 0x00, 0x8F, 0xD8, 0xF9, /*shared*/0x0A, 0x00 },
		{ /*op1*/0xE1, 0x00, 0x7F, 0xD9, 0xAA, /*op2*/0xE1, 0x00, 0x8F, 0xD8, 0xFA, /*shared*/0x06, 0x00 }, // 110
		{ /*op1*/0xE1, 0x00, 0x7F, 0xD9, 0xAA, /*op2*/0xE1, 0x00, 0x8F, 0xD8, 0xFA, /*shared*/0x06, 0x00 },
		{ /*op1*/0xCF, 0x40, 0x09, 0xEA, 0xA8, /*op2*/0xC4, 0x00, 0x0C, 0xDB, 0xC8, /*shared*/0x08, 0x02 },
		{ /*op1*/0xCF, 0x40, 0x0C, 0xAA, 0xA8, /*op2*/0xC4, 0x00, 0x18, 0xF9, 0xC8, /*shared*/0x0C, 0x02 },
		{ /*op1*/0xC5, 0x00, 0x98, 0xD9, 0x92, /*op2*/0xC1, 0x16, 0x6E, 0xF9, 0xE8, /*shared*/0x06, 0x05 },
		{ /*op1*/0x03, 0x00, 0x15, 0x00, 0xC8, /*op2*/0x02, 0x00, 0x08, 0x00, 0xF8, /*shared*/0x09, 0x02 },
		{ /*op1*/0x02, 0x3F, 0x05, 0x08, 0xF8, /*op2*/0x03, 0x3F, 0x3C, 0xF9, 0xF8, /*shared*/0x0A, 0x06 },
		{ /*op1*/0x00, 0x00, 0x36, 0x67, 0xF8, /*op2*/0x01, 0x3F, 0x0E, 0xFA, 0xF8, /*shared*/0x00, 0x05 },
		{ /*op1*/0x02, 0x00, 0x36, 0x68, 0xF8, /*op2*/0x01, 0x3F, 0x0E, 0xFA, 0xF8, /*shared*/0x00, 0x05 },
		{ /*op1*/0xCB, 0x00, 0xAF, 0x00, 0xFA, /*op2*/0xC0, 0x00, 0xC0, 0x06, 0xFB, /*shared*/0x0E, 0x0F },
		{ /*op1*/0x05, 0x0D, 0x80, 0xA6, 0xFB, /*op2*/0x0B, 0x38, 0xA9, 0xD8, 0x00, /*shared*/0x0E, 0x04 }, // 120
		{ /*op1*/0x0F, 0x00, 0x90, 0xFA, 0xD0, /*op2*/0x06, 0x00, 0xA7, 0x39, 0xA8, /*shared*/0x0E, 0x06 },
		{ /*op1*/0xC9, 0x15, 0xDD, 0xFF, 0xF8, /*op2*/0x00, 0x00, 0xE7, 0xFC, 0xD8, /*shared*/0x0E, 0x38 },
		{ /*op1*/0x48, 0x3C, 0x30, 0xF6, 0x03, /*op2*/0x0A, 0x38, 0x97, 0xE8, 0x00, /*shared*/0x0E, 0x04 },
		{ /*op1*/0x07, 0x80, 0x0B, 0xC8, 0xC9, /*op2*/0x02, 0x3F, 0x0C, 0xEA, 0xF8, /*shared*/0x0F, 0x05 },
		{ /*op1*/0x00, 0x21, 0x66, 0x40, 0x03, /*op2*/0x00, 0x3F, 0x47, 0x00, 0x00, /*shared*/0x0E, 0x02 },
		{ /*op1*/0x08, 0x00, 0x0B, 0x3C, 0xF8, /*op2*/0x08, 0x3F, 0x06, 0xF3, 0x00, /*shared*/0x0E, 0x02 },
		{ /*op1*/0x00, 0x3F, 0x4C, 0xFB, 0x00, /*op2*/0x00, 0x3F, 0x0A, 0xE9, 0xF8, /*shared*/0x0E, 0x05 },
		{ /*op1*/0x11, 0x18, 0x15, 0x00, 0xF8, /*op2*/0x12, 0x00, 0x2B, 0x03, 0xF8, /*shared*/0x06, 0x06 },
		{ /*op1*/0x04, 0x3F, 0x42, 0x00, 0x00, /*op2*/0x02, 0x06, 0x1A, 0xE9, 0xE0, /*shared*/0x0E, 0x07 },
		{ /*op1*/0x04, 0x18, 0x06, 0x01, 0xB0, /*op2*/0x10, 0x00, 0x07, 0x00, 0x90, /*shared*/0x00, 0x01 }, // 130
		{ /*op1*/0x01, 0x3C, 0x0F, 0xFF, 0x80, /*op2*/0x14, 0x06, 0x68, 0xB9, 0xC0, /*shared*/0x0E, 0x02 },
		{ /*op1*/0x0E, 0x32, 0x76, 0x03, 0xF8, /*op2*/0x1F, 0x0F, 0x77, 0xD4, 0xFC, /*shared*/0x0E, 0x02 },
		{ /*op1*/0x01, 0x3C, 0x0F, 0xFF, 0x80, /*op2*/0x14, 0x06, 0x68, 0xB9, 0xC0, /*shared*/0x0E, 0x02 },
		{ /*op1*/0x01, 0x3F, 0x42, 0x85, 0x7A, /*op2*/0x02, 0x0B, 0x0A, 0xD8, 0xF8, /*shared*/0x0A, 0x03 },
		{ /*op1*/0xD2, 0x7F, 0x04, 0x0F, 0xFA, /*op2*/0x10, 0xCD, 0x24, 0x07, 0xFB, /*shared*/0x0E, 0x02 },
		{ /*op1*/0x01, 0x3F, 0x42, 0x85, 0x7A, /*op2*/0x02, 0x0B, 0x0A, 0xD8, 0xF8, /*shared*/0x0A, 0x03 },
		{ /*op1*/0xCF, 0x7F, 0x05, 0x07, 0xFA, /*op2*/0x00, 0x40, 0x25, 0x08, 0xC3, /*shared*/0x0E, 0x0C },
		{ /*op1*/0x01, 0x3F, 0x42, 0x85, 0x7A, /*op2*/0x02, 0x0B, 0x0A, 0xD8, 0xF8, /*shared*/0x0A, 0x03 },
		{ /*op1*/0xD2, 0x7F, 0x04, 0x0F, 0xFA, /*op2*/0x10, 0xCD, 0x24, 0x07, 0xFB, /*shared*/0x0E, 0x02 },
		{ /*op1*/0x01, 0x3F, 0x42, 0x85, 0x7A, /*op2*/0x02, 0x0B, 0x0A, 0xD8, 0xF8, /*shared*/0x0A, 0x03 }, // 140
		{ /*op1*/0x01, 0x3F, 0x42, 0x85, 0x7A, /*op2*/0x02, 0x0B, 0x0A, 0xD8, 0xF8, /*shared*/0x0A, 0x03 },
		{ /*op1*/0xCF, 0x3F, 0x2B, 0xFB, 0xFA, /*op2*/0xC0, 0x1E, 0x1A, 0xCA, 0xFB, /*shared*/0x0E, 0x10 },
		{ /*op1*/0x01, 0x3F, 0x42, 0x85, 0x7A, /*op2*/0x02, 0x0B, 0x0A, 0xD8, 0xF8, /*shared*/0x0A, 0x03 },
		{ /*op1*/0xCF, 0x3F, 0x04, 0x57, 0xF8, /*op2*/0xC5, 0x13, 0x06, 0x05, 0xFF, /*shared*/0x04, 0x03 },
		{ /*op1*/0xCF, 0x3F, 0x77, 0x09, 0xF8, /*op2*/0xC2, 0xC0, 0x08, 0xB5, 0xEA, /*shared*/0x0E, 0x06 },
		{ /*op1*/0xCF, 0x3F, 0x47, 0x06, 0xF8, /*op2*/0xCD, 0x00, 0x07, 0x05, 0xB3, /*shared*/0x04, 0x04 },
		{ /*op1*/0xCF, 0x3F, 0x9A, 0x69, 0xF8, /*op2*/0xCF, 0x88, 0x88, 0x48, 0xFA, /*shared*/0x00, 0x02 },
		{ /*op1*/0xCF, 0x3F, 0x48, 0x06, 0xF8, /*op2*/0xCF, 0x00, 0x54, 0x04, 0xF9, /*shared*/0x0E, 0x02 },
		{ /*op1*/0x03, 0x18, 0x04, 0x09, 0xAC, /*op2*/0x05, 0x07, 0x08, 0x07, 0xF8, /*shared*/0x04, 0x02 },
		{ /*op1*/0xCF, 0x3F, 0x25, 0x06, 0xF8, /*op2*/0xCC, 0xD7, 0x05, 0x02, 0xF8, /*shared*/0x0E, 0x10 }, // 150
		{ /*op1*/0x01, 0x00, 0x09, 0x08, 0x40, /*op2*/0x13, 0x00, 0x2A, 0x0A, 0xD8, /*shared*/0x00, 0x07 },
		{ /*op1*/0x04, 0x00, 0x07, 0x08, 0x40, /*op2*/0x12, 0x00, 0x29, 0x08, 0xE0, /*shared*/0x00, 0x04 },
		{ /*op1*/0x04, 0x00, 0x03, 0x09, 0x93, /*op2*/0x02, 0x00, 0x28, 0x09, 0xE8, /*shared*/0x08, 0x07 },
		{ /*op1*/0x05, 0x00, 0x03, 0x03, 0x49, /*op2*/0x02, 0x00, 0x58, 0x08, 0xE0, /*shared*/0x08, 0x05 },
		{ /*op1*/0x10, 0x00, 0x0C, 0x0C, 0x48, /*op2*/0x02, 0x00, 0x08, 0xB9, 0xE0, /*shared*/0x00, 0x05 },
		{ /*op1*/0x15, 0x00, 0x04, 0x87, 0xFB, /*op2*/0x02, 0x40, 0x09, 0x59, 0xD0, /*shared*/0x0E, 0x08 },
		{ /*op1*/0x12, 0x26, 0x03, 0x6A, 0xFB, /*op2*/0x02, 0x00, 0x06, 0x5A, 0xC0, /*shared*/0x0E, 0x08 },
		{ /*op1*/0xCF, 0x4E, 0x05, 0xA6, 0xA0, /*op2*/0xC6, 0x00, 0x16, 0xF8, 0x60, /*shared*/0x04, 0x02 },
		{ /*op1*/0xCF, 0x4E, 0x06, 0xAA, 0xA0, /*op2*/0xC5, 0x00, 0x19, 0xF9, 0x90, /*shared*/0x04, 0x02 },
		{ /*op1*/0xC0, 0x00, 0xF0, 0x00, 0x00, /*op2*/0xC0, 0x00, 0xF0, 0x00, 0x00, /*shared*/0x00, 0x0D }, // 160
		{ /*op1*/0x0C, 0x18, 0x87, 0xB3, 0xFB, /*op2*/0x1B, 0x10, 0x57, 0x75, 0xF8, /*shared*/0x0E, 0x02 },
		{ /*op1*/0x02, 0x11, 0x13, 0x00, 0xC8, /*op2*/0x02, 0x00, 0x05, 0x00, 0x80, /*shared*/0x09, 0x02 },
		{ /*op1*/0x03, 0x08, 0x14, 0x00, 0x90, /*op2*/0x02, 0x00, 0x07, 0x00, 0xA8, /*shared*/0x00, 0x02 },
		{ /*op1*/0xD2, 0x00, 0x56, 0x30, 0x90, /*op2*/0x06, 0x00, 0x46, 0x56, 0x62, /*shared*/0x09, 0x00 },
		{ /*op1*/0x18, 0x00, 0x07, 0xBC, 0x88, /*op2*/0x09, 0x00, 0x0B, 0x6A, 0xBA, /*shared*/0x0B, 0x03 }, // 165
		{ /*op1*/0x01, 0x0E, 0x54, 0x00, 0xF9, /*op2*/0x15, 0x03, 0x27, 0x03, 0xF8, /*shared*/0x06, 0x00 },
	};
};