#pragma once

// Midi Message = MidiMessageType + Channel, data byte 1, data byte 2
// Examples assume: u8 channelId = 0x00 - 0x0f (16 channels)
// Example: TFE_MidiDevice::sendMessage(MID_NOTE_ON + channelId, note, velocity);
//          TFE_MidiDevice::sendMessage(MID_CONTROL_CHANGE + channelId, MID_VOLUME_MSB, 100);

#define CHANNEL_MAX_VOLUME 127

// Channel message type
enum MidiMessageType
{
	// Channel (0x00 - 0x0f)		//   Data 1, Data 2
	MID_NOTE_OFF		 = 0x80,	// Note Number, Velocity
	MID_NOTE_ON			 = 0x90,	// Note Number, Velocity
	MID_KEY_PRESSURE	 = 0xA0,	// Note Number, Pressure
	MID_CONTROL_CHANGE	 = 0xB0,	// Controller Number (see MidiController below), Data
	MID_PROGRAM_CHANGE	 = 0xC0,	// Program Number, Unused
	MID_CHANNEL_PRESSURE = 0xD0,	// Pressure, Unused
	MID_PITCH_BEND		 = 0xE0,	// LSB, MSB
	// System
	MID_EXCLUSIVE_START = 0xF0,		// Manufacturers ID, data
	MID_QUARTER_FRAME   = 0xF1,		// Data, ...
	MID_SONG_POINTER    = 0xF2,		// LSB, MSB
	MID_SONG_SELECT     = 0xF3,		// Song Number
	MID_TUNE_REQUEST    = 0xF6,
	MID_EXCLUSIVE_END   = 0xF7,
	MID_TIMING_CLOCK    = 0xF8,
	MID_MEASURE_END     = 0xF9,
	MID_START           = 0xFA,
	MID_CONTINUE        = 0xFB,
	MID_STOP            = 0xFC,
	MID_ACTIVE_SENSING  = 0xFE,
	MID_RESET           = 0xFF,
};

enum MetaType
{
	META_SEQ_NUMBER = 0x00,
	META_TEXT_EVENT,
	META_COPYRIGHT_NOTICE,
	META_SEQ_NAME,
	META_INSTR_NAME,
	META_LYRIC_TEXT,
	META_MARKER_TEXT,
	META_CUE_POINT,
	META_MIDI_CHANNEL_PREFIX = 0x20,
	META_END_OF_TRACK = 0x2f,
	META_TEMPO = 0x51,
	META_SMPTE_OFFSET = 0x54,
	META_TIME_SIG = 0x58,
	META_KEY_SIG = 0x59,
	META_SEQ_SPECIFIC = 0x7f
};

// Midi controller numbers
enum MidiController
{
	MID_BANK_SELECT_MSB = 0,
	MID_MODULATIONWHEEL_MSB,
	MID_BREATH_MSB,
	MID_FOOT_MSB = 4,
	MID_PORTAMENTO_TIME_MSB,
	MID_DATA_ENTRY_MSB,
	MID_VOLUME_MSB,
	MID_BALANCE_MSB,
	MID_PAN_MSB = 10,
	MID_EXPRESSION_MSB,
	MID_EFFECTS1_MSB,
	MID_EFFECTS2_MSB,
	MID_GPC1_MSB = 16,
	MID_GPC2_MSB,
	MID_GPC3_MSB,
	MID_GPC4_MSB,
	MID_BANK_SELECT_LSB = 32,
	MID_MODULATIONWHEEL_LSB,
	MID_BREATH_LSB,
	MID_FOOT_LSB = 36,
	MID_PORTAMENTO_TIME_LSB,
	MID_DATA_ENTRY_LSB,
	MID_VOLUME_LSB,
	MID_BALANCE_LSB,
	MID_PAN_LSB = 42,
	MID_EXPRESSION_LSB,
	MID_EFFECTS1_LSB,
	MID_EFFECTS2_LSB,
	MID_GPC1_LSB = 48,
	MID_GPC2_LSB,
	MID_GPC3_LSB,
	MID_GPC4_LSB,
	MID_SUSTAIN_SWITCH = 64,
	MID_PORTAMENTO_SWITCH,
	MID_SOSTENUTO_SWITCH,
	MID_SOFT_PEDAL_SWITCH,
	MID_LEGATO_SWITCH,
	MID_HOLD2_SWITCH,
	MID_SOUND_CTRL1,
	MID_SOUND_CTRL2,
	MID_SOUND_CTRL3,
	MID_SOUND_CTRL4,
	MID_SOUND_CTRL5,
	MID_SOUND_CTRL6,
	MID_SOUND_CTRL7,
	MID_SOUND_CTRL8,
	MID_SOUND_CTRL9,
	MID_SOUND_CTRL10,
	MID_GPC5,
	MID_GPC6,
	MID_GPC7,
	MID_GPC8,
	MID_PORTAMENTO_CTRL,
	MID_FX_REVERB = 91,
	MID_FX_TREMOLO,
	MID_FX_CHORUS,
	MID_FX_CELESTE_DETUNE,
	MID_FX_PHASER,
	MID_DATA_ENTRY_INCR,
	MID_DATA_ENTRY_DECR,
	MID_NRPN_LSB,
	MID_NRPN_MSB,
	MID_RPN_LSB,
	MID_RPN_MSB,
	MID_ALL_SOUND_OFF = 120,
	MID_ALL_CTRL_OFF,
	MID_LOCAL_CONTROL,
	MID_ALL_NOTES_OFF,
	MID_OMNI_OFF,
	MID_OMNI_ON,
	MID_POLY_OFF,
	MID_POLY_ON
};

enum MidiInstruments
{
	// General midi supports instruments 0 - 127
	MIDI_INSTRUMENT_COUNT = 128,
	// General midi supports 16 channels (also called "voices")
	MIDI_CHANNEL_COUNT = 16,
};
