//////////////////////////////////////////////////////////////////////
// Wall
// Dark Forces Derived Renderer - Wall functions
//////////////////////////////////////////////////////////////////////
#include "cosTable.h"

namespace TFE_Jedi
{
	// The cosine table from Dark Forces.
	const fixed16_16 s_cosTable[] =
	{
		0x00010000, 0x0000FFFF, 0x0000FFFF, 0x0000FFFF,
		0x0000FFFF, 0x0000FFFF, 0x0000FFFF, 0x0000FFFF,
		0x0000FFFF, 0x0000FFFF, 0x0000FFFF, 0x0000FFFF,
		0x0000FFFF, 0x0000FFFF, 0x0000FFFF, 0x0000FFFE,
		0x0000FFFE, 0x0000FFFE, 0x0000FFFE, 0x0000FFFE,
		0x0000FFFE, 0x0000FFFD, 0x0000FFFD, 0x0000FFFD,
		0x0000FFFD, 0x0000FFFC, 0x0000FFFC, 0x0000FFFC,
		0x0000FFFC, 0x0000FFFB, 0x0000FFFB, 0x0000FFFB,
		0x0000FFFB, 0x0000FFFA, 0x0000FFFA, 0x0000FFFA,
		0x0000FFF9, 0x0000FFF9, 0x0000FFF9, 0x0000FFF8,
		0x0000FFF8, 0x0000FFF7, 0x0000FFF7, 0x0000FFF7,
		0x0000FFF6, 0x0000FFF6, 0x0000FFF5, 0x0000FFF5,
		0x0000FFF4, 0x0000FFF4, 0x0000FFF3, 0x0000FFF3,
		0x0000FFF2, 0x0000FFF2, 0x0000FFF1, 0x0000FFF1,
		0x0000FFF0, 0x0000FFF0, 0x0000FFEF, 0x0000FFEF,
		0x0000FFEE, 0x0000FFEE, 0x0000FFED, 0x0000FFEC,
		0x0000FFEC, 0x0000FFEB, 0x0000FFEB, 0x0000FFEA,
		0x0000FFE9, 0x0000FFE9, 0x0000FFE8, 0x0000FFE7,
		0x0000FFE7, 0x0000FFE6, 0x0000FFE5, 0x0000FFE4,
		0x0000FFE4, 0x0000FFE3, 0x0000FFE2, 0x0000FFE1,
		0x0000FFE1, 0x0000FFE0, 0x0000FFDF, 0x0000FFDE,
		0x0000FFDD, 0x0000FFDD, 0x0000FFDC, 0x0000FFDB,
		0x0000FFDA, 0x0000FFD9, 0x0000FFD8, 0x0000FFD8,
		0x0000FFD7, 0x0000FFD6, 0x0000FFD5, 0x0000FFD4,
		0x0000FFD3, 0x0000FFD2, 0x0000FFD1, 0x0000FFD0,
		0x0000FFCF, 0x0000FFCE, 0x0000FFCD, 0x0000FFCC,
		0x0000FFCB, 0x0000FFCA, 0x0000FFC9, 0x0000FFC8,
		0x0000FFC7, 0x0000FFC6, 0x0000FFC5, 0x0000FFC4,
		0x0000FFC3, 0x0000FFC2, 0x0000FFC1, 0x0000FFC0,
		0x0000FFBF, 0x0000FFBE, 0x0000FFBC, 0x0000FFBB,
		0x0000FFBA, 0x0000FFB9, 0x0000FFB8, 0x0000FFB7,
		0x0000FFB5, 0x0000FFB4, 0x0000FFB3, 0x0000FFB2,
		0x0000FFB1, 0x0000FFAF, 0x0000FFAE, 0x0000FFAD,
		0x0000FFAC, 0x0000FFAA, 0x0000FFA9, 0x0000FFA8,
		0x0000FFA6, 0x0000FFA5, 0x0000FFA4, 0x0000FFA2,
		0x0000FFA1, 0x0000FFA0, 0x0000FF9E, 0x0000FF9D,
		0x0000FF9C, 0x0000FF9A, 0x0000FF99, 0x0000FF97,
		0x0000FF96, 0x0000FF95, 0x0000FF93, 0x0000FF92,
		0x0000FF90, 0x0000FF8F, 0x0000FF8D, 0x0000FF8C,
		0x0000FF8A, 0x0000FF89, 0x0000FF87, 0x0000FF86,
		0x0000FF84, 0x0000FF83, 0x0000FF81, 0x0000FF80,
		0x0000FF7E, 0x0000FF7C, 0x0000FF7B, 0x0000FF79,
		0x0000FF78, 0x0000FF76, 0x0000FF74, 0x0000FF73,
		0x0000FF71, 0x0000FF6F, 0x0000FF6E, 0x0000FF6C,
		0x0000FF6A, 0x0000FF69, 0x0000FF67, 0x0000FF65,
		0x0000FF63, 0x0000FF62, 0x0000FF60, 0x0000FF5E,
		0x0000FF5C, 0x0000FF5B, 0x0000FF59, 0x0000FF57,
		0x0000FF55, 0x0000FF53, 0x0000FF52, 0x0000FF50,
		0x0000FF4E, 0x0000FF4C, 0x0000FF4A, 0x0000FF48,
		0x0000FF46, 0x0000FF45, 0x0000FF43, 0x0000FF41,
		0x0000FF3F, 0x0000FF3D, 0x0000FF3B, 0x0000FF39,
		0x0000FF37, 0x0000FF35, 0x0000FF33, 0x0000FF31,
		0x0000FF2F, 0x0000FF2D, 0x0000FF2B, 0x0000FF29,
		0x0000FF27, 0x0000FF25, 0x0000FF23, 0x0000FF21,
		0x0000FF1F, 0x0000FF1D, 0x0000FF1B, 0x0000FF19,
		0x0000FF16, 0x0000FF14, 0x0000FF12, 0x0000FF10,
		0x0000FF0E, 0x0000FF0C, 0x0000FF0A, 0x0000FF07,
		0x0000FF05, 0x0000FF03, 0x0000FF01, 0x0000FEFF,
		0x0000FEFC, 0x0000FEFA, 0x0000FEF8, 0x0000FEF6,
		0x0000FEF3, 0x0000FEF1, 0x0000FEEF, 0x0000FEEC,
		0x0000FEEA, 0x0000FEE8, 0x0000FEE5, 0x0000FEE3,
		0x0000FEE1, 0x0000FEDE, 0x0000FEDC, 0x0000FEDA,
		0x0000FED7, 0x0000FED5, 0x0000FED3, 0x0000FED0,
		0x0000FECE, 0x0000FECB, 0x0000FEC9, 0x0000FEC6,
		0x0000FEC4, 0x0000FEC1, 0x0000FEBF, 0x0000FEBC,
		0x0000FEBA, 0x0000FEB7, 0x0000FEB5, 0x0000FEB2,
		0x0000FEB0, 0x0000FEAD, 0x0000FEAB, 0x0000FEA8,
		0x0000FEA6, 0x0000FEA3, 0x0000FEA0, 0x0000FE9E,
		0x0000FE9B, 0x0000FE99, 0x0000FE96, 0x0000FE93,
		0x0000FE91, 0x0000FE8E, 0x0000FE8B, 0x0000FE89,
		0x0000FE86, 0x0000FE83, 0x0000FE81, 0x0000FE7E,
		0x0000FE7B, 0x0000FE78, 0x0000FE76, 0x0000FE73,
		0x0000FE70, 0x0000FE6D, 0x0000FE6B, 0x0000FE68,
		0x0000FE65, 0x0000FE62, 0x0000FE5F, 0x0000FE5D,
		0x0000FE5A, 0x0000FE57, 0x0000FE54, 0x0000FE51,
		0x0000FE4E, 0x0000FE4B, 0x0000FE48, 0x0000FE46,
		0x0000FE43, 0x0000FE40, 0x0000FE3D, 0x0000FE3A,
		0x0000FE37, 0x0000FE34, 0x0000FE31, 0x0000FE2E,
		0x0000FE2B, 0x0000FE28, 0x0000FE25, 0x0000FE22,
		0x0000FE1F, 0x0000FE1C, 0x0000FE19, 0x0000FE16,
		0x0000FE13, 0x0000FE10, 0x0000FE0C, 0x0000FE09,
		0x0000FE06, 0x0000FE03, 0x0000FE00, 0x0000FDFD,
		0x0000FDFA, 0x0000FDF7, 0x0000FDF3, 0x0000FDF0,
		0x0000FDED, 0x0000FDEA, 0x0000FDE7, 0x0000FDE3,
		0x0000FDE0, 0x0000FDDD, 0x0000FDDA, 0x0000FDD6,
		0x0000FDD3, 0x0000FDD0, 0x0000FDCD, 0x0000FDC9,
		0x0000FDC6, 0x0000FDC3, 0x0000FDBF, 0x0000FDBC,
		0x0000FDB9, 0x0000FDB5, 0x0000FDB2, 0x0000FDAF,
		0x0000FDAB, 0x0000FDA8, 0x0000FDA5, 0x0000FDA1,
		0x0000FD9E, 0x0000FD9A, 0x0000FD97, 0x0000FD93,
		0x0000FD90, 0x0000FD8C, 0x0000FD89, 0x0000FD86,
		0x0000FD82, 0x0000FD7F, 0x0000FD7B, 0x0000FD77,
		0x0000FD74, 0x0000FD70, 0x0000FD6D, 0x0000FD69,
		0x0000FD66, 0x0000FD62, 0x0000FD5F, 0x0000FD5B,
		0x0000FD57, 0x0000FD54, 0x0000FD50, 0x0000FD4C,
		0x0000FD49, 0x0000FD45, 0x0000FD42, 0x0000FD3E,
		0x0000FD3A, 0x0000FD36, 0x0000FD33, 0x0000FD2F,
		0x0000FD2B, 0x0000FD28, 0x0000FD24, 0x0000FD20,
		0x0000FD1C, 0x0000FD19, 0x0000FD15, 0x0000FD11,
		0x0000FD0D, 0x0000FD09, 0x0000FD06, 0x0000FD02,
		0x0000FCFE, 0x0000FCFA, 0x0000FCF6, 0x0000FCF2,
		0x0000FCEF, 0x0000FCEB, 0x0000FCE7, 0x0000FCE3,
		0x0000FCDF, 0x0000FCDB, 0x0000FCD7, 0x0000FCD3,
		0x0000FCCF, 0x0000FCCB, 0x0000FCC7, 0x0000FCC3,
		0x0000FCBF, 0x0000FCBB, 0x0000FCB7, 0x0000FCB3,
		0x0000FCAF, 0x0000FCAB, 0x0000FCA7, 0x0000FCA3,
		0x0000FC9F, 0x0000FC9B, 0x0000FC97, 0x0000FC93,
		0x0000FC8F, 0x0000FC8B, 0x0000FC86, 0x0000FC82,
		0x0000FC7E, 0x0000FC7A, 0x0000FC76, 0x0000FC72,
		0x0000FC6E, 0x0000FC69, 0x0000FC65, 0x0000FC61,
		0x0000FC5D, 0x0000FC58, 0x0000FC54, 0x0000FC50,
		0x0000FC4C, 0x0000FC48, 0x0000FC43, 0x0000FC3F,
		0x0000FC3B, 0x0000FC36, 0x0000FC32, 0x0000FC2E,
		0x0000FC29, 0x0000FC25, 0x0000FC21, 0x0000FC1C,
		0x0000FC18, 0x0000FC14, 0x0000FC0F, 0x0000FC0B,
		0x0000FC06, 0x0000FC02, 0x0000FBFE, 0x0000FBF9,
		0x0000FBF5, 0x0000FBF0, 0x0000FBEC, 0x0000FBE7,
		0x0000FBE3, 0x0000FBDE, 0x0000FBDA, 0x0000FBD5,
		0x0000FBD1, 0x0000FBCC, 0x0000FBC8, 0x0000FBC3,
		0x0000FBBF, 0x0000FBBA, 0x0000FBB5, 0x0000FBB1,
		0x0000FBAC, 0x0000FBA8, 0x0000FBA3, 0x0000FB9E,
		0x0000FB9A, 0x0000FB95, 0x0000FB91, 0x0000FB8C,
		0x0000FB87, 0x0000FB83, 0x0000FB7E, 0x0000FB79,
		0x0000FB74, 0x0000FB70, 0x0000FB6B, 0x0000FB66,
		0x0000FB61, 0x0000FB5D, 0x0000FB58, 0x0000FB53,
		0x0000FB4E, 0x0000FB4A, 0x0000FB45, 0x0000FB40,
		0x0000FB3B, 0x0000FB36, 0x0000FB31, 0x0000FB2D,
		0x0000FB28, 0x0000FB23, 0x0000FB1E, 0x0000FB19,
		0x0000FB14, 0x0000FB0F, 0x0000FB0A, 0x0000FB05,
		0x0000FB01, 0x0000FAFC, 0x0000FAF7, 0x0000FAF2,
		0x0000FAED, 0x0000FAE8, 0x0000FAE3, 0x0000FADE,
		0x0000FAD9, 0x0000FAD4, 0x0000FACF, 0x0000FACA,
		0x0000FAC5, 0x0000FAC0, 0x0000FABA, 0x0000FAB5,
		0x0000FAB0, 0x0000FAAB, 0x0000FAA6, 0x0000FAA1,
		0x0000FA9C, 0x0000FA97, 0x0000FA92, 0x0000FA8C,
		0x0000FA87, 0x0000FA82, 0x0000FA7D, 0x0000FA78,
		0x0000FA73, 0x0000FA6D, 0x0000FA68, 0x0000FA63,
		0x0000FA5E, 0x0000FA58, 0x0000FA53, 0x0000FA4E,
		0x0000FA49, 0x0000FA43, 0x0000FA3E, 0x0000FA39,
		0x0000FA33, 0x0000FA2E, 0x0000FA29, 0x0000FA23,
		0x0000FA1E, 0x0000FA19, 0x0000FA13, 0x0000FA0E,
		0x0000FA09, 0x0000FA03, 0x0000F9FE, 0x0000F9F8,
		0x0000F9F3, 0x0000F9ED, 0x0000F9E8, 0x0000F9E3,
		0x0000F9DD, 0x0000F9D8, 0x0000F9D2, 0x0000F9CD,
		0x0000F9C7, 0x0000F9C2, 0x0000F9BC, 0x0000F9B7,
		0x0000F9B1, 0x0000F9AB, 0x0000F9A6, 0x0000F9A0,
		0x0000F99B, 0x0000F995, 0x0000F990, 0x0000F98A,
		0x0000F984, 0x0000F97F, 0x0000F979, 0x0000F973,
		0x0000F96E, 0x0000F968, 0x0000F962, 0x0000F95D,
		0x0000F957, 0x0000F951, 0x0000F94C, 0x0000F946,
		0x0000F940, 0x0000F93B, 0x0000F935, 0x0000F92F,
		0x0000F929, 0x0000F923, 0x0000F91E, 0x0000F918,
		0x0000F912, 0x0000F90C, 0x0000F906, 0x0000F901,
		0x0000F8FB, 0x0000F8F5, 0x0000F8EF, 0x0000F8E9,
		0x0000F8E3, 0x0000F8DD, 0x0000F8D8, 0x0000F8D2,
		0x0000F8CC, 0x0000F8C6, 0x0000F8C0, 0x0000F8BA,
		0x0000F8B4, 0x0000F8AE, 0x0000F8A8, 0x0000F8A2,
		0x0000F89C, 0x0000F896, 0x0000F890, 0x0000F88A,
		0x0000F884, 0x0000F87E, 0x0000F878, 0x0000F872,
		0x0000F86C, 0x0000F866, 0x0000F860, 0x0000F85A,
		0x0000F853, 0x0000F84D, 0x0000F847, 0x0000F841,
		0x0000F83B, 0x0000F835, 0x0000F82F, 0x0000F828,
		0x0000F822, 0x0000F81C, 0x0000F816, 0x0000F810,
		0x0000F80A, 0x0000F803, 0x0000F7FD, 0x0000F7F7,
		0x0000F7F1, 0x0000F7EA, 0x0000F7E4, 0x0000F7DE,
		0x0000F7D7, 0x0000F7D1, 0x0000F7CB, 0x0000F7C5,
		0x0000F7BE, 0x0000F7B8, 0x0000F7B2, 0x0000F7AB,
		0x0000F7A5, 0x0000F79E, 0x0000F798, 0x0000F792,
		0x0000F78B, 0x0000F785, 0x0000F77E, 0x0000F778,
		0x0000F772, 0x0000F76B, 0x0000F765, 0x0000F75E,
		0x0000F758, 0x0000F751, 0x0000F74B, 0x0000F744,
		0x0000F73E, 0x0000F737, 0x0000F731, 0x0000F72A,
		0x0000F724, 0x0000F71D, 0x0000F716, 0x0000F710,
		0x0000F709, 0x0000F703, 0x0000F6FC, 0x0000F6F5,
		0x0000F6EF, 0x0000F6E8, 0x0000F6E2, 0x0000F6DB,
		0x0000F6D4, 0x0000F6CE, 0x0000F6C7, 0x0000F6C0,
		0x0000F6BA, 0x0000F6B3, 0x0000F6AC, 0x0000F6A5,
		0x0000F69F, 0x0000F698, 0x0000F691, 0x0000F68A,
		0x0000F684, 0x0000F67D, 0x0000F676, 0x0000F66F,
		0x0000F668, 0x0000F662, 0x0000F65B, 0x0000F654,
		0x0000F64D, 0x0000F646, 0x0000F63F, 0x0000F638,
		0x0000F632, 0x0000F62B, 0x0000F624, 0x0000F61D,
		0x0000F616, 0x0000F60F, 0x0000F608, 0x0000F601,
		0x0000F5FA, 0x0000F5F3, 0x0000F5EC, 0x0000F5E5,
		0x0000F5DE, 0x0000F5D7, 0x0000F5D0, 0x0000F5C9,
		0x0000F5C2, 0x0000F5BB, 0x0000F5B4, 0x0000F5AD,
		0x0000F5A6, 0x0000F59F, 0x0000F598, 0x0000F591,
		0x0000F58A, 0x0000F582, 0x0000F57B, 0x0000F574,
		0x0000F56D, 0x0000F566, 0x0000F55F, 0x0000F558,
		0x0000F550, 0x0000F549, 0x0000F542, 0x0000F53B,
		0x0000F534, 0x0000F52C, 0x0000F525, 0x0000F51E,
		0x0000F517, 0x0000F50F, 0x0000F508, 0x0000F501,
		0x0000F4FA, 0x0000F4F2, 0x0000F4EB, 0x0000F4E4,
		0x0000F4DC, 0x0000F4D5, 0x0000F4CE, 0x0000F4C6,
		0x0000F4BF, 0x0000F4B8, 0x0000F4B0, 0x0000F4A9,
		0x0000F4A1, 0x0000F49A, 0x0000F492, 0x0000F48B,
		0x0000F484, 0x0000F47C, 0x0000F475, 0x0000F46D,
		0x0000F466, 0x0000F45E, 0x0000F457, 0x0000F44F,
		0x0000F448, 0x0000F440, 0x0000F439, 0x0000F431,
		0x0000F42A, 0x0000F422, 0x0000F41B, 0x0000F413,
		0x0000F40B, 0x0000F404, 0x0000F3FC, 0x0000F3F5,
		0x0000F3ED, 0x0000F3E5, 0x0000F3DE, 0x0000F3D6,
		0x0000F3CE, 0x0000F3C7, 0x0000F3BF, 0x0000F3B7,
		0x0000F3B0, 0x0000F3A8, 0x0000F3A0, 0x0000F398,
		0x0000F391, 0x0000F389, 0x0000F381, 0x0000F379,
		0x0000F372, 0x0000F36A, 0x0000F362, 0x0000F35A,
		0x0000F353, 0x0000F34B, 0x0000F343, 0x0000F33B,
		0x0000F333, 0x0000F32B, 0x0000F324, 0x0000F31C,
		0x0000F314, 0x0000F30C, 0x0000F304, 0x0000F2FC,
		0x0000F2F4, 0x0000F2EC, 0x0000F2E4, 0x0000F2DC,
		0x0000F2D4, 0x0000F2CC, 0x0000F2C4, 0x0000F2BD,
		0x0000F2B5, 0x0000F2AD, 0x0000F2A5, 0x0000F29C,
		0x0000F294, 0x0000F28C, 0x0000F284, 0x0000F27C,
		0x0000F274, 0x0000F26C, 0x0000F264, 0x0000F25C,
		0x0000F254, 0x0000F24C, 0x0000F244, 0x0000F23C,
		0x0000F233, 0x0000F22B, 0x0000F223, 0x0000F21B,
		0x0000F213, 0x0000F20B, 0x0000F202, 0x0000F1FA,
		0x0000F1F2, 0x0000F1EA, 0x0000F1E2, 0x0000F1D9,
		0x0000F1D1, 0x0000F1C9, 0x0000F1C1, 0x0000F1B8,
		0x0000F1B0, 0x0000F1A8, 0x0000F19F, 0x0000F197,
		0x0000F18F, 0x0000F187, 0x0000F17E, 0x0000F176,
		0x0000F16D, 0x0000F165, 0x0000F15D, 0x0000F154,
		0x0000F14C, 0x0000F144, 0x0000F13B, 0x0000F133,
		0x0000F12A, 0x0000F122, 0x0000F119, 0x0000F111,
		0x0000F109, 0x0000F100, 0x0000F0F8, 0x0000F0EF,
		0x0000F0E7, 0x0000F0DE, 0x0000F0D6, 0x0000F0CD,
		0x0000F0C5, 0x0000F0BC, 0x0000F0B3, 0x0000F0AB,
		0x0000F0A2, 0x0000F09A, 0x0000F091, 0x0000F089,
		0x0000F080, 0x0000F077, 0x0000F06F, 0x0000F066,
		0x0000F05D, 0x0000F055, 0x0000F04C, 0x0000F043,
		0x0000F03B, 0x0000F032, 0x0000F029, 0x0000F021,
		0x0000F018, 0x0000F00F, 0x0000F006, 0x0000EFFE,
		0x0000EFF5, 0x0000EFEC, 0x0000EFE3, 0x0000EFDB,
		0x0000EFD2, 0x0000EFC9, 0x0000EFC0, 0x0000EFB7,
		0x0000EFAF, 0x0000EFA6, 0x0000EF9D, 0x0000EF94,
		0x0000EF8B, 0x0000EF82, 0x0000EF79, 0x0000EF71,
		0x0000EF68, 0x0000EF5F, 0x0000EF56, 0x0000EF4D,
		0x0000EF44, 0x0000EF3B, 0x0000EF32, 0x0000EF29,
		0x0000EF20, 0x0000EF17, 0x0000EF0E, 0x0000EF05,
		0x0000EEFC, 0x0000EEF3, 0x0000EEEA, 0x0000EEE1,
		0x0000EED8, 0x0000EECF, 0x0000EEC6, 0x0000EEBD,
		0x0000EEB4, 0x0000EEAB, 0x0000EEA2, 0x0000EE99,
		0x0000EE8F, 0x0000EE86, 0x0000EE7D, 0x0000EE74,
		0x0000EE6B, 0x0000EE62, 0x0000EE59, 0x0000EE4F,
		0x0000EE46, 0x0000EE3D, 0x0000EE34, 0x0000EE2B,
		0x0000EE21, 0x0000EE18, 0x0000EE0F, 0x0000EE06,
		0x0000EDFC, 0x0000EDF3, 0x0000EDEA, 0x0000EDE1,
		0x0000EDD7, 0x0000EDCE, 0x0000EDC5, 0x0000EDBB,
		0x0000EDB2, 0x0000EDA9, 0x0000ED9F, 0x0000ED96,
		0x0000ED8D, 0x0000ED83, 0x0000ED7A, 0x0000ED71,
		0x0000ED67, 0x0000ED5E, 0x0000ED54, 0x0000ED4B,
		0x0000ED41, 0x0000ED38, 0x0000ED2F, 0x0000ED25,
		0x0000ED1C, 0x0000ED12, 0x0000ED09, 0x0000ECFF,
		0x0000ECF6, 0x0000ECEC, 0x0000ECE3, 0x0000ECD9,
		0x0000ECD0, 0x0000ECC6, 0x0000ECBC, 0x0000ECB3,
		0x0000ECA9, 0x0000ECA0, 0x0000EC96, 0x0000EC8C,
		0x0000EC83, 0x0000EC79, 0x0000EC70, 0x0000EC66,
		0x0000EC5C, 0x0000EC53, 0x0000EC49, 0x0000EC3F,
		0x0000EC36, 0x0000EC2C, 0x0000EC22, 0x0000EC19,
		0x0000EC0F, 0x0000EC05, 0x0000EBFB, 0x0000EBF2,
		0x0000EBE8, 0x0000EBDE, 0x0000EBD4, 0x0000EBCB,
		0x0000EBC1, 0x0000EBB7, 0x0000EBAD, 0x0000EBA3,
		0x0000EB99, 0x0000EB90, 0x0000EB86, 0x0000EB7C,
		0x0000EB72, 0x0000EB68, 0x0000EB5E, 0x0000EB54,
		0x0000EB4B, 0x0000EB41, 0x0000EB37, 0x0000EB2D,
		0x0000EB23, 0x0000EB19, 0x0000EB0F, 0x0000EB05,
		0x0000EAFB, 0x0000EAF1, 0x0000EAE7, 0x0000EADD,
		0x0000EAD3, 0x0000EAC9, 0x0000EABF, 0x0000EAB5,
		0x0000EAAB, 0x0000EAA1, 0x0000EA97, 0x0000EA8D,
		0x0000EA83, 0x0000EA79, 0x0000EA6F, 0x0000EA64,
		0x0000EA5A, 0x0000EA50, 0x0000EA46, 0x0000EA3C,
		0x0000EA32, 0x0000EA28, 0x0000EA1E, 0x0000EA13,
		0x0000EA09, 0x0000E9FF, 0x0000E9F5, 0x0000E9EB,
		0x0000E9E0, 0x0000E9D6, 0x0000E9CC, 0x0000E9C2,
		0x0000E9B7, 0x0000E9AD, 0x0000E9A3, 0x0000E999,
		0x0000E98E, 0x0000E984, 0x0000E97A, 0x0000E96F,
		0x0000E965, 0x0000E95B, 0x0000E950, 0x0000E946,
		0x0000E93C, 0x0000E931, 0x0000E927, 0x0000E91D,
		0x0000E912, 0x0000E908, 0x0000E8FD, 0x0000E8F3,
		0x0000E8E9, 0x0000E8DE, 0x0000E8D4, 0x0000E8C9,
		0x0000E8BF, 0x0000E8B4, 0x0000E8AA, 0x0000E89F,
		0x0000E895, 0x0000E88A, 0x0000E880, 0x0000E875,
		0x0000E86B, 0x0000E860, 0x0000E856, 0x0000E84B,
		0x0000E841, 0x0000E836, 0x0000E82B, 0x0000E821,
		0x0000E816, 0x0000E80C, 0x0000E801, 0x0000E7F6,
		0x0000E7EC, 0x0000E7E1, 0x0000E7D6, 0x0000E7CC,
		0x0000E7C1, 0x0000E7B6, 0x0000E7AC, 0x0000E7A1,
		0x0000E796, 0x0000E78C, 0x0000E781, 0x0000E776,
		0x0000E76B, 0x0000E761, 0x0000E756, 0x0000E74B,
		0x0000E740, 0x0000E736, 0x0000E72B, 0x0000E720,
		0x0000E715, 0x0000E70A, 0x0000E6FF, 0x0000E6F5,
		0x0000E6EA, 0x0000E6DF, 0x0000E6D4, 0x0000E6C9,
		0x0000E6BE, 0x0000E6B3, 0x0000E6A9, 0x0000E69E,
		0x0000E693, 0x0000E688, 0x0000E67D, 0x0000E672,
		0x0000E667, 0x0000E65C, 0x0000E651, 0x0000E646,
		0x0000E63B, 0x0000E630, 0x0000E625, 0x0000E61A,
		0x0000E60F, 0x0000E604, 0x0000E5F9, 0x0000E5EE,
		0x0000E5E3, 0x0000E5D8, 0x0000E5CD, 0x0000E5C2,
		0x0000E5B7, 0x0000E5AB, 0x0000E5A0, 0x0000E595,
		0x0000E58A, 0x0000E57F, 0x0000E574, 0x0000E569,
		0x0000E55E, 0x0000E552, 0x0000E547, 0x0000E53C,
		0x0000E531, 0x0000E526, 0x0000E51A, 0x0000E50F,
		0x0000E504, 0x0000E4F9, 0x0000E4ED, 0x0000E4E2,
		0x0000E4D7, 0x0000E4CC, 0x0000E4C0, 0x0000E4B5,
		0x0000E4AA, 0x0000E49F, 0x0000E493, 0x0000E488,
		0x0000E47D, 0x0000E471, 0x0000E466, 0x0000E45B,
		0x0000E44F, 0x0000E444, 0x0000E438, 0x0000E42D,
		0x0000E422, 0x0000E416, 0x0000E40B, 0x0000E3FF,
		0x0000E3F4, 0x0000E3E9, 0x0000E3DD, 0x0000E3D2,
		0x0000E3C6, 0x0000E3BB, 0x0000E3AF, 0x0000E3A4,
		0x0000E398, 0x0000E38D, 0x0000E381, 0x0000E376,
		0x0000E36A, 0x0000E35F, 0x0000E353, 0x0000E347,
		0x0000E33C, 0x0000E330, 0x0000E325, 0x0000E319,
		0x0000E30D, 0x0000E302, 0x0000E2F6, 0x0000E2EB,
		0x0000E2DF, 0x0000E2D3, 0x0000E2C8, 0x0000E2BC,
		0x0000E2B0, 0x0000E2A5, 0x0000E299, 0x0000E28D,
		0x0000E282, 0x0000E276, 0x0000E26A, 0x0000E25E,
		0x0000E253, 0x0000E247, 0x0000E23B, 0x0000E22F,
		0x0000E224, 0x0000E218, 0x0000E20C, 0x0000E200,
		0x0000E1F4, 0x0000E1E9, 0x0000E1DD, 0x0000E1D1,
		0x0000E1C5, 0x0000E1B9, 0x0000E1AD, 0x0000E1A2,
		0x0000E196, 0x0000E18A, 0x0000E17E, 0x0000E172,
		0x0000E166, 0x0000E15A, 0x0000E14E, 0x0000E142,
		0x0000E136, 0x0000E12A, 0x0000E11E, 0x0000E112,
		0x0000E106, 0x0000E0FA, 0x0000E0EE, 0x0000E0E2,
		0x0000E0D6, 0x0000E0CA, 0x0000E0BE, 0x0000E0B2,
		0x0000E0A6, 0x0000E09A, 0x0000E08E, 0x0000E082,
		0x0000E076, 0x0000E06A, 0x0000E05E, 0x0000E052,
		0x0000E046, 0x0000E03A, 0x0000E02D, 0x0000E021,
		0x0000E015, 0x0000E009, 0x0000DFFD, 0x0000DFF1,
		0x0000DFE4, 0x0000DFD8, 0x0000DFCC, 0x0000DFC0,
		0x0000DFB4, 0x0000DFA7, 0x0000DF9B, 0x0000DF8F,
		0x0000DF83, 0x0000DF76, 0x0000DF6A, 0x0000DF5E,
		0x0000DF52, 0x0000DF45, 0x0000DF39, 0x0000DF2D,
		0x0000DF20, 0x0000DF14, 0x0000DF08, 0x0000DEFB,
		0x0000DEEF, 0x0000DEE3, 0x0000DED6, 0x0000DECA,
		0x0000DEBE, 0x0000DEB1, 0x0000DEA5, 0x0000DE98,
		0x0000DE8C, 0x0000DE7F, 0x0000DE73, 0x0000DE67,
		0x0000DE5A, 0x0000DE4E, 0x0000DE41, 0x0000DE35,
		0x0000DE28, 0x0000DE1C, 0x0000DE0F, 0x0000DE03,
		0x0000DDF6, 0x0000DDEA, 0x0000DDDD, 0x0000DDD1,
		0x0000DDC4, 0x0000DDB8, 0x0000DDAB, 0x0000DD9E,
		0x0000DD92, 0x0000DD85, 0x0000DD79, 0x0000DD6C,
		0x0000DD5F, 0x0000DD53, 0x0000DD46, 0x0000DD39,
		0x0000DD2D, 0x0000DD20, 0x0000DD13, 0x0000DD07,
		0x0000DCFA, 0x0000DCED, 0x0000DCE1, 0x0000DCD4,
		0x0000DCC7, 0x0000DCBB, 0x0000DCAE, 0x0000DCA1,
		0x0000DC94, 0x0000DC88, 0x0000DC7B, 0x0000DC6E,
		0x0000DC61, 0x0000DC54, 0x0000DC48, 0x0000DC3B,
		0x0000DC2E, 0x0000DC21, 0x0000DC14, 0x0000DC08,
		0x0000DBFB, 0x0000DBEE, 0x0000DBE1, 0x0000DBD4,
		0x0000DBC7, 0x0000DBBA, 0x0000DBAD, 0x0000DBA1,
		0x0000DB94, 0x0000DB87, 0x0000DB7A, 0x0000DB6D,
		0x0000DB60, 0x0000DB53, 0x0000DB46, 0x0000DB39,
		0x0000DB2C, 0x0000DB1F, 0x0000DB12, 0x0000DB05,
		0x0000DAF8, 0x0000DAEB, 0x0000DADE, 0x0000DAD1,
		0x0000DAC4, 0x0000DAB7, 0x0000DAAA, 0x0000DA9D,
		0x0000DA90, 0x0000DA82, 0x0000DA75, 0x0000DA68,
		0x0000DA5B, 0x0000DA4E, 0x0000DA41, 0x0000DA34,
		0x0000DA27, 0x0000DA19, 0x0000DA0C, 0x0000D9FF,
		0x0000D9F2, 0x0000D9E5, 0x0000D9D8, 0x0000D9CA,
		0x0000D9BD, 0x0000D9B0, 0x0000D9A3, 0x0000D995,
		0x0000D988, 0x0000D97B, 0x0000D96E, 0x0000D960,
		0x0000D953, 0x0000D946, 0x0000D939, 0x0000D92B,
		0x0000D91E, 0x0000D911, 0x0000D903, 0x0000D8F6,
		0x0000D8E9, 0x0000D8DB, 0x0000D8CE, 0x0000D8C1,
		0x0000D8B3, 0x0000D8A6, 0x0000D898, 0x0000D88B,
		0x0000D87E, 0x0000D870, 0x0000D863, 0x0000D855,
		0x0000D848, 0x0000D83A, 0x0000D82D, 0x0000D81F,
		0x0000D812, 0x0000D804, 0x0000D7F7, 0x0000D7E9,
		0x0000D7DC, 0x0000D7CE, 0x0000D7C1, 0x0000D7B3,
		0x0000D7A6, 0x0000D798, 0x0000D78B, 0x0000D77D,
		0x0000D770, 0x0000D762, 0x0000D754, 0x0000D747,
		0x0000D739, 0x0000D72C, 0x0000D71E, 0x0000D710,
		0x0000D703, 0x0000D6F5, 0x0000D6E7, 0x0000D6DA,
		0x0000D6CC, 0x0000D6BE, 0x0000D6B1, 0x0000D6A3,
		0x0000D695, 0x0000D688, 0x0000D67A, 0x0000D66C,
		0x0000D65F, 0x0000D651, 0x0000D643, 0x0000D635,
		0x0000D627, 0x0000D61A, 0x0000D60C, 0x0000D5FE,
		0x0000D5F0, 0x0000D5E3, 0x0000D5D5, 0x0000D5C7,
		0x0000D5B9, 0x0000D5AB, 0x0000D59D, 0x0000D590,
		0x0000D582, 0x0000D574, 0x0000D566, 0x0000D558,
		0x0000D54A, 0x0000D53C, 0x0000D52E, 0x0000D520,
		0x0000D512, 0x0000D505, 0x0000D4F7, 0x0000D4E9,
		0x0000D4DB, 0x0000D4CD, 0x0000D4BF, 0x0000D4B1,
		0x0000D4A3, 0x0000D495, 0x0000D487, 0x0000D479,
		0x0000D46B, 0x0000D45D, 0x0000D44F, 0x0000D441,
		0x0000D433, 0x0000D424, 0x0000D416, 0x0000D408,
		0x0000D3FA, 0x0000D3EC, 0x0000D3DE, 0x0000D3D0,
		0x0000D3C2, 0x0000D3B4, 0x0000D3A6, 0x0000D397,
		0x0000D389, 0x0000D37B, 0x0000D36D, 0x0000D35F,
		0x0000D351, 0x0000D342, 0x0000D334, 0x0000D326,
		0x0000D318, 0x0000D30A, 0x0000D2FB, 0x0000D2ED,
		0x0000D2DF, 0x0000D2D1, 0x0000D2C2, 0x0000D2B4,
		0x0000D2A6, 0x0000D297, 0x0000D289, 0x0000D27B,
		0x0000D26D, 0x0000D25E, 0x0000D250, 0x0000D242,
		0x0000D233, 0x0000D225, 0x0000D217, 0x0000D208,
		0x0000D1FA, 0x0000D1EB, 0x0000D1DD, 0x0000D1CF,
		0x0000D1C0, 0x0000D1B2, 0x0000D1A3, 0x0000D195,
		0x0000D187, 0x0000D178, 0x0000D16A, 0x0000D15B,
		0x0000D14D, 0x0000D13E, 0x0000D130, 0x0000D121,
		0x0000D113, 0x0000D104, 0x0000D0F6, 0x0000D0E7,
		0x0000D0D9, 0x0000D0CA, 0x0000D0BC, 0x0000D0AD,
		0x0000D09F, 0x0000D090, 0x0000D081, 0x0000D073,
		0x0000D064, 0x0000D056, 0x0000D047, 0x0000D038,
		0x0000D02A, 0x0000D01B, 0x0000D00C, 0x0000CFFE,
		0x0000CFEF, 0x0000CFE0, 0x0000CFD2, 0x0000CFC3,
		0x0000CFB4, 0x0000CFA6, 0x0000CF97, 0x0000CF88,
		0x0000CF7A, 0x0000CF6B, 0x0000CF5C, 0x0000CF4D,
		0x0000CF3F, 0x0000CF30, 0x0000CF21, 0x0000CF12,
		0x0000CF04, 0x0000CEF5, 0x0000CEE6, 0x0000CED7,
		0x0000CEC8, 0x0000CEBA, 0x0000CEAB, 0x0000CE9C,
		0x0000CE8D, 0x0000CE7E, 0x0000CE6F, 0x0000CE60,
		0x0000CE52, 0x0000CE43, 0x0000CE34, 0x0000CE25,
		0x0000CE16, 0x0000CE07, 0x0000CDF8, 0x0000CDE9,
		0x0000CDDA, 0x0000CDCB, 0x0000CDBC, 0x0000CDAD,
		0x0000CD9F, 0x0000CD90, 0x0000CD81, 0x0000CD72,
		0x0000CD63, 0x0000CD54, 0x0000CD45, 0x0000CD36,
		0x0000CD26, 0x0000CD17, 0x0000CD08, 0x0000CCF9,
		0x0000CCEA, 0x0000CCDB, 0x0000CCCC, 0x0000CCBD,
		0x0000CCAE, 0x0000CC9F, 0x0000CC90, 0x0000CC81,
		0x0000CC72, 0x0000CC62, 0x0000CC53, 0x0000CC44,
		0x0000CC35, 0x0000CC26, 0x0000CC17, 0x0000CC07,
		0x0000CBF8, 0x0000CBE9, 0x0000CBDA, 0x0000CBCB,
		0x0000CBBB, 0x0000CBAC, 0x0000CB9D, 0x0000CB8E,
		0x0000CB7F, 0x0000CB6F, 0x0000CB60, 0x0000CB51,
		0x0000CB41, 0x0000CB32, 0x0000CB23, 0x0000CB14,
		0x0000CB04, 0x0000CAF5, 0x0000CAE6, 0x0000CAD6,
		0x0000CAC7, 0x0000CAB8, 0x0000CAA8, 0x0000CA99,
		0x0000CA8A, 0x0000CA7A, 0x0000CA6B, 0x0000CA5B,
		0x0000CA4C, 0x0000CA3D, 0x0000CA2D, 0x0000CA1E,
		0x0000CA0E, 0x0000C9FF, 0x0000C9EF, 0x0000C9E0,
		0x0000C9D1, 0x0000C9C1, 0x0000C9B2, 0x0000C9A2,
		0x0000C993, 0x0000C983, 0x0000C974, 0x0000C964,
		0x0000C955, 0x0000C945, 0x0000C936, 0x0000C926,
		0x0000C916, 0x0000C907, 0x0000C8F7, 0x0000C8E8,
		0x0000C8D8, 0x0000C8C9, 0x0000C8B9, 0x0000C8A9,
		0x0000C89A, 0x0000C88A, 0x0000C87B, 0x0000C86B,
		0x0000C85B, 0x0000C84C, 0x0000C83C, 0x0000C82C,
		0x0000C81D, 0x0000C80D, 0x0000C7FD, 0x0000C7EE,
		0x0000C7DE, 0x0000C7CE, 0x0000C7BE, 0x0000C7AF,
		0x0000C79F, 0x0000C78F, 0x0000C780, 0x0000C770,
		0x0000C760, 0x0000C750, 0x0000C740, 0x0000C731,
		0x0000C721, 0x0000C711, 0x0000C701, 0x0000C6F1,
		0x0000C6E2, 0x0000C6D2, 0x0000C6C2, 0x0000C6B2,
		0x0000C6A2, 0x0000C692, 0x0000C683, 0x0000C673,
		0x0000C663, 0x0000C653, 0x0000C643, 0x0000C633,
		0x0000C623, 0x0000C613, 0x0000C603, 0x0000C5F3,
		0x0000C5E4, 0x0000C5D4, 0x0000C5C4, 0x0000C5B4,
		0x0000C5A4, 0x0000C594, 0x0000C584, 0x0000C574,
		0x0000C564, 0x0000C554, 0x0000C544, 0x0000C534,
		0x0000C524, 0x0000C514, 0x0000C504, 0x0000C4F4,
		0x0000C4E3, 0x0000C4D3, 0x0000C4C3, 0x0000C4B3,
		0x0000C4A3, 0x0000C493, 0x0000C483, 0x0000C473,
		0x0000C463, 0x0000C453, 0x0000C442, 0x0000C432,
		0x0000C422, 0x0000C412, 0x0000C402, 0x0000C3F2,
		0x0000C3E1, 0x0000C3D1, 0x0000C3C1, 0x0000C3B1,
		0x0000C3A1, 0x0000C390, 0x0000C380, 0x0000C370,
		0x0000C360, 0x0000C350, 0x0000C33F, 0x0000C32F,
		0x0000C31F, 0x0000C30F, 0x0000C2FE, 0x0000C2EE,
		0x0000C2DE, 0x0000C2CD, 0x0000C2BD, 0x0000C2AD,
		0x0000C29C, 0x0000C28C, 0x0000C27C, 0x0000C26B,
		0x0000C25B, 0x0000C24B, 0x0000C23A, 0x0000C22A,
		0x0000C21A, 0x0000C209, 0x0000C1F9, 0x0000C1E8,
		0x0000C1D8, 0x0000C1C8, 0x0000C1B7, 0x0000C1A7,
		0x0000C196, 0x0000C186, 0x0000C175, 0x0000C165,
		0x0000C154, 0x0000C144, 0x0000C133, 0x0000C123,
		0x0000C112, 0x0000C102, 0x0000C0F1, 0x0000C0E1,
		0x0000C0D0, 0x0000C0C0, 0x0000C0AF, 0x0000C09F,
		0x0000C08E, 0x0000C07E, 0x0000C06D, 0x0000C05C,
		0x0000C04C, 0x0000C03B, 0x0000C02B, 0x0000C01A,
		0x0000C009, 0x0000BFF9, 0x0000BFE8, 0x0000BFD8,
		0x0000BFC7, 0x0000BFB6, 0x0000BFA6, 0x0000BF95,
		0x0000BF84, 0x0000BF74, 0x0000BF63, 0x0000BF52,
		0x0000BF41, 0x0000BF31, 0x0000BF20, 0x0000BF0F,
		0x0000BEFF, 0x0000BEEE, 0x0000BEDD, 0x0000BECC,
		0x0000BEBC, 0x0000BEAB, 0x0000BE9A, 0x0000BE89,
		0x0000BE78, 0x0000BE68, 0x0000BE57, 0x0000BE46,
		0x0000BE35, 0x0000BE24, 0x0000BE14, 0x0000BE03,
		0x0000BDF2, 0x0000BDE1, 0x0000BDD0, 0x0000BDBF,
		0x0000BDAE, 0x0000BD9E, 0x0000BD8D, 0x0000BD7C,
		0x0000BD6B, 0x0000BD5A, 0x0000BD49, 0x0000BD38,
		0x0000BD27, 0x0000BD16, 0x0000BD05, 0x0000BCF4,
		0x0000BCE3, 0x0000BCD2, 0x0000BCC1, 0x0000BCB0,
		0x0000BCA0, 0x0000BC8F, 0x0000BC7E, 0x0000BC6C,
		0x0000BC5B, 0x0000BC4A, 0x0000BC39, 0x0000BC28,
		0x0000BC17, 0x0000BC06, 0x0000BBF5, 0x0000BBE4,
		0x0000BBD3, 0x0000BBC2, 0x0000BBB1, 0x0000BBA0,
		0x0000BB8F, 0x0000BB7E, 0x0000BB6C, 0x0000BB5B,
		0x0000BB4A, 0x0000BB39, 0x0000BB28, 0x0000BB17,
		0x0000BB06, 0x0000BAF4, 0x0000BAE3, 0x0000BAD2,
		0x0000BAC1, 0x0000BAB0, 0x0000BA9F, 0x0000BA8D,
		0x0000BA7C, 0x0000BA6B, 0x0000BA5A, 0x0000BA48,
		0x0000BA37, 0x0000BA26, 0x0000BA15, 0x0000BA03,
		0x0000B9F2, 0x0000B9E1, 0x0000B9D0, 0x0000B9BE,
		0x0000B9AD, 0x0000B99C, 0x0000B98A, 0x0000B979,
		0x0000B968, 0x0000B956, 0x0000B945, 0x0000B934,
		0x0000B922, 0x0000B911, 0x0000B900, 0x0000B8EE,
		0x0000B8DD, 0x0000B8CB, 0x0000B8BA, 0x0000B8A9,
		0x0000B897, 0x0000B886, 0x0000B874, 0x0000B863,
		0x0000B852, 0x0000B840, 0x0000B82F, 0x0000B81D,
		0x0000B80C, 0x0000B7FA, 0x0000B7E9, 0x0000B7D7,
		0x0000B7C6, 0x0000B7B4, 0x0000B7A3, 0x0000B791,
		0x0000B780, 0x0000B76E, 0x0000B75D, 0x0000B74B,
		0x0000B73A, 0x0000B728, 0x0000B717, 0x0000B705,
		0x0000B6F3, 0x0000B6E2, 0x0000B6D0, 0x0000B6BF,
		0x0000B6AD, 0x0000B69B, 0x0000B68A, 0x0000B678,
		0x0000B667, 0x0000B655, 0x0000B643, 0x0000B632,
		0x0000B620, 0x0000B60E, 0x0000B5FD, 0x0000B5EB,
		0x0000B5D9, 0x0000B5C8, 0x0000B5B6, 0x0000B5A4,
		0x0000B592, 0x0000B581, 0x0000B56F, 0x0000B55D,
		0x0000B54B, 0x0000B53A, 0x0000B528, 0x0000B516,
		0x0000B504, 0x0000B4F3, 0x0000B4E1, 0x0000B4CF,
		0x0000B4BD, 0x0000B4AB, 0x0000B49A, 0x0000B488,
		0x0000B476, 0x0000B464, 0x0000B452, 0x0000B441,
		0x0000B42F, 0x0000B41D, 0x0000B40B, 0x0000B3F9,
		0x0000B3E7, 0x0000B3D5, 0x0000B3C3, 0x0000B3B2,
		0x0000B3A0, 0x0000B38E, 0x0000B37C, 0x0000B36A,
		0x0000B358, 0x0000B346, 0x0000B334, 0x0000B322,
		0x0000B310, 0x0000B2FE, 0x0000B2EC, 0x0000B2DA,
		0x0000B2C8, 0x0000B2B6, 0x0000B2A4, 0x0000B292,
		0x0000B280, 0x0000B26E, 0x0000B25C, 0x0000B24A,
		0x0000B238, 0x0000B226, 0x0000B214, 0x0000B202,
		0x0000B1F0, 0x0000B1DE, 0x0000B1CC, 0x0000B1BA,
		0x0000B1A8, 0x0000B196, 0x0000B183, 0x0000B171,
		0x0000B15F, 0x0000B14D, 0x0000B13B, 0x0000B129,
		0x0000B117, 0x0000B104, 0x0000B0F2, 0x0000B0E0,
		0x0000B0CE, 0x0000B0BC, 0x0000B0AA, 0x0000B097,
		0x0000B085, 0x0000B073, 0x0000B061, 0x0000B04F,
		0x0000B03C, 0x0000B02A, 0x0000B018, 0x0000B006,
		0x0000AFF3, 0x0000AFE1, 0x0000AFCF, 0x0000AFBD,
		0x0000AFAA, 0x0000AF98, 0x0000AF86, 0x0000AF73,
		0x0000AF61, 0x0000AF4F, 0x0000AF3D, 0x0000AF2A,
		0x0000AF18, 0x0000AF06, 0x0000AEF3, 0x0000AEE1,
		0x0000AECE, 0x0000AEBC, 0x0000AEAA, 0x0000AE97,
		0x0000AE85, 0x0000AE73, 0x0000AE60, 0x0000AE4E,
		0x0000AE3B, 0x0000AE29, 0x0000AE17, 0x0000AE04,
		0x0000ADF2, 0x0000ADDF, 0x0000ADCD, 0x0000ADBA,
		0x0000ADA8, 0x0000AD95, 0x0000AD83, 0x0000AD70,
		0x0000AD5E, 0x0000AD4B, 0x0000AD39, 0x0000AD26,
		0x0000AD14, 0x0000AD01, 0x0000ACEF, 0x0000ACDC,
		0x0000ACCA, 0x0000ACB7, 0x0000ACA5, 0x0000AC92,
		0x0000AC80, 0x0000AC6D, 0x0000AC5A, 0x0000AC48,
		0x0000AC35, 0x0000AC23, 0x0000AC10, 0x0000ABFD,
		0x0000ABEB, 0x0000ABD8, 0x0000ABC6, 0x0000ABB3,
		0x0000ABA0, 0x0000AB8E, 0x0000AB7B, 0x0000AB68,
		0x0000AB56, 0x0000AB43, 0x0000AB30, 0x0000AB1E,
		0x0000AB0B, 0x0000AAF8, 0x0000AAE5, 0x0000AAD3,
		0x0000AAC0, 0x0000AAAD, 0x0000AA9B, 0x0000AA88,
		0x0000AA75, 0x0000AA62, 0x0000AA50, 0x0000AA3D,
		0x0000AA2A, 0x0000AA17, 0x0000AA04, 0x0000A9F2,
		0x0000A9DF, 0x0000A9CC, 0x0000A9B9, 0x0000A9A6,
		0x0000A994, 0x0000A981, 0x0000A96E, 0x0000A95B,
		0x0000A948, 0x0000A935, 0x0000A922, 0x0000A910,
		0x0000A8FD, 0x0000A8EA, 0x0000A8D7, 0x0000A8C4,
		0x0000A8B1, 0x0000A89E, 0x0000A88B, 0x0000A878,
		0x0000A866, 0x0000A853, 0x0000A840, 0x0000A82D,
		0x0000A81A, 0x0000A807, 0x0000A7F4, 0x0000A7E1,
		0x0000A7CE, 0x0000A7BB, 0x0000A7A8, 0x0000A795,
		0x0000A782, 0x0000A76F, 0x0000A75C, 0x0000A749,
		0x0000A736, 0x0000A723, 0x0000A710, 0x0000A6FD,
		0x0000A6EA, 0x0000A6D7, 0x0000A6C4, 0x0000A6B0,
		0x0000A69D, 0x0000A68A, 0x0000A677, 0x0000A664,
		0x0000A651, 0x0000A63E, 0x0000A62B, 0x0000A618,
		0x0000A605, 0x0000A5F1, 0x0000A5DE, 0x0000A5CB,
		0x0000A5B8, 0x0000A5A5, 0x0000A592, 0x0000A57E,
		0x0000A56B, 0x0000A558, 0x0000A545, 0x0000A532,
		0x0000A51F, 0x0000A50B, 0x0000A4F8, 0x0000A4E5,
		0x0000A4D2, 0x0000A4BE, 0x0000A4AB, 0x0000A498,
		0x0000A485, 0x0000A471, 0x0000A45E, 0x0000A44B,
		0x0000A438, 0x0000A424, 0x0000A411, 0x0000A3FE,
		0x0000A3EA, 0x0000A3D7, 0x0000A3C4, 0x0000A3B0,
		0x0000A39D, 0x0000A38A, 0x0000A376, 0x0000A363,
		0x0000A350, 0x0000A33C, 0x0000A329, 0x0000A316,
		0x0000A302, 0x0000A2EF, 0x0000A2DC, 0x0000A2C8,
		0x0000A2B5, 0x0000A2A1, 0x0000A28E, 0x0000A27B,
		0x0000A267, 0x0000A254, 0x0000A240, 0x0000A22D,
		0x0000A219, 0x0000A206, 0x0000A1F2, 0x0000A1DF,
		0x0000A1CB, 0x0000A1B8, 0x0000A1A5, 0x0000A191,
		0x0000A17E, 0x0000A16A, 0x0000A156, 0x0000A143,
		0x0000A12F, 0x0000A11C, 0x0000A108, 0x0000A0F5,
		0x0000A0E1, 0x0000A0CE, 0x0000A0BA, 0x0000A0A7,
		0x0000A093, 0x0000A07F, 0x0000A06C, 0x0000A058,
		0x0000A045, 0x0000A031, 0x0000A01E, 0x0000A00A,
		0x00009FF6, 0x00009FE3, 0x00009FCF, 0x00009FBB,
		0x00009FA8, 0x00009F94, 0x00009F80, 0x00009F6D,
		0x00009F59, 0x00009F45, 0x00009F32, 0x00009F1E,
		0x00009F0A, 0x00009EF7, 0x00009EE3, 0x00009ECF,
		0x00009EBC, 0x00009EA8, 0x00009E94, 0x00009E80,
		0x00009E6D, 0x00009E59, 0x00009E45, 0x00009E31,
		0x00009E1E, 0x00009E0A, 0x00009DF6, 0x00009DE2,
		0x00009DCF, 0x00009DBB, 0x00009DA7, 0x00009D93,
		0x00009D7F, 0x00009D6B, 0x00009D58, 0x00009D44,
		0x00009D30, 0x00009D1C, 0x00009D08, 0x00009CF4,
		0x00009CE1, 0x00009CCD, 0x00009CB9, 0x00009CA5,
		0x00009C91, 0x00009C7D, 0x00009C69, 0x00009C55,
		0x00009C42, 0x00009C2E, 0x00009C1A, 0x00009C06,
		0x00009BF2, 0x00009BDE, 0x00009BCA, 0x00009BB6,
		0x00009BA2, 0x00009B8E, 0x00009B7A, 0x00009B66,
		0x00009B52, 0x00009B3E, 0x00009B2A, 0x00009B16,
		0x00009B02, 0x00009AEE, 0x00009ADA, 0x00009AC6,
		0x00009AB2, 0x00009A9E, 0x00009A8A, 0x00009A76,
		0x00009A62, 0x00009A4E, 0x00009A3A, 0x00009A26,
		0x00009A12, 0x000099FE, 0x000099EA, 0x000099D6,
		0x000099C1, 0x000099AD, 0x00009999, 0x00009985,
		0x00009971, 0x0000995D, 0x00009949, 0x00009935,
		0x00009921, 0x0000990C, 0x000098F8, 0x000098E4,
		0x000098D0, 0x000098BC, 0x000098A8, 0x00009893,
		0x0000987F, 0x0000986B, 0x00009857, 0x00009843,
		0x0000982E, 0x0000981A, 0x00009806, 0x000097F2,
		0x000097DE, 0x000097C9, 0x000097B5, 0x000097A1,
		0x0000978D, 0x00009778, 0x00009764, 0x00009750,
		0x0000973C, 0x00009727, 0x00009713, 0x000096FF,
		0x000096EA, 0x000096D6, 0x000096C2, 0x000096AD,
		0x00009699, 0x00009685, 0x00009670, 0x0000965C,
		0x00009648, 0x00009633, 0x0000961F, 0x0000960B,
		0x000095F6, 0x000095E2, 0x000095CE, 0x000095B9,
		0x000095A5, 0x00009590, 0x0000957C, 0x00009568,
		0x00009553, 0x0000953F, 0x0000952A, 0x00009516,
		0x00009502, 0x000094ED, 0x000094D9, 0x000094C4,
		0x000094B0, 0x0000949B, 0x00009487, 0x00009472,
		0x0000945E, 0x00009449, 0x00009435, 0x00009420,
		0x0000940C, 0x000093F7, 0x000093E3, 0x000093CE,
		0x000093BA, 0x000093A5, 0x00009391, 0x0000937C,
		0x00009368, 0x00009353, 0x0000933F, 0x0000932A,
		0x00009315, 0x00009301, 0x000092EC, 0x000092D8,
		0x000092C3, 0x000092AE, 0x0000929A, 0x00009285,
		0x00009271, 0x0000925C, 0x00009247, 0x00009233,
		0x0000921E, 0x0000920A, 0x000091F5, 0x000091E0,
		0x000091CC, 0x000091B7, 0x000091A2, 0x0000918E,
		0x00009179, 0x00009164, 0x00009150, 0x0000913B,
		0x00009126, 0x00009111, 0x000090FD, 0x000090E8,
		0x000090D3, 0x000090BF, 0x000090AA, 0x00009095,
		0x00009080, 0x0000906C, 0x00009057, 0x00009042,
		0x0000902D, 0x00009019, 0x00009004, 0x00008FEF,
		0x00008FDA, 0x00008FC5, 0x00008FB1, 0x00008F9C,
		0x00008F87, 0x00008F72, 0x00008F5D, 0x00008F49,
		0x00008F34, 0x00008F1F, 0x00008F0A, 0x00008EF5,
		0x00008EE0, 0x00008ECB, 0x00008EB7, 0x00008EA2,
		0x00008E8D, 0x00008E78, 0x00008E63, 0x00008E4E,
		0x00008E39, 0x00008E24, 0x00008E10, 0x00008DFB,
		0x00008DE6, 0x00008DD1, 0x00008DBC, 0x00008DA7,
		0x00008D92, 0x00008D7D, 0x00008D68, 0x00008D53,
		0x00008D3E, 0x00008D29, 0x00008D14, 0x00008CFF,
		0x00008CEA, 0x00008CD5, 0x00008CC0, 0x00008CAB,
		0x00008C96, 0x00008C81, 0x00008C6C, 0x00008C57,
		0x00008C42, 0x00008C2D, 0x00008C18, 0x00008C03,
		0x00008BEE, 0x00008BD9, 0x00008BC4, 0x00008BAF,
		0x00008B9A, 0x00008B85, 0x00008B70, 0x00008B5B,
		0x00008B46, 0x00008B31, 0x00008B1B, 0x00008B06,
		0x00008AF1, 0x00008ADC, 0x00008AC7, 0x00008AB2,
		0x00008A9D, 0x00008A88, 0x00008A72, 0x00008A5D,
		0x00008A48, 0x00008A33, 0x00008A1E, 0x00008A09,
		0x000089F4, 0x000089DE, 0x000089C9, 0x000089B4,
		0x0000899F, 0x0000898A, 0x00008974, 0x0000895F,
		0x0000894A, 0x00008935, 0x00008920, 0x0000890A,
		0x000088F5, 0x000088E0, 0x000088CB, 0x000088B5,
		0x000088A0, 0x0000888B, 0x00008876, 0x00008860,
		0x0000884B, 0x00008836, 0x00008820, 0x0000880B,
		0x000087F6, 0x000087E1, 0x000087CB, 0x000087B6,
		0x000087A1, 0x0000878B, 0x00008776, 0x00008761,
		0x0000874B, 0x00008736, 0x00008721, 0x0000870B,
		0x000086F6, 0x000086E1, 0x000086CB, 0x000086B6,
		0x000086A1, 0x0000868B, 0x00008676, 0x00008660,
		0x0000864B, 0x00008636, 0x00008620, 0x0000860B,
		0x000085F5, 0x000085E0, 0x000085CB, 0x000085B5,
		0x000085A0, 0x0000858A, 0x00008575, 0x0000855F,
		0x0000854A, 0x00008534, 0x0000851F, 0x00008509,
		0x000084F4, 0x000084DF, 0x000084C9, 0x000084B4,
		0x0000849E, 0x00008489, 0x00008473, 0x0000845E,
		0x00008448, 0x00008433, 0x0000841D, 0x00008407,
		0x000083F2, 0x000083DC, 0x000083C7, 0x000083B1,
		0x0000839C, 0x00008386, 0x00008371, 0x0000835B,
		0x00008345, 0x00008330, 0x0000831A, 0x00008305,
		0x000082EF, 0x000082DA, 0x000082C4, 0x000082AE,
		0x00008299, 0x00008283, 0x0000826D, 0x00008258,
		0x00008242, 0x0000822D, 0x00008217, 0x00008201,
		0x000081EC, 0x000081D6, 0x000081C0, 0x000081AB,
		0x00008195, 0x0000817F, 0x0000816A, 0x00008154,
		0x0000813E, 0x00008128, 0x00008113, 0x000080FD,
		0x000080E7, 0x000080D2, 0x000080BC, 0x000080A6,
		0x00008090, 0x0000807B, 0x00008065, 0x0000804F,
		0x0000803A, 0x00008024, 0x0000800E, 0x00007FF8,
		0x00007FE2, 0x00007FCD, 0x00007FB7, 0x00007FA1,
		0x00007F8B, 0x00007F76, 0x00007F60, 0x00007F4A,
		0x00007F34, 0x00007F1E, 0x00007F09, 0x00007EF3,
		0x00007EDD, 0x00007EC7, 0x00007EB1, 0x00007E9B,
		0x00007E85, 0x00007E70, 0x00007E5A, 0x00007E44,
		0x00007E2E, 0x00007E18, 0x00007E02, 0x00007DEC,
		0x00007DD7, 0x00007DC1, 0x00007DAB, 0x00007D95,
		0x00007D7F, 0x00007D69, 0x00007D53, 0x00007D3D,
		0x00007D27, 0x00007D11, 0x00007CFB, 0x00007CE6,
		0x00007CD0, 0x00007CBA, 0x00007CA4, 0x00007C8E,
		0x00007C78, 0x00007C62, 0x00007C4C, 0x00007C36,
		0x00007C20, 0x00007C0A, 0x00007BF4, 0x00007BDE,
		0x00007BC8, 0x00007BB2, 0x00007B9C, 0x00007B86,
		0x00007B70, 0x00007B5A, 0x00007B44, 0x00007B2E,
		0x00007B18, 0x00007B02, 0x00007AEC, 0x00007AD6,
		0x00007AC0, 0x00007AAA, 0x00007A93, 0x00007A7D,
		0x00007A67, 0x00007A51, 0x00007A3B, 0x00007A25,
		0x00007A0F, 0x000079F9, 0x000079E3, 0x000079CD,
		0x000079B7, 0x000079A0, 0x0000798A, 0x00007974,
		0x0000795E, 0x00007948, 0x00007932, 0x0000791C,
		0x00007906, 0x000078EF, 0x000078D9, 0x000078C3,
		0x000078AD, 0x00007897, 0x00007881, 0x0000786A,
		0x00007854, 0x0000783E, 0x00007828, 0x00007812,
		0x000077FB, 0x000077E5, 0x000077CF, 0x000077B9,
		0x000077A3, 0x0000778C, 0x00007776, 0x00007760,
		0x0000774A, 0x00007733, 0x0000771D, 0x00007707,
		0x000076F1, 0x000076DA, 0x000076C4, 0x000076AE,
		0x00007698, 0x00007681, 0x0000766B, 0x00007655,
		0x0000763F, 0x00007628, 0x00007612, 0x000075FC,
		0x000075E5, 0x000075CF, 0x000075B9, 0x000075A2,
		0x0000758C, 0x00007576, 0x0000755F, 0x00007549,
		0x00007533, 0x0000751C, 0x00007506, 0x000074F0,
		0x000074D9, 0x000074C3, 0x000074AD, 0x00007496,
		0x00007480, 0x00007469, 0x00007453, 0x0000743D,
		0x00007426, 0x00007410, 0x000073F9, 0x000073E3,
		0x000073CD, 0x000073B6, 0x000073A0, 0x00007389,
		0x00007373, 0x0000735D, 0x00007346, 0x00007330,
		0x00007319, 0x00007303, 0x000072EC, 0x000072D6,
		0x000072BF, 0x000072A9, 0x00007292, 0x0000727C,
		0x00007265, 0x0000724F, 0x00007239, 0x00007222,
		0x0000720C, 0x000071F5, 0x000071DF, 0x000071C8,
		0x000071B1, 0x0000719B, 0x00007184, 0x0000716E,
		0x00007157, 0x00007141, 0x0000712A, 0x00007114,
		0x000070FD, 0x000070E7, 0x000070D0, 0x000070BA,
		0x000070A3, 0x0000708C, 0x00007076, 0x0000705F,
		0x00007049, 0x00007032, 0x0000701B, 0x00007005,
		0x00006FEE, 0x00006FD8, 0x00006FC1, 0x00006FAA,
		0x00006F94, 0x00006F7D, 0x00006F67, 0x00006F50,
		0x00006F39, 0x00006F23, 0x00006F0C, 0x00006EF5,
		0x00006EDF, 0x00006EC8, 0x00006EB1, 0x00006E9B,
		0x00006E84, 0x00006E6D, 0x00006E57, 0x00006E40,
		0x00006E29, 0x00006E13, 0x00006DFC, 0x00006DE5,
		0x00006DCF, 0x00006DB8, 0x00006DA1, 0x00006D8A,
		0x00006D74, 0x00006D5D, 0x00006D46, 0x00006D30,
		0x00006D19, 0x00006D02, 0x00006CEB, 0x00006CD5,
		0x00006CBE, 0x00006CA7, 0x00006C90, 0x00006C7A,
		0x00006C63, 0x00006C4C, 0x00006C35, 0x00006C1E,
		0x00006C08, 0x00006BF1, 0x00006BDA, 0x00006BC3,
		0x00006BAD, 0x00006B96, 0x00006B7F, 0x00006B68,
		0x00006B51, 0x00006B3A, 0x00006B24, 0x00006B0D,
		0x00006AF6, 0x00006ADF, 0x00006AC8, 0x00006AB1,
		0x00006A9B, 0x00006A84, 0x00006A6D, 0x00006A56,
		0x00006A3F, 0x00006A28, 0x00006A11, 0x000069FB,
		0x000069E4, 0x000069CD, 0x000069B6, 0x0000699F,
		0x00006988, 0x00006971, 0x0000695A, 0x00006943,
		0x0000692D, 0x00006916, 0x000068FF, 0x000068E8,
		0x000068D1, 0x000068BA, 0x000068A3, 0x0000688C,
		0x00006875, 0x0000685E, 0x00006847, 0x00006830,
		0x00006819, 0x00006802, 0x000067EB, 0x000067D4,
		0x000067BD, 0x000067A6, 0x0000678F, 0x00006778,
		0x00006761, 0x0000674A, 0x00006733, 0x0000671C,
		0x00006705, 0x000066EE, 0x000066D7, 0x000066C0,
		0x000066A9, 0x00006692, 0x0000667B, 0x00006664,
		0x0000664D, 0x00006636, 0x0000661F, 0x00006608,
		0x000065F1, 0x000065DA, 0x000065C3, 0x000065AC,
		0x00006595, 0x0000657E, 0x00006567, 0x00006550,
		0x00006539, 0x00006521, 0x0000650A, 0x000064F3,
		0x000064DC, 0x000064C5, 0x000064AE, 0x00006497,
		0x00006480, 0x00006469, 0x00006451, 0x0000643A,
		0x00006423, 0x0000640C, 0x000063F5, 0x000063DE,
		0x000063C7, 0x000063B0, 0x00006398, 0x00006381,
		0x0000636A, 0x00006353, 0x0000633C, 0x00006325,
		0x0000630D, 0x000062F6, 0x000062DF, 0x000062C8,
		0x000062B1, 0x00006299, 0x00006282, 0x0000626B,
		0x00006254, 0x0000623D, 0x00006225, 0x0000620E,
		0x000061F7, 0x000061E0, 0x000061C9, 0x000061B1,
		0x0000619A, 0x00006183, 0x0000616C, 0x00006154,
		0x0000613D, 0x00006126, 0x0000610F, 0x000060F7,
		0x000060E0, 0x000060C9, 0x000060B2, 0x0000609A,
		0x00006083, 0x0000606C, 0x00006054, 0x0000603D,
		0x00006026, 0x0000600F, 0x00005FF7, 0x00005FE0,
		0x00005FC9, 0x00005FB1, 0x00005F9A, 0x00005F83,
		0x00005F6B, 0x00005F54, 0x00005F3D, 0x00005F25,
		0x00005F0E, 0x00005EF7, 0x00005EDF, 0x00005EC8,
		0x00005EB1, 0x00005E99, 0x00005E82, 0x00005E6B,
		0x00005E53, 0x00005E3C, 0x00005E25, 0x00005E0D,
		0x00005DF6, 0x00005DDE, 0x00005DC7, 0x00005DB0,
		0x00005D98, 0x00005D81, 0x00005D6A, 0x00005D52,
		0x00005D3B, 0x00005D23, 0x00005D0C, 0x00005CF4,
		0x00005CDD, 0x00005CC6, 0x00005CAE, 0x00005C97,
		0x00005C7F, 0x00005C68, 0x00005C50, 0x00005C39,
		0x00005C22, 0x00005C0A, 0x00005BF3, 0x00005BDB,
		0x00005BC4, 0x00005BAC, 0x00005B95, 0x00005B7D,
		0x00005B66, 0x00005B4E, 0x00005B37, 0x00005B1F,
		0x00005B08, 0x00005AF0, 0x00005AD9, 0x00005AC1,
		0x00005AAA, 0x00005A92, 0x00005A7B, 0x00005A63,
		0x00005A4C, 0x00005A34, 0x00005A1D, 0x00005A05,
		0x000059EE, 0x000059D6, 0x000059BF, 0x000059A7,
		0x00005990, 0x00005978, 0x00005961, 0x00005949,
		0x00005931, 0x0000591A, 0x00005902, 0x000058EB,
		0x000058D3, 0x000058BC, 0x000058A4, 0x0000588C,
		0x00005875, 0x0000585D, 0x00005846, 0x0000582E,
		0x00005817, 0x000057FF, 0x000057E7, 0x000057D0,
		0x000057B8, 0x000057A0, 0x00005789, 0x00005771,
		0x0000575A, 0x00005742, 0x0000572A, 0x00005713,
		0x000056FB, 0x000056E3, 0x000056CC, 0x000056B4,
		0x0000569D, 0x00005685, 0x0000566D, 0x00005656,
		0x0000563E, 0x00005626, 0x0000560F, 0x000055F7,
		0x000055DF, 0x000055C8, 0x000055B0, 0x00005598,
		0x00005580, 0x00005569, 0x00005551, 0x00005539,
		0x00005522, 0x0000550A, 0x000054F2, 0x000054DB,
		0x000054C3, 0x000054AB, 0x00005493, 0x0000547C,
		0x00005464, 0x0000544C, 0x00005435, 0x0000541D,
		0x00005405, 0x000053ED, 0x000053D6, 0x000053BE,
		0x000053A6, 0x0000538E, 0x00005377, 0x0000535F,
		0x00005347, 0x0000532F, 0x00005317, 0x00005300,
		0x000052E8, 0x000052D0, 0x000052B8, 0x000052A1,
		0x00005289, 0x00005271, 0x00005259, 0x00005241,
		0x0000522A, 0x00005212, 0x000051FA, 0x000051E2,
		0x000051CA, 0x000051B3, 0x0000519B, 0x00005183,
		0x0000516B, 0x00005153, 0x0000513B, 0x00005124,
		0x0000510C, 0x000050F4, 0x000050DC, 0x000050C4,
		0x000050AC, 0x00005095, 0x0000507D, 0x00005065,
		0x0000504D, 0x00005035, 0x0000501D, 0x00005005,
		0x00004FED, 0x00004FD6, 0x00004FBE, 0x00004FA6,
		0x00004F8E, 0x00004F76, 0x00004F5E, 0x00004F46,
		0x00004F2E, 0x00004F16, 0x00004EFF, 0x00004EE7,
		0x00004ECF, 0x00004EB7, 0x00004E9F, 0x00004E87,
		0x00004E6F, 0x00004E57, 0x00004E3F, 0x00004E27,
		0x00004E0F, 0x00004DF7, 0x00004DDF, 0x00004DC8,
		0x00004DB0, 0x00004D98, 0x00004D80, 0x00004D68,
		0x00004D50, 0x00004D38, 0x00004D20, 0x00004D08,
		0x00004CF0, 0x00004CD8, 0x00004CC0, 0x00004CA8,
		0x00004C90, 0x00004C78, 0x00004C60, 0x00004C48,
		0x00004C30, 0x00004C18, 0x00004C00, 0x00004BE8,
		0x00004BD0, 0x00004BB8, 0x00004BA0, 0x00004B88,
		0x00004B70, 0x00004B58, 0x00004B40, 0x00004B28,
		0x00004B10, 0x00004AF8, 0x00004AE0, 0x00004AC8,
		0x00004AB0, 0x00004A98, 0x00004A80, 0x00004A68,
		0x00004A50, 0x00004A38, 0x00004A1F, 0x00004A07,
		0x000049EF, 0x000049D7, 0x000049BF, 0x000049A7,
		0x0000498F, 0x00004977, 0x0000495F, 0x00004947,
		0x0000492F, 0x00004917, 0x000048FF, 0x000048E7,
		0x000048CE, 0x000048B6, 0x0000489E, 0x00004886,
		0x0000486E, 0x00004856, 0x0000483E, 0x00004826,
		0x0000480E, 0x000047F5, 0x000047DD, 0x000047C5,
		0x000047AD, 0x00004795, 0x0000477D, 0x00004765,
		0x0000474D, 0x00004734, 0x0000471C, 0x00004704,
		0x000046EC, 0x000046D4, 0x000046BC, 0x000046A4,
		0x0000468B, 0x00004673, 0x0000465B, 0x00004643,
		0x0000462B, 0x00004613, 0x000045FA, 0x000045E2,
		0x000045CA, 0x000045B2, 0x0000459A, 0x00004581,
		0x00004569, 0x00004551, 0x00004539, 0x00004521,
		0x00004508, 0x000044F0, 0x000044D8, 0x000044C0,
		0x000044A8, 0x0000448F, 0x00004477, 0x0000445F,
		0x00004447, 0x0000442F, 0x00004416, 0x000043FE,
		0x000043E6, 0x000043CE, 0x000043B5, 0x0000439D,
		0x00004385, 0x0000436D, 0x00004354, 0x0000433C,
		0x00004324, 0x0000430C, 0x000042F3, 0x000042DB,
		0x000042C3, 0x000042AB, 0x00004292, 0x0000427A,
		0x00004262, 0x0000424A, 0x00004231, 0x00004219,
		0x00004201, 0x000041E8, 0x000041D0, 0x000041B8,
		0x000041A0, 0x00004187, 0x0000416F, 0x00004157,
		0x0000413E, 0x00004126, 0x0000410E, 0x000040F5,
		0x000040DD, 0x000040C5, 0x000040AC, 0x00004094,
		0x0000407C, 0x00004064, 0x0000404B, 0x00004033,
		0x0000401B, 0x00004002, 0x00003FEA, 0x00003FD2,
		0x00003FB9, 0x00003FA1, 0x00003F89, 0x00003F70,
		0x00003F58, 0x00003F3F, 0x00003F27, 0x00003F0F,
		0x00003EF6, 0x00003EDE, 0x00003EC6, 0x00003EAD,
		0x00003E95, 0x00003E7D, 0x00003E64, 0x00003E4C,
		0x00003E33, 0x00003E1B, 0x00003E03, 0x00003DEA,
		0x00003DD2, 0x00003DBA, 0x00003DA1, 0x00003D89,
		0x00003D70, 0x00003D58, 0x00003D40, 0x00003D27,
		0x00003D0F, 0x00003CF6, 0x00003CDE, 0x00003CC5,
		0x00003CAD, 0x00003C95, 0x00003C7C, 0x00003C64,
		0x00003C4B, 0x00003C33, 0x00003C1B, 0x00003C02,
		0x00003BEA, 0x00003BD1, 0x00003BB9, 0x00003BA0,
		0x00003B88, 0x00003B6F, 0x00003B57, 0x00003B3F,
		0x00003B26, 0x00003B0E, 0x00003AF5, 0x00003ADD,
		0x00003AC4, 0x00003AAC, 0x00003A93, 0x00003A7B,
		0x00003A62, 0x00003A4A, 0x00003A31, 0x00003A19,
		0x00003A01, 0x000039E8, 0x000039D0, 0x000039B7,
		0x0000399F, 0x00003986, 0x0000396E, 0x00003955,
		0x0000393D, 0x00003924, 0x0000390C, 0x000038F3,
		0x000038DB, 0x000038C2, 0x000038AA, 0x00003891,
		0x00003879, 0x00003860, 0x00003848, 0x0000382F,
		0x00003816, 0x000037FE, 0x000037E5, 0x000037CD,
		0x000037B4, 0x0000379C, 0x00003783, 0x0000376B,
		0x00003752, 0x0000373A, 0x00003721, 0x00003709,
		0x000036F0, 0x000036D8, 0x000036BF, 0x000036A6,
		0x0000368E, 0x00003675, 0x0000365D, 0x00003644,
		0x0000362C, 0x00003613, 0x000035FB, 0x000035E2,
		0x000035C9, 0x000035B1, 0x00003598, 0x00003580,
		0x00003567, 0x0000354E, 0x00003536, 0x0000351D,
		0x00003505, 0x000034EC, 0x000034D4, 0x000034BB,
		0x000034A2, 0x0000348A, 0x00003471, 0x00003459,
		0x00003440, 0x00003427, 0x0000340F, 0x000033F6,
		0x000033DE, 0x000033C5, 0x000033AC, 0x00003394,
		0x0000337B, 0x00003362, 0x0000334A, 0x00003331,
		0x00003319, 0x00003300, 0x000032E7, 0x000032CF,
		0x000032B6, 0x0000329D, 0x00003285, 0x0000326C,
		0x00003254, 0x0000323B, 0x00003222, 0x0000320A,
		0x000031F1, 0x000031D8, 0x000031C0, 0x000031A7,
		0x0000318E, 0x00003176, 0x0000315D, 0x00003144,
		0x0000312C, 0x00003113, 0x000030FA, 0x000030E2,
		0x000030C9, 0x000030B0, 0x00003098, 0x0000307F,
		0x00003066, 0x0000304E, 0x00003035, 0x0000301C,
		0x00003004, 0x00002FEB, 0x00002FD2, 0x00002FB9,
		0x00002FA1, 0x00002F88, 0x00002F6F, 0x00002F57,
		0x00002F3E, 0x00002F25, 0x00002F0D, 0x00002EF4,
		0x00002EDB, 0x00002EC2, 0x00002EAA, 0x00002E91,
		0x00002E78, 0x00002E60, 0x00002E47, 0x00002E2E,
		0x00002E15, 0x00002DFD, 0x00002DE4, 0x00002DCB,
		0x00002DB3, 0x00002D9A, 0x00002D81, 0x00002D68,
		0x00002D50, 0x00002D37, 0x00002D1E, 0x00002D05,
		0x00002CED, 0x00002CD4, 0x00002CBB, 0x00002CA2,
		0x00002C8A, 0x00002C71, 0x00002C58, 0x00002C3F,
		0x00002C27, 0x00002C0E, 0x00002BF5, 0x00002BDC,
		0x00002BC4, 0x00002BAB, 0x00002B92, 0x00002B79,
		0x00002B61, 0x00002B48, 0x00002B2F, 0x00002B16,
		0x00002AFD, 0x00002AE5, 0x00002ACC, 0x00002AB3,
		0x00002A9A, 0x00002A82, 0x00002A69, 0x00002A50,
		0x00002A37, 0x00002A1E, 0x00002A06, 0x000029ED,
		0x000029D4, 0x000029BB, 0x000029A2, 0x0000298A,
		0x00002971, 0x00002958, 0x0000293F, 0x00002926,
		0x0000290E, 0x000028F5, 0x000028DC, 0x000028C3,
		0x000028AA, 0x00002892, 0x00002879, 0x00002860,
		0x00002847, 0x0000282E, 0x00002815, 0x000027FD,
		0x000027E4, 0x000027CB, 0x000027B2, 0x00002799,
		0x00002781, 0x00002768, 0x0000274F, 0x00002736,
		0x0000271D, 0x00002704, 0x000026EC, 0x000026D3,
		0x000026BA, 0x000026A1, 0x00002688, 0x0000266F,
		0x00002656, 0x0000263E, 0x00002625, 0x0000260C,
		0x000025F3, 0x000025DA, 0x000025C1, 0x000025A8,
		0x00002590, 0x00002577, 0x0000255E, 0x00002545,
		0x0000252C, 0x00002513, 0x000024FA, 0x000024E2,
		0x000024C9, 0x000024B0, 0x00002497, 0x0000247E,
		0x00002465, 0x0000244C, 0x00002433, 0x0000241B,
		0x00002402, 0x000023E9, 0x000023D0, 0x000023B7,
		0x0000239E, 0x00002385, 0x0000236C, 0x00002353,
		0x0000233B, 0x00002322, 0x00002309, 0x000022F0,
		0x000022D7, 0x000022BE, 0x000022A5, 0x0000228C,
		0x00002273, 0x0000225A, 0x00002242, 0x00002229,
		0x00002210, 0x000021F7, 0x000021DE, 0x000021C5,
		0x000021AC, 0x00002193, 0x0000217A, 0x00002161,
		0x00002148, 0x0000212F, 0x00002117, 0x000020FE,
		0x000020E5, 0x000020CC, 0x000020B3, 0x0000209A,
		0x00002081, 0x00002068, 0x0000204F, 0x00002036,
		0x0000201D, 0x00002004, 0x00001FEB, 0x00001FD2,
		0x00001FBA, 0x00001FA1, 0x00001F88, 0x00001F6F,
		0x00001F56, 0x00001F3D, 0x00001F24, 0x00001F0B,
		0x00001EF2, 0x00001ED9, 0x00001EC0, 0x00001EA7,
		0x00001E8E, 0x00001E75, 0x00001E5C, 0x00001E43,
		0x00001E2A, 0x00001E11, 0x00001DF8, 0x00001DDF,
		0x00001DC7, 0x00001DAE, 0x00001D95, 0x00001D7C,
		0x00001D63, 0x00001D4A, 0x00001D31, 0x00001D18,
		0x00001CFF, 0x00001CE6, 0x00001CCD, 0x00001CB4,
		0x00001C9B, 0x00001C82, 0x00001C69, 0x00001C50,
		0x00001C37, 0x00001C1E, 0x00001C05, 0x00001BEC,
		0x00001BD3, 0x00001BBA, 0x00001BA1, 0x00001B88,
		0x00001B6F, 0x00001B56, 0x00001B3D, 0x00001B24,
		0x00001B0B, 0x00001AF2, 0x00001AD9, 0x00001AC0,
		0x00001AA7, 0x00001A8E, 0x00001A75, 0x00001A5C,
		0x00001A43, 0x00001A2A, 0x00001A11, 0x000019F8,
		0x000019DF, 0x000019C6, 0x000019AD, 0x00001994,
		0x0000197B, 0x00001962, 0x00001949, 0x00001930,
		0x00001917, 0x000018FE, 0x000018E5, 0x000018CC,
		0x000018B3, 0x0000189A, 0x00001881, 0x00001868,
		0x0000184F, 0x00001836, 0x0000181D, 0x00001804,
		0x000017EB, 0x000017D2, 0x000017B9, 0x000017A0,
		0x00001787, 0x0000176E, 0x00001755, 0x0000173C,
		0x00001723, 0x0000170A, 0x000016F1, 0x000016D8,
		0x000016BF, 0x000016A6, 0x0000168D, 0x00001673,
		0x0000165A, 0x00001641, 0x00001628, 0x0000160F,
		0x000015F6, 0x000015DD, 0x000015C4, 0x000015AB,
		0x00001592, 0x00001579, 0x00001560, 0x00001547,
		0x0000152E, 0x00001515, 0x000014FC, 0x000014E3,
		0x000014CA, 0x000014B1, 0x00001498, 0x0000147F,
		0x00001466, 0x0000144C, 0x00001433, 0x0000141A,
		0x00001401, 0x000013E8, 0x000013CF, 0x000013B6,
		0x0000139D, 0x00001384, 0x0000136B, 0x00001352,
		0x00001339, 0x00001320, 0x00001307, 0x000012EE,
		0x000012D5, 0x000012BC, 0x000012A2, 0x00001289,
		0x00001270, 0x00001257, 0x0000123E, 0x00001225,
		0x0000120C, 0x000011F3, 0x000011DA, 0x000011C1,
		0x000011A8, 0x0000118F, 0x00001176, 0x0000115D,
		0x00001143, 0x0000112A, 0x00001111, 0x000010F8,
		0x000010DF, 0x000010C6, 0x000010AD, 0x00001094,
		0x0000107B, 0x00001062, 0x00001049, 0x00001030,
		0x00001017, 0x00000FFD, 0x00000FE4, 0x00000FCB,
		0x00000FB2, 0x00000F99, 0x00000F80, 0x00000F67,
		0x00000F4E, 0x00000F35, 0x00000F1C, 0x00000F03,
		0x00000EE9, 0x00000ED0, 0x00000EB7, 0x00000E9E,
		0x00000E85, 0x00000E6C, 0x00000E53, 0x00000E3A,
		0x00000E21, 0x00000E08, 0x00000DEF, 0x00000DD5,
		0x00000DBC, 0x00000DA3, 0x00000D8A, 0x00000D71,
		0x00000D58, 0x00000D3F, 0x00000D26, 0x00000D0D,
		0x00000CF4, 0x00000CDA, 0x00000CC1, 0x00000CA8,
		0x00000C8F, 0x00000C76, 0x00000C5D, 0x00000C44,
		0x00000C2B, 0x00000C12, 0x00000BF9, 0x00000BDF,
		0x00000BC6, 0x00000BAD, 0x00000B94, 0x00000B7B,
		0x00000B62, 0x00000B49, 0x00000B30, 0x00000B17,
		0x00000AFD, 0x00000AE4, 0x00000ACB, 0x00000AB2,
		0x00000A99, 0x00000A80, 0x00000A67, 0x00000A4E,
		0x00000A35, 0x00000A1B, 0x00000A02, 0x000009E9,
		0x000009D0, 0x000009B7, 0x0000099E, 0x00000985,
		0x0000096C, 0x00000953, 0x00000939, 0x00000920,
		0x00000907, 0x000008EE, 0x000008D5, 0x000008BC,
		0x000008A3, 0x0000088A, 0x00000871, 0x00000857,
		0x0000083E, 0x00000825, 0x0000080C, 0x000007F3,
		0x000007DA, 0x000007C1, 0x000007A8, 0x0000078E,
		0x00000775, 0x0000075C, 0x00000743, 0x0000072A,
		0x00000711, 0x000006F8, 0x000006DF, 0x000006C5,
		0x000006AC, 0x00000693, 0x0000067A, 0x00000661,
		0x00000648, 0x0000062F, 0x00000616, 0x000005FC,
		0x000005E3, 0x000005CA, 0x000005B1, 0x00000598,
		0x0000057F, 0x00000566, 0x0000054D, 0x00000533,
		0x0000051A, 0x00000501, 0x000004E8, 0x000004CF,
		0x000004B6, 0x0000049D, 0x00000484, 0x0000046A,
		0x00000451, 0x00000438, 0x0000041F, 0x00000406,
		0x000003ED, 0x000003D4, 0x000003BA, 0x000003A1,
		0x00000388, 0x0000036F, 0x00000356, 0x0000033D,
		0x00000324, 0x0000030B, 0x000002F1, 0x000002D8,
		0x000002BF, 0x000002A6, 0x0000028D, 0x00000274,
		0x0000025B, 0x00000242, 0x00000228, 0x0000020F,
		0x000001F6, 0x000001DD, 0x000001C4, 0x000001AB,
		0x00000192, 0x00000178, 0x0000015F, 0x00000146,
		0x0000012D, 0x00000114, 0x000000FB, 0x000000E2,
		0x000000C9, 0x000000AF, 0x00000096, 0x0000007D,
		0x00000064, 0x0000004B, 0x00000032, 0x00000019,
		0x00000000,
	};

	// TODO: Better formatting like the cosine table.
	const fixed16_16 s_tanTable[]=
	{
		0, 25, 50, 75,
		100,
		125,
		150,
		175,
		201,
		226,
		251,
		276,
		301,
		326,
		351,
		376,
		402,
		427,
		452,
		477,
		502,
		527,
		552,
		578,
		603,
		628,
		653,
		678,
		703,
		728,
		754,
		779,
		804,
		829,
		854,
		879,
		904,
		929,
		955,
		980,
		1005,
		1030,
		1055,
		1080,
		1105,
		1131,
		1156,
		1181,
		1206,
		1231,
		1256,
		1281,
		1307,
		1332,
		1357,
		1382,
		1407,
		1432,
		1457,
		1483,
		1508,
		1533,
		1558,
		1583,
		1608,
		1633,
		1659,
		1684,
		1709,
		1734,
		1759,
		1784,
		1810,
		1835,
		1860,
		1885,
		1910,
		1935,
		1960,
		1986,
		2011,
		2036,
		2061,
		2086,
		2111,
		2137,
		2162,
		2187,
		2212,
		2237,
		2262,
		2288,
		2313,
		2338,
		2363,
		2388,
		2413,
		2439,
		2464,
		2489,
		2514,
		2539,
		2564,
		2590,
		2615,
		2640,
		2665,
		2690,
		2715,
		2741,
		2766,
		2791,
		2816,
		2841,
		2866,
		2892,
		2917,
		2942,
		2967,
		2992,
		3018,
		3043,
		3068,
		3093,
		3118,
		3144,
		3169,
		3194,
		3219,
		3244,
		3269,
		3295,
		3320,
		3345,
		3370,
		3395,
		3421,
		3446,
		3471,
		3496,
		3521,
		3547,
		3572,
		3597,
		3622,
		3648,
		3673,
		3698,
		3723,
		3748,
		3774,
		3799,
		3824,
		3849,
		3874,
		3900,
		3925,
		3950,
		3975,
		4001,
		4026,
		4051,
		4076,
		4101,
		4127,
		4152,
		4177,
		4202,
		4228,
		4253,
		4278,
		4303,
		4329,
		4354,
		4379,
		4404,
		4430,
		4455,
		4480,
		4505,
		4531,
		4556,
		4581,
		4606,
		4632,
		4657,
		4682,
		4707,
		4733,
		4758,
		4783,
		4808,
		4834,
		4859,
		4884,
		4910,
		4935,
		4960,
		4985,
		5011,
		5036,
		5061,
		5086,
		5112,
		5137,
		5162,
		5188,
		5213,
		5238,
		5264,
		5289,
		5314,
		5339,
		5365,
		5390,
		5415,
		5441,
		5466,
		5491,
		5517,
		5542,
		5567,
		5592,
		5618,
		5643,
		5668,
		5694,
		5719,
		5744,
		5770,
		5795,
		5820,
		5846,
		5871,
		5896,
		5922,
		5947,
		5972,
		5998,
		6023,
		6048,
		6074,
		6099,
		6124,
		6150,
		6175,
		6201,
		6226,
		6251,
		6277,
		6302,
		6327,
		6353,
		6378,
		6403,
		6429,
		6454,
		6480,
		6505,
		6530,
		6556,
		6581,
		6607,
		6632,
		6657,
		6683,
		6708,
		6733,
		6759,
		6784,
		6810,
		6835,
		6861,
		6886,
		6911,
		6937,
		6962,
		6988,
		7013,
		7038,
		7064,
		7089,
		7115,
		7140,
		7166,
		7191,
		7216,
		7242,
		7267,
		7293,
		7318,
		7344,
		7369,
		7395,
		7420,
		7445,
		7471,
		7496,
		7522,
		7547,
		7573,
		7598,
		7624,
		7649,
		7675,
		7700,
		7726,
		7751,
		7777,
		7802,
		7828,
		7853,
		7879,
		7904,
		7930,
		7955,
		7981,
		8006,
		8032,
		8057,
		8083,
		8108,
		8134,
		8159,
		8185,
		8210,
		8236,
		8261,
		8287,
		8312,
		8338,
		8363,
		8389,
		8414,
		8440,
		8466,
		8491,
		8517,
		8542,
		8568,
		8593,
		8619,
		8645,
		8670,
		8696,
		8721,
		8747,
		8772,
		8798,
		8824,
		8849,
		8875,
		8900,
		8926,
		8952,
		8977,
		9003,
		9028,
		9054,
		9080,
		9105,
		9131,
		9156,
		9182,
		9208,
		9233,
		9259,
		9285,
		9310,
		9336,
		9362,
		9387,
		9413,
		9438,
		9464,
		9490,
		9515,
		9541,
		9567,
		9592,
		9618,
		9644,
		9669,
		9695,
		9721,
		9747,
		9772,
		9798,
		9824,
		9849,
		9875,
		9901,
		9926,
		9952,
		9978,
		10004,
		10029,
		10055,
		10081,
		10106,
		10132,
		10158,
		10184,
		10209,
		10235,
		10261,
		10287,
		10312,
		10338,
		10364,
		10390,
		10415,
		10441,
		10467,
		10493,
		10519,
		10544,
		10570,
		10596,
		10622,
		10647,
		10673,
		10699,
		10725,
		10751,
		10777,
		10802,
		10828,
		10854,
		10880,
		10906,
		10931,
		10957,
		10983,
		11009,
		11035,
		11061,
		11086,
		11112,
		11138,
		11164,
		11190,
		11216,
		11242,
		11268,
		11293,
		11319,
		11345,
		11371,
		11397,
		11423,
		11449,
		11475,
		11501,
		11526,
		11552,
		11578,
		11604,
		11630,
		11656,
		11682,
		11708,
		11734,
		11760,
		11786,
		11812,
		11838,
		11864,
		11890,
		11916,
		11941,
		11967,
		11993,
		12019,
		12045,
		12071,
		12097,
		12123,
		12149,
		12175,
		12201,
		12227,
		12253,
		12279,
		12305,
		12331,
		12357,
		12383,
		12409,
		12436,
		12462,
		12488,
		12514,
		12540,
		12566,
		12592,
		12618,
		12644,
		12670,
		12696,
		12722,
		12748,
		12774,
		12800,
		12827,
		12853,
		12879,
		12905,
		12931,
		12957,
		12983,
		13009,
		13035,
		13062,
		13088,
		13114,
		13140,
		13166,
		13192,
		13218,
		13245,
		13271,
		13297,
		13323,
		13349,
		13375,
		13402,
		13428,
		13454,
		13480,
		13506,
		13533,
		13559,
		13585,
		13611,
		13637,
		13664,
		13690,
		13716,
		13742,
		13769,
		13795,
		13821,
		13847,
		13874,
		13900,
		13926,
		13952,
		13979,
		14005,
		14031,
		14057,
		14084,
		14110,
		14136,
		14163,
		14189,
		14215,
		14242,
		14268,
		14294,
		14321,
		14347,
		14373,
		14400,
		14426,
		14452,
		14479,
		14505,
		14531,
		14558,
		14584,
		14611,
		14637,
		14663,
		14690,
		14716,
		14743,
		14769,
		14795,
		14822,
		14848,
		14875,
		14901,
		14927,
		14954,
		14980,
		15007,
		15033,
		15060,
		15086,
		15113,
		15139,
		15166,
		15192,
		15219,
		15245,
		15272,
		15298,
		15325,
		15351,
		15378,
		15404,
		15431,
		15457,
		15484,
		15510,
		15537,
		15563,
		15590,
		15616,
		15643,
		15670,
		15696,
		15723,
		15749,
		15776,
		15802,
		15829,
		15856,
		15882,
		15909,
		15935,
		15962,
		15989,
		16015,
		16042,
		16069,
		16095,
		16122,
		16149,
		16175,
		16202,
		16229,
		16255,
		16282,
		16309,
		16335,
		16362,
		16389,
		16415,
		16442,
		16469,
		16496,
		16522,
		16549,
		16576,
		16603,
		16629,
		16656,
		16683,
		16710,
		16736,
		16763,
		16790,
		16817,
		16843,
		16870,
		16897,
		16924,
		16951,
		16977,
		17004,
		17031,
		17058,
		17085,
		17112,
		17138,
		17165,
		17192,
		17219,
		17246,
		17273,
		17300,
		17327,
		17353,
		17380,
		17407,
		17434,
		17461,
		17488,
		17515,
		17542,
		17569,
		17596,
		17623,
		17650,
		17677,
		17704,
		17731,
		17758,
		17784,
		17811,
		17838,
		17865,
		17892,
		17919,
		17946,
		17974,
		18001,
		18028,
		18055,
		18082,
		18109,
		18136,
		18163,
		18190,
		18217,
		18244,
		18271,
		18298,
		18325,
		18352,
		18380,
		18407,
		18434,
		18461,
		18488,
		18515,
		18542,
		18569,
		18597,
		18624,
		18651,
		18678,
		18705,
		18732,
		18760,
		18787,
		18814,
		18841,
		18868,
		18896,
		18923,
		18950,
		18977,
		19005,
		19032,
		19059,
		19086,
		19114,
		19141,
		19168,
		19195,
		19223,
		19250,
		19277,
		19305,
		19332,
		19359,
		19387,
		19414,
		19441,
		19469,
		19496,
		19523,
		19551,
		19578,
		19605,
		19633,
		19660,
		19688,
		19715,
		19742,
		19770,
		19797,
		19825,
		19852,
		19880,
		19907,
		19935,
		19962,
		19989,
		20017,
		20044,
		20072,
		20099,
		20127,
		20154,
		20182,
		20209,
		20237,
		20264,
		20292,
		20320,
		20347,
		20375,
		20402,
		20430,
		20457,
		20485,
		20513,
		20540,
		20568,
		20595,
		20623,
		20651,
		20678,
		20706,
		20734,
		20761,
		20789,
		20817,
		20844,
		20872,
		20900,
		20927,
		20955,
		20983,
		21010,
		21038,
		21066,
		21094,
		21121,
		21149,
		21177,
		21205,
		21232,
		21260,
		21288,
		21316,
		21343,
		21371,
		21399,
		21427,
		21455,
		21483,
		21510,
		21538,
		21566,
		21594,
		21622,
		21650,
		21678,
		21705,
		21733,
		21761,
		21789,
		21817,
		21845,
		21873,
		21901,
		21929,
		21957,
		21985,
		22013,
		22041,
		22069,
		22097,
		22125,
		22153,
		22181,
		22209,
		22237,
		22265,
		22293,
		22321,
		22349,
		22377,
		22405,
		22433,
		22461,
		22489,
		22517,
		22545,
		22573,
		22602,
		22630,
		22658,
		22686,
		22714,
		22742,
		22770,
		22799,
		22827,
		22855,
		22883,
		22911,
		22940,
		22968,
		22996,
		23024,
		23053,
		23081,
		23109,
		23137,
		23166,
		23194,
		23222,
		23250,
		23279,
		23307,
		23335,
		23364,
		23392,
		23420,
		23449,
		23477,
		23505,
		23534,
		23562,
		23591,
		23619,
		23647,
		23676,
		23704,
		23733,
		23761,
		23789,
		23818,
		23846,
		23875,
		23903,
		23932,
		23960,
		23989,
		24017,
		24046,
		24074,
		24103,
		24131,
		24160,
		24188,
		24217,
		24246,
		24274,
		24303,
		24331,
		24360,
		24389,
		24417,
		24446,
		24474,
		24503,
		24532,
		24560,
		24589,
		24618,
		24646,
		24675,
		24704,
		24732,
		24761,
		24790,
		24819,
		24847,
		24876,
		24905,
		24934,
		24962,
		24991,
		25020,
		25049,
		25078,
		25106,
		25135,
		25164,
		25193,
		25222,
		25251,
		25280,
		25308,
		25337,
		25366,
		25395,
		25424,
		25453,
		25482,
		25511,
		25540,
		25569,
		25598,
		25627,
		25656,
		25685,
		25714,
		25743,
		25772,
		25801,
		25830,
		25859,
		25888,
		25917,
		25946,
		25975,
		26004,
		26033,
		26062,
		26091,
		26120,
		26150,
		26179,
		26208,
		26237,
		26266,
		26295,
		26325,
		26354,
		26383,
		26412,
		26441,
		26471,
		26500,
		26529,
		26558,
		26588,
		26617,
		26646,
		26675,
		26705,
		26734,
		26763,
		26793,
		26822,
		26851,
		26881,
		26910,
		26940,
		26969,
		26998,
		27028,
		27057,
		27087,
		27116,
		27145,
		27175,
		27204,
		27234,
		27263,
		27293,
		27322,
		27352,
		27381,
		27411,
		27440,
		27470,
		27499,
		27529,
		27559,
		27588,
		27618,
		27647,
		27677,
		27707,
		27736,
		27766,
		27795,
		27825,
		27855,
		27884,
		27914,
		27944,
		27974,
		28003,
		28033,
		28063,
		28092,
		28122,
		28152,
		28182,
		28212,
		28241,
		28271,
		28301,
		28331,
		28361,
		28390,
		28420,
		28450,
		28480,
		28510,
		28540,
		28570,
		28600,
		28630,
		28660,
		28689,
		28719,
		28749,
		28779,
		28809,
		28839,
		28869,
		28899,
		28929,
		28959,
		28989,
		29020,
		29050,
		29080,
		29110,
		29140,
		29170,
		29200,
		29230,
		29260,
		29291,
		29321,
		29351,
		29381,
		29411,
		29441,
		29472,
		29502,
		29532,
		29562,
		29593,
		29623,
		29653,
		29683,
		29714,
		29744,
		29774,
		29805,
		29835,
		29865,
		29896,
		29926,
		29956,
		29987,
		30017,
		30048,
		30078,
		30108,
		30139,
		30169,
		30200,
		30230,
		30261,
		30291,
		30322,
		30352,
		30383,
		30413,
		30444,
		30474,
		30505,
		30536,
		30566,
		30597,
		30627,
		30658,
		30689,
		30719,
		30750,
		30781,
		30811,
		30842,
		30873,
		30904,
		30934,
		30965,
		30996,
		31026,
		31057,
		31088,
		31119,
		31150,
		31180,
		31211,
		31242,
		31273,
		31304,
		31335,
		31366,
		31396,
		31427,
		31458,
		31489,
		31520,
		31551,
		31582,
		31613,
		31644,
		31675,
		31706,
		31737,
		31768,
		31799,
		31830,
		31861,
		31892,
		31923,
		31955,
		31986,
		32017,
		32048,
		32079,
		32110,
		32141,
		32173,
		32204,
		32235,
		32266,
		32297,
		32329,
		32360,
		32391,
		32422,
		32454,
		32485,
		32516,
		32548,
		32579,
		32610,
		32642,
		32673,
		32705,
		32736,
		32767,
		32799,
		32830,
		32862,
		32893,
		32925,
		32956,
		32988,
		33019,
		33051,
		33082,
		33114,
		33145,
		33177,
		33208,
		33240,
		33272,
		33303,
		33335,
		33366,
		33398,
		33430,
		33461,
		33493,
		33525,
		33557,
		33588,
		33620,
		33652,
		33684,
		33715,
		33747,
		33779,
		33811,
		33843,
		33874,
		33906,
		33938,
		33970,
		34002,
		34034,
		34066,
		34098,
		34130,
		34162,
		34194,
		34225,
		34257,
		34289,
		34322,
		34354,
		34386,
		34418,
		34450,
		34482,
		34514,
		34546,
		34578,
		34610,
		34642,
		34675,
		34707,
		34739,
		34771,
		34803,
		34836,
		34868,
		34900,
		34932,
		34965,
		34997,
		35029,
		35062,
		35094,
		35126,
		35159,
		35191,
		35223,
		35256,
		35288,
		35321,
		35353,
		35385,
		35418,
		35450,
		35483,
		35515,
		35548,
		35580,
		35613,
		35646,
		35678,
		35711,
		35743,
		35776,
		35809,
		35841,
		35874,
		35907,
		35939,
		35972,
		36005,
		36037,
		36070,
		36103,
		36136,
		36168,
		36201,
		36234,
		36267,
		36300,
		36333,
		36365,
		36398,
		36431,
		36464,
		36497,
		36530,
		36563,
		36596,
		36629,
		36662,
		36695,
		36728,
		36761,
		36794,
		36827,
		36860,
		36893,
		36926,
		36959,
		36993,
		37026,
		37059,
		37092,
		37125,
		37158,
		37192,
		37225,
		37258,
		37291,
		37325,
		37358,
		37391,
		37425,
		37458,
		37491,
		37525,
		37558,
		37591,
		37625,
		37658,
		37692,
		37725,
		37759,
		37792,
		37826,
		37859,
		37893,
		37926,
		37960,
		37993,
		38027,
		38060,
		38094,
		38128,
		38161,
		38195,
		38229,
		38262,
		38296,
		38330,
		38364,
		38397,
		38431,
		38465,
		38499,
		38532,
		38566,
		38600,
		38634,
		38668,
		38702,
		38736,
		38770,
		38804,
		38837,
		38871,
		38905,
		38939,
		38973,
		39007,
		39042,
		39076,
		39110,
		39144,
		39178,
		39212,
		39246,
		39280,
		39314,
		39349,
		39383,
		39417,
		39451,
		39486,
		39520,
		39554,
		39588,
		39623,
		39657,
		39691,
		39726,
		39760,
		39794,
		39829,
		39863,
		39898,
		39932,
		39967,
		40001,
		40036,
		40070,
		40105,
		40139,
		40174,
		40208,
		40243,
		40278,
		40312,
		40347,
		40382,
		40416,
		40451,
		40486,
		40520,
		40555,
		40590,
		40625,
		40660,
		40694,
		40729,
		40764,
		40799,
		40834,
		40869,
		40904,
		40939,
		40973,
		41008,
		41043,
		41078,
		41113,
		41148,
		41184,
		41219,
		41254,
		41289,
		41324,
		41359,
		41394,
		41429,
		41465,
		41500,
		41535,
		41570,
		41605,
		41641,
		41676,
		41711,
		41747,
		41782,
		41817,
		41853,
		41888,
		41923,
		41959,
		41994,
		42030,
		42065,
		42101,
		42136,
		42172,
		42207,
		42243,
		42279,
		42314,
		42350,
		42385,
		42421,
		42457,
		42492,
		42528,
		42564,
		42600,
		42635,
		42671,
		42707,
		42743,
		42779,
		42814,
		42850,
		42886,
		42922,
		42958,
		42994,
		43030,
		43066,
		43102,
		43138,
		43174,
		43210,
		43246,
		43282,
		43318,
		43354,
		43390,
		43427,
		43463,
		43499,
		43535,
		43571,
		43608,
		43644,
		43680,
		43717,
		43753,
		43789,
		43826,
		43862,
		43898,
		43935,
		43971,
		44008,
		44044,
		44081,
		44117,
		44154,
		44190,
		44227,
		44263,
		44300,
		44337,
		44373,
		44410,
		44447,
		44483,
		44520,
		44557,
		44594,
		44630,
		44667,
		44704,
		44741,
		44778,
		44815,
		44851,
		44888,
		44925,
		44962,
		44999,
		45036,
		45073,
		45110,
		45147,
		45184,
		45221,
		45259,
		45296,
		45333,
		45370,
		45407,
		45444,
		45482,
		45519,
		45556,
		45593,
		45631,
		45668,
		45705,
		45743,
		45780,
		45818,
		45855,
		45892,
		45930,
		45967,
		46005,
		46042,
		46080,
		46118,
		46155,
		46193,
		46230,
		46268,
		46306,
		46343,
		46381,
		46419,
		46457,
		46494,
		46532,
		46570,
		46608,
		46646,
		46684,
		46721,
		46759,
		46797,
		46835,
		46873,
		46911,
		46949,
		46987,
		47025,
		47063,
		47102,
		47140,
		47178,
		47216,
		47254,
		47292,
		47331,
		47369,
		47407,
		47445,
		47484,
		47522,
		47560,
		47599,
		47637,
		47676,
		47714,
		47753,
		47791,
		47830,
		47868,
		47907,
		47945,
		47984,
		48022,
		48061,
		48100,
		48138,
		48177,
		48216,
		48255,
		48293,
		48332,
		48371,
		48410,
		48449,
		48488,
		48526,
		48565,
		48604,
		48643,
		48682,
		48721,
		48760,
		48799,
		48838,
		48878,
		48917,
		48956,
		48995,
		49034,
		49073,
		49113,
		49152,
		49191,
		49230,
		49270,
		49309,
		49349,
		49388,
		49427,
		49467,
		49506,
		49546,
		49585,
		49625,
		49664,
		49704,
		49744,
		49783,
		49823,
		49862,
		49902,
		49942,
		49982,
		50021,
		50061,
		50101,
		50141,
		50181,
		50221,
		50260,
		50300,
		50340,
		50380,
		50420,
		50460,
		50500,
		50540,
		50581,
		50621,
		50661,
		50701,
		50741,
		50781,
		50822,
		50862,
		50902,
		50942,
		50983,
		51023,
		51063,
		51104,
		51144,
		51185,
		51225,
		51266,
		51306,
		51347,
		51387,
		51428,
		51469,
		51509,
		51550,
		51591,
		51631,
		51672,
		51713,
		51754,
		51794,
		51835,
		51876,
		51917,
		51958,
		51999,
		52040,
		52081,
		52122,
		52163,
		52204,
		52245,
		52286,
		52327,
		52369,
		52410,
		52451,
		52492,
		52533,
		52575,
		52616,
		52657,
		52699,
		52740,
		52782,
		52823,
		52865,
		52906,
		52948,
		52989,
		53031,
		53072,
		53114,
		53156,
		53197,
		53239,
		53281,
		53322,
		53364,
		53406,
		53448,
		53490,
		53532,
		53574,
		53615,
		53657,
		53699,
		53741,
		53784,
		53826,
		53868,
		53910,
		53952,
		53994,
		54036,
		54079,
		54121,
		54163,
		54205,
		54248,
		54290,
		54333,
		54375,
		54417,
		54460,
		54502,
		54545,
		54587,
		54630,
		54673,
		54715,
		54758,
		54801,
		54843,
		54886,
		54929,
		54972,
		55015,
		55057,
		55100,
		55143,
		55186,
		55229,
		55272,
		55315,
		55358,
		55401,
		55444,
		55487,
		55531,
		55574,
		55617,
		55660,
		55704,
		55747,
		55790,
		55834,
		55877,
		55920,
		55964,
		56007,
		56051,
		56094,
		56138,
		56181,
		56225,
		56269,
		56312,
		56356,
		56400,
		56444,
		56487,
		56531,
		56575,
		56619,
		56663,
		56707,
		56751,
		56795,
		56839,
		56883,
		56927,
		56971,
		57015,
		57059,
		57104,
		57148,
		57192,
		57236,
		57281,
		57325,
		57369,
		57414,
		57458,
		57503,
		57547,
		57592,
		57636,
		57681,
		57725,
		57770,
		57815,
		57859,
		57904,
		57949,
		57994,
		58039,
		58083,
		58128,
		58173,
		58218,
		58263,
		58308,
		58353,
		58398,
		58443,
		58489,
		58534,
		58579,
		58624,
		58669,
		58715,
		58760,
		58805,
		58851,
		58896,
		58942,
		58987,
		59033,
		59078,
		59124,
		59169,
		59215,
		59261,
		59306,
		59352,
		59398,
		59444,
		59489,
		59535,
		59581,
		59627,
		59673,
		59719,
		59765,
		59811,
		59857,
		59903,
		59950,
		59996,
		60042,
		60088,
		60134,
		60181,
		60227,
		60273,
		60320,
		60366,
		60413,
		60459,
		60506,
		60552,
		60599,
		60646,
		60692,
		60739,
		60786,
		60833,
		60879,
		60926,
		60973,
		61020,
		61067,
		61114,
		61161,
		61208,
		61255,
		61302,
		61349,
		61396,
		61444,
		61491,
		61538,
		61585,
		61633,
		61680,
		61728,
		61775,
		61822,
		61870,
		61918,
		61965,
		62013,
		62060,
		62108,
		62156,
		62204,
		62251,
		62299,
		62347,
		62395,
		62443,
		62491,
		62539,
		62587,
		62635,
		62683,
		62731,
		62779,
		62828,
		62876,
		62924,
		62972,
		63021,
		63069,
		63118,
		63166,
		63215,
		63263,
		63312,
		63360,
		63409,
		63458,
		63506,
		63555,
		63604,
		63653,
		63702,
		63750,
		63799,
		63848,
		63897,
		63946,
		63996,
		64045,
		64094,
		64143,
		64192,
		64241,
		64291,
		64340,
		64389,
		64439,
		64488,
		64538,
		64587,
		64637,
		64687,
		64736,
		64786,
		64836,
		64885,
		64935,
		64985,
		65035,
		65085,
		65135,
		65185,
		65235,
		65285,
		65335,
		65385,
		65435,
		65485,
		65535,
		65586,
		65636,
		65686,
		65737,
		65787,
		65838,
		65888,
		65939,
		65989,
		66040,
		66091,
		66141,
		66192,
		66243,
		66294,
		66345,
		66396,
		66447,
		66498,
		66549,
		66600,
		66651,
		66702,
		66753,
		66804,
		66856,
		66907,
		66958,
		67010,
		67061,
		67113,
		67164,
		67216,
		67267,
		67319,
		67371,
		67422,
		67474,
		67526,
		67578,
		67629,
		67681,
		67733,
		67785,
		67837,
		67889,
		67942,
		67994,
		68046,
		68098,
		68151,
		68203,
		68255,
		68308,
		68360,
		68413,
		68465,
		68518,
		68570,
		68623,
		68676,
		68728,
		68781,
		68834,
		68887,
		68940,
		68993,
		69046,
		69099,
		69152,
		69205,
		69258,
		69312,
		69365,
		69418,
		69472,
		69525,
		69578,
		69632,
		69685,
		69739,
		69793,
		69846,
		69900,
		69954,
		70007,
		70061,
		70115,
		70169,
		70223,
		70277,
		70331,
		70385,
		70439,
		70494,
		70548,
		70602,
		70656,
		70711,
		70765,
		70820,
		70874,
		70929,
		70983,
		71038,
		71093,
		71147,
		71202,
		71257,
		71312,
		71367,
		71422,
		71477,
		71532,
		71587,
		71642,
		71697,
		71752,
		71808,
		71863,
		71918,
		71974,
		72029,
		72085,
		72140,
		72196,
		72252,
		72307,
		72363,
		72419,
		72475,
		72531,
		72587,
		72643,
		72699,
		72755,
		72811,
		72867,
		72923,
		72979,
		73036,
		73092,
		73149,
		73205,
		73262,
		73318,
		73375,
		73431,
		73488,
		73545,
		73602,
		73659,
		73715,
		73772,
		73829,
		73886,
		73944,
		74001,
		74058,
		74115,
		74172,
		74230,
		74287,
		74345,
		74402,
		74460,
		74517,
		74575,
		74633,
		74690,
		74748,
		74806,
		74864,
		74922,
		74980,
		75038,
		75096,
		75154,
		75213,
		75271,
		75329,
		75387,
		75446,
		75504,
		75563,
		75621,
		75680,
		75739,
		75797,
		75856,
		75915,
		75974,
		76033,
		76092,
		76151,
		76210,
		76269,
		76328,
		76388,
		76447,
		76506,
		76566,
		76625,
		76685,
		76744,
		76804,
		76864,
		76923,
		76983,
		77043,
		77103,
		77163,
		77223,
		77283,
		77343,
		77403,
		77463,
		77524,
		77584,
		77644,
		77705,
		77765,
		77826,
		77886,
		77947,
		78008,
		78068,
		78129,
		78190,
		78251,
		78312,
		78373,
		78434,
		78495,
		78557,
		78618,
		78679,
		78741,
		78802,
		78864,
		78925,
		78987,
		79048,
		79110,
		79172,
		79234,
		79296,
		79358,
		79420,
		79482,
		79544,
		79606,
		79668,
		79731,
		79793,
		79855,
		79918,
		79980,
		80043,
		80106,
		80168,
		80231,
		80294,
		80357,
		80420,
		80483,
		80546,
		80609,
		80672,
		80735,
		80799,
		80862,
		80925,
		80989,
		81053,
		81116,
		81180,
		81244,
		81307,
		81371,
		81435,
		81499,
		81563,
		81627,
		81691,
		81756,
		81820,
		81884,
		81949,
		82013,
		82078,
		82142,
		82207,
		82271,
		82336,
		82401,
		82466,
		82531,
		82596,
		82661,
		82726,
		82791,
		82857,
		82922,
		82987,
		83053,
		83118,
		83184,
		83250,
		83315,
		83381,
		83447,
		83513,
		83579,
		83645,
		83711,
		83777,
		83843,
		83910,
		83976,
		84043,
		84109,
		84176,
		84242,
		84309,
		84376,
		84443,
		84509,
		84576,
		84643,
		84710,
		84778,
		84845,
		84912,
		84980,
		85047,
		85114,
		85182,
		85250,
		85317,
		85385,
		85453,
		85521,
		85589,
		85657,
		85725,
		85793,
		85861,
		85930,
		85998,
		86066,
		86135,
		86204,
		86272,
		86341,
		86410,
		86479,
		86547,
		86616,
		86686,
		86755,
		86824,
		86893,
		86963,
		87032,
		87101,
		87171,
		87241,
		87310,
		87380,
		87450,
		87520,
		87590,
		87660,
		87730,
		87800,
		87871,
		87941,
		88011,
		88082,
		88152,
		88223,
		88294,
		88365,
		88435,
		88506,
		88577,
		88648,
		88720,
		88791,
		88862,
		88934,
		89005,
		89077,
		89148,
		89220,
		89292,
		89363,
		89435,
		89507,
		89579,
		89651,
		89724,
		89796,
		89868,
		89941,
		90013,
		90086,
		90158,
		90231,
		90304,
		90377,
		90450,
		90523,
		90596,
		90669,
		90742,
		90816,
		90889,
		90963,
		91036,
		91110,
		91184,
		91258,
		91332,
		91406,
		91480,
		91554,
		91628,
		91702,
		91777,
		91851,
		91926,
		92000,
		92075,
		92150,
		92225,
		92300,
		92375,
		92450,
		92525,
		92600,
		92675,
		92751,
		92826,
		92902,
		92978,
		93053,
		93129,
		93205,
		93281,
		93357,
		93434,
		93510,
		93586,
		93663,
		93739,
		93816,
		93892,
		93969,
		94046,
		94123,
		94200,
		94277,
		94354,
		94431,
		94509,
		94586,
		94664,
		94741,
		94819,
		94897,
		94975,
		95053,
		95131,
		95209,
		95287,
		95365,
		95444,
		95522,
		95601,
		95680,
		95758,
		95837,
		95916,
		95995,
		96074,
		96153,
		96233,
		96312,
		96391,
		96471,
		96551,
		96630,
		96710,
		96790,
		96870,
		96950,
		97030,
		97111,
		97191,
		97271,
		97352,
		97433,
		97513,
		97594,
		97675,
		97756,
		97837,
		97918,
		98000,
		98081,
		98163,
		98244,
		98326,
		98408,
		98489,
		98571,
		98653,
		98735,
		98818,
		98900,
		98982,
		99065,
		99148,
		99230,
		99313,
		99396,
		99479,
		99562,
		99645,
		99729,
		99812,
		99895,
		99979,
		100063,
		100146,
		100230,
		100314,
		100398,
		100482,
		100567,
		100651,
		100736,
		100820,
		100905,
		100990,
		101074,
		101159,
		101244,
		101330,
		101415,
		101500,
		101586,
		101671,
		101757,
		101843,
		101929,
		102015,
		102101,
		102187,
		102273,
		102360,
		102446,
		102533,
		102619,
		102706,
		102793,
		102880,
		102967,
		103054,
		103142,
		103229,
		103317,
		103404,
		103492,
		103580,
		103668,
		103756,
		103844,
		103933,
		104021,
		104109,
		104198,
		104287,
		104376,
		104465,
		104554,
		104643,
		104732,
		104821,
		104911,
		105000,
		105090,
		105180,
		105270,
		105360,
		105450,
		105540,
		105631,
		105721,
		105812,
		105902,
		105993,
		106084,
		106175,
		106266,
		106358,
		106449,
		106541,
		106632,
		106724,
		106816,
		106908,
		107000,
		107092,
		107184,
		107277,
		107369,
		107462,
		107555,
		107648,
		107741,
		107834,
		107927,
		108020,
		108114,
		108207,
		108301,
		108395,
		108489,
		108583,
		108677,
		108771,
		108866,
		108960,
		109055,
		109150,
		109245,
		109340,
		109435,
		109530,
		109626,
		109721,
		109817,
		109912,
		110008,
		110104,
		110200,
		110297,
		110393,
		110490,
		110586,
		110683,
		110780,
		110877,
		110974,
		111071,
		111169,
		111266,
		111364,
		111462,
		111560,
		111658,
		111756,
		111854,
		111952,
		112051,
		112150,
		112248,
		112347,
		112446,
		112546,
		112645,
		112744,
		112844,
		112944,
		113043,
		113143,
		113244,
		113344,
		113444,
		113545,
		113645,
		113746,
		113847,
		113948,
		114049,
		114151,
		114252,
		114354,
		114455,
		114557,
		114659,
		114761,
		114864,
		114966,
		115069,
		115171,
		115274,
		115377,
		115480,
		115583,
		115687,
		115790,
		115894,
		115998,
		116102,
		116206,
		116310,
		116414,
		116519,
		116623,
		116728,
		116833,
		116938,
		117044,
		117149,
		117254,
		117360,
		117466,
		117572,
		117678,
		117784,
		117891,
		117997,
		118104,
		118211,
		118318,
		118425,
		118532,
		118639,
		118747,
		118855,
		118963,
		119071,
		119179,
		119287,
		119396,
		119504,
		119613,
		119722,
		119831,
		119940,
		120050,
		120159,
		120269,
		120379,
		120489,
		120599,
		120709,
		120820,
		120930,
		121041,
		121152,
		121263,
		121374,
		121486,
		121597,
		121709,
		121821,
		121933,
		122045,
		122158,
		122270,
		122383,
		122496,
		122609,
		122722,
		122835,
		122949,
		123062,
		123176,
		123290,
		123404,
		123519,
		123633,
		123748,
		123863,
		123978,
		124093,
		124208,
		124324,
		124439,
		124555,
		124671,
		124787,
		124904,
		125020,
		125137,
		125254,
		125371,
		125488,
		125605,
		125723,
		125841,
		125958,
		126077,
		126195,
		126313,
		126432,
		126551,
		126669,
		126789,
		126908,
		127027,
		127147,
		127267,
		127387,
		127507,
		127627,
		127748,
		127869,
		127990,
		128111,
		128232,
		128353,
		128475,
		128597,
		128719,
		128841,
		128963,
		129086,
		129209,
		129331,
		129455,
		129578,
		129701,
		129825,
		129949,
		130073,
		130197,
		130322,
		130446,
		130571,
		130696,
		130821,
		130947,
		131072,
		131198,
		131324,
		131450,
		131576,
		131703,
		131830,
		131957,
		132084,
		132211,
		132338,
		132466,
		132594,
		132722,
		132851,
		132979,
		133108,
		133237,
		133366,
		133495,
		133625,
		133754,
		133884,
		134014,
		134145,
		134275,
		134406,
		134537,
		134668,
		134799,
		134931,
		135063,
		135195,
		135327,
		135459,
		135592,
		135725,
		135858,
		135991,
		136125,
		136258,
		136392,
		136526,
		136661,
		136795,
		136930,
		137065,
		137200,
		137335,
		137471,
		137607,
		137743,
		137879,
		138016,
		138152,
		138289,
		138426,
		138564,
		138701,
		138839,
		138977,
		139115,
		139254,
		139393,
		139532,
		139671,
		139810,
		139950,
		140090,
		140230,
		140370,
		140511,
		140651,
		140792,
		140934,
		141075,
		141217,
		141359,
		141501,
		141643,
		141786,
		141929,
		142072,
		142215,
		142359,
		142503,
		142647,
		142791,
		142936,
		143081,
		143226,
		143371,
		143517,
		143662,
		143808,
		143955,
		144101,
		144248,
		144395,
		144542,
		144690,
		144837,
		144986,
		145134,
		145282,
		145431,
		145580,
		145729,
		145879,
		146029,
		146179,
		146329,
		146480,
		146630,
		146781,
		146933,
		147084,
		147236,
		147388,
		147541,
		147693,
		147846,
		148000,
		148153,
		148307,
		148461,
		148615,
		148769,
		148924,
		149079,
		149235,
		149390,
		149546,
		149702,
		149859,
		150015,
		150172,
		150329,
		150487,
		150645,
		150803,
		150961,
		151120,
		151279,
		151438,
		151597,
		151757,
		151917,
		152077,
		152238,
		152399,
		152560,
		152722,
		152883,
		153045,
		153208,
		153370,
		153533,
		153697,
		153860,
		154024,
		154188,
		154352,
		154517,
		154682,
		154847,
		155013,
		155179,
		155345,
		155512,
		155678,
		155845,
		156013,
		156181,
		156349,
		156517,
		156686,
		156855,
		157024,
		157193,
		157363,
		157533,
		157704,
		157875,
		158046,
		158217,
		158389,
		158561,
		158734,
		158906,
		159079,
		159253,
		159427,
		159601,
		159775,
		159950,
		160125,
		160300,
		160476,
		160652,
		160828,
		161005,
		161182,
		161359,
		161537,
		161715,
		161893,
		162072,
		162251,
		162430,
		162610,
		162790,
		162970,
		163151,
		163332,
		163513,
		163695,
		163877,
		164060,
		164242,
		164426,
		164609,
		164793,
		164977,
		165162,
		165347,
		165532,
		165718,
		165904,
		166090,
		166277,
		166464,
		166651,
		166839,
		167027,
		167216,
		167405,
		167594,
		167784,
		167974,
		168164,
		168355,
		168546,
		168738,
		168930,
		169122,
		169315,
		169508,
		169701,
		169895,
		170089,
		170284,
		170479,
		170674,
		170870,
		171066,
		171263,
		171460,
		171657,
		171855,
		172053,
		172252,
		172451,
		172650,
		172850,
		173050,
		173251,
		173452,
		173653,
		173855,
		174057,
		174260,
		174463,
		174666,
		174870,
		175074,
		175279,
		175484,
		175690,
		175896,
		176102,
		176309,
		176516,
		176724,
		176932,
		177140,
		177349,
		177559,
		177769,
		177979,
		178190,
		178401,
		178612,
		178824,
		179037,
		179250,
		179463,
		179677,
		179891,
		180106,
		180321,
		180537,
		180753,
		180969,
		181186,
		181404,
		181622,
		181840,
		182059,
		182278,
		182498,
		182718,
		182939,
		183160,
		183382,
		183604,
		183827,
		184050,
		184274,
		184498,
		184722,
		184947,
		185173,
		185399,
		185625,
		185852,
		186080,
		186308,
		186536,
		186765,
		186995,
		187225,
		187455,
		187686,
		187918,
		188150,
		188382,
		188615,
		188849,
		189083,
		189318,
		189553,
		189789,
		190025,
		190261,
		190499,
		190736,
		190975,
		191213,
		191453,
		191693,
		191933,
		192174,
		192416,
		192658,
		192900,
		193143,
		193387,
		193631,
		193876,
		194122,
		194367,
		194614,
		194861,
		195109,
		195357,
		195606,
		195855,
		196105,
		196355,
		196606,
		196858,
		197110,
		197363,
		197616,
		197870,
		198125,
		198380,
		198636,
		198892,
		199149,
		199406,
		199664,
		199923,
		200182,
		200442,
		200703,
		200964,
		201226,
		201488,
		201751,
		202015,
		202279,
		202544,
		202809,
		203076,
		203342,
		203610,
		203878,
		204147,
		204416,
		204686,
		204956,
		205228,
		205500,
		205772,
		206045,
		206319,
		206594,
		206869,
		207145,
		207422,
		207699,
		207977,
		208255,
		208535,
		208815,
		209095,
		209376,
		209658,
		209941,
		210225,
		210509,
		210793,
		211079,
		211365,
		211652,
		211940,
		212228,
		212517,
		212807,
		213097,
		213389,
		213681,
		213973,
		214267,
		214561,
		214856,
		215151,
		215448,
		215745,
		216043,
		216341,
		216641,
		216941,
		217242,
		217544,
		217846,
		218149,
		218453,
		218758,
		219064,
		219370,
		219677,
		219985,
		220294,
		220603,
		220913,
		221225,
		221536,
		221849,
		222163,
		222477,
		222792,
		223108,
		223425,
		223743,
		224061,
		224381,
		224701,
		225022,
		225344,
		225666,
		225990,
		226314,
		226640,
		226966,
		227293,
		227621,
		227949,
		228279,
		228610,
		228941,
		229273,
		229606,
		229940,
		230275,
		230611,
		230948,
		231286,
		231624,
		231964,
		232304,
		232646,
		232988,
		233331,
		233676,
		234021,
		234367,
		234714,
		235062,
		235411,
		235761,
		236112,
		236463,
		236816,
		237170,
		237525,
		237881,
		238237,
		238595,
		238954,
		239314,
		239674,
		240036,
		240399,
		240763,
		241128,
		241493,
		241860,
		242228,
		242597,
		242967,
		243338,
		243711,
		244084,
		244458,
		244834,
		245210,
		245588,
		245966,
		246346,
		246727,
		247109,
		247492,
		247876,
		248261,
		248647,
		249035,
		249423,
		249813,
		250204,
		250596,
		250989,
		251384,
		251779,
		252176,
		252574,
		252973,
		253373,
		253774,
		254177,
		254581,
		254986,
		255392,
		255799,
		256208,
		256618,
		257029,
		257441,
		257855,
		258270,
		258686,
		259103,
		259522,
		259941,
		260363,
		260785,
		261209,
		261634,
		262060,
		262488,
		262917,
		263347,
		263779,
		264212,
		264646,
		265082,
		265519,
		265957,
		266397,
		266838,
		267280,
		267724,
		268169,
		268616,
		269064,
		269514,
		269965,
		270417,
		270871,
		271326,
		271782,
		272241,
		272700,
		273161,
		273624,
		274088,
		274553,
		275020,
		275489,
		275959,
		276430,
		276903,
		277378,
		277854,
		278332,
		278811,
		279292,
		279774,
		280258,
		280743,
		281231,
		281719,
		282210,
		282702,
		283195,
		283691,
		284188,
		284686,
		285186,
		285688,
		286192,
		286697,
		287204,
		287713,
		288223,
		288735,
		289249,
		289765,
		290282,
		290801,
		291322,
		291845,
		292369,
		292895,
		293423,
		293953,
		294485,
		295018,
		295554,
		296091,
		296630,
		297171,
		297714,
		298259,
		298805,
		299354,
		299904,
		300457,
		301011,
		301567,
		302126,
		302686,
		303248,
		303812,
		304379,
		304947,
		305517,
		306090,
		306664,
		307240,
		307819,
		308400,
		308982,
		309567,
		310154,
		310743,
		311335,
		311928,
		312524,
		313121,
		313721,
		314324,
		314928,
		315535,
		316143,
		316754,
		317368,
		317984,
		318602,
		319222,
		319844,
		320469,
		321097,
		321726,
		322358,
		322993,
		323629,
		324269,
		324910,
		325554,
		326201,
		326850,
		327502,
		328156,
		328812,
		329471,
		330133,
		330797,
		331464,
		332133,
		332805,
		333480,
		334157,
		334837,
		335519,
		336204,
		336892,
		337583,
		338276,
		338973,
		339671,
		340373,
		341078,
		341785,
		342495,
		343208,
		343924,
		344643,
		345364,
		346089,
		346816,
		347547,
		348280,
		349017,
		349756,
		350499,
		351244,
		351993,
		352744,
		353499,
		354257,
		355018,
		355783,
		356550,
		357321,
		358094,
		358872,
		359652,
		360436,
		361223,
		362013,
		362807,
		363604,
		364404,
		365208,
		366016,
		366826,
		367641,
		368458,
		369280,
		370105,
		370933,
		371765,
		372601,
		373440,
		374283,
		375130,
		375981,
		376835,
		377693,
		378555,
		379420,
		380290,
		381163,
		382040,
		382921,
		383807,
		384696,
		385589,
		386486,
		387387,
		388293,
		389202,
		390116,
		391033,
		391956,
		392882,
		393812,
		394747,
		395686,
		396630,
		397578,
		398530,
		399487,
		400448,
		401414,
		402384,
		403359,
		404338,
		405323,
		406311,
		407305,
		408303,
		409306,
		410314,
		411327,
		412345,
		413367,
		414395,
		415427,
		416465,
		417507,
		418555,
		419608,
		420666,
		421729,
		422798,
		423871,
		424951,
		426035,
		427125,
		428221,
		429322,
		430428,
		431540,
		432658,
		433781,
		434910,
		436045,
		437186,
		438332,
		439485,
		440643,
		441807,
		442978,
		444154,
		445337,
		446526,
		447720,
		448922,
		450129,
		451343,
		452564,
		453791,
		455024,
		456264,
		457511,
		458764,
		460024,
		461291,
		462565,
		463845,
		465133,
		466428,
		467729,
		469038,
		470354,
		471678,
		473009,
		474347,
		475692,
		477045,
		478406,
		479774,
		481150,
		482534,
		483925,
		485325,
		486732,
		488148,
		489571,
		491003,
		492443,
		493891,
		495348,
		496813,
		498287,
		499769,
		501260,
		502760,
		504269,
		505787,
		507313,
		508849,
		510394,
		511948,
		513512,
		515084,
		516667,
		518259,
		519861,
		521472,
		523093,
		524725,
		526366,
		528018,
		529679,
		531351,
		533034,
		534727,
		536431,
		538145,
		539870,
		541606,
		543353,
		545112,
		546881,
		548662,
		550455,
		552259,
		554074,
		555902,
		557741,
		559593,
		561457,
		563332,
		565221,
		567122,
		569035,
		570962,
		572901,
		574853,
		576819,
		578797,
		580790,
		582795,
		584815,
		586848,
		588896,
		590957,
		593033,
		595124,
		597229,
		599348,
		601483,
		603633,
		605798,
		607978,
		610174,
		612386,
		614613,
		616857,
		619117,
		621393,
		623686,
		625996,
		628323,
		630667,
		633028,
		635407,
		637804,
		640218,
		642651,
		645102,
		647572,
		650060,
		652568,
		655094,
		657640,
		660206,
		662792,
		665398,
		668024,
		670671,
		673338,
		676027,
		678737,
		681469,
		684223,
		686999,
		689797,
		692618,
		695461,
		698328,
		701219,
		704133,
		707072,
		710035,
		713023,
		716035,
		719073,
		722137,
		725227,
		728343,
		731486,
		734655,
		737853,
		741077,
		744330,
		747612,
		750922,
		754261,
		757631,
		761030,
		764459,
		767919,
		771411,
		774934,
		778490,
		782077,
		785698,
		789353,
		793041,
		796763,
		800521,
		804314,
		808143,
		812008,
		815910,
		819849,
		823827,
		827843,
		831898,
		835992,
		840127,
		844303,
		848521,
		852780,
		857082,
		861428,
		865817,
		870251,
		874731,
		879257,
		883829,
		888449,
		893118,
		897835,
		902602,
		907420,
		912290,
		917211,
		922186,
		927215,
		932298,
		937438,
		942634,
		947887,
		953200,
		958571,
		964004,
		969498,
		975055,
		980675,
		986361,
		992112,
		997931,
		1003818,
		1009775,
		1015802,
		1021901,
		1028074,
		1034322,
		1040645,
		1047047,
		1053527,
		1060087,
		1066729,
		1073455,
		1080266,
		1087164,
		1094149,
		1101225,
		1108393,
		1115654,
		1123011,
		1130465,
		1138018,
		1145673,
		1153430,
		1161294,
		1169265,
		1177345,
		1185538,
		1193845,
		1202270,
		1210813,
		1219479,
		1228269,
		1237186,
		1246233,
		1255414,
		1264730,
		1274185,
		1283782,
		1293525,
		1303416,
		1313459,
		1323658,
		1334015,
		1344536,
		1355224,
		1366083,
		1377116,
		1388329,
		1399726,
		1411311,
		1423088,
		1435064,
		1447242,
		1459629,
		1472229,
		1485047,
		1498091,
		1511365,
		1524876,
		1538631,
		1552635,
		1566897,
		1581422,
		1596218,
		1611294,
		1626656,
		1642314,
		1658276,
		1674550,
		1691147,
		1708075,
		1725345,
		1742967,
		1760953,
		1779313,
		1798060,
		1817205,
		1836761,
		1856743,
		1877164,
		1898038,
		1919381,
		1941209,
		1963539,
		1986387,
		2009773,
		2033716,
		2058236,
		2083353,
		2109090,
		2135471,
		2162519,
		2190260,
		2218722,
		2247933,
		2277922,
		2308722,
		2340365,
		2372887,
		2406325,
		2440718,
		2476107,
		2512537,
		2550055,
		2588709,
		2628552,
		2669640,
		2712032,
		2755792,
		2800985,
		2847685,
		2895968,
		2945916,
		2997615,
		3051161,
		3106654,
		3164201,
		3223920,
		3285935,
		3350382,
		3417407,
		3487167,
		3559833,
		3635591,
		3714643,
		3797207,
		3883524,
		3973856,
		4068489,
		4167737,
		4271947,
		4381501,
		4496821,
		4618374,
		4746679,
		4882315,
		5025930,
		5178248,
		5340085,
		5512363,
		5696125,
		5892561,
		6103026,
		6329081,
		6572525,
		6835443,
		7120270,
		7429864,
		7767602,
		8137505,
		8544398,
		8994120,
		9493811,
		10052288,
		10680573,
		11392628,
		12206405,
		13145377,
		14240842,
		15535482,
		17089047,
		18987848,
		21361347,
		24412986,
		28481835,
		34178221,
		42722794,
		56963745,
		85445637,
		170891290,
		-2147483647,
		-170891330,
		-85445647,
		-56963750,
		-42722797,
		-34178222,
		-28481836,
		-24412987,
		-21361348,
		-18987849,
		-17089048,
		-15535482,
		-14240842,
		-13145377,
		-12206405,
		-11392629,
		-10680573,
		-10052288,
		-9493811,
		-8994120,
		-8544398,
		-8137505,
		-7767602,
		-7429864,
		-7120270,
		-6835443,
		-6572525,
		-6329081,
		-6103026,
		-5892561,
		-5696125,
		-5512363,
		-5340085,
		-5178248,
		-5025930,
		-4882315,
		-4746679,
		-4618374,
		-4496821,
		-4381501,
		-4271947,
		-4167737,
		-4068489,
		-3973856,
		-3883525,
		-3797207,
		-3714643,
		-3635591,
		-3559833,
		-3487167,
		-3417407,
		-3350382,
		-3285935,
		-3223920,
		-3164201,
		-3106654,
		-3051161,
		-2997615,
		-2945916,
		-2895968,
		-2847685,
		-2800985,
		-2755792,
		-2712032,
		-2669640,
		-2628552,
		-2588709,
		-2550055,
		-2512537,
		-2476107,
		-2440718,
		-2406325,
		-2372887,
		-2340365,
		-2308722,
		-2277922,
		-2247933,
		-2218722,
		-2190260,
		-2162519,
		-2135471,
		-2109090,
		-2083353,
		-2058236,
		-2033716,
		-2009773,
		-1986387,
		-1963539,
		-1941209,
		-1919381,
		-1898038,
		-1877164,
		-1856743,
		-1836761,
		-1817205,
		-1798060,
		-1779313,
		-1760953,
		-1742967,
		-1725345,
		-1708075,
		-1691147,
		-1674550,
		-1658276,
		-1642314,
		-1626656,
		-1611294,
		-1596218,
		-1581422,
		-1566897,
		-1552635,
		-1538631,
		-1524876,
		-1511365,
		-1498091,
		-1485047,
		-1472229,
		-1459629,
		-1447242,
		-1435064,
		-1423088,
		-1411311,
		-1399726,
		-1388329,
		-1377116,
		-1366083,
		-1355224,
		-1344536,
		-1334015,
		-1323658,
		-1313459,
		-1303416,
		-1293525,
		-1283782,
		-1274185,
		-1264730,
		-1255414,
		-1246233,
		-1237186,
		-1228269,
		-1219479,
		-1210813,
		-1202270,
		-1193845,
		-1185538,
		-1177345,
		-1169265,
		-1161294,
		-1153430,
		-1145673,
		-1138018,
		-1130465,
		-1123011,
		-1115654,
		-1108393,
		-1101225,
		-1094149,
		-1087164,
		-1080266,
		-1073455,
		-1066729,
		-1060087,
		-1053527,
		-1047047,
		-1040645,
		-1034322,
		-1028074,
		-1021901,
		-1015802,
		-1009775,
		-1003818,
		-997931,
		-992112,
		-986361,
		-980675,
		-975055,
		-969498,
		-964004,
		-958571,
		-953200,
		-947887,
		-942634,
		-937438,
		-932298,
		-927215,
		-922186,
		-917211,
		-912290,
		-907420,
		-902602,
		-897835,
		-893118,
		-888449,
		-883829,
		-879257,
		-874731,
		-870251,
		-865817,
		-861428,
		-857082,
		-852780,
		-848521,
		-844303,
		-840127,
		-835992,
		-831898,
		-827843,
		-823827,
		-819849,
		-815910,
		-812008,
		-808143,
		-804314,
		-800521,
		-796763,
		-793041,
		-789353,
		-785698,
		-782077,
		-778490,
		-774934,
		-771411,
		-767919,
		-764459,
		-761030,
		-757631,
		-754261,
		-750922,
		-747612,
		-744330,
		-741077,
		-737853,
		-734655,
		-731486,
		-728343,
		-725227,
		-722137,
		-719073,
		-716035,
		-713023,
		-710035,
		-707072,
		-704133,
		-701219,
		-698328,
		-695461,
		-692618,
		-689797,
		-686999,
		-684223,
		-681469,
		-678737,
		-676027,
		-673338,
		-670671,
		-668024,
		-665398,
		-662792,
		-660206,
		-657640,
		-655094,
		-652568,
		-650060,
		-647572,
		-645102,
		-642651,
		-640218,
		-637804,
		-635407,
		-633028,
		-630667,
		-628323,
		-625996,
		-623686,
		-621393,
		-619117,
		-616857,
		-614613,
		-612386,
		-610174,
		-607978,
		-605798,
		-603633,
		-601483,
		-599348,
		-597229,
		-595124,
		-593033,
		-590957,
		-588896,
		-586848,
		-584815,
		-582795,
		-580790,
		-578797,
		-576819,
		-574853,
		-572901,
		-570962,
		-569035,
		-567122,
		-565221,
		-563333,
		-561457,
		-559593,
		-557741,
		-555902,
		-554074,
		-552259,
		-550455,
		-548662,
		-546881,
		-545112,
		-543353,
		-541606,
		-539870,
		-538145,
		-536431,
		-534727,
		-533034,
		-531351,
		-529679,
		-528018,
		-526366,
		-524725,
		-523093,
		-521472,
		-519861,
		-518259,
		-516667,
		-515084,
		-513512,
		-511948,
		-510394,
		-508849,
		-507313,
		-505787,
		-504269,
		-502760,
		-501260,
		-499769,
		-498287,
		-496813,
		-495348,
		-493891,
		-492443,
		-491003,
		-489571,
		-488148,
		-486732,
		-485325,
		-483925,
		-482534,
		-481150,
		-479774,
		-478406,
		-477045,
		-475692,
		-474347,
		-473009,
		-471678,
		-470354,
		-469038,
		-467729,
		-466428,
		-465133,
		-463845,
		-462565,
		-461291,
		-460024,
		-458764,
		-457511,
		-456264,
		-455024,
		-453791,
		-452564,
		-451343,
		-450129,
		-448922,
		-447720,
		-446526,
		-445337,
		-444154,
		-442978,
		-441807,
		-440643,
		-439485,
		-438332,
		-437186,
		-436045,
		-434910,
		-433781,
		-432658,
		-431540,
		-430428,
		-429322,
		-428221,
		-427125,
		-426035,
		-424951,
		-423871,
		-422798,
		-421729,
		-420666,
		-419608,
		-418555,
		-417507,
		-416465,
		-415427,
		-414395,
		-413367,
		-412345,
		-411327,
		-410314,
		-409306,
		-408303,
		-407305,
		-406311,
		-405323,
		-404338,
		-403359,
		-402384,
		-401414,
		-400448,
		-399487,
		-398530,
		-397578,
		-396630,
		-395686,
		-394747,
		-393812,
		-392882,
		-391956,
		-391033,
		-390116,
		-389202,
		-388293,
		-387387,
		-386486,
		-385589,
		-384696,
		-383807,
		-382921,
		-382040,
		-381163,
		-380290,
		-379420,
		-378555,
		-377693,
		-376835,
		-375981,
		-375130,
		-374283,
		-373440,
		-372601,
		-371765,
		-370933,
		-370105,
		-369280,
		-368458,
		-367641,
		-366826,
		-366016,
		-365208,
		-364404,
		-363604,
		-362807,
		-362013,
		-361223,
		-360436,
		-359652,
		-358872,
		-358094,
		-357321,
		-356550,
		-355783,
		-355018,
		-354257,
		-353499,
		-352744,
		-351993,
		-351244,
		-350499,
		-349756,
		-349017,
		-348280,
		-347547,
		-346816,
		-346089,
		-345364,
		-344643,
		-343924,
		-343208,
		-342495,
		-341785,
		-341078,
		-340373,
		-339671,
		-338973,
		-338276,
		-337583,
		-336892,
		-336204,
		-335519,
		-334837,
		-334157,
		-333480,
		-332805,
		-332133,
		-331464,
		-330797,
		-330133,
		-329471,
		-328812,
		-328156,
		-327502,
		-326850,
		-326201,
		-325554,
		-324910,
		-324269,
		-323629,
		-322993,
		-322358,
		-321726,
		-321097,
		-320469,
		-319844,
		-319222,
		-318602,
		-317984,
		-317368,
		-316754,
		-316143,
		-315535,
		-314928,
		-314324,
		-313721,
		-313121,
		-312524,
		-311928,
		-311335,
		-310743,
		-310154,
		-309567,
		-308982,
		-308400,
		-307819,
		-307240,
		-306664,
		-306090,
		-305517,
		-304947,
		-304379,
		-303812,
		-303248,
		-302686,
		-302126,
		-301567,
		-301011,
		-300457,
		-299904,
		-299354,
		-298805,
		-298259,
		-297714,
		-297171,
		-296630,
		-296091,
		-295554,
		-295018,
		-294485,
		-293953,
		-293423,
		-292895,
		-292369,
		-291845,
		-291322,
		-290801,
		-290282,
		-289765,
		-289249,
		-288735,
		-288223,
		-287713,
		-287204,
		-286697,
		-286192,
		-285688,
		-285186,
		-284686,
		-284188,
		-283691,
		-283195,
		-282702,
		-282210,
		-281719,
		-281231,
		-280743,
		-280258,
		-279774,
		-279292,
		-278811,
		-278332,
		-277854,
		-277378,
		-276903,
		-276430,
		-275959,
		-275489,
		-275020,
		-274553,
		-274088,
		-273624,
		-273161,
		-272700,
		-272241,
		-271782,
		-271326,
		-270871,
		-270417,
		-269965,
		-269514,
		-269064,
		-268616,
		-268169,
		-267724,
		-267280,
		-266838,
		-266397,
		-265957,
		-265519,
		-265082,
		-264646,
		-264212,
		-263779,
		-263347,
		-262917,
		-262488,
		-262060,
		-261634,
		-261209,
		-260785,
		-260363,
		-259941,
		-259522,
		-259103,
		-258686,
		-258270,
		-257855,
		-257441,
		-257029,
		-256618,
		-256208,
		-255799,
		-255392,
		-254986,
		-254581,
		-254177,
		-253774,
		-253373,
		-252973,
		-252574,
		-252176,
		-251779,
		-251384,
		-250989,
		-250596,
		-250204,
		-249813,
		-249423,
		-249035,
		-248647,
		-248261,
		-247876,
		-247492,
		-247109,
		-246727,
		-246346,
		-245966,
		-245588,
		-245210,
		-244834,
		-244458,
		-244084,
		-243711,
		-243338,
		-242967,
		-242597,
		-242228,
		-241860,
		-241493,
		-241128,
		-240763,
		-240399,
		-240036,
		-239674,
		-239314,
		-238954,
		-238595,
		-238237,
		-237881,
		-237525,
		-237170,
		-236816,
		-236463,
		-236112,
		-235761,
		-235411,
		-235062,
		-234714,
		-234367,
		-234021,
		-233676,
		-233331,
		-232988,
		-232646,
		-232304,
		-231964,
		-231624,
		-231286,
		-230948,
		-230611,
		-230275,
		-229940,
		-229606,
		-229273,
		-228941,
		-228610,
		-228279,
		-227949,
		-227621,
		-227293,
		-226966,
		-226640,
		-226314,
		-225990,
		-225666,
		-225344,
		-225022,
		-224701,
		-224381,
		-224061,
		-223743,
		-223425,
		-223108,
		-222792,
		-222477,
		-222163,
		-221849,
		-221536,
		-221225,
		-220913,
		-220603,
		-220294,
		-219985,
		-219677,
		-219370,
		-219064,
		-218758,
		-218453,
		-218149,
		-217846,
		-217544,
		-217242,
		-216941,
		-216641,
		-216341,
		-216043,
		-215745,
		-215448,
		-215151,
		-214856,
		-214561,
		-214267,
		-213973,
		-213681,
		-213389,
		-213097,
		-212807,
		-212517,
		-212228,
		-211940,
		-211652,
		-211365,
		-211079,
		-210793,
		-210509,
		-210225,
		-209941,
		-209658,
		-209376,
		-209095,
		-208815,
		-208535,
		-208255,
		-207977,
		-207699,
		-207422,
		-207145,
		-206869,
		-206594,
		-206319,
		-206045,
		-205772,
		-205500,
		-205228,
		-204956,
		-204686,
		-204416,
		-204147,
		-203878,
		-203610,
		-203342,
		-203076,
		-202809,
		-202544,
		-202279,
		-202015,
		-201751,
		-201488,
		-201226,
		-200964,
		-200703,
		-200442,
		-200182,
		-199923,
		-199664,
		-199406,
		-199149,
		-198892,
		-198636,
		-198380,
		-198125,
		-197870,
		-197616,
		-197363,
		-197110,
		-196858,
		-196606,
		-196355,
		-196105,
		-195855,
		-195606,
		-195357,
		-195109,
		-194861,
		-194614,
		-194367,
		-194122,
		-193876,
		-193631,
		-193387,
		-193143,
		-192900,
		-192658,
		-192416,
		-192174,
		-191933,
		-191693,
		-191453,
		-191213,
		-190975,
		-190736,
		-190499,
		-190261,
		-190025,
		-189789,
		-189553,
		-189318,
		-189083,
		-188849,
		-188615,
		-188382,
		-188150,
		-187918,
		-187686,
		-187455,
		-187225,
		-186995,
		-186765,
		-186536,
		-186308,
		-186080,
		-185852,
		-185625,
		-185399,
		-185173,
		-184947,
		-184722,
		-184498,
		-184274,
		-184050,
		-183827,
		-183604,
		-183382,
		-183160,
		-182939,
		-182718,
		-182498,
		-182278,
		-182059,
		-181840,
		-181622,
		-181404,
		-181186,
		-180969,
		-180753,
		-180537,
		-180321,
		-180106,
		-179891,
		-179677,
		-179463,
		-179250,
		-179037,
		-178824,
		-178612,
		-178401,
		-178190,
		-177979,
		-177769,
		-177559,
		-177349,
		-177140,
		-176932,
		-176724,
		-176516,
		-176309,
		-176102,
		-175896,
		-175690,
		-175484,
		-175279,
		-175074,
		-174870,
		-174666,
		-174463,
		-174260,
		-174057,
		-173855,
		-173653,
		-173452,
		-173251,
		-173050,
		-172850,
		-172650,
		-172451,
		-172252,
		-172053,
		-171855,
		-171657,
		-171460,
		-171263,
		-171066,
		-170870,
		-170674,
		-170479,
		-170284,
		-170089,
		-169895,
		-169701,
		-169508,
		-169315,
		-169122,
		-168930,
		-168738,
		-168546,
		-168355,
		-168164,
		-167974,
		-167784,
		-167594,
		-167405,
		-167216,
		-167027,
		-166839,
		-166651,
		-166464,
		-166277,
		-166090,
		-165904,
		-165718,
		-165532,
		-165347,
		-165162,
		-164977,
		-164793,
		-164609,
		-164426,
		-164242,
		-164060,
		-163877,
		-163695,
		-163513,
		-163332,
		-163151,
		-162970,
		-162790,
		-162610,
		-162430,
		-162251,
		-162072,
		-161893,
		-161715,
		-161537,
		-161359,
		-161182,
		-161005,
		-160828,
		-160652,
		-160476,
		-160300,
		-160125,
		-159950,
		-159775,
		-159601,
		-159427,
		-159253,
		-159079,
		-158906,
		-158734,
		-158561,
		-158389,
		-158217,
		-158046,
		-157875,
		-157704,
		-157533,
		-157363,
		-157193,
		-157024,
		-156855,
		-156686,
		-156517,
		-156349,
		-156181,
		-156013,
		-155845,
		-155678,
		-155512,
		-155345,
		-155179,
		-155013,
		-154847,
		-154682,
		-154517,
		-154352,
		-154188,
		-154024,
		-153860,
		-153697,
		-153533,
		-153370,
		-153208,
		-153045,
		-152883,
		-152722,
		-152560,
		-152399,
		-152238,
		-152077,
		-151917,
		-151757,
		-151597,
		-151438,
		-151279,
		-151120,
		-150961,
		-150803,
		-150645,
		-150487,
		-150329,
		-150172,
		-150015,
		-149859,
		-149702,
		-149546,
		-149390,
		-149235,
		-149079,
		-148924,
		-148769,
		-148615,
		-148461,
		-148307,
		-148153,
		-148000,
		-147846,
		-147693,
		-147541,
		-147388,
		-147236,
		-147084,
		-146933,
		-146781,
		-146630,
		-146480,
		-146329,
		-146179,
		-146029,
		-145879,
		-145729,
		-145580,
		-145431,
		-145282,
		-145134,
		-144986,
		-144837,
		-144690,
		-144542,
		-144395,
		-144248,
		-144101,
		-143955,
		-143808,
		-143662,
		-143517,
		-143371,
		-143226,
		-143081,
		-142936,
		-142791,
		-142647,
		-142503,
		-142359,
		-142215,
		-142072,
		-141929,
		-141786,
		-141643,
		-141501,
		-141359,
		-141217,
		-141075,
		-140934,
		-140792,
		-140651,
		-140511,
		-140370,
		-140230,
		-140090,
		-139950,
		-139810,
		-139671,
		-139532,
		-139393,
		-139254,
		-139115,
		-138977,
		-138839,
		-138701,
		-138564,
		-138426,
		-138289,
		-138152,
		-138016,
		-137879,
		-137743,
		-137607,
		-137471,
		-137335,
		-137200,
		-137065,
		-136930,
		-136795,
		-136661,
		-136526,
		-136392,
		-136258,
		-136125,
		-135991,
		-135858,
		-135725,
		-135592,
		-135459,
		-135327,
		-135195,
		-135063,
		-134931,
		-134799,
		-134668,
		-134537,
		-134406,
		-134275,
		-134145,
		-134014,
		-133884,
		-133754,
		-133625,
		-133495,
		-133366,
		-133237,
		-133108,
		-132979,
		-132851,
		-132722,
		-132594,
		-132466,
		-132338,
		-132211,
		-132084,
		-131957,
		-131830,
		-131703,
		-131576,
		-131450,
		-131324,
		-131198,
		-131072,
		-130947,
		-130821,
		-130696,
		-130571,
		-130446,
		-130322,
		-130197,
		-130073,
		-129949,
		-129825,
		-129701,
		-129578,
		-129455,
		-129331,
		-129209,
		-129086,
		-128963,
		-128841,
		-128719,
		-128597,
		-128475,
		-128353,
		-128232,
		-128111,
		-127990,
		-127869,
		-127748,
		-127627,
		-127507,
		-127387,
		-127267,
		-127147,
		-127027,
		-126908,
		-126789,
		-126669,
		-126551,
		-126432,
		-126313,
		-126195,
		-126077,
		-125958,
		-125841,
		-125723,
		-125605,
		-125488,
		-125371,
		-125254,
		-125137,
		-125020,
		-124904,
		-124787,
		-124671,
		-124555,
		-124439,
		-124324,
		-124208,
		-124093,
		-123978,
		-123863,
		-123748,
		-123633,
		-123519,
		-123404,
		-123290,
		-123176,
		-123062,
		-122949,
		-122835,
		-122722,
		-122609,
		-122496,
		-122383,
		-122270,
		-122158,
		-122045,
		-121933,
		-121821,
		-121709,
		-121597,
		-121486,
		-121374,
		-121263,
		-121152,
		-121041,
		-120930,
		-120820,
		-120709,
		-120599,
		-120489,
		-120379,
		-120269,
		-120159,
		-120050,
		-119940,
		-119831,
		-119722,
		-119613,
		-119504,
		-119396,
		-119287,
		-119179,
		-119071,
		-118963,
		-118855,
		-118747,
		-118639,
		-118532,
		-118425,
		-118318,
		-118211,
		-118104,
		-117997,
		-117891,
		-117784,
		-117678,
		-117572,
		-117466,
		-117360,
		-117254,
		-117149,
		-117044,
		-116938,
		-116833,
		-116728,
		-116623,
		-116519,
		-116414,
		-116310,
		-116206,
		-116102,
		-115998,
		-115894,
		-115790,
		-115687,
		-115583,
		-115480,
		-115377,
		-115274,
		-115171,
		-115069,
		-114966,
		-114864,
		-114761,
		-114659,
		-114557,
		-114455,
		-114354,
		-114252,
		-114151,
		-114049,
		-113948,
		-113847,
		-113746,
		-113645,
		-113545,
		-113444,
		-113344,
		-113244,
		-113143,
		-113043,
		-112944,
		-112844,
		-112744,
		-112645,
		-112546,
		-112446,
		-112347,
		-112248,
		-112150,
		-112051,
		-111952,
		-111854,
		-111756,
		-111658,
		-111560,
		-111462,
		-111364,
		-111266,
		-111169,
		-111071,
		-110974,
		-110877,
		-110780,
		-110683,
		-110586,
		-110490,
		-110393,
		-110297,
		-110200,
		-110104,
		-110008,
		-109912,
		-109817,
		-109721,
		-109626,
		-109530,
		-109435,
		-109340,
		-109245,
		-109150,
		-109055,
		-108960,
		-108866,
		-108771,
		-108677,
		-108583,
		-108489,
		-108395,
		-108301,
		-108207,
		-108114,
		-108020,
		-107927,
		-107834,
		-107741,
		-107648,
		-107555,
		-107462,
		-107369,
		-107277,
		-107184,
		-107092,
		-107000,
		-106908,
		-106816,
		-106724,
		-106632,
		-106541,
		-106449,
		-106358,
		-106266,
		-106175,
		-106084,
		-105993,
		-105902,
		-105812,
		-105721,
		-105631,
		-105540,
		-105450,
		-105360,
		-105270,
		-105180,
		-105090,
		-105000,
		-104911,
		-104821,
		-104732,
		-104643,
		-104554,
		-104465,
		-104376,
		-104287,
		-104198,
		-104109,
		-104021,
		-103933,
		-103844,
		-103756,
		-103668,
		-103580,
		-103492,
		-103404,
		-103317,
		-103229,
		-103142,
		-103054,
		-102967,
		-102880,
		-102793,
		-102706,
		-102619,
		-102533,
		-102446,
		-102360,
		-102273,
		-102187,
		-102101,
		-102015,
		-101929,
		-101843,
		-101757,
		-101671,
		-101586,
		-101500,
		-101415,
		-101330,
		-101244,
		-101159,
		-101074,
		-100990,
		-100905,
		-100820,
		-100736,
		-100651,
		-100567,
		-100482,
		-100398,
		-100314,
		-100230,
		-100146,
		-100063,
		-99979,
		-99895,
		-99812,
		-99729,
		-99645,
		-99562,
		-99479,
		-99396,
		-99313,
		-99230,
		-99148,
		-99065,
		-98982,
		-98900,
		-98818,
		-98735,
		-98653,
		-98571,
		-98489,
		-98408,
		-98326,
		-98244,
		-98163,
		-98081,
		-98000,
		-97918,
		-97837,
		-97756,
		-97675,
		-97594,
		-97513,
		-97433,
		-97352,
		-97271,
		-97191,
		-97111,
		-97030,
		-96950,
		-96870,
		-96790,
		-96710,
		-96630,
		-96551,
		-96471,
		-96391,
		-96312,
		-96233,
		-96153,
		-96074,
		-95995,
		-95916,
		-95837,
		-95758,
		-95680,
		-95601,
		-95522,
		-95444,
		-95365,
		-95287,
		-95209,
		-95131,
		-95053,
		-94975,
		-94897,
		-94819,
		-94741,
		-94664,
		-94586,
		-94509,
		-94431,
		-94354,
		-94277,
		-94200,
		-94123,
		-94046,
		-93969,
		-93892,
		-93816,
		-93739,
		-93663,
		-93586,
		-93510,
		-93434,
		-93357,
		-93281,
		-93205,
		-93129,
		-93053,
		-92978,
		-92902,
		-92826,
		-92751,
		-92675,
		-92600,
		-92525,
		-92450,
		-92375,
		-92300,
		-92225,
		-92150,
		-92075,
		-92000,
		-91926,
		-91851,
		-91777,
		-91702,
		-91628,
		-91554,
		-91480,
		-91406,
		-91332,
		-91258,
		-91184,
		-91110,
		-91036,
		-90963,
		-90889,
		-90816,
		-90742,
		-90669,
		-90596,
		-90523,
		-90450,
		-90377,
		-90304,
		-90231,
		-90158,
		-90086,
		-90013,
		-89941,
		-89868,
		-89796,
		-89724,
		-89651,
		-89579,
		-89507,
		-89435,
		-89363,
		-89292,
		-89220,
		-89148,
		-89077,
		-89005,
		-88934,
		-88862,
		-88791,
		-88720,
		-88648,
		-88577,
		-88506,
		-88435,
		-88365,
		-88294,
		-88223,
		-88152,
		-88082,
		-88011,
		-87941,
		-87871,
		-87800,
		-87730,
		-87660,
		-87590,
		-87520,
		-87450,
		-87380,
		-87310,
		-87241,
		-87171,
		-87101,
		-87032,
		-86963,
		-86893,
		-86824,
		-86755,
		-86686,
		-86616,
		-86547,
		-86479,
		-86410,
		-86341,
		-86272,
		-86204,
		-86135,
		-86066,
		-85998,
		-85930,
		-85861,
		-85793,
		-85725,
		-85657,
		-85589,
		-85521,
		-85453,
		-85385,
		-85317,
		-85250,
		-85182,
		-85114,
		-85047,
		-84980,
		-84912,
		-84845,
		-84778,
		-84710,
		-84643,
		-84576,
		-84509,
		-84443,
		-84376,
		-84309,
		-84242,
		-84176,
		-84109,
		-84043,
		-83976,
		-83910,
		-83843,
		-83777,
		-83711,
		-83645,
		-83579,
		-83513,
		-83447,
		-83381,
		-83315,
		-83250,
		-83184,
		-83118,
		-83053,
		-82987,
		-82922,
		-82857,
		-82791,
		-82726,
		-82661,
		-82596,
		-82531,
		-82466,
		-82401,
		-82336,
		-82271,
		-82207,
		-82142,
		-82078,
		-82013,
		-81949,
		-81884,
		-81820,
		-81756,
		-81691,
		-81627,
		-81563,
		-81499,
		-81435,
		-81371,
		-81307,
		-81244,
		-81180,
		-81116,
		-81053,
		-80989,
		-80925,
		-80862,
		-80799,
		-80735,
		-80672,
		-80609,
		-80546,
		-80483,
		-80420,
		-80357,
		-80294,
		-80231,
		-80168,
		-80106,
		-80043,
		-79980,
		-79918,
		-79855,
		-79793,
		-79731,
		-79668,
		-79606,
		-79544,
		-79482,
		-79420,
		-79358,
		-79296,
		-79234,
		-79172,
		-79110,
		-79048,
		-78987,
		-78925,
		-78864,
		-78802,
		-78741,
		-78679,
		-78618,
		-78557,
		-78495,
		-78434,
		-78373,
		-78312,
		-78251,
		-78190,
		-78129,
		-78068,
		-78008,
		-77947,
		-77886,
		-77826,
		-77765,
		-77705,
		-77644,
		-77584,
		-77524,
		-77463,
		-77403,
		-77343,
		-77283,
		-77223,
		-77163,
		-77103,
		-77043,
		-76983,
		-76923,
		-76864,
		-76804,
		-76744,
		-76685,
		-76625,
		-76566,
		-76506,
		-76447,
		-76388,
		-76328,
		-76269,
		-76210,
		-76151,
		-76092,
		-76033,
		-75974,
		-75915,
		-75856,
		-75797,
		-75739,
		-75680,
		-75621,
		-75563,
		-75504,
		-75446,
		-75387,
		-75329,
		-75271,
		-75213,
		-75154,
		-75096,
		-75038,
		-74980,
		-74922,
		-74864,
		-74806,
		-74748,
		-74690,
		-74633,
		-74575,
		-74517,
		-74460,
		-74402,
		-74345,
		-74287,
		-74230,
		-74172,
		-74115,
		-74058,
		-74001,
		-73944,
		-73886,
		-73829,
		-73772,
		-73715,
		-73659,
		-73602,
		-73545,
		-73488,
		-73431,
		-73375,
		-73318,
		-73262,
		-73205,
		-73149,
		-73092,
		-73036,
		-72979,
		-72923,
		-72867,
		-72811,
		-72755,
		-72699,
		-72643,
		-72587,
		-72531,
		-72475,
		-72419,
		-72363,
		-72307,
		-72252,
		-72196,
		-72140,
		-72085,
		-72029,
		-71974,
		-71918,
		-71863,
		-71808,
		-71752,
		-71697,
		-71642,
		-71587,
		-71532,
		-71477,
		-71422,
		-71367,
		-71312,
		-71257,
		-71202,
		-71147,
		-71093,
		-71038,
		-70983,
		-70929,
		-70874,
		-70820,
		-70765,
		-70711,
		-70656,
		-70602,
		-70548,
		-70494,
		-70439,
		-70385,
		-70331,
		-70277,
		-70223,
		-70169,
		-70115,
		-70061,
		-70007,
		-69954,
		-69900,
		-69846,
		-69793,
		-69739,
		-69685,
		-69632,
		-69578,
		-69525,
		-69472,
		-69418,
		-69365,
		-69312,
		-69258,
		-69205,
		-69152,
		-69099,
		-69046,
		-68993,
		-68940,
		-68887,
		-68834,
		-68781,
		-68728,
		-68676,
		-68623,
		-68570,
		-68518,
		-68465,
		-68413,
		-68360,
		-68308,
		-68255,
		-68203,
		-68151,
		-68098,
		-68046,
		-67994,
		-67942,
		-67889,
		-67837,
		-67785,
		-67733,
		-67681,
		-67629,
		-67578,
		-67526,
		-67474,
		-67422,
		-67371,
		-67319,
		-67267,
		-67216,
		-67164,
		-67113,
		-67061,
		-67010,
		-66958,
		-66907,
		-66856,
		-66804,
		-66753,
		-66702,
		-66651,
		-66600,
		-66549,
		-66498,
		-66447,
		-66396,
		-66345,
		-66294,
		-66243,
		-66192,
		-66141,
		-66091,
		-66040,
		-65989,
		-65939,
		-65888,
		-65838,
		-65787,
		-65737,
		-65686,
		-65636,
		-65586,
		-65536,
		-65485,
		-65435,
		-65385,
		-65335,
		-65285,
		-65235,
		-65185,
		-65135,
		-65085,
		-65035,
		-64985,
		-64935,
		-64885,
		-64836,
		-64786,
		-64736,
		-64687,
		-64637,
		-64587,
		-64538,
		-64488,
		-64439,
		-64389,
		-64340,
		-64291,
		-64241,
		-64192,
		-64143,
		-64094,
		-64045,
		-63996,
		-63946,
		-63897,
		-63848,
		-63799,
		-63750,
		-63702,
		-63653,
		-63604,
		-63555,
		-63506,
		-63458,
		-63409,
		-63360,
		-63312,
		-63263,
		-63215,
		-63166,
		-63118,
		-63069,
		-63021,
		-62972,
		-62924,
		-62876,
		-62828,
		-62779,
		-62731,
		-62683,
		-62635,
		-62587,
		-62539,
		-62491,
		-62443,
		-62395,
		-62347,
		-62299,
		-62251,
		-62204,
		-62156,
		-62108,
		-62060,
		-62013,
		-61965,
		-61918,
		-61870,
		-61822,
		-61775,
		-61728,
		-61680,
		-61633,
		-61585,
		-61538,
		-61491,
		-61444,
		-61396,
		-61349,
		-61302,
		-61255,
		-61208,
		-61161,
		-61114,
		-61067,
		-61020,
		-60973,
		-60926,
		-60879,
		-60833,
		-60786,
		-60739,
		-60692,
		-60646,
		-60599,
		-60552,
		-60506,
		-60459,
		-60413,
		-60366,
		-60320,
		-60273,
		-60227,
		-60181,
		-60134,
		-60088,
		-60042,
		-59996,
		-59950,
		-59903,
		-59857,
		-59811,
		-59765,
		-59719,
		-59673,
		-59627,
		-59581,
		-59535,
		-59489,
		-59444,
		-59398,
		-59352,
		-59306,
		-59261,
		-59215,
		-59169,
		-59124,
		-59078,
		-59033,
		-58987,
		-58942,
		-58896,
		-58851,
		-58805,
		-58760,
		-58715,
		-58669,
		-58624,
		-58579,
		-58534,
		-58489,
		-58443,
		-58398,
		-58353,
		-58308,
		-58263,
		-58218,
		-58173,
		-58128,
		-58083,
		-58039,
		-57994,
		-57949,
		-57904,
		-57859,
		-57815,
		-57770,
		-57725,
		-57681,
		-57636,
		-57592,
		-57547,
		-57503,
		-57458,
		-57414,
		-57369,
		-57325,
		-57281,
		-57236,
		-57192,
		-57148,
		-57104,
		-57059,
		-57015,
		-56971,
		-56927,
		-56883,
		-56839,
		-56795,
		-56751,
		-56707,
		-56663,
		-56619,
		-56575,
		-56531,
		-56487,
		-56444,
		-56400,
		-56356,
		-56312,
		-56269,
		-56225,
		-56181,
		-56138,
		-56094,
		-56051,
		-56007,
		-55964,
		-55920,
		-55877,
		-55834,
		-55790,
		-55747,
		-55704,
		-55660,
		-55617,
		-55574,
		-55531,
		-55487,
		-55444,
		-55401,
		-55358,
		-55315,
		-55272,
		-55229,
		-55186,
		-55143,
		-55100,
		-55057,
		-55015,
		-54972,
		-54929,
		-54886,
		-54843,
		-54801,
		-54758,
		-54715,
		-54673,
		-54630,
		-54587,
		-54545,
		-54502,
		-54460,
		-54417,
		-54375,
		-54333,
		-54290,
		-54248,
		-54205,
		-54163,
		-54121,
		-54079,
		-54036,
		-53994,
		-53952,
		-53910,
		-53868,
		-53826,
		-53784,
		-53741,
		-53699,
		-53657,
		-53615,
		-53574,
		-53532,
		-53490,
		-53448,
		-53406,
		-53364,
		-53322,
		-53281,
		-53239,
		-53197,
		-53156,
		-53114,
		-53072,
		-53031,
		-52989,
		-52948,
		-52906,
		-52865,
		-52823,
		-52782,
		-52740,
		-52699,
		-52657,
		-52616,
		-52575,
		-52533,
		-52492,
		-52451,
		-52410,
		-52369,
		-52327,
		-52286,
		-52245,
		-52204,
		-52163,
		-52122,
		-52081,
		-52040,
		-51999,
		-51958,
		-51917,
		-51876,
		-51835,
		-51794,
		-51754,
		-51713,
		-51672,
		-51631,
		-51591,
		-51550,
		-51509,
		-51469,
		-51428,
		-51387,
		-51347,
		-51306,
		-51266,
		-51225,
		-51185,
		-51144,
		-51104,
		-51063,
		-51023,
		-50983,
		-50942,
		-50902,
		-50862,
		-50822,
		-50781,
		-50741,
		-50701,
		-50661,
		-50621,
		-50581,
		-50540,
		-50500,
		-50460,
		-50420,
		-50380,
		-50340,
		-50300,
		-50260,
		-50221,
		-50181,
		-50141,
		-50101,
		-50061,
		-50021,
		-49982,
		-49942,
		-49902,
		-49862,
		-49823,
		-49783,
		-49744,
		-49704,
		-49664,
		-49625,
		-49585,
		-49546,
		-49506,
		-49467,
		-49427,
		-49388,
		-49349,
		-49309,
		-49270,
		-49230,
		-49191,
		-49152,
		-49113,
		-49073,
		-49034,
		-48995,
		-48956,
		-48917,
		-48878,
		-48838,
		-48799,
		-48760,
		-48721,
		-48682,
		-48643,
		-48604,
		-48565,
		-48526,
		-48488,
		-48449,
		-48410,
		-48371,
		-48332,
		-48293,
		-48255,
		-48216,
		-48177,
		-48138,
		-48100,
		-48061,
		-48022,
		-47984,
		-47945,
		-47907,
		-47868,
		-47830,
		-47791,
		-47753,
		-47714,
		-47676,
		-47637,
		-47599,
		-47560,
		-47522,
		-47484,
		-47445,
		-47407,
		-47369,
		-47331,
		-47292,
		-47254,
		-47216,
		-47178,
		-47140,
		-47102,
		-47063,
		-47025,
		-46987,
		-46949,
		-46911,
		-46873,
		-46835,
		-46797,
		-46759,
		-46721,
		-46684,
		-46646,
		-46608,
		-46570,
		-46532,
		-46494,
		-46457,
		-46419,
		-46381,
		-46343,
		-46306,
		-46268,
		-46230,
		-46193,
		-46155,
		-46118,
		-46080,
		-46042,
		-46005,
		-45967,
		-45930,
		-45892,
		-45855,
		-45818,
		-45780,
		-45743,
		-45705,
		-45668,
		-45631,
		-45593,
		-45556,
		-45519,
		-45482,
		-45444,
		-45407,
		-45370,
		-45333,
		-45296,
		-45259,
		-45221,
		-45184,
		-45147,
		-45110,
		-45073,
		-45036,
		-44999,
		-44962,
		-44925,
		-44888,
		-44851,
		-44815,
		-44778,
		-44741,
		-44704,
		-44667,
		-44630,
		-44594,
		-44557,
		-44520,
		-44483,
		-44447,
		-44410,
		-44373,
		-44337,
		-44300,
		-44263,
		-44227,
		-44190,
		-44154,
		-44117,
		-44081,
		-44044,
		-44008,
		-43971,
		-43935,
		-43898,
		-43862,
		-43826,
		-43789,
		-43753,
		-43717,
		-43680,
		-43644,
		-43608,
		-43571,
		-43535,
		-43499,
		-43463,
		-43427,
		-43390,
		-43354,
		-43318,
		-43282,
		-43246,
		-43210,
		-43174,
		-43138,
		-43102,
		-43066,
		-43030,
		-42994,
		-42958,
		-42922,
		-42886,
		-42850,
		-42814,
		-42779,
		-42743,
		-42707,
		-42671,
		-42635,
		-42600,
		-42564,
		-42528,
		-42492,
		-42457,
		-42421,
		-42385,
		-42350,
		-42314,
		-42279,
		-42243,
		-42207,
		-42172,
		-42136,
		-42101,
		-42065,
		-42030,
		-41994,
		-41959,
		-41923,
		-41888,
		-41853,
		-41817,
		-41782,
		-41747,
		-41711,
		-41676,
		-41641,
		-41605,
		-41570,
		-41535,
		-41500,
		-41465,
		-41429,
		-41394,
		-41359,
		-41324,
		-41289,
		-41254,
		-41219,
		-41184,
		-41148,
		-41113,
		-41078,
		-41043,
		-41008,
		-40973,
		-40939,
		-40904,
		-40869,
		-40834,
		-40799,
		-40764,
		-40729,
		-40694,
		-40660,
		-40625,
		-40590,
		-40555,
		-40520,
		-40486,
		-40451,
		-40416,
		-40382,
		-40347,
		-40312,
		-40278,
		-40243,
		-40208,
		-40174,
		-40139,
		-40105,
		-40070,
		-40036,
		-40001,
		-39967,
		-39932,
		-39898,
		-39863,
		-39829,
		-39794,
		-39760,
		-39726,
		-39691,
		-39657,
		-39623,
		-39588,
		-39554,
		-39520,
		-39486,
		-39451,
		-39417,
		-39383,
		-39349,
		-39314,
		-39280,
		-39246,
		-39212,
		-39178,
		-39144,
		-39110,
		-39076,
		-39042,
		-39007,
		-38973,
		-38939,
		-38905,
		-38871,
		-38837,
		-38804,
		-38770,
		-38736,
		-38702,
		-38668,
		-38634,
		-38600,
		-38566,
		-38532,
		-38499,
		-38465,
		-38431,
		-38397,
		-38364,
		-38330,
		-38296,
		-38262,
		-38229,
		-38195,
		-38161,
		-38128,
		-38094,
		-38060,
		-38027,
		-37993,
		-37960,
		-37926,
		-37893,
		-37859,
		-37826,
		-37792,
		-37759,
		-37725,
		-37692,
		-37658,
		-37625,
		-37591,
		-37558,
		-37525,
		-37491,
		-37458,
		-37425,
		-37391,
		-37358,
		-37325,
		-37291,
		-37258,
		-37225,
		-37192,
		-37158,
		-37125,
		-37092,
		-37059,
		-37026,
		-36993,
		-36959,
		-36926,
		-36893,
		-36860,
		-36827,
		-36794,
		-36761,
		-36728,
		-36695,
		-36662,
		-36629,
		-36596,
		-36563,
		-36530,
		-36497,
		-36464,
		-36431,
		-36398,
		-36365,
		-36333,
		-36300,
		-36267,
		-36234,
		-36201,
		-36168,
		-36136,
		-36103,
		-36070,
		-36037,
		-36005,
		-35972,
		-35939,
		-35907,
		-35874,
		-35841,
		-35809,
		-35776,
		-35743,
		-35711,
		-35678,
		-35646,
		-35613,
		-35580,
		-35548,
		-35515,
		-35483,
		-35450,
		-35418,
		-35385,
		-35353,
		-35321,
		-35288,
		-35256,
		-35223,
		-35191,
		-35159,
		-35126,
		-35094,
		-35062,
		-35029,
		-34997,
		-34965,
		-34932,
		-34900,
		-34868,
		-34836,
		-34803,
		-34771,
		-34739,
		-34707,
		-34675,
		-34642,
		-34610,
		-34578,
		-34546,
		-34514,
		-34482,
		-34450,
		-34418,
		-34386,
		-34354,
		-34322,
		-34289,
		-34257,
		-34225,
		-34194,
		-34162,
		-34130,
		-34098,
		-34066,
		-34034,
		-34002,
		-33970,
		-33938,
		-33906,
		-33874,
		-33843,
		-33811,
		-33779,
		-33747,
		-33715,
		-33684,
		-33652,
		-33620,
		-33588,
		-33557,
		-33525,
		-33493,
		-33461,
		-33430,
		-33398,
		-33366,
		-33335,
		-33303,
		-33272,
		-33240,
		-33208,
		-33177,
		-33145,
		-33114,
		-33082,
		-33051,
		-33019,
		-32988,
		-32956,
		-32925,
		-32893,
		-32862,
		-32830,
		-32799,
		-32767,
		-32736,
		-32705,
		-32673,
		-32642,
		-32610,
		-32579,
		-32548,
		-32516,
		-32485,
		-32454,
		-32422,
		-32391,
		-32360,
		-32329,
		-32297,
		-32266,
		-32235,
		-32204,
		-32173,
		-32141,
		-32110,
		-32079,
		-32048,
		-32017,
		-31986,
		-31955,
		-31923,
		-31892,
		-31861,
		-31830,
		-31799,
		-31768,
		-31737,
		-31706,
		-31675,
		-31644,
		-31613,
		-31582,
		-31551,
		-31520,
		-31489,
		-31458,
		-31427,
		-31396,
		-31366,
		-31335,
		-31304,
		-31273,
		-31242,
		-31211,
		-31180,
		-31150,
		-31119,
		-31088,
		-31057,
		-31026,
		-30996,
		-30965,
		-30934,
		-30904,
		-30873,
		-30842,
		-30811,
		-30781,
		-30750,
		-30719,
		-30689,
		-30658,
		-30627,
		-30597,
		-30566,
		-30536,
		-30505,
		-30474,
		-30444,
		-30413,
		-30383,
		-30352,
		-30322,
		-30291,
		-30261,
		-30230,
		-30200,
		-30169,
		-30139,
		-30108,
		-30078,
		-30048,
		-30017,
		-29987,
		-29956,
		-29926,
		-29896,
		-29865,
		-29835,
		-29805,
		-29774,
		-29744,
		-29714,
		-29683,
		-29653,
		-29623,
		-29593,
		-29562,
		-29532,
		-29502,
		-29472,
		-29441,
		-29411,
		-29381,
		-29351,
		-29321,
		-29291,
		-29260,
		-29230,
		-29200,
		-29170,
		-29140,
		-29110,
		-29080,
		-29050,
		-29020,
		-28989,
		-28959,
		-28929,
		-28899,
		-28869,
		-28839,
		-28809,
		-28779,
		-28749,
		-28719,
		-28689,
		-28660,
		-28630,
		-28600,
		-28570,
		-28540,
		-28510,
		-28480,
		-28450,
		-28420,
		-28390,
		-28361,
		-28331,
		-28301,
		-28271,
		-28241,
		-28212,
		-28182,
		-28152,
		-28122,
		-28092,
		-28063,
		-28033,
		-28003,
		-27974,
		-27944,
		-27914,
		-27884,
		-27855,
		-27825,
		-27795,
		-27766,
		-27736,
		-27707,
		-27677,
		-27647,
		-27618,
		-27588,
		-27559,
		-27529,
		-27499,
		-27470,
		-27440,
		-27411,
		-27381,
		-27352,
		-27322,
		-27293,
		-27263,
		-27234,
		-27204,
		-27175,
		-27145,
		-27116,
		-27087,
		-27057,
		-27028,
		-26998,
		-26969,
		-26940,
		-26910,
		-26881,
		-26851,
		-26822,
		-26793,
		-26763,
		-26734,
		-26705,
		-26675,
		-26646,
		-26617,
		-26588,
		-26558,
		-26529,
		-26500,
		-26471,
		-26441,
		-26412,
		-26383,
		-26354,
		-26325,
		-26295,
		-26266,
		-26237,
		-26208,
		-26179,
		-26150,
		-26120,
		-26091,
		-26062,
		-26033,
		-26004,
		-25975,
		-25946,
		-25917,
		-25888,
		-25859,
		-25830,
		-25801,
		-25772,
		-25743,
		-25714,
		-25685,
		-25656,
		-25627,
		-25598,
		-25569,
		-25540,
		-25511,
		-25482,
		-25453,
		-25424,
		-25395,
		-25366,
		-25337,
		-25308,
		-25280,
		-25251,
		-25222,
		-25193,
		-25164,
		-25135,
		-25106,
		-25078,
		-25049,
		-25020,
		-24991,
		-24962,
		-24934,
		-24905,
		-24876,
		-24847,
		-24819,
		-24790,
		-24761,
		-24732,
		-24704,
		-24675,
		-24646,
		-24618,
		-24589,
		-24560,
		-24532,
		-24503,
		-24474,
		-24446,
		-24417,
		-24389,
		-24360,
		-24331,
		-24303,
		-24274,
		-24246,
		-24217,
		-24188,
		-24160,
		-24131,
		-24103,
		-24074,
		-24046,
		-24017,
		-23989,
		-23960,
		-23932,
		-23903,
		-23875,
		-23846,
		-23818,
		-23789,
		-23761,
		-23733,
		-23704,
		-23676,
		-23647,
		-23619,
		-23591,
		-23562,
		-23534,
		-23505,
		-23477,
		-23449,
		-23420,
		-23392,
		-23364,
		-23335,
		-23307,
		-23279,
		-23250,
		-23222,
		-23194,
		-23166,
		-23137,
		-23109,
		-23081,
		-23053,
		-23024,
		-22996,
		-22968,
		-22940,
		-22911,
		-22883,
		-22855,
		-22827,
		-22799,
		-22770,
		-22742,
		-22714,
		-22686,
		-22658,
		-22630,
		-22602,
		-22573,
		-22545,
		-22517,
		-22489,
		-22461,
		-22433,
		-22405,
		-22377,
		-22349,
		-22321,
		-22293,
		-22265,
		-22237,
		-22209,
		-22181,
		-22153,
		-22125,
		-22097,
		-22069,
		-22041,
		-22013,
		-21985,
		-21957,
		-21929,
		-21901,
		-21873,
		-21845,
		-21817,
		-21789,
		-21761,
		-21733,
		-21705,
		-21678,
		-21650,
		-21622,
		-21594,
		-21566,
		-21538,
		-21510,
		-21483,
		-21455,
		-21427,
		-21399,
		-21371,
		-21343,
		-21316,
		-21288,
		-21260,
		-21232,
		-21205,
		-21177,
		-21149,
		-21121,
		-21094,
		-21066,
		-21038,
		-21010,
		-20983,
		-20955,
		-20927,
		-20900,
		-20872,
		-20844,
		-20817,
		-20789,
		-20761,
		-20734,
		-20706,
		-20678,
		-20651,
		-20623,
		-20595,
		-20568,
		-20540,
		-20513,
		-20485,
		-20457,
		-20430,
		-20402,
		-20375,
		-20347,
		-20320,
		-20292,
		-20264,
		-20237,
		-20209,
		-20182,
		-20154,
		-20127,
		-20099,
		-20072,
		-20044,
		-20017,
		-19989,
		-19962,
		-19935,
		-19907,
		-19880,
		-19852,
		-19825,
		-19797,
		-19770,
		-19742,
		-19715,
		-19688,
		-19660,
		-19633,
		-19605,
		-19578,
		-19551,
		-19523,
		-19496,
		-19469,
		-19441,
		-19414,
		-19387,
		-19359,
		-19332,
		-19305,
		-19277,
		-19250,
		-19223,
		-19195,
		-19168,
		-19141,
		-19114,
		-19086,
		-19059,
		-19032,
		-19005,
		-18977,
		-18950,
		-18923,
		-18896,
		-18868,
		-18841,
		-18814,
		-18787,
		-18760,
		-18732,
		-18705,
		-18678,
		-18651,
		-18624,
		-18597,
		-18569,
		-18542,
		-18515,
		-18488,
		-18461,
		-18434,
		-18407,
		-18380,
		-18352,
		-18325,
		-18298,
		-18271,
		-18244,
		-18217,
		-18190,
		-18163,
		-18136,
		-18109,
		-18082,
		-18055,
		-18028,
		-18001,
		-17974,
		-17946,
		-17919,
		-17892,
		-17865,
		-17838,
		-17811,
		-17784,
		-17758,
		-17731,
		-17704,
		-17677,
		-17650,
		-17623,
		-17596,
		-17569,
		-17542,
		-17515,
		-17488,
		-17461,
		-17434,
		-17407,
		-17380,
		-17353,
		-17327,
		-17300,
		-17273,
		-17246,
		-17219,
		-17192,
		-17165,
		-17138,
		-17112,
		-17085,
		-17058,
		-17031,
		-17004,
		-16977,
		-16951,
		-16924,
		-16897,
		-16870,
		-16843,
		-16817,
		-16790,
		-16763,
		-16736,
		-16710,
		-16683,
		-16656,
		-16629,
		-16603,
		-16576,
		-16549,
		-16522,
		-16496,
		-16469,
		-16442,
		-16415,
		-16389,
		-16362,
		-16335,
		-16309,
		-16282,
		-16255,
		-16229,
		-16202,
		-16175,
		-16149,
		-16122,
		-16095,
		-16069,
		-16042,
		-16015,
		-15989,
		-15962,
		-15935,
		-15909,
		-15882,
		-15856,
		-15829,
		-15802,
		-15776,
		-15749,
		-15723,
		-15696,
		-15670,
		-15643,
		-15616,
		-15590,
		-15563,
		-15537,
		-15510,
		-15484,
		-15457,
		-15431,
		-15404,
		-15378,
		-15351,
		-15325,
		-15298,
		-15272,
		-15245,
		-15219,
		-15192,
		-15166,
		-15139,
		-15113,
		-15086,
		-15060,
		-15033,
		-15007,
		-14980,
		-14954,
		-14927,
		-14901,
		-14875,
		-14848,
		-14822,
		-14795,
		-14769,
		-14743,
		-14716,
		-14690,
		-14663,
		-14637,
		-14611,
		-14584,
		-14558,
		-14531,
		-14505,
		-14479,
		-14452,
		-14426,
		-14400,
		-14373,
		-14347,
		-14321,
		-14294,
		-14268,
		-14242,
		-14215,
		-14189,
		-14163,
		-14136,
		-14110,
		-14084,
		-14057,
		-14031,
		-14005,
		-13979,
		-13952,
		-13926,
		-13900,
		-13874,
		-13847,
		-13821,
		-13795,
		-13769,
		-13742,
		-13716,
		-13690,
		-13664,
		-13637,
		-13611,
		-13585,
		-13559,
		-13533,
		-13506,
		-13480,
		-13454,
		-13428,
		-13402,
		-13375,
		-13349,
		-13323,
		-13297,
		-13271,
		-13245,
		-13218,
		-13192,
		-13166,
		-13140,
		-13114,
		-13088,
		-13062,
		-13035,
		-13009,
		-12983,
		-12957,
		-12931,
		-12905,
		-12879,
		-12853,
		-12827,
		-12800,
		-12774,
		-12748,
		-12722,
		-12696,
		-12670,
		-12644,
		-12618,
		-12592,
		-12566,
		-12540,
		-12514,
		-12488,
		-12462,
		-12436,
		-12409,
		-12383,
		-12357,
		-12331,
		-12305,
		-12279,
		-12253,
		-12227,
		-12201,
		-12175,
		-12149,
		-12123,
		-12097,
		-12071,
		-12045,
		-12019,
		-11993,
		-11967,
		-11941,
		-11916,
		-11890,
		-11864,
		-11838,
		-11812,
		-11786,
		-11760,
		-11734,
		-11708,
		-11682,
		-11656,
		-11630,
		-11604,
		-11578,
		-11552,
		-11526,
		-11501,
		-11475,
		-11449,
		-11423,
		-11397,
		-11371,
		-11345,
		-11319,
		-11293,
		-11268,
		-11242,
		-11216,
		-11190,
		-11164,
		-11138,
		-11112,
		-11086,
		-11061,
		-11035,
		-11009,
		-10983,
		-10957,
		-10931,
		-10906,
		-10880,
		-10854,
		-10828,
		-10802,
		-10777,
		-10751,
		-10725,
		-10699,
		-10673,
		-10647,
		-10622,
		-10596,
		-10570,
		-10544,
		-10519,
		-10493,
		-10467,
		-10441,
		-10415,
		-10390,
		-10364,
		-10338,
		-10312,
		-10287,
		-10261,
		-10235,
		-10209,
		-10184,
		-10158,
		-10132,
		-10106,
		-10081,
		-10055,
		-10029,
		-10004,
		-9978,
		-9952,
		-9926,
		-9901,
		-9875,
		-9849,
		-9824,
		-9798,
		-9772,
		-9747,
		-9721,
		-9695,
		-9669,
		-9644,
		-9618,
		-9592,
		-9567,
		-9541,
		-9515,
		-9490,
		-9464,
		-9438,
		-9413,
		-9387,
		-9362,
		-9336,
		-9310,
		-9285,
		-9259,
		-9233,
		-9208,
		-9182,
		-9156,
		-9131,
		-9105,
		-9080,
		-9054,
		-9028,
		-9003,
		-8977,
		-8952,
		-8926,
		-8900,
		-8875,
		-8849,
		-8824,
		-8798,
		-8772,
		-8747,
		-8721,
		-8696,
		-8670,
		-8645,
		-8619,
		-8593,
		-8568,
		-8542,
		-8517,
		-8491,
		-8466,
		-8440,
		-8414,
		-8389,
		-8363,
		-8338,
		-8312,
		-8287,
		-8261,
		-8236,
		-8210,
		-8185,
		-8159,
		-8134,
		-8108,
		-8083,
		-8057,
		-8032,
		-8006,
		-7981,
		-7955,
		-7930,
		-7904,
		-7879,
		-7853,
		-7828,
		-7802,
		-7777,
		-7751,
		-7726,
		-7700,
		-7675,
		-7649,
		-7624,
		-7598,
		-7573,
		-7547,
		-7522,
		-7496,
		-7471,
		-7445,
		-7420,
		-7395,
		-7369,
		-7344,
		-7318,
		-7293,
		-7267,
		-7242,
		-7216,
		-7191,
		-7166,
		-7140,
		-7115,
		-7089,
		-7064,
		-7038,
		-7013,
		-6988,
		-6962,
		-6937,
		-6911,
		-6886,
		-6861,
		-6835,
		-6810,
		-6784,
		-6759,
		-6733,
		-6708,
		-6683,
		-6657,
		-6632,
		-6607,
		-6581,
		-6556,
		-6530,
		-6505,
		-6480,
		-6454,
		-6429,
		-6403,
		-6378,
		-6353,
		-6327,
		-6302,
		-6277,
		-6251,
		-6226,
		-6201,
		-6175,
		-6150,
		-6124,
		-6099,
		-6074,
		-6048,
		-6023,
		-5998,
		-5972,
		-5947,
		-5922,
		-5896,
		-5871,
		-5846,
		-5820,
		-5795,
		-5770,
		-5744,
		-5719,
		-5694,
		-5668,
		-5643,
		-5618,
		-5592,
		-5567,
		-5542,
		-5517,
		-5491,
		-5466,
		-5441,
		-5415,
		-5390,
		-5365,
		-5339,
		-5314,
		-5289,
		-5264,
		-5238,
		-5213,
		-5188,
		-5162,
		-5137,
		-5112,
		-5086,
		-5061,
		-5036,
		-5011,
		-4985,
		-4960,
		-4935,
		-4910,
		-4884,
		-4859,
		-4834,
		-4808,
		-4783,
		-4758,
		-4733,
		-4707,
		-4682,
		-4657,
		-4632,
		-4606,
		-4581,
		-4556,
		-4531,
		-4505,
		-4480,
		-4455,
		-4430,
		-4404,
		-4379,
		-4354,
		-4329,
		-4303,
		-4278,
		-4253,
		-4228,
		-4202,
		-4177,
		-4152,
		-4127,
		-4101,
		-4076,
		-4051,
		-4026,
		-4001,
		-3975,
		-3950,
		-3925,
		-3900,
		-3874,
		-3849,
		-3824,
		-3799,
		-3774,
		-3748,
		-3723,
		-3698,
		-3673,
		-3648,
		-3622,
		-3597,
		-3572,
		-3547,
		-3521,
		-3496,
		-3471,
		-3446,
		-3421,
		-3395,
		-3370,
		-3345,
		-3320,
		-3295,
		-3269,
		-3244,
		-3219,
		-3194,
		-3169,
		-3144,
		-3118,
		-3093,
		-3068,
		-3043,
		-3018,
		-2992,
		-2967,
		-2942,
		-2917,
		-2892,
		-2866,
		-2841,
		-2816,
		-2791,
		-2766,
		-2741,
		-2715,
		-2690,
		-2665,
		-2640,
		-2615,
		-2590,
		-2564,
		-2539,
		-2514,
		-2489,
		-2464,
		-2439,
		-2413,
		-2388,
		-2363,
		-2338,
		-2313,
		-2288,
		-2262,
		-2237,
		-2212,
		-2187,
		-2162,
		-2137,
		-2111,
		-2086,
		-2061,
		-2036,
		-2011,
		-1986,
		-1960,
		-1935,
		-1910,
		-1885,
		-1860,
		-1835,
		-1810,
		-1784,
		-1759,
		-1734,
		-1709,
		-1684,
		-1659,
		-1633,
		-1608,
		-1583,
		-1558,
		-1533,
		-1508,
		-1483,
		-1457,
		-1432,
		-1407,
		-1382,
		-1357,
		-1332,
		-1307,
		-1281,
		-1256,
		-1231,
		-1206,
		-1181,
		-1156,
		-1131,
		-1105,
		-1080,
		-1055,
		-1030,
		-1005,
		-980,
		-955,
		-929,
		-904,
		-879,
		-854,
		-829,
		-804,
		-779,
		-754,
		-728,
		-703,
		-678,
		-653,
		-628,
		-603,
		-578,
		-552,
		-527,
		-502,
		-477,
		-452,
		-427,
		-402,
		-376,
		-351,
		-326,
		-301,
		-276,
		-251,
		-226,
		-201,
		-175,
		-150,
		-125,
		-100,
		-75,
		-50,
		-25,
	};
}
